/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.applications.distributedshell;

import com.google.common.base.Joiner;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.net.URI;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.io.DataOutputBuffer;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.yarn.api.ApplicationConstants;
import org.apache.hadoop.yarn.api.protocolrecords.GetNewApplicationResponse;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ApplicationReport;
import org.apache.hadoop.yarn.api.records.ApplicationSubmissionContext;
import org.apache.hadoop.yarn.api.records.ContainerLaunchContext;
import org.apache.hadoop.yarn.api.records.ExecutionType;
import org.apache.hadoop.yarn.api.records.FinalApplicationStatus;
import org.apache.hadoop.yarn.api.records.LocalResource;
import org.apache.hadoop.yarn.api.records.LocalResourceType;
import org.apache.hadoop.yarn.api.records.LocalResourceVisibility;
import org.apache.hadoop.yarn.api.records.NodeReport;
import org.apache.hadoop.yarn.api.records.NodeState;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.QueueACL;
import org.apache.hadoop.yarn.api.records.QueueInfo;
import org.apache.hadoop.yarn.api.records.QueueUserACLInfo;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.ResourceRequest;
import org.apache.hadoop.yarn.api.records.ResourceTypeInfo;
import org.apache.hadoop.yarn.api.records.URL;
import org.apache.hadoop.yarn.api.records.YarnApplicationState;
import org.apache.hadoop.yarn.api.records.YarnClusterMetrics;
import org.apache.hadoop.yarn.api.records.timeline.TimelineDomain;
import org.apache.hadoop.yarn.applications.distributedshell.ApplicationMaster;
import org.apache.hadoop.yarn.applications.distributedshell.Log4jPropertyHelper;
import org.apache.hadoop.yarn.client.api.TimelineClient;
import org.apache.hadoop.yarn.client.api.YarnClient;
import org.apache.hadoop.yarn.client.api.YarnClientApplication;
import org.apache.hadoop.yarn.client.util.YarnClientUtils;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.exceptions.ResourceNotFoundException;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.util.UnitsConversionUtil;
import org.apache.hadoop.yarn.util.resource.ResourceUtils;
import org.apache.hadoop.yarn.util.resource.Resources;
import org.apache.hadoop.yarn.util.timeline.TimelineUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Public
@InterfaceStability.Unstable
public class Client {
    private static final Logger LOG = LoggerFactory.getLogger(Client.class);
    private static final int DEFAULT_AM_MEMORY = 100;
    private static final int DEFAULT_AM_VCORES = 1;
    private static final int DEFAULT_CONTAINER_MEMORY = 10;
    private static final int DEFAULT_CONTAINER_VCORES = 1;
    private Configuration conf;
    private YarnClient yarnClient;
    private String appName = "";
    private int amPriority = 0;
    private String amQueue = "";
    private long amMemory = 100L;
    private int amVCores = 1;
    private Map<String, Long> amResources = new HashMap<String, Long>();
    private String appMasterJar = "";
    private final String appMasterMainClass;
    private String shellCommand = "";
    private String shellScriptPath = "";
    private String[] shellArgs = new String[0];
    private Map<String, String> shellEnv = new HashMap<String, String>();
    private int shellCmdPriority = 0;
    private long containerMemory = 10L;
    private int containerVirtualCores = 1;
    private Map<String, Long> containerResources = new HashMap<String, Long>();
    private int numContainers = 1;
    private String nodeLabelExpression = null;
    private ExecutionType containerType = ExecutionType.GUARANTEED;
    private String log4jPropFile = "";
    private final long clientStartTime = System.currentTimeMillis();
    private long clientTimeout = 600000L;
    private boolean keepContainers = false;
    private long attemptFailuresValidityInterval = -1L;
    private Vector<CharSequence> containerRetryOptions = new Vector(5);
    boolean debugFlag = false;
    private String domainId = null;
    private boolean toCreateDomain = false;
    private String viewACLs = null;
    private String modifyACLs = null;
    private String flowName = null;
    private String flowVersion = null;
    private long flowRunId = 0L;
    private List<String> filesToLocalize = new ArrayList<String>();
    private Options opts;
    private static final String shellCommandPath = "shellCommands";
    private static final String shellArgsPath = "shellArgs";
    private static final String appMasterJarPath = "AppMaster.jar";
    private static final String log4jPath = "log4j.properties";
    public static final String SCRIPT_PATH = "ExecScript";

    public static void main(String[] args) {
        boolean result = false;
        try {
            Client client = new Client();
            LOG.info("Initializing Client");
            try {
                boolean doRun = client.init(args);
                if (!doRun) {
                    System.exit(0);
                }
            }
            catch (IllegalArgumentException e) {
                System.err.println(e.getLocalizedMessage());
                client.printUsage();
                System.exit(-1);
            }
            result = client.run();
        }
        catch (Throwable t) {
            LOG.error("Error running Client", t);
            System.exit(1);
        }
        if (result) {
            LOG.info("Application completed successfully");
            System.exit(0);
        }
        LOG.error("Application failed to complete successfully");
        System.exit(2);
    }

    public Client(Configuration conf) throws Exception {
        this("org.apache.hadoop.yarn.applications.distributedshell.ApplicationMaster", conf);
    }

    Client(String appMasterMainClass, Configuration conf) {
        this.conf = conf;
        this.conf.setBoolean("yarn.client.load.resource-types.from-server", true);
        this.appMasterMainClass = appMasterMainClass;
        this.yarnClient = YarnClient.createYarnClient();
        this.yarnClient.init(conf);
        this.opts = new Options();
        this.opts.addOption("appname", true, "Application Name. Default value - DistributedShell");
        this.opts.addOption("priority", true, "Application Priority. Default 0");
        this.opts.addOption("queue", true, "RM Queue in which this application is to be submitted");
        this.opts.addOption("timeout", true, "Application timeout in milliseconds");
        this.opts.addOption("master_memory", true, "Amount of memory in MB to be requested to run the application master");
        this.opts.addOption("master_vcores", true, "Amount of virtual cores to be requested to run the application master");
        this.opts.addOption("master_resources", true, "Amount of resources to be requested to run the application master. Specified as resource type=value pairs separated by commas.E.g. -master_resources memory-mb=512,vcores=2");
        this.opts.addOption("jar", true, "Jar file containing the application master");
        this.opts.addOption("shell_command", true, "Shell command to be executed by the Application Master. Can only specify either --shell_command or --shell_script");
        this.opts.addOption("shell_script", true, "Location of the shell script to be executed. Can only specify either --shell_command or --shell_script");
        this.opts.addOption("shell_args", true, "Command line args for the shell script.Multiple args can be separated by empty space.");
        this.opts.getOption("shell_args").setArgs(-2);
        this.opts.addOption("shell_env", true, "Environment for shell script. Specified as env_key=env_val pairs");
        this.opts.addOption("shell_cmd_priority", true, "Priority for the shell command containers");
        this.opts.addOption("container_type", true, "Container execution type, GUARANTEED or OPPORTUNISTIC");
        this.opts.addOption("container_memory", true, "Amount of memory in MB to be requested to run the shell command");
        this.opts.addOption("container_vcores", true, "Amount of virtual cores to be requested to run the shell command");
        this.opts.addOption("container_resources", true, "Amount of resources to be requested to run the shell command. Specified as resource type=value pairs separated by commas. E.g. -container_resources memory-mb=256,vcores=1");
        this.opts.addOption("num_containers", true, "No. of containers on which the shell command needs to be executed");
        this.opts.addOption("log_properties", true, "log4j.properties file");
        this.opts.addOption("keep_containers_across_application_attempts", false, "Flag to indicate whether to keep containers across application attempts. If the flag is true, running containers will not be killed when application attempt fails and these containers will be retrieved by the new application attempt ");
        this.opts.addOption("attempt_failures_validity_interval", true, "when attempt_failures_validity_interval in milliseconds is set to > 0,the failure number will not take failures which happen out of the validityInterval into failure count. If failure count reaches to maxAppAttempts, the application will be failed.");
        this.opts.addOption("debug", false, "Dump out debug information");
        this.opts.addOption("domain", true, "ID of the timeline domain where the timeline entities will be put");
        this.opts.addOption("view_acls", true, "Users and groups that allowed to view the timeline entities in the given domain");
        this.opts.addOption("modify_acls", true, "Users and groups that allowed to modify the timeline entities in the given domain");
        this.opts.addOption("create", false, "Flag to indicate whether to create the domain specified with -domain.");
        this.opts.addOption("flow_name", true, "Flow name which the distributed shell app belongs to");
        this.opts.addOption("flow_version", true, "Flow version which the distributed shell app belongs to");
        this.opts.addOption("flow_run_id", true, "Flow run ID which the distributed shell app belongs to");
        this.opts.addOption("help", false, "Print usage");
        this.opts.addOption("node_label_expression", true, "Node label expression to determine the nodes where all the containers of this application will be allocated, \"\" means containers can be allocated anywhere, if you don't specify the option, default node_label_expression of queue will be used.");
        this.opts.addOption("container_retry_policy", true, "Retry policy when container fails to run, 0: NEVER_RETRY, 1: RETRY_ON_ALL_ERRORS, 2: RETRY_ON_SPECIFIC_ERROR_CODES");
        this.opts.addOption("container_retry_error_codes", true, "When retry policy is set to RETRY_ON_SPECIFIC_ERROR_CODES, error codes is specified with this option, e.g. --container_retry_error_codes 1,2,3");
        this.opts.addOption("container_max_retries", true, "If container could retry, it specifies max retires");
        this.opts.addOption("container_retry_interval", true, "Interval between each retry, unit is milliseconds");
        this.opts.addOption("localize_files", true, "List of files, separated by comma to be localized for the command");
    }

    public Client() throws Exception {
        this((Configuration)new YarnConfiguration());
    }

    private void printUsage() {
        new HelpFormatter().printHelp("Client", this.opts);
    }

    public boolean init(String[] args) throws ParseException {
        CommandLine cliParser = new GnuParser().parse(this.opts, args);
        if (args.length == 0) {
            throw new IllegalArgumentException("No args specified for client to initialize");
        }
        if (cliParser.hasOption("log_properties")) {
            String log4jPath = cliParser.getOptionValue("log_properties");
            try {
                Log4jPropertyHelper.updateLog4jConfiguration(Client.class, log4jPath);
            }
            catch (Exception e) {
                LOG.warn("Can not set up custom log4j properties. " + e);
            }
        }
        if (cliParser.hasOption("help")) {
            this.printUsage();
            return false;
        }
        if (cliParser.hasOption("debug")) {
            this.debugFlag = true;
        }
        if (cliParser.hasOption("keep_containers_across_application_attempts")) {
            LOG.info("keep_containers_across_application_attempts");
            this.keepContainers = true;
        }
        this.appName = cliParser.getOptionValue("appname", "DistributedShell");
        this.amPriority = Integer.parseInt(cliParser.getOptionValue("priority", "0"));
        this.amQueue = cliParser.getOptionValue("queue", "default");
        this.amMemory = Integer.parseInt(cliParser.getOptionValue("master_memory", "-1"));
        this.amVCores = Integer.parseInt(cliParser.getOptionValue("master_vcores", "-1"));
        if (cliParser.hasOption("master_resources")) {
            Map<String, Long> masterResources = Client.parseResourcesString(cliParser.getOptionValue("master_resources"));
            for (Map.Entry<String, Long> entry : masterResources.entrySet()) {
                if (entry.getKey().equals("memory-mb")) {
                    this.amMemory = entry.getValue();
                    continue;
                }
                if (entry.getKey().equals("vcores")) {
                    this.amVCores = entry.getValue().intValue();
                    continue;
                }
                this.amResources.put(entry.getKey(), entry.getValue());
            }
        }
        if (!cliParser.hasOption("jar")) {
            throw new IllegalArgumentException("No jar file specified for application master");
        }
        this.appMasterJar = cliParser.getOptionValue("jar");
        if (!cliParser.hasOption("shell_command") && !cliParser.hasOption("shell_script")) {
            throw new IllegalArgumentException("No shell command or shell script specified to be executed by application master");
        }
        if (cliParser.hasOption("shell_command") && cliParser.hasOption("shell_script")) {
            throw new IllegalArgumentException("Can not specify shell_command option and shell_script option at the same time");
        }
        if (cliParser.hasOption("shell_command")) {
            this.shellCommand = cliParser.getOptionValue("shell_command");
        } else {
            this.shellScriptPath = cliParser.getOptionValue("shell_script");
        }
        if (cliParser.hasOption("shell_args")) {
            this.shellArgs = cliParser.getOptionValues("shell_args");
        }
        if (cliParser.hasOption("shell_env")) {
            String[] envs = cliParser.getOptionValues("shell_env");
            for (String env : envs) {
                int index = (env = env.trim()).indexOf(61);
                if (index == -1) {
                    this.shellEnv.put(env, "");
                    continue;
                }
                String key = env.substring(0, index);
                String val = "";
                if (index < env.length() - 1) {
                    val = env.substring(index + 1);
                }
                this.shellEnv.put(key, val);
            }
        }
        this.shellCmdPriority = Integer.parseInt(cliParser.getOptionValue("shell_cmd_priority", "0"));
        this.containerMemory = Integer.parseInt(cliParser.getOptionValue("container_memory", "10"));
        this.containerVirtualCores = Integer.parseInt(cliParser.getOptionValue("container_vcores", "1"));
        this.numContainers = Integer.parseInt(cliParser.getOptionValue("num_containers", "1"));
        if (this.containerMemory < 0L || this.containerVirtualCores < 0 || this.numContainers < 1) {
            throw new IllegalArgumentException("Invalid no. of containers or container memory/vcores specified, exiting. Specified containerMemory=" + this.containerMemory + ", containerVirtualCores=" + this.containerVirtualCores + ", numContainer=" + this.numContainers);
        }
        if (cliParser.hasOption("container_type")) {
            String containerTypeStr = cliParser.getOptionValue("container_type");
            if (Arrays.stream(ExecutionType.values()).noneMatch(executionType -> executionType.toString().equals(containerTypeStr))) {
                throw new IllegalArgumentException("Invalid container_type: " + containerTypeStr);
            }
            this.containerType = ExecutionType.valueOf((String)containerTypeStr);
        }
        this.containerMemory = Integer.parseInt(cliParser.getOptionValue("container_memory", "-1"));
        this.containerVirtualCores = Integer.parseInt(cliParser.getOptionValue("container_vcores", "-1"));
        if (cliParser.hasOption("container_resources")) {
            Map<String, Long> resources = Client.parseResourcesString(cliParser.getOptionValue("container_resources"));
            for (Map.Entry entry : resources.entrySet()) {
                if (((String)entry.getKey()).equals("memory-mb")) {
                    this.containerMemory = (Long)entry.getValue();
                    continue;
                }
                if (((String)entry.getKey()).equals("vcores")) {
                    this.containerVirtualCores = ((Long)entry.getValue()).intValue();
                    continue;
                }
                this.containerResources.put((String)entry.getKey(), (Long)entry.getValue());
            }
        }
        this.numContainers = Integer.parseInt(cliParser.getOptionValue("num_containers", "1"));
        if (this.numContainers < 1) {
            throw new IllegalArgumentException("Invalid no. of containers specified, exiting. Specified numContainer=" + this.numContainers);
        }
        this.nodeLabelExpression = cliParser.getOptionValue("node_label_expression", null);
        this.clientTimeout = Integer.parseInt(cliParser.getOptionValue("timeout", "600000"));
        this.attemptFailuresValidityInterval = Long.parseLong(cliParser.getOptionValue("attempt_failures_validity_interval", "-1"));
        this.log4jPropFile = cliParser.getOptionValue("log_properties", "");
        if (cliParser.hasOption("domain")) {
            this.domainId = cliParser.getOptionValue("domain");
            this.toCreateDomain = cliParser.hasOption("create");
            if (cliParser.hasOption("view_acls")) {
                this.viewACLs = cliParser.getOptionValue("view_acls");
            }
            if (cliParser.hasOption("modify_acls")) {
                this.modifyACLs = cliParser.getOptionValue("modify_acls");
            }
        }
        if (cliParser.hasOption("container_retry_policy")) {
            this.containerRetryOptions.add("--container_retry_policy " + cliParser.getOptionValue("container_retry_policy"));
        }
        if (cliParser.hasOption("container_retry_error_codes")) {
            this.containerRetryOptions.add("--container_retry_error_codes " + cliParser.getOptionValue("container_retry_error_codes"));
        }
        if (cliParser.hasOption("container_max_retries")) {
            this.containerRetryOptions.add("--container_max_retries " + cliParser.getOptionValue("container_max_retries"));
        }
        if (cliParser.hasOption("container_retry_interval")) {
            this.containerRetryOptions.add("--container_retry_interval " + cliParser.getOptionValue("container_retry_interval"));
        }
        if (cliParser.hasOption("flow_name")) {
            this.flowName = cliParser.getOptionValue("flow_name");
        }
        if (cliParser.hasOption("flow_version")) {
            this.flowVersion = cliParser.getOptionValue("flow_version");
        }
        if (cliParser.hasOption("flow_run_id")) {
            try {
                this.flowRunId = Long.parseLong(cliParser.getOptionValue("flow_run_id"));
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Flow run is not a valid long value", e);
            }
        }
        if (cliParser.hasOption("localize_files")) {
            String filesStr = cliParser.getOptionValue("localize_files");
            if (filesStr.contains(",")) {
                String[] files = filesStr.split(",");
                this.filesToLocalize = Arrays.asList(files);
            } else {
                this.filesToLocalize.add(filesStr);
            }
        }
        return true;
    }

    public boolean run() throws IOException, YarnException {
        LOG.info("Running Client");
        this.yarnClient.start();
        YarnClusterMetrics clusterMetrics = this.yarnClient.getYarnClusterMetrics();
        LOG.info("Got Cluster metric info from ASM, numNodeManagers=" + clusterMetrics.getNumNodeManagers());
        List clusterNodeReports = this.yarnClient.getNodeReports(new NodeState[]{NodeState.RUNNING});
        LOG.info("Got Cluster node info from ASM");
        for (NodeReport node : clusterNodeReports) {
            LOG.info("Got node report from ASM for, nodeId=" + node.getNodeId() + ", nodeAddress=" + node.getHttpAddress() + ", nodeRackName=" + node.getRackName() + ", nodeNumContainers=" + node.getNumContainers());
        }
        QueueInfo queueInfo = this.yarnClient.getQueueInfo(this.amQueue);
        LOG.info("Queue info, queueName=" + queueInfo.getQueueName() + ", queueCurrentCapacity=" + queueInfo.getCurrentCapacity() + ", queueMaxCapacity=" + queueInfo.getMaximumCapacity() + ", queueApplicationCount=" + queueInfo.getApplications().size() + ", queueChildQueueCount=" + queueInfo.getChildQueues().size());
        List listAclInfo = this.yarnClient.getQueueAclsInfo();
        for (QueueUserACLInfo aclInfo : listAclInfo) {
            for (QueueACL userAcl : aclInfo.getUserAcls()) {
                LOG.info("User ACL Info for Queue, queueName=" + aclInfo.getQueueName() + ", userAcl=" + userAcl.name());
            }
        }
        if (this.domainId != null && this.domainId.length() > 0 && this.toCreateDomain) {
            this.prepareTimelineDomain();
        }
        YarnClientApplication app = this.yarnClient.createApplication();
        GetNewApplicationResponse appResponse = app.getNewApplicationResponse();
        long maxMem = appResponse.getMaximumResourceCapability().getMemorySize();
        LOG.info("Max mem capability of resources in this cluster " + maxMem);
        if (this.amMemory > maxMem) {
            LOG.info("AM memory specified above max threshold of cluster. Using max value., specified=" + this.amMemory + ", max=" + maxMem);
            this.amMemory = maxMem;
        }
        int maxVCores = appResponse.getMaximumResourceCapability().getVirtualCores();
        LOG.info("Max virtual cores capability of resources in this cluster " + maxVCores);
        if (this.amVCores > maxVCores) {
            LOG.info("AM virtual cores specified above max threshold of cluster. Using max value., specified=" + this.amVCores + ", max=" + maxVCores);
            this.amVCores = maxVCores;
        }
        ApplicationSubmissionContext appContext = app.getApplicationSubmissionContext();
        ApplicationId appId = appContext.getApplicationId();
        List resourceTypes = this.yarnClient.getResourceTypeInfo();
        this.setAMResourceCapability(appContext, resourceTypes);
        this.setContainerResources(resourceTypes);
        appContext.setKeepContainersAcrossApplicationAttempts(this.keepContainers);
        appContext.setApplicationName(this.appName);
        if (this.attemptFailuresValidityInterval >= 0L) {
            appContext.setAttemptFailuresValidityInterval(this.attemptFailuresValidityInterval);
        }
        HashSet<String> tags = new HashSet<String>();
        if (this.flowName != null) {
            tags.add(TimelineUtils.generateFlowNameTag((String)this.flowName));
        }
        if (this.flowVersion != null) {
            tags.add(TimelineUtils.generateFlowVersionTag((String)this.flowVersion));
        }
        if (this.flowRunId != 0L) {
            tags.add(TimelineUtils.generateFlowRunIdTag((long)this.flowRunId));
        }
        appContext.setApplicationTags(tags);
        HashMap<String, LocalResource> localResources = new HashMap<String, LocalResource>();
        LOG.info("Copy App Master jar from local filesystem and add to local environment");
        FileSystem fs = FileSystem.get((Configuration)this.conf);
        this.addToLocalResources(fs, this.appMasterJar, appMasterJarPath, appId.toString(), localResources, null);
        if (!this.log4jPropFile.isEmpty()) {
            this.addToLocalResources(fs, this.log4jPropFile, log4jPath, appId.toString(), localResources, null);
        }
        StringBuilder localizableFiles = new StringBuilder();
        this.filesToLocalize.stream().forEach(path -> {
            File f = new File((String)path);
            if (!f.exists()) {
                throw new UncheckedIOException(new IOException(path + " does not exist"));
            }
            if (!f.canRead()) {
                throw new UncheckedIOException(new IOException(path + " cannot be read"));
            }
            if (f.isDirectory()) {
                throw new UncheckedIOException(new IOException(path + " is a directory"));
            }
            try {
                String fileName = f.getName();
                this.uploadFile(fs, (String)path, fileName, appId.toString());
                if (localizableFiles.length() == 0) {
                    localizableFiles.append(fileName);
                } else {
                    localizableFiles.append(",").append(fileName);
                }
            }
            catch (IOException e) {
                throw new UncheckedIOException("Cannot upload file: " + path, e);
            }
        });
        String hdfsShellScriptLocation = "";
        long hdfsShellScriptLen = 0L;
        long hdfsShellScriptTimestamp = 0L;
        if (!this.shellScriptPath.isEmpty()) {
            Path shellSrc = new Path(this.shellScriptPath);
            String shellPathSuffix = ApplicationMaster.getRelativePath(this.appName, appId.toString(), SCRIPT_PATH);
            String[] shellDst = new Path(fs.getHomeDirectory(), shellPathSuffix);
            fs.copyFromLocalFile(false, true, shellSrc, (Path)shellDst);
            hdfsShellScriptLocation = shellDst.toUri().toString();
            FileStatus shellFileStatus = fs.getFileStatus((Path)shellDst);
            hdfsShellScriptLen = shellFileStatus.getLen();
            hdfsShellScriptTimestamp = shellFileStatus.getModificationTime();
        }
        if (!this.shellCommand.isEmpty()) {
            this.addToLocalResources(fs, null, shellCommandPath, appId.toString(), localResources, this.shellCommand);
        }
        if (this.shellArgs.length > 0) {
            this.addToLocalResources(fs, null, shellArgsPath, appId.toString(), localResources, StringUtils.join((Object[])this.shellArgs, (String)" "));
        }
        LOG.info("Set the environment for the application master");
        HashMap<String, String> env = new HashMap<String, String>();
        env.put("DISTRIBUTEDSHELLSCRIPTLOCATION", hdfsShellScriptLocation);
        env.put("DISTRIBUTEDSHELLSCRIPTTIMESTAMP", Long.toString(hdfsShellScriptTimestamp));
        env.put("DISTRIBUTEDSHELLSCRIPTLEN", Long.toString(hdfsShellScriptLen));
        if (this.domainId != null && this.domainId.length() > 0) {
            env.put("DISTRIBUTEDSHELLTIMELINEDOMAIN", this.domainId);
        }
        StringBuilder classPathEnv = new StringBuilder(ApplicationConstants.Environment.CLASSPATH.$$()).append("<CPS>").append("./*");
        for (String c : this.conf.getStrings("yarn.application.classpath", YarnConfiguration.DEFAULT_YARN_CROSS_PLATFORM_APPLICATION_CLASSPATH)) {
            classPathEnv.append("<CPS>");
            classPathEnv.append(c.trim());
        }
        classPathEnv.append("<CPS>").append("./log4j.properties");
        if (this.conf.getBoolean("yarn.is.minicluster", false)) {
            classPathEnv.append(':');
            classPathEnv.append(System.getProperty("java.class.path"));
        }
        env.put("CLASSPATH", classPathEnv.toString());
        Vector<CharSequence> vargs = new Vector<CharSequence>(30);
        LOG.info("Setting up app master command");
        vargs.add(ApplicationConstants.Environment.JAVA_HOME.$$() + "/bin/java");
        vargs.add("-Xmx" + this.amMemory + "m");
        vargs.add(this.appMasterMainClass);
        if (this.containerType != null) {
            vargs.add("--container_type " + String.valueOf(this.containerType));
        }
        if (this.containerMemory > 0L) {
            vargs.add("--container_memory " + String.valueOf(this.containerMemory));
        }
        if (this.containerVirtualCores > 0) {
            vargs.add("--container_vcores " + String.valueOf(this.containerVirtualCores));
        }
        if (!this.containerResources.isEmpty()) {
            Joiner.MapJoiner joiner = Joiner.on((char)',').withKeyValueSeparator("=");
            vargs.add("--container_resources " + joiner.join(this.containerResources));
        }
        vargs.add("--num_containers " + String.valueOf(this.numContainers));
        if (null != this.nodeLabelExpression) {
            appContext.setNodeLabelExpression(this.nodeLabelExpression);
        }
        vargs.add("--priority " + String.valueOf(this.shellCmdPriority));
        for (Map.Entry<String, String> entry : this.shellEnv.entrySet()) {
            vargs.add("--shell_env " + entry.getKey() + "=" + entry.getValue());
        }
        if (this.debugFlag) {
            vargs.add("--debug");
        }
        if (localizableFiles.length() > 0) {
            vargs.add("--localized_files " + localizableFiles.toString());
        }
        vargs.add("--appname " + this.appName);
        vargs.addAll(this.containerRetryOptions);
        vargs.add("1><LOG_DIR>/AppMaster.stdout");
        vargs.add("2><LOG_DIR>/AppMaster.stderr");
        StringBuilder command = new StringBuilder();
        for (CharSequence str : vargs) {
            command.append(str).append(" ");
        }
        LOG.info("Completed setting up app master command " + command.toString());
        ArrayList<String> commands = new ArrayList<String>();
        commands.add(command.toString());
        ContainerLaunchContext amContainer = ContainerLaunchContext.newInstance(localResources, env, commands, null, null, null);
        Resource capability = Resource.newInstance((long)this.amMemory, (int)this.amVCores);
        appContext.setResource(capability);
        if (UserGroupInformation.isSecurityEnabled()) {
            Credentials credentials = new Credentials();
            String tokenRenewer = YarnClientUtils.getRmPrincipal((Configuration)this.conf);
            if (tokenRenewer == null || tokenRenewer.length() == 0) {
                throw new IOException("Can't get Master Kerberos principal for the RM to use as renewer");
            }
            Token[] tokens = fs.addDelegationTokens(tokenRenewer, credentials);
            if (tokens != null) {
                for (Token token : tokens) {
                    LOG.info("Got dt for " + fs.getUri() + "; " + token);
                }
            }
            DataOutputBuffer dob = new DataOutputBuffer();
            credentials.writeTokenStorageToStream((DataOutputStream)dob);
            ByteBuffer fsTokens = ByteBuffer.wrap(dob.getData(), 0, dob.getLength());
            amContainer.setTokens(fsTokens);
        }
        appContext.setAMContainerSpec(amContainer);
        Priority pri = Priority.newInstance((int)this.amPriority);
        appContext.setPriority(pri);
        appContext.setQueue(this.amQueue);
        LOG.info("Submitting application to ASM");
        this.yarnClient.submitApplication(appContext);
        return this.monitorApplication(appId);
    }

    private boolean monitorApplication(ApplicationId appId) throws YarnException, IOException {
        do {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                LOG.debug("Thread sleep in monitoring loop interrupted");
            }
            ApplicationReport report = this.yarnClient.getApplicationReport(appId);
            LOG.info("Got application report from ASM for, appId=" + appId.getId() + ", clientToAMToken=" + report.getClientToAMToken() + ", appDiagnostics=" + report.getDiagnostics() + ", appMasterHost=" + report.getHost() + ", appQueue=" + report.getQueue() + ", appMasterRpcPort=" + report.getRpcPort() + ", appStartTime=" + report.getStartTime() + ", yarnAppState=" + report.getYarnApplicationState().toString() + ", distributedFinalState=" + report.getFinalApplicationStatus().toString() + ", appTrackingUrl=" + report.getTrackingUrl() + ", appUser=" + report.getUser());
            YarnApplicationState state = report.getYarnApplicationState();
            FinalApplicationStatus dsStatus = report.getFinalApplicationStatus();
            if (YarnApplicationState.FINISHED == state) {
                if (FinalApplicationStatus.SUCCEEDED == dsStatus) {
                    LOG.info("Application has completed successfully. Breaking monitoring loop");
                    return true;
                }
                LOG.info("Application did finished unsuccessfully. YarnState=" + state.toString() + ", DSFinalStatus=" + dsStatus.toString() + ". Breaking monitoring loop");
                return false;
            }
            if (YarnApplicationState.KILLED != state && YarnApplicationState.FAILED != state) continue;
            LOG.info("Application did not finish. YarnState=" + state.toString() + ", DSFinalStatus=" + dsStatus.toString() + ". Breaking monitoring loop");
            return false;
        } while (System.currentTimeMillis() <= this.clientStartTime + this.clientTimeout);
        LOG.info("Reached client specified timeout for application. Killing application");
        this.forceKillApplication(appId);
        return false;
    }

    private void forceKillApplication(ApplicationId appId) throws YarnException, IOException {
        this.yarnClient.killApplication(appId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addToLocalResources(FileSystem fs, String fileSrcPath, String fileDstPath, String appId, Map<String, LocalResource> localResources, String resources) throws IOException {
        Path dst;
        block3: {
            block2: {
                String suffix = ApplicationMaster.getRelativePath(this.appName, appId, fileDstPath);
                dst = new Path(fs.getHomeDirectory(), suffix);
                if (fileSrcPath != null) break block2;
                FSDataOutputStream ostream = null;
                try {
                    ostream = FileSystem.create((FileSystem)fs, (Path)dst, (FsPermission)new FsPermission(456));
                    ostream.writeUTF(resources);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(ostream);
                    throw throwable;
                }
                IOUtils.closeQuietly((OutputStream)ostream);
                break block3;
            }
            fs.copyFromLocalFile(new Path(fileSrcPath), dst);
        }
        FileStatus scFileStatus = fs.getFileStatus(dst);
        LocalResource scRsrc = LocalResource.newInstance((URL)URL.fromURI((URI)dst.toUri()), (LocalResourceType)LocalResourceType.FILE, (LocalResourceVisibility)LocalResourceVisibility.APPLICATION, (long)scFileStatus.getLen(), (long)scFileStatus.getModificationTime());
        localResources.put(fileDstPath, scRsrc);
    }

    private void uploadFile(FileSystem fs, String fileSrcPath, String fileDstPath, String appId) throws IOException {
        String relativePath = ApplicationMaster.getRelativePath(this.appName, appId, fileDstPath);
        Path dst = new Path(fs.getHomeDirectory(), relativePath);
        LOG.info("Uploading file: " + fileSrcPath + " to " + dst);
        fs.copyFromLocalFile(new Path(fileSrcPath), dst);
    }

    private void prepareTimelineDomain() {
        TimelineClient timelineClient = null;
        if (!this.conf.getBoolean("yarn.timeline-service.enabled", false)) {
            LOG.warn("Cannot put the domain " + this.domainId + " because the timeline service is not enabled");
            return;
        }
        timelineClient = TimelineClient.createTimelineClient();
        timelineClient.init(this.conf);
        timelineClient.start();
        try {
            TimelineDomain domain = new TimelineDomain();
            domain.setId(this.domainId);
            domain.setReaders(this.viewACLs != null && this.viewACLs.length() > 0 ? this.viewACLs : " ");
            domain.setWriters(this.modifyACLs != null && this.modifyACLs.length() > 0 ? this.modifyACLs : " ");
            timelineClient.putDomain(domain);
            LOG.info("Put the timeline domain: " + TimelineUtils.dumpTimelineRecordtoJSON((Object)domain));
        }
        catch (Exception e) {
            LOG.error("Error when putting the timeline domain", (Throwable)e);
        }
        finally {
            timelineClient.stop();
        }
    }

    private void setAMResourceCapability(ApplicationSubmissionContext appContext, List<ResourceTypeInfo> resourceTypes) throws IllegalArgumentException, IOException, YarnException {
        if (this.amMemory < -1L || this.amMemory == 0L) {
            throw new IllegalArgumentException("Invalid memory specified for application master, exiting. Specified memory=" + this.amMemory);
        }
        if (this.amVCores < -1 || this.amVCores == 0) {
            throw new IllegalArgumentException("Invalid virtual cores specified for application master, exiting. Specified virtual cores=" + this.amVCores);
        }
        if (appContext.getAMContainerResourceRequests() == null) {
            ArrayList<ResourceRequest> amResourceRequests = new ArrayList<ResourceRequest>();
            amResourceRequests.add(ResourceRequest.newInstance((Priority)Priority.newInstance((int)this.amPriority), (String)"*", (Resource)Resources.clone((Resource)Resources.none()), (int)1));
            appContext.setAMContainerResourceRequests(amResourceRequests);
        }
        Resource capability = Resource.newInstance((int)0, (int)0);
        this.validateResourceTypes(this.amResources.keySet(), resourceTypes);
        for (Map.Entry<String, Long> entry : this.amResources.entrySet()) {
            capability.setResourceValue(entry.getKey(), entry.getValue().longValue());
        }
        if (this.amMemory == -1L) {
            this.amMemory = 100L;
        }
        if (this.amVCores == -1) {
            this.amVCores = 1;
        }
        capability.setMemorySize(this.amMemory);
        capability.setVirtualCores(this.amVCores);
    }

    private void setContainerResources(List<ResourceTypeInfo> resourceTypes) throws IllegalArgumentException {
        if (this.containerMemory < -1L || this.containerMemory == 0L) {
            throw new IllegalArgumentException("Container memory '" + this.containerMemory + "' has to be greater than 0");
        }
        if (this.containerVirtualCores < -1 || this.containerVirtualCores == 0) {
            throw new IllegalArgumentException("Container vcores '" + this.containerVirtualCores + "' has to be greater than 0");
        }
        this.validateResourceTypes(this.containerResources.keySet(), resourceTypes);
        this.containerMemory = this.containerMemory == -1L ? 10L : this.containerMemory;
        this.containerVirtualCores = this.containerVirtualCores == -1 ? 1 : this.containerVirtualCores;
    }

    private void validateResourceTypes(Iterable<String> resourceNames, List<ResourceTypeInfo> resourceTypes) {
        for (String resourceName : resourceNames) {
            if (resourceTypes.stream().anyMatch(e -> e.getName().equals(resourceName))) continue;
            throw new ResourceNotFoundException("Unknown resource: " + resourceName);
        }
    }

    static Map<String, Long> parseResourcesString(String resourcesStr) {
        HashMap<String, Long> resources = new HashMap<String, Long>();
        if (resourcesStr.startsWith("[")) {
            resourcesStr = resourcesStr.substring(1);
        }
        if (resourcesStr.endsWith("]")) {
            resourcesStr = resourcesStr.substring(0, resourcesStr.length());
        }
        for (String resource : resourcesStr.trim().split(",")) {
            if (!(resource = resource.trim()).matches("^[^=]+=\\d+\\s?\\w*$")) {
                throw new IllegalArgumentException("\"" + resource + "\" is not a valid resource type/amount pair. Please provide key=amount pairs separated by commas.");
            }
            String[] splits = resource.split("=");
            String key = splits[0];
            String value = splits[1];
            String units = ResourceUtils.getUnits((String)value);
            String valueWithoutUnit = value.substring(0, value.length() - units.length()).trim();
            Long resourceValue = Long.valueOf(valueWithoutUnit);
            if (!units.isEmpty()) {
                resourceValue = UnitsConversionUtil.convert((String)units, (String)"Mi", (long)resourceValue);
            }
            if (key.equals("memory")) {
                key = "memory-mb";
            }
            resources.put(key, resourceValue);
        }
        return resources;
    }
}

