/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.applications.distributedshell;

import com.google.common.annotations.VisibleForTesting;
import com.sun.jersey.api.client.ClientHandlerException;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.io.UncheckedIOException;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.ByteBuffer;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.DataOutputBuffer;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.util.ExitUtil;
import org.apache.hadoop.util.Shell;
import org.apache.hadoop.yarn.api.ApplicationConstants;
import org.apache.hadoop.yarn.api.protocolrecords.RegisterApplicationMasterResponse;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ContainerLaunchContext;
import org.apache.hadoop.yarn.api.records.ContainerRetryContext;
import org.apache.hadoop.yarn.api.records.ContainerRetryPolicy;
import org.apache.hadoop.yarn.api.records.ContainerState;
import org.apache.hadoop.yarn.api.records.ContainerStatus;
import org.apache.hadoop.yarn.api.records.ExecutionType;
import org.apache.hadoop.yarn.api.records.ExecutionTypeRequest;
import org.apache.hadoop.yarn.api.records.FinalApplicationStatus;
import org.apache.hadoop.yarn.api.records.LocalResource;
import org.apache.hadoop.yarn.api.records.LocalResourceType;
import org.apache.hadoop.yarn.api.records.LocalResourceVisibility;
import org.apache.hadoop.yarn.api.records.NodeReport;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.URL;
import org.apache.hadoop.yarn.api.records.UpdatedContainer;
import org.apache.hadoop.yarn.api.records.timeline.TimelineEntity;
import org.apache.hadoop.yarn.api.records.timeline.TimelineEntityGroupId;
import org.apache.hadoop.yarn.api.records.timeline.TimelineEvent;
import org.apache.hadoop.yarn.api.records.timeline.TimelinePutResponse;
import org.apache.hadoop.yarn.applications.distributedshell.Client;
import org.apache.hadoop.yarn.applications.distributedshell.Log4jPropertyHelper;
import org.apache.hadoop.yarn.client.api.AMRMClient;
import org.apache.hadoop.yarn.client.api.TimelineClient;
import org.apache.hadoop.yarn.client.api.TimelineV2Client;
import org.apache.hadoop.yarn.client.api.async.AMRMClientAsync;
import org.apache.hadoop.yarn.client.api.async.NMClientAsync;
import org.apache.hadoop.yarn.client.api.async.impl.NMClientAsyncImpl;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.security.AMRMTokenIdentifier;
import org.apache.hadoop.yarn.util.SystemClock;
import org.apache.hadoop.yarn.util.TimelineServiceHelper;
import org.apache.hadoop.yarn.util.resource.ResourceUtils;
import org.apache.hadoop.yarn.util.timeline.TimelineUtils;
import org.apache.log4j.LogManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Public
@InterfaceStability.Unstable
public class ApplicationMaster {
    private static final Logger LOG = LoggerFactory.getLogger(ApplicationMaster.class);
    private static final String YARN_SHELL_ID = "YARN_SHELL_ID";
    private Configuration conf;
    private AMRMClientAsync amRMClient;
    @VisibleForTesting
    UserGroupInformation appSubmitterUgi;
    private NMClientAsync nmClientAsync;
    private NMCallbackHandler containerListener;
    @VisibleForTesting
    protected ApplicationAttemptId appAttemptID;
    private ApplicationId appId;
    private String appName;
    private String appMasterHostname = "";
    private int appMasterRpcPort = -1;
    private String appMasterTrackingUrl = "";
    private boolean timelineServiceV2Enabled = false;
    private boolean timelineServiceV1Enabled = false;
    @VisibleForTesting
    protected int numTotalContainers = 1;
    private long containerMemory = 10L;
    private static final int DEFAULT_CONTAINER_VCORES = 1;
    private int containerVirtualCores = 1;
    private Map<String, Long> containerResources = new HashMap<String, Long>();
    private int requestPriority;
    private ExecutionType containerType = ExecutionType.GUARANTEED;
    private AtomicInteger numCompletedContainers = new AtomicInteger();
    @VisibleForTesting
    protected AtomicInteger numAllocatedContainers = new AtomicInteger();
    private AtomicInteger numFailedContainers = new AtomicInteger();
    @VisibleForTesting
    protected AtomicInteger numRequestedContainers = new AtomicInteger();
    private String shellCommand = "";
    private String shellArgs = "";
    private Map<String, String> shellEnv = new HashMap<String, String>();
    private String scriptPath = "";
    private long shellScriptPathTimestamp = 0L;
    private long shellScriptPathLen = 0L;
    private ContainerRetryPolicy containerRetryPolicy = ContainerRetryPolicy.NEVER_RETRY;
    private Set<Integer> containerRetryErrorCodes = null;
    private int containerMaxRetries = 0;
    private int containrRetryInterval = 0;
    private List<String> localizableFiles = new ArrayList<String>();
    private String domainId = null;
    private static final String EXEC_SHELL_STRING_PATH = "ExecScript.sh";
    private static final String EXEC_BAT_SCRIPT_STRING_PATH = "ExecScript.bat";
    private static final String log4jPath = "log4j.properties";
    private static final String shellCommandPath = "shellCommands";
    private static final String shellArgsPath = "shellArgs";
    private volatile boolean done;
    private ByteBuffer allTokens;
    private List<Thread> launchThreads = new ArrayList<Thread>();
    @VisibleForTesting
    TimelineClient timelineClient;
    private TimelineV2Client timelineV2Client;
    static final String CONTAINER_ENTITY_GROUP_ID = "CONTAINERS";
    static final String APPID_TIMELINE_FILTER_NAME = "appId";
    static final String USER_TIMELINE_FILTER_NAME = "user";
    private final String linux_bash_command = "bash";
    private final String windows_command = "cmd /c";
    private int yarnShellIdCounter = 1;
    @VisibleForTesting
    protected final Set<ContainerId> launchedContainers = Collections.newSetFromMap(new ConcurrentHashMap());
    private final ConcurrentMap<ContainerId, Long> containerStartTimes = new ConcurrentHashMap<ContainerId, Long>();

    private ConcurrentMap<ContainerId, Long> getContainerStartTimes() {
        return this.containerStartTimes;
    }

    public static void main(String[] args) {
        boolean result = false;
        try {
            ApplicationMaster appMaster = new ApplicationMaster();
            LOG.info("Initializing ApplicationMaster");
            boolean doRun = appMaster.init(args);
            if (!doRun) {
                System.exit(0);
            }
            appMaster.run();
            result = appMaster.finish();
        }
        catch (Throwable t) {
            LOG.error("Error running ApplicationMaster", t);
            LogManager.shutdown();
            ExitUtil.terminate((int)1, (Throwable)t);
        }
        if (result) {
            LOG.info("Application Master completed successfully. exiting");
            System.exit(0);
        } else {
            LOG.info("Application Master failed. exiting");
            System.exit(2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dumpOutDebugInfo() {
        LOG.info("Dump debug output");
        Map<String, String> envs = System.getenv();
        for (Map.Entry<String, String> env : envs.entrySet()) {
            LOG.info("System env: key=" + env.getKey() + ", val=" + env.getValue());
            System.out.println("System env: key=" + env.getKey() + ", val=" + env.getValue());
        }
        BufferedReader buf = null;
        try {
            String lines = Shell.WINDOWS ? Shell.execCommand((String[])new String[]{"cmd", "/c", "dir"}) : Shell.execCommand((String[])new String[]{"ls", "-al"});
            buf = new BufferedReader(new StringReader(lines));
            String line = "";
            while ((line = buf.readLine()) != null) {
                LOG.info("System CWD content: " + line);
                System.out.println("System CWD content: " + line);
            }
        }
        catch (IOException e) {
            try {
                e.printStackTrace();
            }
            catch (Throwable throwable) {
                org.apache.hadoop.io.IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{buf});
                throw throwable;
            }
            org.apache.hadoop.io.IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{buf});
        }
        org.apache.hadoop.io.IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{buf});
    }

    public ApplicationMaster() {
        this.conf = new YarnConfiguration();
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean init(String[] args) throws ParseException, IOException {
        String[] resources;
        Map<String, String> envs;
        Options opts = new Options();
        opts.addOption("appname", true, "Application Name. Default value - DistributedShell");
        opts.addOption("app_attempt_id", true, "App Attempt ID. Not to be used unless for testing purposes");
        opts.addOption("shell_env", true, "Environment for shell script. Specified as env_key=env_val pairs");
        opts.addOption("container_type", true, "Container execution type, GUARANTEED or OPPORTUNISTIC");
        opts.addOption("container_memory", true, "Amount of memory in MB to be requested to run the shell command");
        opts.addOption("container_vcores", true, "Amount of virtual cores to be requested to run the shell command");
        opts.addOption("container_resources", true, "Amount of resources to be requested to run the shell command. Specified as resource type=value pairs separated by commas. E.g. -container_resources memory-mb=512,vcores=1");
        opts.addOption("num_containers", true, "No. of containers on which the shell command needs to be executed");
        opts.addOption("priority", true, "Application Priority. Default 0");
        opts.addOption("container_retry_policy", true, "Retry policy when container fails to run, 0: NEVER_RETRY, 1: RETRY_ON_ALL_ERRORS, 2: RETRY_ON_SPECIFIC_ERROR_CODES");
        opts.addOption("container_retry_error_codes", true, "When retry policy is set to RETRY_ON_SPECIFIC_ERROR_CODES, error codes is specified with this option, e.g. --container_retry_error_codes 1,2,3");
        opts.addOption("container_max_retries", true, "If container could retry, it specifies max retires");
        opts.addOption("container_retry_interval", true, "Interval between each retry, unit is milliseconds");
        opts.addOption("debug", false, "Dump out debug information");
        opts.addOption("localized_files", true, "List of localized files");
        opts.addOption("help", false, "Print usage");
        CommandLine cliParser = new GnuParser().parse(opts, args);
        if (args.length == 0) {
            this.printUsage(opts);
            throw new IllegalArgumentException("No args specified for application master to initialize");
        }
        if (this.fileExist(log4jPath)) {
            try {
                Log4jPropertyHelper.updateLog4jConfiguration(ApplicationMaster.class, log4jPath);
            }
            catch (Exception e) {
                LOG.warn("Can not set up custom log4j properties. " + e);
            }
        }
        this.appName = cliParser.getOptionValue("appname", "DistributedShell");
        if (cliParser.hasOption("help")) {
            this.printUsage(opts);
            return false;
        }
        if (cliParser.hasOption("debug")) {
            this.dumpOutDebugInfo();
        }
        if (!(envs = System.getenv()).containsKey(ApplicationConstants.Environment.CONTAINER_ID.name())) {
            if (!cliParser.hasOption("app_attempt_id")) throw new IllegalArgumentException("Application Attempt Id not set in the environment");
            String appIdStr = cliParser.getOptionValue("app_attempt_id", "");
            this.appAttemptID = ApplicationAttemptId.fromString((String)appIdStr);
        } else {
            ContainerId containerId = ContainerId.fromString((String)envs.get(ApplicationConstants.Environment.CONTAINER_ID.name()));
            this.appAttemptID = containerId.getApplicationAttemptId();
            this.appId = this.appAttemptID.getApplicationId();
        }
        if (!envs.containsKey("APP_SUBMIT_TIME_ENV")) {
            throw new RuntimeException("APP_SUBMIT_TIME_ENV not set in the environment");
        }
        if (!envs.containsKey(ApplicationConstants.Environment.NM_HOST.name())) {
            throw new RuntimeException(ApplicationConstants.Environment.NM_HOST.name() + " not set in the environment");
        }
        if (!envs.containsKey(ApplicationConstants.Environment.NM_HTTP_PORT.name())) {
            throw new RuntimeException(ApplicationConstants.Environment.NM_HTTP_PORT + " not set in the environment");
        }
        if (!envs.containsKey(ApplicationConstants.Environment.NM_PORT.name())) {
            throw new RuntimeException(ApplicationConstants.Environment.NM_PORT.name() + " not set in the environment");
        }
        LOG.info("Application master for app, appId=" + this.appAttemptID.getApplicationId().getId() + ", clustertimestamp=" + this.appAttemptID.getApplicationId().getClusterTimestamp() + ", attemptId=" + this.appAttemptID.getAttemptId());
        if (!this.fileExist(shellCommandPath) && envs.get("DISTRIBUTEDSHELLSCRIPTLOCATION").isEmpty()) {
            throw new IllegalArgumentException("No shell command or shell script specified to be executed by application master");
        }
        if (this.fileExist(shellCommandPath)) {
            this.shellCommand = this.readContent(shellCommandPath);
        }
        if (this.fileExist(shellArgsPath)) {
            this.shellArgs = this.readContent(shellArgsPath);
        }
        if (cliParser.hasOption("shell_env")) {
            String[] shellEnvs = cliParser.getOptionValues("shell_env");
            for (String env : shellEnvs) {
                int index = (env = env.trim()).indexOf(61);
                if (index == -1) {
                    this.shellEnv.put(env, "");
                    continue;
                }
                String key = env.substring(0, index);
                String val = "";
                if (index < env.length() - 1) {
                    val = env.substring(index + 1);
                }
                this.shellEnv.put(key, val);
            }
        }
        if (envs.containsKey("DISTRIBUTEDSHELLSCRIPTLOCATION")) {
            this.scriptPath = envs.get("DISTRIBUTEDSHELLSCRIPTLOCATION");
            if (envs.containsKey("DISTRIBUTEDSHELLSCRIPTTIMESTAMP")) {
                this.shellScriptPathTimestamp = Long.parseLong(envs.get("DISTRIBUTEDSHELLSCRIPTTIMESTAMP"));
            }
            if (envs.containsKey("DISTRIBUTEDSHELLSCRIPTLEN")) {
                this.shellScriptPathLen = Long.parseLong(envs.get("DISTRIBUTEDSHELLSCRIPTLEN"));
            }
            if (!(this.scriptPath.isEmpty() || this.shellScriptPathTimestamp > 0L && this.shellScriptPathLen > 0L)) {
                LOG.error("Illegal values in env for shell script path, path=" + this.scriptPath + ", len=" + this.shellScriptPathLen + ", timestamp=" + this.shellScriptPathTimestamp);
                throw new IllegalArgumentException("Illegal values in env for shell script path");
            }
        }
        if (envs.containsKey("DISTRIBUTEDSHELLTIMELINEDOMAIN")) {
            this.domainId = envs.get("DISTRIBUTEDSHELLTIMELINEDOMAIN");
        }
        if (cliParser.hasOption("container_type")) {
            String containerTypeStr = cliParser.getOptionValue("container_type");
            if (Arrays.stream(ExecutionType.values()).noneMatch(executionType -> executionType.toString().equals(containerTypeStr))) {
                throw new IllegalArgumentException("Invalid container_type: " + containerTypeStr);
            }
            this.containerType = ExecutionType.valueOf((String)containerTypeStr);
        }
        this.containerMemory = Integer.parseInt(cliParser.getOptionValue("container_memory", "10"));
        this.containerVirtualCores = Integer.parseInt(cliParser.getOptionValue("container_vcores", "1"));
        this.containerResources = new HashMap<String, Long>();
        if (cliParser.hasOption("container_resources")) {
            resources = Client.parseResourcesString(cliParser.getOptionValue("container_resources"));
            for (Map.Entry entry : resources.entrySet()) {
                this.containerResources.put((String)entry.getKey(), (Long)entry.getValue());
            }
        }
        this.numTotalContainers = Integer.parseInt(cliParser.getOptionValue("num_containers", "1"));
        if (this.numTotalContainers == 0) {
            throw new IllegalArgumentException("Cannot run distributed shell with no containers");
        }
        this.requestPriority = Integer.parseInt(cliParser.getOptionValue("priority", "0"));
        this.containerRetryPolicy = ContainerRetryPolicy.values()[Integer.parseInt(cliParser.getOptionValue("container_retry_policy", "0"))];
        if (cliParser.hasOption("container_retry_error_codes")) {
            void var7_13;
            this.containerRetryErrorCodes = new HashSet<Integer>();
            resources = cliParser.getOptionValue("container_retry_error_codes").split(",");
            int n = resources.length;
            boolean bl = false;
            while (var7_13 < n) {
                String errorCode = resources[var7_13];
                this.containerRetryErrorCodes.add(Integer.parseInt(errorCode));
                ++var7_13;
            }
        }
        this.containerMaxRetries = Integer.parseInt(cliParser.getOptionValue("container_max_retries", "0"));
        this.containrRetryInterval = Integer.parseInt(cliParser.getOptionValue("container_retry_interval", "0"));
        if (YarnConfiguration.timelineServiceEnabled((Configuration)this.conf)) {
            this.timelineServiceV2Enabled = (int)YarnConfiguration.getTimelineServiceVersion((Configuration)this.conf) == 2;
            this.timelineServiceV1Enabled = !this.timelineServiceV2Enabled;
        } else {
            this.timelineClient = null;
            this.timelineV2Client = null;
            LOG.warn("Timeline service is not enabled");
        }
        if (!cliParser.hasOption("localized_files")) return true;
        String localizedFilesArg = cliParser.getOptionValue("localized_files");
        if (localizedFilesArg.contains(",")) {
            String[] files = localizedFilesArg.split(",");
            this.localizableFiles = Arrays.asList(files);
            return true;
        } else {
            this.localizableFiles.add(localizedFilesArg);
        }
        return true;
    }

    private void printUsage(Options opts) {
        new HelpFormatter().printHelp("ApplicationMaster", opts);
    }

    public void run() throws YarnException, IOException, InterruptedException {
        LOG.info("Starting ApplicationMaster");
        Credentials credentials = UserGroupInformation.getCurrentUser().getCredentials();
        DataOutputBuffer dob = new DataOutputBuffer();
        credentials.writeTokenStorageToStream((DataOutputStream)dob);
        Iterator iter = credentials.getAllTokens().iterator();
        LOG.info("Executing with tokens:");
        while (iter.hasNext()) {
            Token token = (Token)iter.next();
            LOG.info(token.toString());
            if (!token.getKind().equals((Object)AMRMTokenIdentifier.KIND_NAME)) continue;
            iter.remove();
        }
        this.allTokens = ByteBuffer.wrap(dob.getData(), 0, dob.getLength());
        String appSubmitterUserName = System.getenv(ApplicationConstants.Environment.USER.name());
        this.appSubmitterUgi = UserGroupInformation.createRemoteUser((String)appSubmitterUserName);
        this.appSubmitterUgi.addCredentials(credentials);
        RMCallbackHandler allocListener = new RMCallbackHandler();
        this.amRMClient = AMRMClientAsync.createAMRMClientAsync((int)1000, (AMRMClientAsync.AbstractCallbackHandler)allocListener);
        this.amRMClient.init(this.conf);
        this.amRMClient.start();
        this.containerListener = this.createNMCallbackHandler();
        this.nmClientAsync = new NMClientAsyncImpl((NMClientAsync.AbstractCallbackHandler)this.containerListener);
        this.nmClientAsync.init(this.conf);
        this.nmClientAsync.start();
        this.startTimelineClient(this.conf);
        if (this.timelineServiceV2Enabled) {
            this.amRMClient.registerTimelineV2Client(this.timelineV2Client);
        }
        if (this.timelineServiceV2Enabled) {
            this.publishApplicationAttemptEventOnTimelineServiceV2(DSEvent.DS_APP_ATTEMPT_START);
        } else if (this.timelineServiceV1Enabled) {
            this.publishApplicationAttemptEvent(this.timelineClient, this.appAttemptID.toString(), DSEvent.DS_APP_ATTEMPT_START, this.domainId, this.appSubmitterUgi);
        }
        this.appMasterHostname = NetUtils.getHostname();
        RegisterApplicationMasterResponse response = this.amRMClient.registerApplicationMaster(this.appMasterHostname, this.appMasterRpcPort, this.appMasterTrackingUrl);
        ResourceUtils.reinitializeResources((List)response.getResourceTypes());
        long maxMem = response.getMaximumResourceCapability().getMemorySize();
        LOG.info("Max mem capability of resources in this cluster " + maxMem);
        int maxVCores = response.getMaximumResourceCapability().getVirtualCores();
        LOG.info("Max vcores capability of resources in this cluster " + maxVCores);
        if (this.containerMemory > maxMem) {
            LOG.info("Container memory specified above max threshold of cluster. Using max value., specified=" + this.containerMemory + ", max=" + maxMem);
            this.containerMemory = maxMem;
        }
        if (this.containerVirtualCores > maxVCores) {
            LOG.info("Container virtual cores specified above max threshold of cluster. Using max value., specified=" + this.containerVirtualCores + ", max=" + maxVCores);
            this.containerVirtualCores = maxVCores;
        }
        List previousAMRunningContainers = response.getContainersFromPreviousAttempts();
        LOG.info(this.appAttemptID + " received " + previousAMRunningContainers.size() + " previous attempts' running containers on AM registration.");
        for (Container container : previousAMRunningContainers) {
            this.launchedContainers.add(container.getId());
        }
        this.numAllocatedContainers.addAndGet(previousAMRunningContainers.size());
        int numTotalContainersToRequest = this.numTotalContainers - previousAMRunningContainers.size();
        for (int i = 0; i < numTotalContainersToRequest; ++i) {
            AMRMClient.ContainerRequest containerAsk = this.setupContainerAskForRM();
            this.amRMClient.addContainerRequest(containerAsk);
        }
        this.numRequestedContainers.set(this.numTotalContainers);
    }

    @VisibleForTesting
    void startTimelineClient(final Configuration conf) throws YarnException, IOException, InterruptedException {
        try {
            this.appSubmitterUgi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws Exception {
                    if (YarnConfiguration.timelineServiceEnabled((Configuration)conf)) {
                        if (ApplicationMaster.this.timelineServiceV2Enabled) {
                            ApplicationMaster.this.timelineV2Client = TimelineV2Client.createTimelineClient((ApplicationId)ApplicationMaster.this.appAttemptID.getApplicationId());
                            ApplicationMaster.this.timelineV2Client.init(conf);
                            ApplicationMaster.this.timelineV2Client.start();
                            LOG.info("Timeline service V2 client is enabled");
                        } else {
                            ApplicationMaster.this.timelineClient = TimelineClient.createTimelineClient();
                            ApplicationMaster.this.timelineClient.init(conf);
                            ApplicationMaster.this.timelineClient.start();
                            LOG.info("Timeline service V1 client is enabled");
                        }
                    } else {
                        ApplicationMaster.this.timelineClient = null;
                        ApplicationMaster.this.timelineV2Client = null;
                        LOG.warn("Timeline service is not enabled");
                    }
                    return null;
                }
            });
        }
        catch (UndeclaredThrowableException e) {
            throw new YarnException(e.getCause());
        }
    }

    @VisibleForTesting
    NMCallbackHandler createNMCallbackHandler() {
        return new NMCallbackHandler(this);
    }

    @VisibleForTesting
    protected boolean finish() {
        FinalApplicationStatus appStatus;
        while (!this.done && this.numCompletedContainers.get() != this.numTotalContainers) {
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (this.timelineServiceV2Enabled) {
            this.publishApplicationAttemptEventOnTimelineServiceV2(DSEvent.DS_APP_ATTEMPT_END);
        } else if (this.timelineServiceV1Enabled) {
            this.publishApplicationAttemptEvent(this.timelineClient, this.appAttemptID.toString(), DSEvent.DS_APP_ATTEMPT_END, this.domainId, this.appSubmitterUgi);
        }
        for (Thread launchThread : this.launchThreads) {
            try {
                launchThread.join(10000L);
            }
            catch (InterruptedException e) {
                LOG.info("Exception thrown in thread join: " + e.getMessage());
                e.printStackTrace();
            }
        }
        LOG.info("Application completed. Stopping running containers");
        this.nmClientAsync.stop();
        LOG.info("Application completed. Signalling finish to RM");
        String appMessage = null;
        boolean success = true;
        if (this.numCompletedContainers.get() - this.numFailedContainers.get() >= this.numTotalContainers) {
            appStatus = FinalApplicationStatus.SUCCEEDED;
        } else {
            appStatus = FinalApplicationStatus.FAILED;
            appMessage = "Diagnostics., total=" + this.numTotalContainers + ", completed=" + this.numCompletedContainers.get() + ", allocated=" + this.numAllocatedContainers.get() + ", failed=" + this.numFailedContainers.get();
            LOG.info(appMessage);
            success = false;
        }
        try {
            this.amRMClient.unregisterApplicationMaster(appStatus, appMessage, null);
        }
        catch (YarnException ex) {
            LOG.error("Failed to unregister application", (Throwable)ex);
        }
        catch (IOException e) {
            LOG.error("Failed to unregister application", (Throwable)e);
        }
        this.amRMClient.stop();
        if (this.timelineServiceV1Enabled) {
            this.timelineClient.stop();
        } else if (this.timelineServiceV2Enabled) {
            this.timelineV2Client.stop();
        }
        return success;
    }

    public static String getRelativePath(String appName, String appId, String fileDstPath) {
        return appName + "/" + appId + "/" + fileDstPath;
    }

    private void renameScriptFile(final Path renamedScriptPath) throws IOException, InterruptedException {
        this.appSubmitterUgi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

            @Override
            public Void run() throws IOException {
                FileSystem fs = renamedScriptPath.getFileSystem(ApplicationMaster.this.conf);
                fs.rename(new Path(ApplicationMaster.this.scriptPath), renamedScriptPath);
                return null;
            }
        });
        LOG.info("User " + this.appSubmitterUgi.getUserName() + " added suffix(.sh/.bat) to script file as " + renamedScriptPath);
    }

    private AMRMClient.ContainerRequest setupContainerAskForRM() {
        Priority pri = Priority.newInstance((int)this.requestPriority);
        Resource capability = Resource.newInstance((long)this.containerMemory, (int)this.containerVirtualCores);
        AMRMClient.ContainerRequest request = new AMRMClient.ContainerRequest(capability, null, null, pri, 0L, true, null, ExecutionTypeRequest.newInstance((ExecutionType)this.containerType));
        LOG.info("Requested container ask: " + request.toString());
        return request;
    }

    private boolean fileExist(String filePath) {
        return new File(filePath).exists();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String readContent(String filePath) throws IOException {
        String string;
        DataInputStream ds = null;
        try {
            ds = new DataInputStream(new FileInputStream(filePath));
            string = ds.readUTF();
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(ds);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)ds);
        return string;
    }

    private void publishContainerStartEvent(TimelineClient timelineClient, Container container, String domainId, UserGroupInformation ugi) {
        TimelineEntity entity = new TimelineEntity();
        entity.setEntityId(container.getId().toString());
        entity.setEntityType(DSEntity.DS_CONTAINER.toString());
        entity.setDomainId(domainId);
        entity.addPrimaryFilter(USER_TIMELINE_FILTER_NAME, (Object)ugi.getShortUserName());
        entity.addPrimaryFilter(APPID_TIMELINE_FILTER_NAME, (Object)container.getId().getApplicationAttemptId().getApplicationId().toString());
        TimelineEvent event = new TimelineEvent();
        event.setTimestamp(System.currentTimeMillis());
        event.setEventType(DSEvent.DS_CONTAINER_START.toString());
        event.addEventInfo("Node", (Object)container.getNodeId().toString());
        event.addEventInfo("Resources", (Object)container.getResource().toString());
        entity.addEvent(event);
        try {
            this.processTimelineResponseErrors(this.putContainerEntity(timelineClient, container.getId().getApplicationAttemptId(), entity));
        }
        catch (ClientHandlerException | IOException | YarnException e) {
            LOG.error("Container start event could not be published for " + container.getId().toString(), e);
        }
    }

    @VisibleForTesting
    void publishContainerEndEvent(TimelineClient timelineClient, ContainerStatus container, String domainId, UserGroupInformation ugi) {
        TimelineEntity entity = new TimelineEntity();
        entity.setEntityId(container.getContainerId().toString());
        entity.setEntityType(DSEntity.DS_CONTAINER.toString());
        entity.setDomainId(domainId);
        entity.addPrimaryFilter(USER_TIMELINE_FILTER_NAME, (Object)ugi.getShortUserName());
        entity.addPrimaryFilter(APPID_TIMELINE_FILTER_NAME, (Object)container.getContainerId().getApplicationAttemptId().getApplicationId().toString());
        TimelineEvent event = new TimelineEvent();
        event.setTimestamp(System.currentTimeMillis());
        event.setEventType(DSEvent.DS_CONTAINER_END.toString());
        event.addEventInfo("State", (Object)container.getState().name());
        event.addEventInfo("Exit Status", (Object)container.getExitStatus());
        entity.addEvent(event);
        try {
            this.processTimelineResponseErrors(this.putContainerEntity(timelineClient, container.getContainerId().getApplicationAttemptId(), entity));
        }
        catch (ClientHandlerException | IOException | YarnException e) {
            LOG.error("Container end event could not be published for " + container.getContainerId().toString(), e);
        }
    }

    private TimelinePutResponse putContainerEntity(TimelineClient timelineClient, ApplicationAttemptId currAttemptId, TimelineEntity entity) throws YarnException, IOException {
        if (TimelineUtils.timelineServiceV1_5Enabled((Configuration)this.conf)) {
            TimelineEntityGroupId groupId = TimelineEntityGroupId.newInstance((ApplicationId)currAttemptId.getApplicationId(), (String)CONTAINER_ENTITY_GROUP_ID);
            return timelineClient.putEntities(currAttemptId, groupId, new TimelineEntity[]{entity});
        }
        return timelineClient.putEntities(new TimelineEntity[]{entity});
    }

    private void publishApplicationAttemptEvent(TimelineClient timelineClient, String appAttemptId, DSEvent appEvent, String domainId, UserGroupInformation ugi) {
        TimelineEntity entity = new TimelineEntity();
        entity.setEntityId(appAttemptId);
        entity.setEntityType(DSEntity.DS_APP_ATTEMPT.toString());
        entity.setDomainId(domainId);
        entity.addPrimaryFilter(USER_TIMELINE_FILTER_NAME, (Object)ugi.getShortUserName());
        TimelineEvent event = new TimelineEvent();
        event.setEventType(appEvent.toString());
        event.setTimestamp(System.currentTimeMillis());
        entity.addEvent(event);
        try {
            TimelinePutResponse response = timelineClient.putEntities(new TimelineEntity[]{entity});
            this.processTimelineResponseErrors(response);
        }
        catch (ClientHandlerException | IOException | YarnException e) {
            LOG.error("App Attempt " + (appEvent.equals((Object)DSEvent.DS_APP_ATTEMPT_START) ? "start" : "end") + " event could not be published for " + this.appAttemptID, e);
        }
    }

    private TimelinePutResponse processTimelineResponseErrors(TimelinePutResponse response) {
        List errors = response.getErrors();
        if (errors.size() == 0) {
            LOG.debug("Timeline entities are successfully put");
        } else {
            for (TimelinePutResponse.TimelinePutError error : errors) {
                LOG.error("Error when publishing entity [" + error.getEntityType() + "," + error.getEntityId() + "], server side error code: " + error.getErrorCode());
            }
        }
        return response;
    }

    RMCallbackHandler getRMCallbackHandler() {
        return new RMCallbackHandler();
    }

    @VisibleForTesting
    void setAmRMClient(AMRMClientAsync client) {
        this.amRMClient = client;
    }

    @VisibleForTesting
    int getNumCompletedContainers() {
        return this.numCompletedContainers.get();
    }

    @VisibleForTesting
    boolean getDone() {
        return this.done;
    }

    @VisibleForTesting
    Thread createLaunchContainerThread(Container allocatedContainer, String shellId) {
        LaunchContainerRunnable runnableLaunchContainer = new LaunchContainerRunnable(allocatedContainer, this.containerListener, shellId);
        return new Thread(runnableLaunchContainer);
    }

    private void publishContainerStartEventOnTimelineServiceV2(Container container, long startTime) {
        final org.apache.hadoop.yarn.api.records.timelineservice.TimelineEntity entity = new org.apache.hadoop.yarn.api.records.timelineservice.TimelineEntity();
        entity.setId(container.getId().toString());
        entity.setType(DSEntity.DS_CONTAINER.toString());
        entity.setCreatedTime(Long.valueOf(startTime));
        entity.addInfo(USER_TIMELINE_FILTER_NAME, (Object)this.appSubmitterUgi.getShortUserName());
        org.apache.hadoop.yarn.api.records.timelineservice.TimelineEvent event = new org.apache.hadoop.yarn.api.records.timelineservice.TimelineEvent();
        event.setTimestamp(startTime);
        event.setId(DSEvent.DS_CONTAINER_START.toString());
        event.addInfo("Node", (Object)container.getNodeId().toString());
        event.addInfo("Resources", (Object)container.getResource().toString());
        entity.addEvent(event);
        entity.setIdPrefix(TimelineServiceHelper.invertLong((long)startTime));
        try {
            this.appSubmitterUgi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Object>(){

                @Override
                public TimelinePutResponse run() throws Exception {
                    ApplicationMaster.this.timelineV2Client.putEntities(new org.apache.hadoop.yarn.api.records.timelineservice.TimelineEntity[]{entity});
                    return null;
                }
            });
        }
        catch (Exception e) {
            LOG.error("Container start event could not be published for " + container.getId().toString(), e instanceof UndeclaredThrowableException ? e.getCause() : e);
        }
    }

    private void publishContainerEndEventOnTimelineServiceV2(ContainerStatus container, long containerStartTime) {
        final org.apache.hadoop.yarn.api.records.timelineservice.TimelineEntity entity = new org.apache.hadoop.yarn.api.records.timelineservice.TimelineEntity();
        entity.setId(container.getContainerId().toString());
        entity.setType(DSEntity.DS_CONTAINER.toString());
        entity.addInfo(USER_TIMELINE_FILTER_NAME, (Object)this.appSubmitterUgi.getShortUserName());
        org.apache.hadoop.yarn.api.records.timelineservice.TimelineEvent event = new org.apache.hadoop.yarn.api.records.timelineservice.TimelineEvent();
        event.setTimestamp(System.currentTimeMillis());
        event.setId(DSEvent.DS_CONTAINER_END.toString());
        event.addInfo("State", (Object)container.getState().name());
        event.addInfo("Exit Status", (Object)container.getExitStatus());
        entity.addEvent(event);
        entity.setIdPrefix(TimelineServiceHelper.invertLong((long)containerStartTime));
        try {
            this.appSubmitterUgi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Object>(){

                @Override
                public TimelinePutResponse run() throws Exception {
                    ApplicationMaster.this.timelineV2Client.putEntities(new org.apache.hadoop.yarn.api.records.timelineservice.TimelineEntity[]{entity});
                    return null;
                }
            });
        }
        catch (Exception e) {
            LOG.error("Container end event could not be published for " + container.getContainerId().toString(), e instanceof UndeclaredThrowableException ? e.getCause() : e);
        }
    }

    private void publishApplicationAttemptEventOnTimelineServiceV2(DSEvent appEvent) {
        final org.apache.hadoop.yarn.api.records.timelineservice.TimelineEntity entity = new org.apache.hadoop.yarn.api.records.timelineservice.TimelineEntity();
        entity.setId(this.appAttemptID.toString());
        entity.setType(DSEntity.DS_APP_ATTEMPT.toString());
        long ts = System.currentTimeMillis();
        if (appEvent == DSEvent.DS_APP_ATTEMPT_START) {
            entity.setCreatedTime(Long.valueOf(ts));
        }
        entity.addInfo(USER_TIMELINE_FILTER_NAME, (Object)this.appSubmitterUgi.getShortUserName());
        org.apache.hadoop.yarn.api.records.timelineservice.TimelineEvent event = new org.apache.hadoop.yarn.api.records.timelineservice.TimelineEvent();
        event.setId(appEvent.toString());
        event.setTimestamp(ts);
        entity.addEvent(event);
        entity.setIdPrefix(TimelineServiceHelper.invertLong((long)this.appAttemptID.getAttemptId()));
        try {
            this.appSubmitterUgi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Object>(){

                @Override
                public TimelinePutResponse run() throws Exception {
                    ApplicationMaster.this.timelineV2Client.putEntitiesAsync(new org.apache.hadoop.yarn.api.records.timelineservice.TimelineEntity[]{entity});
                    return null;
                }
            });
        }
        catch (Exception e) {
            LOG.error("App Attempt " + (appEvent.equals((Object)DSEvent.DS_APP_ATTEMPT_START) ? "start" : "end") + " event could not be published for " + this.appAttemptID, e instanceof UndeclaredThrowableException ? e.getCause() : e);
        }
    }

    private class LaunchContainerRunnable
    implements Runnable {
        private Container container;
        private String shellId;
        NMCallbackHandler containerListener;

        public LaunchContainerRunnable(Container lcontainer, NMCallbackHandler containerListener, String shellId) {
            this.container = lcontainer;
            this.containerListener = containerListener;
            this.shellId = shellId;
        }

        @Override
        public void run() {
            LOG.info("Setting up container launch container for containerid=" + this.container.getId() + " with shellid=" + this.shellId);
            HashMap<String, LocalResource> localResources = new HashMap<String, LocalResource>();
            if (!ApplicationMaster.this.scriptPath.isEmpty()) {
                Path renamedScriptPath = null;
                renamedScriptPath = Shell.WINDOWS ? new Path(ApplicationMaster.this.scriptPath + ".bat") : new Path(ApplicationMaster.this.scriptPath + ".sh");
                try {
                    ApplicationMaster.this.renameScriptFile(renamedScriptPath);
                }
                catch (Exception e) {
                    LOG.error("Not able to add suffix (.bat/.sh) to the shell script filename", (Throwable)e);
                    ApplicationMaster.this.numCompletedContainers.incrementAndGet();
                    ApplicationMaster.this.numFailedContainers.incrementAndGet();
                    return;
                }
                URL yarnUrl = null;
                try {
                    yarnUrl = URL.fromURI((URI)new URI(renamedScriptPath.toString()));
                }
                catch (URISyntaxException e) {
                    LOG.error("Error when trying to use shell script path specified in env, path=" + renamedScriptPath, (Throwable)e);
                    ApplicationMaster.this.numCompletedContainers.incrementAndGet();
                    ApplicationMaster.this.numFailedContainers.incrementAndGet();
                    return;
                }
                LocalResource shellRsrc = LocalResource.newInstance((URL)yarnUrl, (LocalResourceType)LocalResourceType.FILE, (LocalResourceVisibility)LocalResourceVisibility.APPLICATION, (long)ApplicationMaster.this.shellScriptPathLen, (long)ApplicationMaster.this.shellScriptPathTimestamp);
                localResources.put(Shell.WINDOWS ? ApplicationMaster.EXEC_BAT_SCRIPT_STRING_PATH : ApplicationMaster.EXEC_SHELL_STRING_PATH, shellRsrc);
                ApplicationMaster.this.shellCommand = Shell.WINDOWS ? "cmd /c" : "bash";
            }
            if (ApplicationMaster.this.localizableFiles.size() > 0) {
                FileSystem fs;
                try {
                    fs = FileSystem.get((Configuration)ApplicationMaster.this.conf);
                }
                catch (IOException e) {
                    throw new UncheckedIOException("Cannot get FileSystem", e);
                }
                ApplicationMaster.this.localizableFiles.stream().forEach(fileName -> {
                    try {
                        String relativePath = ApplicationMaster.getRelativePath(ApplicationMaster.this.appName, ApplicationMaster.this.appId.toString(), fileName);
                        Path dst = new Path(fs.getHomeDirectory(), relativePath);
                        FileStatus fileStatus = fs.getFileStatus(dst);
                        LocalResource localRes = LocalResource.newInstance((URL)URL.fromURI((URI)dst.toUri()), (LocalResourceType)LocalResourceType.FILE, (LocalResourceVisibility)LocalResourceVisibility.APPLICATION, (long)fileStatus.getLen(), (long)fileStatus.getModificationTime());
                        LOG.info("Setting up file for localization: " + dst);
                        localResources.put((String)fileName, localRes);
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException("Error during localization setup", e);
                    }
                });
            }
            Vector<String> vargs = new Vector<String>(5);
            vargs.add(ApplicationMaster.this.shellCommand);
            if (!ApplicationMaster.this.scriptPath.isEmpty()) {
                vargs.add(Shell.WINDOWS ? ApplicationMaster.EXEC_BAT_SCRIPT_STRING_PATH : ApplicationMaster.EXEC_SHELL_STRING_PATH);
            }
            vargs.add(ApplicationMaster.this.shellArgs);
            vargs.add("1><LOG_DIR>/stdout");
            vargs.add("2><LOG_DIR>/stderr");
            StringBuilder command = new StringBuilder();
            for (CharSequence charSequence : vargs) {
                command.append(charSequence).append(" ");
            }
            ArrayList<String> commands = new ArrayList<String>();
            commands.add(command.toString());
            HashMap<String, String> hashMap = new HashMap<String, String>(ApplicationMaster.this.shellEnv);
            hashMap.put(ApplicationMaster.YARN_SHELL_ID, this.shellId);
            ContainerRetryContext containerRetryContext = ContainerRetryContext.newInstance((ContainerRetryPolicy)ApplicationMaster.this.containerRetryPolicy, (Set)ApplicationMaster.this.containerRetryErrorCodes, (int)ApplicationMaster.this.containerMaxRetries, (int)ApplicationMaster.this.containrRetryInterval);
            ContainerLaunchContext ctx = ContainerLaunchContext.newInstance(localResources, hashMap, commands, null, (ByteBuffer)ApplicationMaster.this.allTokens.duplicate(), null, (ContainerRetryContext)containerRetryContext);
            this.containerListener.addContainer(this.container.getId(), this.container);
            ApplicationMaster.this.nmClientAsync.startContainerAsync(this.container, ctx);
        }
    }

    @VisibleForTesting
    static class NMCallbackHandler
    extends NMClientAsync.AbstractCallbackHandler {
        private ConcurrentMap<ContainerId, Container> containers = new ConcurrentHashMap<ContainerId, Container>();
        private final ApplicationMaster applicationMaster;

        public NMCallbackHandler(ApplicationMaster applicationMaster) {
            this.applicationMaster = applicationMaster;
        }

        public void addContainer(ContainerId containerId, Container container) {
            this.containers.putIfAbsent(containerId, container);
        }

        public void onContainerStopped(ContainerId containerId) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Succeeded to stop Container " + containerId);
            }
            this.containers.remove(containerId);
        }

        public void onContainerStatusReceived(ContainerId containerId, ContainerStatus containerStatus) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Container Status: id=" + containerId + ", status=" + containerStatus);
            }
        }

        public void onContainerStarted(ContainerId containerId, Map<String, ByteBuffer> allServiceResponse) {
            Container container;
            if (LOG.isDebugEnabled()) {
                LOG.debug("Succeeded to start Container " + containerId);
            }
            if ((container = (Container)this.containers.get(containerId)) != null) {
                this.applicationMaster.nmClientAsync.getContainerStatusAsync(containerId, container.getNodeId());
            }
            if (this.applicationMaster.timelineServiceV2Enabled) {
                long startTime = SystemClock.getInstance().getTime();
                this.applicationMaster.getContainerStartTimes().put(containerId, startTime);
                this.applicationMaster.publishContainerStartEventOnTimelineServiceV2(container, startTime);
            } else if (this.applicationMaster.timelineServiceV1Enabled) {
                this.applicationMaster.publishContainerStartEvent(this.applicationMaster.timelineClient, container, this.applicationMaster.domainId, this.applicationMaster.appSubmitterUgi);
            }
        }

        public void onStartContainerError(ContainerId containerId, Throwable t) {
            LOG.error("Failed to start Container " + containerId, t);
            this.containers.remove(containerId);
            this.applicationMaster.numCompletedContainers.incrementAndGet();
            this.applicationMaster.numFailedContainers.incrementAndGet();
        }

        public void onGetContainerStatusError(ContainerId containerId, Throwable t) {
            LOG.error("Failed to query the status of Container " + containerId);
        }

        public void onStopContainerError(ContainerId containerId, Throwable t) {
            LOG.error("Failed to stop Container " + containerId);
            this.containers.remove(containerId);
        }

        @Deprecated
        public void onIncreaseContainerResourceError(ContainerId containerId, Throwable t) {
        }

        @Deprecated
        public void onContainerResourceIncreased(ContainerId containerId, Resource resource) {
        }

        public void onUpdateContainerResourceError(ContainerId containerId, Throwable t) {
        }

        public void onContainerResourceUpdated(ContainerId containerId, Resource resource) {
        }
    }

    @VisibleForTesting
    class RMCallbackHandler
    extends AMRMClientAsync.AbstractCallbackHandler {
        RMCallbackHandler() {
        }

        public void onContainersCompleted(List<ContainerStatus> completedContainers) {
            LOG.info("Got response from RM for container ask, completedCnt=" + completedContainers.size());
            for (ContainerStatus containerStatus : completedContainers) {
                LOG.info(ApplicationMaster.this.appAttemptID + " got container status for containerID=" + containerStatus.getContainerId() + ", state=" + containerStatus.getState() + ", exitStatus=" + containerStatus.getExitStatus() + ", diagnostics=" + containerStatus.getDiagnostics());
                assert (containerStatus.getState() == ContainerState.COMPLETE);
                if (!ApplicationMaster.this.launchedContainers.contains(containerStatus.getContainerId())) {
                    LOG.info("Ignoring completed status of " + containerStatus.getContainerId() + "; unknown container(probably launched by previous attempt)");
                    continue;
                }
                int exitStatus = containerStatus.getExitStatus();
                if (0 != exitStatus) {
                    if (-100 != exitStatus) {
                        ApplicationMaster.this.numCompletedContainers.incrementAndGet();
                        ApplicationMaster.this.numFailedContainers.incrementAndGet();
                    } else {
                        ApplicationMaster.this.numAllocatedContainers.decrementAndGet();
                        ApplicationMaster.this.numRequestedContainers.decrementAndGet();
                    }
                } else {
                    ApplicationMaster.this.numCompletedContainers.incrementAndGet();
                    LOG.info("Container completed successfully., containerId=" + containerStatus.getContainerId());
                }
                if (ApplicationMaster.this.timelineServiceV2Enabled) {
                    Long containerStartTime = (Long)ApplicationMaster.this.containerStartTimes.get(containerStatus.getContainerId());
                    if (containerStartTime == null) {
                        containerStartTime = SystemClock.getInstance().getTime();
                        ApplicationMaster.this.containerStartTimes.put(containerStatus.getContainerId(), containerStartTime);
                    }
                    ApplicationMaster.this.publishContainerEndEventOnTimelineServiceV2(containerStatus, containerStartTime);
                    continue;
                }
                if (!ApplicationMaster.this.timelineServiceV1Enabled) continue;
                ApplicationMaster.this.publishContainerEndEvent(ApplicationMaster.this.timelineClient, containerStatus, ApplicationMaster.this.domainId, ApplicationMaster.this.appSubmitterUgi);
            }
            int askCount = ApplicationMaster.this.numTotalContainers - ApplicationMaster.this.numRequestedContainers.get();
            ApplicationMaster.this.numRequestedContainers.addAndGet(askCount);
            if (askCount > 0) {
                for (int i = 0; i < askCount; ++i) {
                    AMRMClient.ContainerRequest containerAsk = ApplicationMaster.this.setupContainerAskForRM();
                    ApplicationMaster.this.amRMClient.addContainerRequest(containerAsk);
                }
            }
            if (ApplicationMaster.this.numCompletedContainers.get() == ApplicationMaster.this.numTotalContainers) {
                ApplicationMaster.this.done = true;
            }
        }

        public void onContainersAllocated(List<Container> allocatedContainers) {
            LOG.info("Got response from RM for container ask, allocatedCnt=" + allocatedContainers.size());
            ApplicationMaster.this.numAllocatedContainers.addAndGet(allocatedContainers.size());
            for (Container allocatedContainer : allocatedContainers) {
                String yarnShellId = Integer.toString(ApplicationMaster.this.yarnShellIdCounter);
                ApplicationMaster.this.yarnShellIdCounter++;
                LOG.info("Launching shell command on a new container., containerId=" + allocatedContainer.getId() + ", yarnShellId=" + yarnShellId + ", containerNode=" + allocatedContainer.getNodeId().getHost() + ":" + allocatedContainer.getNodeId().getPort() + ", containerNodeURI=" + allocatedContainer.getNodeHttpAddress() + ", containerResourceMemory" + allocatedContainer.getResource().getMemorySize() + ", containerResourceVirtualCores" + allocatedContainer.getResource().getVirtualCores());
                Thread launchThread = ApplicationMaster.this.createLaunchContainerThread(allocatedContainer, yarnShellId);
                ApplicationMaster.this.launchThreads.add(launchThread);
                ApplicationMaster.this.launchedContainers.add(allocatedContainer.getId());
                launchThread.start();
            }
        }

        public void onContainersUpdated(List<UpdatedContainer> containers) {
        }

        public void onShutdownRequest() {
            ApplicationMaster.this.done = true;
        }

        public void onNodesUpdated(List<NodeReport> updatedNodes) {
        }

        public float getProgress() {
            float progress = (float)ApplicationMaster.this.numCompletedContainers.get() / (float)ApplicationMaster.this.numTotalContainers;
            return progress;
        }

        public void onError(Throwable e) {
            LOG.error("Error in RMCallbackHandler: ", e);
            ApplicationMaster.this.done = true;
        }
    }

    @InterfaceAudience.Private
    @VisibleForTesting
    public static enum DSEntity {
        DS_APP_ATTEMPT,
        DS_CONTAINER;

    }

    @InterfaceAudience.Private
    @VisibleForTesting
    public static enum DSEvent {
        DS_APP_ATTEMPT_START,
        DS_APP_ATTEMPT_END,
        DS_CONTAINER_START,
        DS_CONTAINER_END;

    }
}

