/*
 * Decompiled with CFR 0.152.
 */
package org.cloudera.log4j.redactor;

import java.io.IOException;
import org.apache.log4j.Priority;
import org.apache.log4j.rewrite.RewritePolicy;
import org.apache.log4j.spi.LoggingEvent;
import org.apache.log4j.spi.OptionHandler;
import org.cloudera.log4j.redactor.StringRedactor;

public class RedactorPolicy
implements RewritePolicy,
OptionHandler {
    private String rules;
    private StringRedactor redactor;

    public void setRules(String rules) {
        this.rules = rules;
    }

    public void activateOptions() {
        try {
            this.redactor = StringRedactor.createFromJsonFile(this.rules);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Problem with rules file " + this.rules, e);
        }
    }

    public LoggingEvent rewrite(LoggingEvent source) {
        String original;
        String redacted;
        Object msg;
        if (source != null && (msg = source.getMessage()) != null && !(redacted = this.redactor.redact(original = msg.toString())).equals(original)) {
            Throwable throwable = source.getThrowableInformation() != null ? source.getThrowableInformation().getThrowable() : null;
            source = new LoggingEvent(source.getFQNOfLoggerClass(), source.getLogger(), source.getTimeStamp(), (Priority)source.getLevel(), (Object)redacted, throwable);
        }
        return source;
    }
}

