/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public final class FutureUtils {
    private static final Logger LOG = LoggerFactory.getLogger(FutureUtils.class);

    private FutureUtils() {
    }

    public static <T> void addListener(CompletableFuture<T> future, BiConsumer<? super T, ? super Throwable> action) {
        future.whenComplete((resp, error) -> {
            try {
                action.accept((Object)resp, (Throwable)error);
            }
            catch (Throwable t) {
                LOG.error("Unexpected error caught when processing CompletableFuture", t);
            }
        });
    }
}

