/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.sls.synthetic;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Queue;
import java.util.Random;
import java.util.concurrent.atomic.AtomicInteger;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.math3.random.JDKRandomGenerator;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.tools.rumen.JobStory;
import org.apache.hadoop.tools.rumen.JobStoryProducer;
import org.apache.hadoop.yarn.sls.synthetic.SynthJobClass;
import org.apache.hadoop.yarn.sls.synthetic.SynthUtils;
import org.apache.hadoop.yarn.sls.synthetic.SynthWorkload;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.annotate.JsonProperty;
import org.codehaus.jackson.map.DeserializationConfig;
import org.codehaus.jackson.map.ObjectMapper;

public class SynthTraceJobProducer
implements JobStoryProducer {
    private static final Log LOG = LogFactory.getLog(SynthTraceJobProducer.class);
    private final Configuration conf;
    private final AtomicInteger numJobs;
    private final Trace trace;
    private final long seed;
    private int totalWeight;
    private final List<Double> weightList;
    private final Map<Integer, SynthWorkload> workloads;
    private final Queue<StoryParams> listStoryParams;
    private final JDKRandomGenerator rand;
    public static final String SLS_SYNTHETIC_TRACE_FILE = "sls.synthetic.trace_file";

    public SynthTraceJobProducer(Configuration conf) throws IOException {
        this(conf, new Path(conf.get(SLS_SYNTHETIC_TRACE_FILE)));
    }

    public SynthTraceJobProducer(Configuration conf, Path path) throws IOException {
        LOG.info((Object)"SynthTraceJobProducer");
        this.conf = conf;
        this.rand = new JDKRandomGenerator();
        this.workloads = new HashMap<Integer, SynthWorkload>();
        this.weightList = new ArrayList<Double>();
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(JsonParser.Feature.INTERN_FIELD_NAMES, true);
        mapper.configure(DeserializationConfig.Feature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        FileSystem ifs = path.getFileSystem(conf);
        FSDataInputStream fileIn = ifs.open(path);
        this.trace = (Trace)mapper.readValue((InputStream)fileIn, Trace.class);
        this.seed = this.trace.rand_seed;
        this.rand.setSeed(this.seed);
        this.numJobs = new AtomicInteger(this.trace.num_jobs);
        for (int workloadId = 0; workloadId < this.trace.workloads.size(); ++workloadId) {
            SynthWorkload workload = new SynthWorkload(workloadId, this.trace);
            for (int classId = 0; classId < this.trace.workloads.get((int)workloadId).job_classes.size(); ++classId) {
                SynthJobClass cls = new SynthJobClass(this.rand, this.trace, workload, classId);
                workload.add(cls);
            }
            this.workloads.put(workloadId, workload);
        }
        for (int i = 0; i < this.workloads.size(); ++i) {
            double w = this.workloads.get(i).getWorkloadWeight();
            this.totalWeight = (int)((double)this.totalWeight + w);
            this.weightList.add(w);
        }
        this.listStoryParams = new PriorityQueue<StoryParams>(10, new Comparator<StoryParams>(){

            @Override
            public int compare(StoryParams o1, StoryParams o2) {
                return Math.toIntExact(o2.actualSubmissionTime - o1.actualSubmissionTime);
            }
        });
        this.createStoryParams();
        LOG.info((Object)("Generated " + this.listStoryParams.size() + " deadlines for " + this.numJobs.get() + " jobs "));
    }

    public long getSeed() {
        return this.seed;
    }

    public int getNodesPerRack() {
        return this.trace.nodes_per_rack < 1 ? 1 : this.trace.nodes_per_rack;
    }

    public int getNumNodes() {
        return this.trace.num_nodes;
    }

    void createStoryParams() {
        for (int i = 0; i < this.numJobs.get(); ++i) {
            int workload = SynthUtils.getWeighted(this.weightList, (Random)this.rand);
            SynthWorkload pickedWorkload = this.workloads.get(workload);
            long jobClass = SynthUtils.getWeighted(pickedWorkload.getWeightList(), (Random)this.rand);
            SynthJobClass pickedJobClass = pickedWorkload.getClassList().get((int)jobClass);
            long actualSubmissionTime = pickedWorkload.getBaseSubmissionTime((Random)this.rand);
            this.listStoryParams.add(new StoryParams(pickedJobClass, actualSubmissionTime));
        }
    }

    public JobStory getNextJob() throws IOException {
        if (this.numJobs.decrementAndGet() < 0) {
            return null;
        }
        StoryParams storyParams = this.listStoryParams.poll();
        return storyParams.pickedJobClass.getJobStory(this.conf, storyParams.actualSubmissionTime);
    }

    public void close() {
    }

    public String toString() {
        return "SynthTraceJobProducer [ conf=" + this.conf + ", numJobs=" + this.numJobs + ", weightList=" + this.weightList + ", r=" + this.rand + ", totalWeight=" + this.totalWeight + ", workloads=" + this.workloads + "]";
    }

    public int getNumJobs() {
        return this.trace.num_jobs;
    }

    static class StoryParams {
        private SynthJobClass pickedJobClass;
        private long actualSubmissionTime;

        StoryParams(SynthJobClass pickedJobClass, long actualSubmissionTime) {
            this.pickedJobClass = pickedJobClass;
            this.actualSubmissionTime = actualSubmissionTime;
        }
    }

    public static class TimeSample {
        @JsonProperty(value="time")
        int time;
        @JsonProperty(value="weight")
        double jobs;
    }

    public static class JobClass {
        @JsonProperty(value="class_name")
        String class_name;
        @JsonProperty(value="user_name")
        String user_name;
        @JsonProperty(value="class_weight")
        double class_weight;
        @JsonProperty(value="chance_of_reservation")
        double chance_of_reservation;
        @JsonProperty(value="deadline_factor_avg")
        double deadline_factor_avg;
        @JsonProperty(value="deadline_factor_stddev")
        double deadline_factor_stddev;
        @JsonProperty(value="dur_avg")
        double dur_avg;
        @JsonProperty(value="dur_stddev")
        double dur_stddev;
        @JsonProperty(value="mtime_avg")
        double mtime_avg;
        @JsonProperty(value="mtime_stddev")
        double mtime_stddev;
        @JsonProperty(value="rtime_avg")
        double rtime_avg;
        @JsonProperty(value="rtime_stddev")
        double rtime_stddev;
        @JsonProperty(value="mtasks_avg")
        double mtasks_avg;
        @JsonProperty(value="mtasks_stddev")
        double mtasks_stddev;
        @JsonProperty(value="rtasks_avg")
        double rtasks_avg;
        @JsonProperty(value="rtasks_stddev")
        double rtasks_stddev;
        @JsonProperty(value="map_max_memory_avg")
        long map_max_memory_avg;
        @JsonProperty(value="map_max_memory_stddev")
        double map_max_memory_stddev;
        @JsonProperty(value="reduce_max_memory_avg")
        long reduce_max_memory_avg;
        @JsonProperty(value="reduce_max_memory_stddev")
        double reduce_max_memory_stddev;
        @JsonProperty(value="map_max_vcores_avg")
        long map_max_vcores_avg;
        @JsonProperty(value="map_max_vcores_stddev")
        double map_max_vcores_stddev;
        @JsonProperty(value="reduce_max_vcores_avg")
        long reduce_max_vcores_avg;
        @JsonProperty(value="reduce_max_vcores_stddev")
        double reduce_max_vcores_stddev;
    }

    public static class Workload {
        @JsonProperty(value="workload_name")
        String workload_name;
        @JsonProperty(value="workload_weight")
        double workload_weight;
        @JsonProperty(value="queue_name")
        String queue_name;
        @JsonProperty(value="job_classes")
        List<JobClass> job_classes;
        @JsonProperty(value="time_distribution")
        List<TimeSample> time_distribution;
    }

    @XmlRootElement
    public static class Trace {
        @JsonProperty(value="description")
        String description;
        @JsonProperty(value="num_nodes")
        int num_nodes;
        @JsonProperty(value="nodes_per_rack")
        int nodes_per_rack;
        @JsonProperty(value="num_jobs")
        int num_jobs;
        @JsonProperty(value="rand_seed")
        long rand_seed;
        @JsonProperty(value="workloads")
        List<Workload> workloads;
    }
}

