/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.sls.synthetic;

import org.apache.commons.math3.distribution.AbstractRealDistribution;
import org.apache.commons.math3.distribution.LogNormalDistribution;
import org.apache.commons.math3.random.JDKRandomGenerator;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.tools.rumen.JobStory;
import org.apache.hadoop.yarn.sls.synthetic.SynthJob;
import org.apache.hadoop.yarn.sls.synthetic.SynthTraceJobProducer;
import org.apache.hadoop.yarn.sls.synthetic.SynthUtils;
import org.apache.hadoop.yarn.sls.synthetic.SynthWorkload;

public class SynthJobClass {
    private final JDKRandomGenerator rand;
    private final LogNormalDistribution dur;
    private final LogNormalDistribution mapRuntime;
    private final LogNormalDistribution redRuntime;
    private final LogNormalDistribution mtasks;
    private final LogNormalDistribution rtasks;
    private final LogNormalDistribution mapMem;
    private final LogNormalDistribution redMem;
    private final LogNormalDistribution mapVcores;
    private final LogNormalDistribution redVcores;
    private final SynthTraceJobProducer.Trace trace;
    protected final SynthWorkload workload;
    protected final SynthTraceJobProducer.JobClass jobClass;

    public SynthJobClass(JDKRandomGenerator rand, SynthTraceJobProducer.Trace trace, SynthWorkload workload, int classId) {
        this.trace = trace;
        this.workload = workload;
        this.rand = new JDKRandomGenerator();
        this.rand.setSeed(rand.nextLong());
        this.jobClass = trace.workloads.get((int)workload.getId()).job_classes.get(classId);
        this.dur = SynthUtils.getLogNormalDist(rand, this.jobClass.dur_avg, this.jobClass.dur_stddev);
        this.mapRuntime = SynthUtils.getLogNormalDist(rand, this.jobClass.mtime_avg, this.jobClass.mtime_stddev);
        this.redRuntime = SynthUtils.getLogNormalDist(rand, this.jobClass.rtime_avg, this.jobClass.rtime_stddev);
        this.mtasks = SynthUtils.getLogNormalDist(rand, this.jobClass.mtasks_avg, this.jobClass.mtasks_stddev);
        this.rtasks = SynthUtils.getLogNormalDist(rand, this.jobClass.rtasks_avg, this.jobClass.rtasks_stddev);
        this.mapMem = SynthUtils.getLogNormalDist(rand, this.jobClass.map_max_memory_avg, this.jobClass.map_max_memory_stddev);
        this.redMem = SynthUtils.getLogNormalDist(rand, this.jobClass.reduce_max_memory_avg, this.jobClass.reduce_max_memory_stddev);
        this.mapVcores = SynthUtils.getLogNormalDist(rand, this.jobClass.map_max_vcores_avg, this.jobClass.map_max_vcores_stddev);
        this.redVcores = SynthUtils.getLogNormalDist(rand, this.jobClass.reduce_max_vcores_avg, this.jobClass.reduce_max_vcores_stddev);
    }

    public JobStory getJobStory(Configuration conf, long actualSubmissionTime) {
        return new SynthJob(this.rand, conf, this, actualSubmissionTime);
    }

    public String toString() {
        return "SynthJobClass [workload=" + this.workload.getName() + ", class=" + this.jobClass.class_name + " job_count=" + this.jobClass.class_weight + ", dur=" + (this.dur != null ? this.dur.getNumericalMean() : 0.0) + ", mapRuntime=" + (this.mapRuntime != null ? this.mapRuntime.getNumericalMean() : 0.0) + ", redRuntime=" + (this.redRuntime != null ? this.redRuntime.getNumericalMean() : 0.0) + ", mtasks=" + (this.mtasks != null ? this.mtasks.getNumericalMean() : 0.0) + ", rtasks=" + (this.rtasks != null ? this.rtasks.getNumericalMean() : 0.0) + ", chance_of_reservation=" + this.jobClass.chance_of_reservation + "]\n";
    }

    public double getClassWeight() {
        return this.jobClass.class_weight;
    }

    public long getDur() {
        return this.genLongSample((AbstractRealDistribution)this.dur);
    }

    public int getMtasks() {
        return this.genIntSample((AbstractRealDistribution)this.mtasks);
    }

    public int getRtasks() {
        return this.genIntSample((AbstractRealDistribution)this.rtasks);
    }

    public long getMapMaxMemory() {
        return this.genLongSample((AbstractRealDistribution)this.mapMem);
    }

    public long getReduceMaxMemory() {
        return this.genLongSample((AbstractRealDistribution)this.redMem);
    }

    public long getMapMaxVcores() {
        return this.genLongSample((AbstractRealDistribution)this.mapVcores);
    }

    public long getReduceMaxVcores() {
        return this.genLongSample((AbstractRealDistribution)this.redVcores);
    }

    public SynthWorkload getWorkload() {
        return this.workload;
    }

    public int genIntSample(AbstractRealDistribution dist) {
        if (dist == null) {
            return 0;
        }
        double baseSample = dist.sample();
        if (baseSample < 0.0) {
            baseSample = 0.0;
        }
        return (int)(Integer.MAX_VALUE & (long)Math.ceil(baseSample));
    }

    public long genLongSample(AbstractRealDistribution dist) {
        return dist != null ? (long)Math.ceil(dist.sample()) : 0L;
    }

    public boolean equals(Object other) {
        if (!(other instanceof SynthJobClass)) {
            return false;
        }
        SynthJobClass o = (SynthJobClass)other;
        return this.workload.equals(o.workload);
    }

    public int hashCode() {
        return this.workload.hashCode() * this.workload.getId();
    }

    public String getClassName() {
        return this.jobClass.class_name;
    }

    public long getMapTimeSample() {
        return this.genLongSample((AbstractRealDistribution)this.mapRuntime);
    }

    public long getReduceTimeSample() {
        return this.genLongSample((AbstractRealDistribution)this.redRuntime);
    }

    public String getUserName() {
        return this.jobClass.user_name;
    }
}

