/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.sls.scheduler;

import com.codahale.metrics.Timer;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ContainerStatus;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.ResourceRequest;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainer;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.UpdatedContainerInfo;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.Allocation;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ContainerUpdates;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ResourceScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerAppReport;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerApplication;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacityScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.AppAttemptAddedSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.AppAttemptRemovedSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.NodeUpdateSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.SchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.SchedulerEventType;
import org.apache.hadoop.yarn.sls.SLSRunner;
import org.apache.hadoop.yarn.sls.scheduler.NodeUpdateSchedulerEventWrapper;
import org.apache.hadoop.yarn.sls.scheduler.RMNodeWrapper;
import org.apache.hadoop.yarn.sls.scheduler.SchedulerMetrics;
import org.apache.hadoop.yarn.sls.scheduler.SchedulerWrapper;
import org.apache.hadoop.yarn.sls.scheduler.Tracker;
import org.apache.hadoop.yarn.util.resource.Resources;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class SLSCapacityScheduler
extends CapacityScheduler
implements SchedulerWrapper,
Configurable {
    private Configuration conf;
    private Map<ApplicationAttemptId, String> appQueueMap = new ConcurrentHashMap<ApplicationAttemptId, String>();
    private Map<ContainerId, Resource> preemptionContainerMap = new ConcurrentHashMap<ContainerId, Resource>();
    private SchedulerMetrics schedulerMetrics;
    private boolean metricsON;
    private Tracker tracker = new Tracker();

    @Override
    public Tracker getTracker() {
        return this.tracker;
    }

    public void setConf(Configuration conf) {
        this.conf = conf;
        super.setConf(conf);
        this.metricsON = conf.getBoolean("yarn.sls.metrics.switch", true);
        if (this.metricsON) {
            try {
                this.schedulerMetrics = SchedulerMetrics.getInstance(conf, CapacityScheduler.class);
                this.schedulerMetrics.init((ResourceScheduler)this, conf);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Allocation allocate(ApplicationAttemptId attemptId, List<ResourceRequest> resourceRequests, List<ContainerId> containerIds, List<String> strings, List<String> strings2, ContainerUpdates updateRequests) {
        if (this.metricsON) {
            Timer.Context context = this.schedulerMetrics.getSchedulerAllocateTimer().time();
            Allocation allocation = null;
            try {
                Allocation allocation2 = allocation = super.allocate(attemptId, resourceRequests, containerIds, strings, strings2, updateRequests);
                return allocation2;
            }
            finally {
                context.stop();
                this.schedulerMetrics.increaseSchedulerAllocationCounter();
                try {
                    this.updateQueueWithAllocateRequest(allocation, attemptId, resourceRequests, containerIds);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return super.allocate(attemptId, resourceRequests, containerIds, strings, strings2, updateRequests);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handle(SchedulerEvent schedulerEvent) {
        AppAttemptRemovedSchedulerEvent appRemoveEvent;
        if (!this.metricsON) {
            super.handle(schedulerEvent);
            return;
        }
        if (!this.schedulerMetrics.isRunning()) {
            this.schedulerMetrics.setRunning(true);
        }
        Timer.Context handlerTimer = null;
        Timer.Context operationTimer = null;
        try {
            if (schedulerEvent.getType() == SchedulerEventType.NODE_UPDATE && schedulerEvent instanceof NodeUpdateSchedulerEvent) {
                NodeUpdateSchedulerEventWrapper eventWrapper = new NodeUpdateSchedulerEventWrapper((NodeUpdateSchedulerEvent)schedulerEvent);
                schedulerEvent = eventWrapper;
                this.updateQueueWithNodeUpdate(eventWrapper);
            } else if (schedulerEvent.getType() == SchedulerEventType.APP_ATTEMPT_REMOVED && schedulerEvent instanceof AppAttemptRemovedSchedulerEvent) {
                appRemoveEvent = (AppAttemptRemovedSchedulerEvent)schedulerEvent;
                ApplicationAttemptId appAttemptId = appRemoveEvent.getApplicationAttemptID();
                String queue = this.appQueueMap.get(appAttemptId);
                SchedulerAppReport app = super.getSchedulerAppInfo(appAttemptId);
                if (!app.getLiveContainers().isEmpty()) {
                    RMContainer rmc = (RMContainer)app.getLiveContainers().iterator().next();
                    this.schedulerMetrics.updateQueueMetricsByRelease(rmc.getContainer().getResource(), queue);
                }
            }
            handlerTimer = this.schedulerMetrics.getSchedulerHandleTimer().time();
            operationTimer = this.schedulerMetrics.getSchedulerHandleTimer((SchedulerEventType)schedulerEvent.getType()).time();
            super.handle(schedulerEvent);
        }
        finally {
            if (handlerTimer != null) {
                handlerTimer.stop();
            }
            if (operationTimer != null) {
                operationTimer.stop();
            }
            this.schedulerMetrics.increaseSchedulerHandleCounter((SchedulerEventType)schedulerEvent.getType());
            if (schedulerEvent.getType() == SchedulerEventType.APP_ATTEMPT_REMOVED && schedulerEvent instanceof AppAttemptRemovedSchedulerEvent) {
                SLSRunner.decreaseRemainingApps();
                appRemoveEvent = (AppAttemptRemovedSchedulerEvent)schedulerEvent;
                this.appQueueMap.remove(appRemoveEvent.getApplicationAttemptID());
            } else if (schedulerEvent.getType() == SchedulerEventType.APP_ATTEMPT_ADDED && schedulerEvent instanceof AppAttemptAddedSchedulerEvent) {
                AppAttemptAddedSchedulerEvent appAddEvent = (AppAttemptAddedSchedulerEvent)schedulerEvent;
                SchedulerApplication app = (SchedulerApplication)this.applications.get(appAddEvent.getApplicationAttemptId().getApplicationId());
                this.appQueueMap.put(appAddEvent.getApplicationAttemptId(), app.getQueue().getQueueName());
            }
        }
    }

    private void updateQueueWithNodeUpdate(NodeUpdateSchedulerEventWrapper eventWrapper) {
        RMNodeWrapper node = (RMNodeWrapper)eventWrapper.getRMNode();
        List<UpdatedContainerInfo> containerList = node.getContainerUpdates();
        for (UpdatedContainerInfo info : containerList) {
            for (ContainerStatus status : info.getCompletedContainers()) {
                ContainerId containerId = status.getContainerId();
                SchedulerAppReport app = super.getSchedulerAppInfo(containerId.getApplicationAttemptId());
                if (app == null) continue;
                String queue = this.appQueueMap.get(containerId.getApplicationAttemptId());
                int releasedMemory = 0;
                int releasedVCores = 0;
                if (status.getExitStatus() == 0) {
                    for (RMContainer rmc : app.getLiveContainers()) {
                        if (rmc.getContainerId() != containerId) continue;
                        releasedMemory = (int)((long)releasedMemory + rmc.getContainer().getResource().getMemorySize());
                        releasedVCores += rmc.getContainer().getResource().getVirtualCores();
                        break;
                    }
                } else if (status.getExitStatus() == -100 && this.preemptionContainerMap.containsKey(containerId)) {
                    Resource preResource = this.preemptionContainerMap.get(containerId);
                    releasedMemory = (int)((long)releasedMemory + preResource.getMemorySize());
                    releasedVCores += preResource.getVirtualCores();
                    this.preemptionContainerMap.remove(containerId);
                }
                this.schedulerMetrics.updateQueueMetricsByRelease(Resource.newInstance((int)releasedMemory, (int)releasedVCores), queue);
            }
        }
    }

    private void updateQueueWithAllocateRequest(Allocation allocation, ApplicationAttemptId attemptId, List<ResourceRequest> resourceRequests, List<ContainerId> containerIds) throws IOException {
        Resource pendingResource = Resources.createResource((int)0, (int)0);
        Resource allocatedResource = Resources.createResource((int)0, (int)0);
        String queueName = this.appQueueMap.get(attemptId);
        for (ResourceRequest request : resourceRequests) {
            if (!request.getResourceName().equals("*")) continue;
            Resources.addTo((Resource)pendingResource, (Resource)Resources.multiply((Resource)request.getCapability(), (double)request.getNumContainers()));
        }
        for (Object container : allocation.getContainers()) {
            Resources.addTo((Resource)allocatedResource, (Resource)container.getResource());
            Resources.subtractFrom((Resource)pendingResource, (Resource)container.getResource());
        }
        SchedulerAppReport report = super.getSchedulerAppInfo(attemptId);
        for (ContainerId containerId : containerIds) {
            Container container = null;
            for (RMContainer c : report.getLiveContainers()) {
                if (!c.getContainerId().equals((Object)containerId)) continue;
                container = c.getContainer();
                break;
            }
            if (container != null) {
                Resources.subtractFrom((Resource)allocatedResource, (Resource)container.getResource());
                continue;
            }
            for (RMContainer c : report.getReservedContainers()) {
                if (!c.getContainerId().equals((Object)containerId)) continue;
                container = c.getContainer();
                break;
            }
            if (container == null) continue;
            Resources.subtractFrom((Resource)pendingResource, (Resource)container.getResource());
        }
        HashSet preemptionContainers = new HashSet();
        if (allocation.getContainerPreemptions() != null) {
            preemptionContainers.addAll(allocation.getContainerPreemptions());
        }
        if (allocation.getStrictContainerPreemptions() != null) {
            preemptionContainers.addAll(allocation.getStrictContainerPreemptions());
        }
        if (!preemptionContainers.isEmpty()) {
            for (ContainerId containerId : preemptionContainers) {
                if (this.preemptionContainerMap.containsKey(containerId)) continue;
                Container container = null;
                for (RMContainer c : report.getLiveContainers()) {
                    if (!c.getContainerId().equals((Object)containerId)) continue;
                    container = c.getContainer();
                    break;
                }
                if (container == null) continue;
                this.preemptionContainerMap.put(containerId, container.getResource());
            }
        }
        this.schedulerMetrics.updateQueueMetrics(pendingResource, allocatedResource, queueName);
    }

    public void serviceStop() throws Exception {
        try {
            this.schedulerMetrics.tearDown();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        super.serviceStop();
    }

    @Override
    public SchedulerMetrics getSchedulerMetrics() {
        return this.schedulerMetrics;
    }

    public Configuration getConf() {
        return this.conf;
    }

    @Override
    public String getRealQueueName(String queue) throws YarnException {
        if (this.getQueue(queue) == null) {
            throw new YarnException("Can't find the queue by the given name: " + queue + "! Please check if queue " + queue + " is in the allocation file.");
        }
        return this.getQueue(queue).getQueueName();
    }
}

