/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.resourceestimator.service;

import java.io.IOException;
import java.net.URI;
import javax.ws.rs.core.UriBuilder;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.http.HttpServer2;
import org.apache.hadoop.resourceestimator.service.ResourceEstimatorService;
import org.apache.hadoop.service.CompositeService;
import org.apache.hadoop.util.ShutdownHookManager;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.webapp.GenericExceptionHandler;
import org.apache.hadoop.yarn.webapp.YarnJacksonJaxbJsonProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ResourceEstimatorServer
extends CompositeService {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)ResourceEstimatorServer.class.getName());
    private HttpServer2 webServer;
    private static URI baseURI;

    public ResourceEstimatorServer() {
        super(ResourceEstimatorServer.class.getName());
    }

    private static URI getBaseURI(Configuration config) {
        baseURI = UriBuilder.fromUri((String)"http://0.0.0.0/").port(ResourceEstimatorServer.getPort(config)).build(new Object[0]);
        return baseURI;
    }

    private static int getPort(Configuration config) {
        return config.getInt("resourceestimator.service-port", 9998);
    }

    protected void serviceInit(Configuration conf) throws Exception {
        super.serviceInit(conf);
    }

    protected void serviceStart() throws Exception {
        super.serviceStart();
        this.startResourceEstimatorApp();
    }

    private void join() {
        if (this.webServer != null) {
            try {
                this.webServer.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    protected void serviceStop() throws Exception {
        if (this.webServer != null) {
            this.webServer.stop();
        }
        super.serviceStop();
    }

    private void startResourceEstimatorApp() throws IOException {
        YarnConfiguration config = new YarnConfiguration();
        config.addResource("resourceestimator-config.xml");
        HttpServer2.Builder builder = new HttpServer2.Builder().setName("ResourceEstimatorServer").setConf((Configuration)config).addEndpoint(ResourceEstimatorServer.getBaseURI((Configuration)config));
        this.webServer = builder.build();
        this.webServer.addJerseyResourcePackage(ResourceEstimatorService.class.getPackage().getName() + ";" + GenericExceptionHandler.class.getPackage().getName() + ";" + YarnJacksonJaxbJsonProvider.class.getPackage().getName(), "/*");
        this.webServer.start();
    }

    static ResourceEstimatorServer startResourceEstimatorServer() throws IOException, InterruptedException {
        YarnConfiguration config = new YarnConfiguration();
        config.addResource("resourceestimator-config.xml");
        ResourceEstimatorServer resourceEstimatorServer = null;
        try {
            resourceEstimatorServer = new ResourceEstimatorServer();
            ShutdownHookManager.get().addShutdownHook((Runnable)new CompositeService.CompositeServiceShutdownHook((CompositeService)resourceEstimatorServer), 30);
            resourceEstimatorServer.init((Configuration)config);
            resourceEstimatorServer.start();
        }
        catch (Throwable t) {
            LOGGER.error("Error starting ResourceEstimatorServer", t);
        }
        return resourceEstimatorServer;
    }

    public static void main(String[] args) throws InterruptedException, IOException {
        ResourceEstimatorServer server = ResourceEstimatorServer.startResourceEstimatorServer();
        server.join();
    }

    public void shutdown() throws Exception {
        LOGGER.info("Stopping resourceestimator service at: {}.", (Object)baseURI.toString());
        this.webServer.stop();
    }
}

