/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.api.records.impl.pb;

import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.yarn.api.protocolrecords.ResourceTypes;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.ResourceInformation;
import org.apache.hadoop.yarn.api.records.impl.pb.ProtoUtils;
import org.apache.hadoop.yarn.proto.YarnProtos;
import org.apache.hadoop.yarn.util.UnitsConversionUtil;
import org.apache.hadoop.yarn.util.resource.ResourceUtils;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class ResourcePBImpl
extends Resource {
    private static final Log LOG = LogFactory.getLog(ResourcePBImpl.class);
    YarnProtos.ResourceProto proto = YarnProtos.ResourceProto.getDefaultInstance();
    YarnProtos.ResourceProto.Builder builder = null;
    boolean viaProto = false;

    static YarnProtos.ResourceProto getProto(Resource r) {
        ResourcePBImpl pb;
        if (r instanceof ResourcePBImpl) {
            pb = (ResourcePBImpl)r;
        } else {
            pb = new ResourcePBImpl();
            pb.setMemorySize(r.getMemorySize());
            pb.setVirtualCores(r.getVirtualCores());
            for (ResourceInformation res : r.getResources()) {
                pb.setResourceInformation(res.getName(), res);
            }
        }
        return pb.getProto();
    }

    public ResourcePBImpl() {
        this.builder = YarnProtos.ResourceProto.newBuilder();
        this.initResources();
    }

    public ResourcePBImpl(YarnProtos.ResourceProto proto) {
        this.proto = proto;
        this.viaProto = true;
        this.initResources();
    }

    public YarnProtos.ResourceProto getProto() {
        this.mergeLocalToProto();
        this.proto = this.viaProto ? this.proto : this.builder.build();
        this.viaProto = true;
        return this.proto;
    }

    private void maybeInitBuilder() {
        if (this.viaProto || this.builder == null) {
            this.builder = YarnProtos.ResourceProto.newBuilder(this.proto);
        }
        this.viaProto = false;
    }

    @Override
    public int getMemory() {
        return ResourcePBImpl.castToIntSafely(this.getMemorySize());
    }

    @Override
    public long getMemorySize() {
        ResourceInformation ri = this.resources[0];
        if (ri.getUnits().isEmpty()) {
            return ri.getValue();
        }
        return UnitsConversionUtil.convert(ri.getUnits(), ResourceInformation.MEMORY_MB.getUnits(), ri.getValue());
    }

    @Override
    public void setMemory(int memory) {
        this.setMemorySize(memory);
    }

    @Override
    public void setMemorySize(long memory) {
        this.maybeInitBuilder();
        this.resources[0].setValue(memory);
    }

    @Override
    public int getVirtualCores() {
        return ResourcePBImpl.castToIntSafely(this.resources[1].getValue());
    }

    @Override
    public void setVirtualCores(int vCores) {
        this.maybeInitBuilder();
        this.resources[1].setValue(vCores);
    }

    private void initResources() {
        if (this.resources != null) {
            return;
        }
        YarnProtos.ResourceProtoOrBuilder p = this.viaProto ? this.proto : this.builder;
        ResourceInformation[] types = ResourceUtils.getResourceTypesArray();
        Map<String, Integer> indexMap = ResourceUtils.getResourceTypeIndex();
        this.resources = new ResourceInformation[types.length];
        for (YarnProtos.ResourceInformationProto entry : p.getResourceValueMapList()) {
            Integer index = indexMap.get(entry.getKey());
            if (index == null) {
                LOG.warn((Object)("Got unknown resource type: " + entry.getKey() + "; skipping"));
                continue;
            }
            this.resources[index.intValue()] = ResourcePBImpl.newDefaultInformation(types[index], entry);
        }
        this.resources[0] = ResourceInformation.newInstance(ResourceInformation.MEMORY_MB);
        this.resources[1] = ResourceInformation.newInstance(ResourceInformation.VCORES);
        this.setMemorySize(p.getMemory());
        this.setVirtualCores(p.getVirtualCores());
        this.updateResourceInformationMap(types);
    }

    private void updateResourceInformationMap(ResourceInformation[] types) {
        for (int i = 0; i < types.length; ++i) {
            if (this.resources[i] != null) continue;
            this.resources[i] = ResourceInformation.newInstance(types[i]);
        }
    }

    private static ResourceInformation newDefaultInformation(ResourceInformation resourceInformation, YarnProtos.ResourceInformationProto entry) {
        ResourceInformation ri = new ResourceInformation();
        ri.setName(resourceInformation.getName());
        ri.setMinimumAllocation(resourceInformation.getMinimumAllocation());
        ri.setMaximumAllocation(resourceInformation.getMaximumAllocation());
        ri.setResourceType(entry.hasType() ? ProtoUtils.convertFromProtoFormat(entry.getType()) : ResourceTypes.COUNTABLE);
        String units = entry.hasUnits() ? entry.getUnits() : ResourceUtils.getDefaultUnit(entry.getKey());
        long value = entry.hasValue() ? entry.getValue() : 0L;
        String destUnit = ResourceUtils.getDefaultUnit(entry.getKey());
        if (!units.equals(destUnit)) {
            ri.setValue(UnitsConversionUtil.convert(units, destUnit, value));
            ri.setUnits(destUnit);
        } else {
            ri.setUnits(units);
            ri.setValue(value);
        }
        return ri;
    }

    @Override
    public void setResourceInformation(String resource, ResourceInformation resourceInformation) {
        this.maybeInitBuilder();
        if (resource == null || resourceInformation == null) {
            throw new IllegalArgumentException("resource and/or resourceInformation cannot be null");
        }
        ResourceInformation storedResourceInfo = super.getResourceInformation(resource);
        ResourceInformation.copy(resourceInformation, storedResourceInfo);
    }

    @Override
    public void setResourceValue(String resource, long value) {
        this.maybeInitBuilder();
        if (resource == null) {
            throw new IllegalArgumentException("resource type object cannot be null");
        }
        this.getResourceInformation(resource).setValue(value);
    }

    @Override
    public ResourceInformation getResourceInformation(String resource) {
        this.initResources();
        return super.getResourceInformation(resource);
    }

    @Override
    public long getResourceValue(String resource) {
        return super.getResourceValue(resource);
    }

    private synchronized void mergeLocalToBuilder() {
        this.builder.clearResourceValueMap();
        if (this.resources != null && this.resources.length != 0) {
            for (ResourceInformation resInfo : this.resources) {
                YarnProtos.ResourceInformationProto.Builder e = YarnProtos.ResourceInformationProto.newBuilder();
                e.setKey(resInfo.getName());
                e.setUnits(resInfo.getUnits());
                e.setType(ProtoUtils.converToProtoFormat(resInfo.getResourceType()));
                e.setValue(resInfo.getValue());
                this.builder.addResourceValueMap(e);
            }
        }
        this.builder.setMemory(this.getMemorySize());
        this.builder.setVirtualCores(this.getVirtualCores());
    }

    private void mergeLocalToProto() {
        if (this.viaProto) {
            this.maybeInitBuilder();
        }
        this.mergeLocalToBuilder();
        this.proto = this.builder.build();
        this.viaProto = true;
    }
}

