/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode.ha;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.server.namenode.ha.ConfiguredFailoverProxyProvider;
import org.apache.hadoop.hdfs.server.namenode.ha.HAProxyFactory;
import org.apache.hadoop.io.retry.FailoverProxyProvider;
import org.apache.hadoop.io.retry.MultiException;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.hadoop.ipc.StandbyException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestHedgingProxyProvider<T>
extends ConfiguredFailoverProxyProvider<T> {
    public static final Logger LOG = LoggerFactory.getLogger(RequestHedgingProxyProvider.class);
    private volatile FailoverProxyProvider.ProxyInfo<T> successfulProxy = null;
    private volatile String toIgnore = null;

    public RequestHedgingProxyProvider(Configuration conf, URI uri, Class<T> xface, HAProxyFactory<T> proxyFactory) {
        super(conf, uri, xface, proxyFactory);
    }

    @Override
    public synchronized FailoverProxyProvider.ProxyInfo<T> getProxy() {
        if (this.successfulProxy != null) {
            return this.successfulProxy;
        }
        HashMap targetProxyInfos = new HashMap();
        StringBuilder combinedInfo = new StringBuilder("[");
        for (int i = 0; i < this.proxies.size(); ++i) {
            FailoverProxyProvider.ProxyInfo pInfo = super.getProxy();
            this.incrementProxyIndex();
            targetProxyInfos.put(pInfo.proxyInfo, pInfo);
            combinedInfo.append(pInfo.proxyInfo).append(',');
        }
        combinedInfo.append(']');
        Object wrappedProxy = Proxy.newProxyInstance(RequestHedgingInvocationHandler.class.getClassLoader(), new Class[]{this.xface}, (InvocationHandler)new RequestHedgingInvocationHandler(targetProxyInfos));
        return new FailoverProxyProvider.ProxyInfo<Object>(wrappedProxy, combinedInfo.toString());
    }

    @Override
    public synchronized void performFailover(T currentProxy) {
        this.toIgnore = this.successfulProxy.proxyInfo;
        this.successfulProxy = null;
    }

    private void logProxyException(Exception ex, String proxyInfo) {
        if (this.isStandbyException(ex)) {
            LOG.debug("Invocation returned standby exception on [{}]", (Object)proxyInfo);
        } else {
            LOG.warn("Invocation returned exception on [{}]", (Object)proxyInfo);
        }
    }

    private boolean isStandbyException(Exception ex) {
        Exception exception = this.unwrapException(ex);
        if (exception instanceof RemoteException) {
            return ((RemoteException)exception).unwrapRemoteException() instanceof StandbyException;
        }
        return false;
    }

    private Exception unwrapException(Exception ex) {
        Throwable cause;
        if (ex != null && (cause = ex.getCause()) instanceof Exception) {
            Throwable innerCause = cause.getCause();
            if (innerCause instanceof Exception) {
                return (Exception)innerCause;
            }
            return (Exception)cause;
        }
        return ex;
    }

    class RequestHedgingInvocationHandler
    implements InvocationHandler {
        final Map<String, FailoverProxyProvider.ProxyInfo<T>> targetProxies;

        public RequestHedgingInvocationHandler(Map<String, FailoverProxyProvider.ProxyInfo<T>> targetProxies) {
            this.targetProxies = new HashMap(targetProxies);
        }

        @Override
        public Object invoke(Object proxy, final Method method, final Object[] args) throws Throwable {
            HashMap<String, Exception> badResults;
            ExecutorService executor;
            block11: {
                HashMap proxyMap = new HashMap();
                int numAttempts = 0;
                executor = null;
                this.targetProxies.remove(RequestHedgingProxyProvider.this.toIgnore);
                if (this.targetProxies.size() == 1) {
                    FailoverProxyProvider.ProxyInfo proxyInfo = this.targetProxies.values().iterator().next();
                    Object retVal = method.invoke(proxyInfo.proxy, args);
                    RequestHedgingProxyProvider.this.successfulProxy = proxyInfo;
                    Object object = retVal;
                    return object;
                }
                executor = Executors.newFixedThreadPool(RequestHedgingProxyProvider.this.proxies.size());
                ExecutorCompletionService<Object> completionService = new ExecutorCompletionService<Object>(executor);
                for (final Map.Entry pEntry : this.targetProxies.entrySet()) {
                    Callable<Object> c = new Callable<Object>(){

                        @Override
                        public Object call() throws Exception {
                            LOG.trace("Invoking method {} on proxy {}", (Object)method, (Object)((FailoverProxyProvider.ProxyInfo)pEntry.getValue()).proxyInfo);
                            return method.invoke(((FailoverProxyProvider.ProxyInfo)pEntry.getValue()).proxy, args);
                        }
                    };
                    proxyMap.put(completionService.submit(c), pEntry.getValue());
                    ++numAttempts;
                }
                badResults = new HashMap<String, Exception>();
                while (numAttempts > 0) {
                    Future callResultFuture = completionService.take();
                    try {
                        Object retVal = callResultFuture.get();
                        RequestHedgingProxyProvider.this.successfulProxy = (FailoverProxyProvider.ProxyInfo)proxyMap.get(callResultFuture);
                        LOG.debug("Invocation successful on [{}]", (Object)((RequestHedgingProxyProvider)RequestHedgingProxyProvider.this).successfulProxy.proxyInfo);
                        Object v = retVal;
                        return v;
                    }
                    catch (Exception ex) {
                        FailoverProxyProvider.ProxyInfo tProxyInfo = (FailoverProxyProvider.ProxyInfo)proxyMap.get(callResultFuture);
                        RequestHedgingProxyProvider.this.logProxyException(ex, tProxyInfo.proxyInfo);
                        badResults.put(tProxyInfo.proxyInfo, RequestHedgingProxyProvider.this.unwrapException(ex));
                        LOG.trace("Unsuccessful invocation on [{}]", (Object)tProxyInfo.proxyInfo);
                        --numAttempts;
                    }
                }
                if (badResults.size() != 1) break block11;
                throw (Exception)badResults.values().iterator().next();
            }
            throw new MultiException(badResults);
            finally {
                if (executor != null) {
                    LOG.trace("Shutting down threadpool executor");
                    executor.shutdownNow();
                }
            }
        }
    }
}

