/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.tukaani.xz.rangecoder;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.hadoop.shaded.org.tukaani.xz.rangecoder.RangeEncoder;

public final class RangeEncoderToBuffer
extends RangeEncoder {
    private final byte[] buf;
    private int bufPos;

    public RangeEncoderToBuffer(int n) {
        this.buf = new byte[n];
        this.reset();
    }

    public void reset() {
        super.reset();
        this.bufPos = 0;
    }

    public int getPendingSize() {
        return this.bufPos + (int)this.cacheSize + 5 - 1;
    }

    public int finish() {
        try {
            super.finish();
        }
        catch (IOException iOException) {
            throw new Error();
        }
        return this.bufPos;
    }

    public void write(OutputStream outputStream) throws IOException {
        outputStream.write(this.buf, 0, this.bufPos);
    }

    void writeByte(int n) {
        this.buf[this.bufPos++] = (byte)n;
    }
}

