/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.tukaani.xz;

import java.io.InputStream;
import org.apache.hadoop.shaded.org.tukaani.xz.DeltaCoder;
import org.apache.hadoop.shaded.org.tukaani.xz.DeltaInputStream;
import org.apache.hadoop.shaded.org.tukaani.xz.FilterDecoder;
import org.apache.hadoop.shaded.org.tukaani.xz.UnsupportedOptionsException;

class DeltaDecoder
extends DeltaCoder
implements FilterDecoder {
    private final int distance;

    DeltaDecoder(byte[] byArray) throws UnsupportedOptionsException {
        if (byArray.length != 1) {
            throw new UnsupportedOptionsException("Unsupported Delta filter properties");
        }
        this.distance = (byArray[0] & 0xFF) + 1;
    }

    public int getMemoryUsage() {
        return 1;
    }

    public InputStream getInputStream(InputStream inputStream) {
        return new DeltaInputStream(inputStream, this.distance);
    }
}

