/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.apache.kerby.kerberos.kerb.client;

import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.shaded.org.apache.kerby.kerberos.kerb.KrbException;
import org.apache.hadoop.shaded.org.apache.kerby.kerberos.kerb.client.KrbConfig;
import org.apache.hadoop.shaded.org.apache.kerby.kerberos.kerb.client.KrbSetting;
import org.apache.hadoop.shaded.org.apache.kerby.kerberos.kerb.transport.TransportPair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ClientUtil {
    private static final Logger LOG = LoggerFactory.getLogger(ClientUtil.class);
    private static final String KRB5_FILE_NAME = "krb5.conf";
    private static final String KRB5_ENV_NAME = "KRB5_CONFIG";

    private ClientUtil() {
    }

    public static KrbConfig getConfig(File confDir) throws KrbException {
        File confFile = new File(confDir, KRB5_FILE_NAME);
        if (!confFile.exists()) {
            throw new KrbException("krb5.conf not found");
        }
        if (confFile != null && confFile.exists()) {
            KrbConfig krbConfig = new KrbConfig();
            try {
                krbConfig.addKrb5Config(confFile);
                return krbConfig;
            }
            catch (IOException e) {
                throw new KrbException("Failed to load krb config " + confFile.getAbsolutePath());
            }
        }
        return null;
    }

    public static KrbConfig getDefaultConfig() throws KrbException {
        String tmpEnv;
        File confFile = null;
        try {
            Map<String, String> mapEnv = System.getenv();
            tmpEnv = mapEnv.get(KRB5_ENV_NAME);
        }
        catch (SecurityException e) {
            tmpEnv = null;
        }
        if (tmpEnv != null) {
            confFile = new File(tmpEnv);
            if (!confFile.exists()) {
                throw new KrbException("krb5 conf not found. Invalid env KRB5_CONFIG");
            }
        } else {
            File confDir = new File("/etc/");
            if (confDir.exists()) {
                confFile = new File(confDir, KRB5_FILE_NAME);
            }
        }
        KrbConfig krbConfig = new KrbConfig();
        if (confFile != null && confFile.exists()) {
            try {
                krbConfig.addKrb5Config(confFile);
            }
            catch (IOException e) {
                throw new KrbException("Failed to load krb config " + confFile.getAbsolutePath());
            }
        }
        return krbConfig;
    }

    public static TransportPair getTransportPair(KrbSetting setting, String kdcString) throws KrbException, IOException {
        int tempPort;
        String kdc;
        TransportPair result = new TransportPair();
        int tcpPort = setting.checkGetKdcTcpPort();
        int udpPort = setting.checkGetKdcUdpPort();
        int port = 0;
        String portStr = null;
        if (kdcString.charAt(0) == '[') {
            int pos = kdcString.indexOf(93, 1);
            if (pos == -1) {
                throw new IOException("Illegal KDC: " + kdcString);
            }
            kdc = kdcString.substring(1, pos);
            if (pos != kdcString.length() - 1) {
                if (kdcString.charAt(pos + 1) != ':') {
                    throw new IOException("Illegal KDC: " + kdcString);
                }
                portStr = kdcString.substring(pos + 2);
            }
        } else {
            int colon = kdcString.indexOf(58);
            if (colon == -1) {
                kdc = kdcString;
            } else {
                int nextColon = kdcString.indexOf(58, colon + 1);
                if (nextColon > 0) {
                    kdc = kdcString;
                } else {
                    kdc = kdcString.substring(0, colon);
                    portStr = kdcString.substring(colon + 1);
                }
            }
        }
        if (portStr != null && (tempPort = ClientUtil.parsePositiveIntString(portStr)) > 0) {
            port = tempPort;
        }
        if (port != 0) {
            tcpPort = port;
            udpPort = port;
        }
        if (tcpPort > 0) {
            result.tcpAddress = new InetSocketAddress(kdc, tcpPort);
        }
        if (udpPort > 0) {
            result.udpAddress = new InetSocketAddress(kdc, udpPort);
        }
        return result;
    }

    private static int parsePositiveIntString(String intString) {
        if (intString == null) {
            return -1;
        }
        int ret = -1;
        try {
            ret = Integer.parseInt(intString);
        }
        catch (Exception exc) {
            return -1;
        }
        if (ret >= 0) {
            return ret;
        }
        return -1;
    }

    public static List<String> getKDCList(KrbSetting krbSetting) throws KrbException {
        ArrayList<String> kdcList = new ArrayList<String>();
        kdcList.add(krbSetting.getKdcHost());
        String realm = krbSetting.getKdcRealm();
        if (realm != null) {
            KrbConfig krbConfig = krbSetting.getKrbConfig();
            List<Object> kdcs = krbConfig.getRealmSectionItems(realm, "kdc");
            if (kdcs != null) {
                for (Object object : kdcs) {
                    kdcList.add(object != null ? object.toString() : null);
                }
            }
            if (kdcList.isEmpty()) {
                LOG.error("Cannot get kdc for realm " + realm);
            }
        } else {
            throw new KrbException("Can't get the realm");
        }
        return kdcList;
    }
}

