/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.apache.avro.message;

import java.io.IOException;
import java.io.InputStream;
import org.apache.hadoop.shaded.org.apache.avro.AvroRuntimeException;
import org.apache.hadoop.shaded.org.apache.avro.Schema;
import org.apache.hadoop.shaded.org.apache.avro.generic.GenericData;
import org.apache.hadoop.shaded.org.apache.avro.io.BinaryDecoder;
import org.apache.hadoop.shaded.org.apache.avro.io.DatumReader;
import org.apache.hadoop.shaded.org.apache.avro.io.DecoderFactory;
import org.apache.hadoop.shaded.org.apache.avro.message.MessageDecoder;

public class RawMessageDecoder<D>
extends MessageDecoder.BaseDecoder<D> {
    private static final ThreadLocal<BinaryDecoder> DECODER = new ThreadLocal();
    private final Schema writeSchema;
    private final Schema readSchema;
    private final DatumReader<D> reader;

    public RawMessageDecoder(GenericData model, Schema schema) {
        this(model, schema, schema);
    }

    public RawMessageDecoder(GenericData model, Schema writeSchema, Schema readSchema) {
        this.writeSchema = writeSchema;
        this.readSchema = readSchema;
        this.reader = model.createDatumReader(this.writeSchema, this.readSchema);
    }

    @Override
    public D decode(InputStream stream, D reuse) {
        BinaryDecoder decoder = DecoderFactory.get().directBinaryDecoder(stream, DECODER.get());
        DECODER.set(decoder);
        try {
            return this.reader.read(reuse, decoder);
        }
        catch (IOException e) {
            throw new AvroRuntimeException("Decoding datum failed", e);
        }
    }
}

