/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity;

import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ContainerStatus;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.QueueACL;
import org.apache.hadoop.yarn.api.records.QueueState;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.security.PrivilegedEntity;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainer;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainerEventType;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.AbstractUsersManager;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ResourceLimits;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ResourceUsage;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerApplicationAttempt;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CSAssignment;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.QueueCapacities;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.SchedulingMode;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.common.ResourceCommitRequest;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.common.fica.FiCaSchedulerApp;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.common.fica.FiCaSchedulerNode;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.placement.CandidateNodeSet;

@InterfaceStability.Stable
@InterfaceAudience.Private
public interface CSQueue
extends SchedulerQueue<CSQueue> {
    @Override
    public CSQueue getParent();

    public void setParent(CSQueue var1);

    @Override
    public String getQueueName();

    public String getQueuePath();

    public PrivilegedEntity getPrivilegedEntity();

    public float getCapacity();

    public float getAbsoluteCapacity();

    public float getMaximumCapacity();

    public float getAbsoluteMaximumCapacity();

    public float getAbsoluteUsedCapacity();

    public float getUsedCapacity();

    public Resource getUsedResources();

    @Override
    public QueueState getState();

    @Override
    public List<CSQueue> getChildQueues();

    @Override
    public boolean hasAccess(QueueACL var1, UserGroupInformation var2);

    public void submitApplication(ApplicationId var1, String var2, String var3) throws AccessControlException;

    public void submitApplicationAttempt(FiCaSchedulerApp var1, String var2);

    public void finishApplication(ApplicationId var1, String var2);

    public void finishApplicationAttempt(FiCaSchedulerApp var1, String var2);

    public CSAssignment assignContainers(Resource var1, CandidateNodeSet<FiCaSchedulerNode> var2, ResourceLimits var3, SchedulingMode var4);

    public void completedContainer(Resource var1, FiCaSchedulerApp var2, FiCaSchedulerNode var3, RMContainer var4, ContainerStatus var5, RMContainerEventType var6, CSQueue var7, boolean var8);

    public int getNumApplications();

    public void reinitialize(CSQueue var1, Resource var2) throws IOException;

    public void updateClusterResource(Resource var1, ResourceLimits var2);

    @Override
    public AbstractUsersManager getAbstractUsersManager();

    public void collectSchedulerApplications(Collection<ApplicationAttemptId> var1);

    public void detachContainer(Resource var1, FiCaSchedulerApp var2, RMContainer var3);

    public void attachContainer(Resource var1, FiCaSchedulerApp var2, RMContainer var3);

    public boolean getPreemptionDisabled();

    public QueueCapacities getQueueCapacities();

    public ResourceUsage getQueueResourceUsage();

    public void incUsedResource(String var1, Resource var2, SchedulerApplicationAttempt var3);

    public void decUsedResource(String var1, Resource var2, SchedulerApplicationAttempt var3);

    @Override
    public void decPendingResource(String var1, Resource var2);

    public Set<String> getNodeLabelsForQueue();

    @VisibleForTesting
    public CSAssignment assignContainers(Resource var1, FiCaSchedulerNode var2, ResourceLimits var3, SchedulingMode var4);

    public boolean accept(Resource var1, ResourceCommitRequest<FiCaSchedulerApp, FiCaSchedulerNode> var2);

    public void apply(Resource var1, ResourceCommitRequest<FiCaSchedulerApp, FiCaSchedulerNode> var2);

    public ReentrantReadWriteLock.ReadLock getReadLock();

    public void validateSubmitApplication(ApplicationId var1, String var2, String var3) throws AccessControlException;

    public Priority getPriority();

    public Map<String, Float> getUserWeights();
}

