/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.placement;

import java.io.IOException;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.security.Groups;
import org.apache.hadoop.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ApplicationSubmissionContext;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.server.resourcemanager.placement.PlacementRule;

public class UserGroupMappingPlacementRule
extends PlacementRule {
    private static final Log LOG = LogFactory.getLog(UserGroupMappingPlacementRule.class);
    public static final String CURRENT_USER_MAPPING = "%user";
    public static final String PRIMARY_GROUP_MAPPING = "%primary_group";
    private boolean overrideWithQueueMappings = false;
    private List<QueueMapping> mappings = null;
    private Groups groups;

    public UserGroupMappingPlacementRule(boolean overrideWithQueueMappings, List<QueueMapping> newMappings, Groups groups) {
        this.mappings = newMappings;
        this.overrideWithQueueMappings = overrideWithQueueMappings;
        this.groups = groups;
    }

    private String getMappedQueue(String user) throws IOException {
        for (QueueMapping mapping : this.mappings) {
            if (mapping.type == QueueMapping.MappingType.USER) {
                if (mapping.source.equals(CURRENT_USER_MAPPING)) {
                    if (mapping.queue.equals(CURRENT_USER_MAPPING)) {
                        return user;
                    }
                    if (mapping.queue.equals(PRIMARY_GROUP_MAPPING)) {
                        return (String)this.groups.getGroups(user).get(0);
                    }
                    return mapping.queue;
                }
                if (user.equals(mapping.source)) {
                    return mapping.queue;
                }
            }
            if (mapping.type != QueueMapping.MappingType.GROUP) continue;
            for (String userGroups : this.groups.getGroups(user)) {
                if (!userGroups.equals(mapping.source)) continue;
                return mapping.queue;
            }
        }
        return null;
    }

    @Override
    public String getQueueForApp(ApplicationSubmissionContext asc, String user) throws YarnException {
        String queueName = asc.getQueue();
        ApplicationId applicationId = asc.getApplicationId();
        if (this.mappings != null && this.mappings.size() > 0) {
            try {
                String mappedQueue = this.getMappedQueue(user);
                if (mappedQueue != null && (queueName.equals("default") || this.overrideWithQueueMappings)) {
                    LOG.info((Object)("Application " + applicationId + " user " + user + " mapping [" + queueName + "] to [" + mappedQueue + "] override " + this.overrideWithQueueMappings));
                    return mappedQueue;
                }
            }
            catch (IOException ioex) {
                String message = "Failed to submit application " + applicationId + " submitted by user " + user + " reason: " + ioex.getMessage();
                throw new YarnException(message);
            }
        }
        return queueName;
    }

    @VisibleForTesting
    public List<QueueMapping> getQueueMappings() {
        return this.mappings;
    }

    @InterfaceAudience.Private
    public static class QueueMapping {
        MappingType type;
        String source;
        String queue;

        public QueueMapping(MappingType type, String source, String queue) {
            this.type = type;
            this.source = source;
            this.queue = queue;
        }

        public String getQueue() {
            return this.queue;
        }

        public int hashCode() {
            return super.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj instanceof QueueMapping) {
                QueueMapping other = (QueueMapping)obj;
                return other.type.equals((Object)this.type) && other.source.equals(this.source) && other.queue.equals(this.queue);
            }
            return false;
        }

        public static enum MappingType {
            USER("u"),
            GROUP("g");

            private final String type;

            private MappingType(String type) {
                this.type = type;
            }

            public String toString() {
                return this.type;
            }
        }
    }
}

