/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.resources.gpu;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.shaded.com.google.common.collect.ImmutableSet;
import org.apache.hadoop.shaded.com.google.common.collect.Sets;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.exceptions.ResourceNotFoundException;
import org.apache.hadoop.yarn.server.nodemanager.Context;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.container.Container;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.resources.ResourceHandlerException;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.resourceplugin.gpu.AssignedGpuDevice;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.resourceplugin.gpu.GpuDevice;

public class GpuResourceAllocator {
    static final Log LOG = LogFactory.getLog(GpuResourceAllocator.class);
    private static final int WAIT_MS_PER_LOOP = 1000;
    private Set<GpuDevice> allowedGpuDevices = new TreeSet<GpuDevice>();
    private Map<GpuDevice, ContainerId> usedDevices = new TreeMap<GpuDevice, ContainerId>();
    private Context nmContext;

    public GpuResourceAllocator(Context ctx) {
        this.nmContext = ctx;
    }

    public synchronized void addGpu(GpuDevice gpuDevice) {
        this.allowedGpuDevices.add(gpuDevice);
    }

    private String getResourceHandlerExceptionMessage(int numRequestedGpuDevices, ContainerId containerId) {
        return "Failed to find enough GPUs, requestor=" + containerId + ", #RequestedGPUs=" + numRequestedGpuDevices + ", #availableGpus=" + this.getAvailableGpus();
    }

    @VisibleForTesting
    public synchronized int getAvailableGpus() {
        return this.allowedGpuDevices.size() - this.usedDevices.size();
    }

    public synchronized void recoverAssignedGpus(ContainerId containerId) throws ResourceHandlerException {
        Container c = (Container)this.nmContext.getContainers().get(containerId);
        if (null == c) {
            throw new ResourceHandlerException("This shouldn't happen, cannot find container with id=" + containerId);
        }
        for (Serializable gpuDeviceSerializable : c.getResourceMappings().getAssignedResources("yarn.io/gpu")) {
            if (!(gpuDeviceSerializable instanceof GpuDevice)) {
                throw new ResourceHandlerException("Trying to recover device id, however it is not GpuDevice, this shouldn't happen");
            }
            GpuDevice gpuDevice = (GpuDevice)gpuDeviceSerializable;
            if (!this.allowedGpuDevices.contains(gpuDevice)) {
                throw new ResourceHandlerException("Try to recover device = " + gpuDevice + " however it is not in allowed device list:" + StringUtils.join((CharSequence)",", this.allowedGpuDevices));
            }
            if (this.usedDevices.containsKey(gpuDevice)) {
                throw new ResourceHandlerException("Try to recover device id = " + gpuDevice + " however it is already assigned to container=" + this.usedDevices.get(gpuDevice) + ", please double check what happened.");
            }
            this.usedDevices.put(gpuDevice, containerId);
        }
    }

    public static int getRequestedGpus(Resource requestedResource) {
        try {
            return Long.valueOf(requestedResource.getResourceValue("yarn.io/gpu")).intValue();
        }
        catch (ResourceNotFoundException e) {
            return 0;
        }
    }

    public GpuAllocation assignGpus(Container container) throws ResourceHandlerException {
        GpuAllocation allocation = this.internalAssignGpus(container);
        int timeoutMsecs = 120000;
        for (int timeWaiting = 0; allocation == null && timeWaiting < 120000; timeWaiting += 1000) {
            try {
                LOG.info((Object)("Container : " + container.getContainerId() + " is waiting for free GPU devices."));
                Thread.sleep(1000L);
                allocation = this.internalAssignGpus(container);
                continue;
            }
            catch (InterruptedException e) {
                // empty catch block
                break;
            }
        }
        if (allocation == null) {
            String message = "Could not get valid GPU device for container '" + container.getContainerId() + "' as some other containers might not releasing GPUs.";
            LOG.warn((Object)message);
            throw new ResourceHandlerException(message);
        }
        return allocation;
    }

    private synchronized GpuAllocation internalAssignGpus(Container container) throws ResourceHandlerException {
        Resource requestedResource = container.getResource();
        ContainerId containerId = container.getContainerId();
        int numRequestedGpuDevices = GpuResourceAllocator.getRequestedGpus(requestedResource);
        if (numRequestedGpuDevices > 0) {
            if (numRequestedGpuDevices > this.getAvailableGpus() && (long)numRequestedGpuDevices <= this.getReleasingGpus() + (long)this.getAvailableGpus()) {
                return null;
            }
            if (numRequestedGpuDevices > this.getAvailableGpus()) {
                throw new ResourceHandlerException(this.getResourceHandlerExceptionMessage(numRequestedGpuDevices, containerId));
            }
            TreeSet<GpuDevice> assignedGpus = new TreeSet<GpuDevice>();
            for (GpuDevice gpu : this.allowedGpuDevices) {
                if (this.usedDevices.containsKey(gpu)) continue;
                this.usedDevices.put(gpu, containerId);
                assignedGpus.add(gpu);
                if (assignedGpus.size() != numRequestedGpuDevices) continue;
                break;
            }
            if (!assignedGpus.isEmpty()) {
                try {
                    this.nmContext.getNMStateStore().storeAssignedResources(container, "yarn.io/gpu", new ArrayList<Serializable>(assignedGpus));
                }
                catch (IOException e) {
                    this.cleanupAssignGpus(containerId);
                    throw new ResourceHandlerException(e);
                }
            }
            return new GpuAllocation(assignedGpus, (Set<GpuDevice>)Sets.difference(this.allowedGpuDevices, assignedGpus));
        }
        return new GpuAllocation(null, this.allowedGpuDevices);
    }

    private synchronized long getReleasingGpus() {
        long releasingGpus = 0L;
        for (ContainerId containerId : ImmutableSet.copyOf(this.usedDevices.values())) {
            Container container = (Container)this.nmContext.getContainers().get(containerId);
            if (container == null || !container.isContainerInFinalStates()) continue;
            releasingGpus += container.getResource().getResourceInformation("yarn.io/gpu").getValue();
        }
        return releasingGpus;
    }

    public synchronized void cleanupAssignGpus(ContainerId containerId) {
        Iterator<Map.Entry<GpuDevice, ContainerId>> iter = this.usedDevices.entrySet().iterator();
        while (iter.hasNext()) {
            if (!iter.next().getValue().equals((Object)containerId)) continue;
            iter.remove();
        }
    }

    @VisibleForTesting
    public synchronized Map<GpuDevice, ContainerId> getDeviceAllocationMappingCopy() {
        return new HashMap<GpuDevice, ContainerId>(this.usedDevices);
    }

    public synchronized List<GpuDevice> getAllowedGpusCopy() {
        return new ArrayList<GpuDevice>(this.allowedGpuDevices);
    }

    public synchronized List<AssignedGpuDevice> getAssignedGpusCopy() {
        ArrayList<AssignedGpuDevice> assigns = new ArrayList<AssignedGpuDevice>();
        for (Map.Entry<GpuDevice, ContainerId> entry : this.usedDevices.entrySet()) {
            assigns.add(new AssignedGpuDevice(entry.getKey().getIndex(), entry.getKey().getMinorNumber(), entry.getValue()));
        }
        return assigns;
    }

    public String toString() {
        return GpuResourceAllocator.class.getName();
    }

    static class GpuAllocation {
        private Set<GpuDevice> allowed = Collections.emptySet();
        private Set<GpuDevice> denied = Collections.emptySet();

        GpuAllocation(Set<GpuDevice> allowed, Set<GpuDevice> denied) {
            if (allowed != null) {
                this.allowed = ImmutableSet.copyOf(allowed);
            }
            if (denied != null) {
                this.denied = ImmutableSet.copyOf(denied);
            }
        }

        public Set<GpuDevice> getAllowedGPUs() {
            return this.allowed;
        }

        public Set<GpuDevice> getDeniedGPUs() {
            return this.denied;
        }
    }
}

