/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.resources;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.container.Container;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.privileged.PrivilegedOperation;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.resources.ResourceHandler;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.resources.ResourceHandlerException;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class ResourceHandlerChain
implements ResourceHandler {
    private final List<ResourceHandler> resourceHandlers;

    public ResourceHandlerChain(List<ResourceHandler> resourceHandlers) {
        this.resourceHandlers = resourceHandlers;
    }

    @Override
    public List<PrivilegedOperation> bootstrap(Configuration configuration) throws ResourceHandlerException {
        ArrayList<PrivilegedOperation> allOperations = new ArrayList<PrivilegedOperation>();
        for (ResourceHandler resourceHandler : this.resourceHandlers) {
            List<PrivilegedOperation> handlerOperations = resourceHandler.bootstrap(configuration);
            if (handlerOperations == null) continue;
            allOperations.addAll(handlerOperations);
        }
        return allOperations;
    }

    @Override
    public List<PrivilegedOperation> preStart(Container container) throws ResourceHandlerException {
        ArrayList<PrivilegedOperation> allOperations = new ArrayList<PrivilegedOperation>();
        for (ResourceHandler resourceHandler : this.resourceHandlers) {
            List<PrivilegedOperation> handlerOperations = resourceHandler.preStart(container);
            if (handlerOperations == null) continue;
            allOperations.addAll(handlerOperations);
        }
        return allOperations;
    }

    @Override
    public List<PrivilegedOperation> reacquireContainer(ContainerId containerId) throws ResourceHandlerException {
        ArrayList<PrivilegedOperation> allOperations = new ArrayList<PrivilegedOperation>();
        for (ResourceHandler resourceHandler : this.resourceHandlers) {
            List<PrivilegedOperation> handlerOperations = resourceHandler.reacquireContainer(containerId);
            if (handlerOperations == null) continue;
            allOperations.addAll(handlerOperations);
        }
        return allOperations;
    }

    @Override
    public List<PrivilegedOperation> postComplete(ContainerId containerId) throws ResourceHandlerException {
        ArrayList<PrivilegedOperation> allOperations = new ArrayList<PrivilegedOperation>();
        for (ResourceHandler resourceHandler : this.resourceHandlers) {
            List<PrivilegedOperation> handlerOperations = resourceHandler.postComplete(containerId);
            if (handlerOperations == null) continue;
            allOperations.addAll(handlerOperations);
        }
        return allOperations;
    }

    @Override
    public List<PrivilegedOperation> teardown() throws ResourceHandlerException {
        ArrayList<PrivilegedOperation> allOperations = new ArrayList<PrivilegedOperation>();
        for (ResourceHandler resourceHandler : this.resourceHandlers) {
            List<PrivilegedOperation> handlerOperations = resourceHandler.teardown();
            if (handlerOperations == null) continue;
            allOperations.addAll(handlerOperations);
        }
        return allOperations;
    }

    @VisibleForTesting
    public List<ResourceHandler> getResourceHandlerList() {
        return Collections.unmodifiableList(this.resourceHandlers);
    }

    public String toString() {
        return ResourceHandlerChain.class.getName() + "{resourceHandlers=" + this.resourceHandlers + '}';
    }
}

