/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.applicationhistoryservice;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.service.AbstractService;
import org.apache.hadoop.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptReport;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ApplicationReport;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ContainerReport;
import org.apache.hadoop.yarn.api.records.ContainerState;
import org.apache.hadoop.yarn.api.records.FinalApplicationStatus;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.YarnApplicationAttemptState;
import org.apache.hadoop.yarn.api.records.YarnApplicationState;
import org.apache.hadoop.yarn.server.applicationhistoryservice.ApplicationHistoryManager;
import org.apache.hadoop.yarn.server.applicationhistoryservice.ApplicationHistoryStore;
import org.apache.hadoop.yarn.server.applicationhistoryservice.FileSystemApplicationHistoryStore;
import org.apache.hadoop.yarn.server.applicationhistoryservice.records.ApplicationAttemptHistoryData;
import org.apache.hadoop.yarn.server.applicationhistoryservice.records.ApplicationHistoryData;
import org.apache.hadoop.yarn.server.applicationhistoryservice.records.ContainerHistoryData;
import org.apache.hadoop.yarn.webapp.util.WebAppUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApplicationHistoryManagerImpl
extends AbstractService
implements ApplicationHistoryManager {
    private static final Logger LOG = LoggerFactory.getLogger(ApplicationHistoryManagerImpl.class);
    private static final String UNAVAILABLE = "N/A";
    private ApplicationHistoryStore historyStore;
    private String serverHttpAddress;

    public ApplicationHistoryManagerImpl() {
        super(ApplicationHistoryManagerImpl.class.getName());
    }

    protected void serviceInit(Configuration conf) throws Exception {
        LOG.info("ApplicationHistory Init");
        this.historyStore = this.createApplicationHistoryStore(conf);
        this.historyStore.init(conf);
        this.serverHttpAddress = WebAppUtils.getHttpSchemePrefix((Configuration)conf) + WebAppUtils.getAHSWebAppURLWithoutScheme((Configuration)conf);
        super.serviceInit(conf);
    }

    protected void serviceStart() throws Exception {
        LOG.info("Starting ApplicationHistory");
        this.historyStore.start();
        super.serviceStart();
    }

    protected void serviceStop() throws Exception {
        LOG.info("Stopping ApplicationHistory");
        this.historyStore.stop();
        super.serviceStop();
    }

    protected ApplicationHistoryStore createApplicationHistoryStore(Configuration conf) {
        return (ApplicationHistoryStore)ReflectionUtils.newInstance((Class)conf.getClass("yarn.timeline-service.generic-application-history.store-class", FileSystemApplicationHistoryStore.class, ApplicationHistoryStore.class), (Configuration)conf);
    }

    @Override
    public ContainerReport getAMContainer(ApplicationAttemptId appAttemptId) throws IOException {
        ApplicationReport app = this.getApplication(appAttemptId.getApplicationId());
        return this.convertToContainerReport(this.historyStore.getAMContainer(appAttemptId), app == null ? null : app.getUser());
    }

    @Override
    public Map<ApplicationId, ApplicationReport> getApplications(long appsNum, long appStartedTimeBegin, long appStartedTimeEnd) throws IOException {
        Map histData = this.historyStore.getAllApplications();
        HashMap<ApplicationId, ApplicationReport> applicationsReport = new HashMap<ApplicationId, ApplicationReport>();
        for (Map.Entry entry : histData.entrySet()) {
            applicationsReport.put((ApplicationId)entry.getKey(), this.convertToApplicationReport((ApplicationHistoryData)entry.getValue()));
        }
        return applicationsReport;
    }

    @Override
    public ApplicationReport getApplication(ApplicationId appId) throws IOException {
        return this.convertToApplicationReport(this.historyStore.getApplication(appId));
    }

    private ApplicationReport convertToApplicationReport(ApplicationHistoryData appHistory) throws IOException {
        ApplicationAttemptId currentApplicationAttemptId = null;
        String trackingUrl = UNAVAILABLE;
        String host = UNAVAILABLE;
        int rpcPort = -1;
        ApplicationAttemptHistoryData lastAttempt = this.getLastAttempt(appHistory.getApplicationId());
        if (lastAttempt != null) {
            currentApplicationAttemptId = lastAttempt.getApplicationAttemptId();
            trackingUrl = lastAttempt.getTrackingURL();
            host = lastAttempt.getHost();
            rpcPort = lastAttempt.getRPCPort();
        }
        return ApplicationReport.newInstance((ApplicationId)appHistory.getApplicationId(), (ApplicationAttemptId)currentApplicationAttemptId, (String)appHistory.getUser(), (String)appHistory.getQueue(), (String)appHistory.getApplicationName(), (String)host, (int)rpcPort, null, (YarnApplicationState)appHistory.getYarnApplicationState(), (String)appHistory.getDiagnosticsInfo(), (String)trackingUrl, (long)appHistory.getStartTime(), (long)0L, (long)appHistory.getFinishTime(), (FinalApplicationStatus)appHistory.getFinalApplicationStatus(), null, (String)"", (float)100.0f, (String)appHistory.getApplicationType(), null);
    }

    private ApplicationAttemptHistoryData getLastAttempt(ApplicationId appId) throws IOException {
        Map attempts = this.historyStore.getApplicationAttempts(appId);
        ApplicationAttemptId prevMaxAttemptId = null;
        for (ApplicationAttemptId attemptId : attempts.keySet()) {
            if (prevMaxAttemptId == null) {
                prevMaxAttemptId = attemptId;
                continue;
            }
            if (prevMaxAttemptId.getAttemptId() >= attemptId.getAttemptId()) continue;
            prevMaxAttemptId = attemptId;
        }
        return (ApplicationAttemptHistoryData)attempts.get(prevMaxAttemptId);
    }

    private ApplicationAttemptReport convertToApplicationAttemptReport(ApplicationAttemptHistoryData appAttemptHistory) {
        return ApplicationAttemptReport.newInstance((ApplicationAttemptId)appAttemptHistory.getApplicationAttemptId(), (String)appAttemptHistory.getHost(), (int)appAttemptHistory.getRPCPort(), (String)appAttemptHistory.getTrackingURL(), null, (String)appAttemptHistory.getDiagnosticsInfo(), (YarnApplicationAttemptState)appAttemptHistory.getYarnApplicationAttemptState(), (ContainerId)appAttemptHistory.getMasterContainerId());
    }

    @Override
    public ApplicationAttemptReport getApplicationAttempt(ApplicationAttemptId appAttemptId) throws IOException {
        return this.convertToApplicationAttemptReport(this.historyStore.getApplicationAttempt(appAttemptId));
    }

    @Override
    public Map<ApplicationAttemptId, ApplicationAttemptReport> getApplicationAttempts(ApplicationId appId) throws IOException {
        Map histData = this.historyStore.getApplicationAttempts(appId);
        HashMap<ApplicationAttemptId, ApplicationAttemptReport> applicationAttemptsReport = new HashMap<ApplicationAttemptId, ApplicationAttemptReport>();
        for (Map.Entry entry : histData.entrySet()) {
            applicationAttemptsReport.put((ApplicationAttemptId)entry.getKey(), this.convertToApplicationAttemptReport((ApplicationAttemptHistoryData)entry.getValue()));
        }
        return applicationAttemptsReport;
    }

    @Override
    public ContainerReport getContainer(ContainerId containerId) throws IOException {
        ApplicationReport app = this.getApplication(containerId.getApplicationAttemptId().getApplicationId());
        return this.convertToContainerReport(this.historyStore.getContainer(containerId), app == null ? null : app.getUser());
    }

    private ContainerReport convertToContainerReport(ContainerHistoryData containerHistory, String user) {
        String logUrl = WebAppUtils.getAggregatedLogURL((String)this.serverHttpAddress, (String)containerHistory.getAssignedNode().toString(), (String)containerHistory.getContainerId().toString(), (String)containerHistory.getContainerId().toString(), (String)user);
        return ContainerReport.newInstance((ContainerId)containerHistory.getContainerId(), (Resource)containerHistory.getAllocatedResource(), (NodeId)containerHistory.getAssignedNode(), (Priority)containerHistory.getPriority(), (long)containerHistory.getStartTime(), (long)containerHistory.getFinishTime(), (String)containerHistory.getDiagnosticsInfo(), (String)logUrl, (int)containerHistory.getContainerExitStatus(), (ContainerState)containerHistory.getContainerState(), null);
    }

    @Override
    public Map<ContainerId, ContainerReport> getContainers(ApplicationAttemptId appAttemptId) throws IOException {
        ApplicationReport app = this.getApplication(appAttemptId.getApplicationId());
        Map histData = this.historyStore.getContainers(appAttemptId);
        HashMap<ContainerId, ContainerReport> containersReport = new HashMap<ContainerId, ContainerReport>();
        for (Map.Entry entry : histData.entrySet()) {
            containersReport.put((ContainerId)entry.getKey(), this.convertToContainerReport((ContainerHistoryData)entry.getValue(), app == null ? null : app.getUser()));
        }
        return containersReport;
    }

    @InterfaceAudience.Private
    @VisibleForTesting
    public ApplicationHistoryStore getHistoryStore() {
        return this.historyStore;
    }
}

