/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.mockito.internal.invocation;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.hadoop.shaded.org.hamcrest.Matcher;
import org.apache.hadoop.shaded.org.mockito.exceptions.PrintableInvocation;
import org.apache.hadoop.shaded.org.mockito.exceptions.Reporter;
import org.apache.hadoop.shaded.org.mockito.internal.debugging.Location;
import org.apache.hadoop.shaded.org.mockito.internal.exceptions.VerificationAwareInvocation;
import org.apache.hadoop.shaded.org.mockito.internal.invocation.MockitoMethod;
import org.apache.hadoop.shaded.org.mockito.internal.invocation.StubInfo;
import org.apache.hadoop.shaded.org.mockito.internal.invocation.realmethod.RealMethod;
import org.apache.hadoop.shaded.org.mockito.internal.matchers.ArrayEquals;
import org.apache.hadoop.shaded.org.mockito.internal.matchers.Equals;
import org.apache.hadoop.shaded.org.mockito.internal.matchers.MatchersPrinter;
import org.apache.hadoop.shaded.org.mockito.internal.reporting.PrintSettings;
import org.apache.hadoop.shaded.org.mockito.internal.reporting.PrintingFriendlyInvocation;
import org.apache.hadoop.shaded.org.mockito.internal.util.MockUtil;
import org.apache.hadoop.shaded.org.mockito.internal.util.ObjectMethodsGuru;
import org.apache.hadoop.shaded.org.mockito.internal.util.Primitives;
import org.apache.hadoop.shaded.org.mockito.invocation.InvocationOnMock;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Invocation
implements PrintableInvocation,
InvocationOnMock,
PrintingFriendlyInvocation,
VerificationAwareInvocation {
    private static final long serialVersionUID = 8240069639250980199L;
    private static final int MAX_LINE_LENGTH = 45;
    private final int sequenceNumber;
    private final Object mock;
    private final MockitoMethod method;
    private final Object[] arguments;
    private final Object[] rawArguments;
    private final Location location;
    private boolean verified;
    final RealMethod realMethod;
    private StubInfo stubInfo;

    public Invocation(Object mock, MockitoMethod mockitoMethod, Object[] args, int sequenceNumber, RealMethod realMethod) {
        this.method = mockitoMethod;
        this.mock = mock;
        this.realMethod = realMethod;
        this.arguments = Invocation.expandVarArgs(mockitoMethod.isVarArgs(), args);
        this.rawArguments = args;
        this.sequenceNumber = sequenceNumber;
        this.location = new Location();
    }

    private static Object[] expandVarArgs(boolean isVarArgs, Object[] args) {
        if (!isVarArgs || args[args.length - 1] != null && !args[args.length - 1].getClass().isArray()) {
            return args == null ? new Object[]{} : args;
        }
        int nonVarArgsCount = args.length - 1;
        Object[] varArgs = args[nonVarArgsCount] == null ? new Object[]{null} : ArrayEquals.createObjectArray(args[nonVarArgsCount]);
        int varArgsCount = varArgs.length;
        Object[] newArgs = new Object[nonVarArgsCount + varArgsCount];
        System.arraycopy(args, 0, newArgs, 0, nonVarArgsCount);
        System.arraycopy(varArgs, 0, newArgs, nonVarArgsCount, varArgsCount);
        return newArgs;
    }

    @Override
    public Object getMock() {
        return this.mock;
    }

    @Override
    public Method getMethod() {
        return this.method.getJavaMethod();
    }

    @Override
    public Object[] getArguments() {
        return this.arguments;
    }

    @Override
    public boolean isVerified() {
        return this.verified;
    }

    public Integer getSequenceNumber() {
        return this.sequenceNumber;
    }

    public boolean equals(Object o) {
        if (o == null || !o.getClass().equals(this.getClass())) {
            return false;
        }
        Invocation other = (Invocation)o;
        return this.mock.equals(other.mock) && this.method.equals(other.method) && this.equalArguments(other.arguments);
    }

    private boolean equalArguments(Object[] arguments) {
        return Arrays.equals(arguments, this.arguments);
    }

    public int hashCode() {
        return 1;
    }

    @Override
    public String toString() {
        return this.toString(this.argumentsToMatchers(), new PrintSettings());
    }

    protected String toString(List<Matcher> matchers, PrintSettings printSettings) {
        MatchersPrinter matchersPrinter = new MatchersPrinter();
        String method = this.qualifiedMethodName();
        String invocation = method + matchersPrinter.getArgumentsLine(matchers, printSettings);
        if (printSettings.isMultiline() || !matchers.isEmpty() && invocation.length() > 45) {
            return method + matchersPrinter.getArgumentsBlock(matchers, printSettings);
        }
        return invocation;
    }

    private String qualifiedMethodName() {
        return new MockUtil().getMockName(this.mock) + "." + this.method.getName();
    }

    protected List<Matcher> argumentsToMatchers() {
        ArrayList<Matcher> matchers = new ArrayList<Matcher>(this.arguments.length);
        for (Object arg : this.arguments) {
            if (arg != null && arg.getClass().isArray()) {
                matchers.add(new ArrayEquals(arg));
                continue;
            }
            matchers.add(new Equals(arg));
        }
        return matchers;
    }

    public static boolean isToString(InvocationOnMock invocation) {
        return new ObjectMethodsGuru().isToString(invocation.getMethod());
    }

    public boolean isValidException(Throwable throwable) {
        Class<?>[] exceptions = this.getMethod().getExceptionTypes();
        Class<?> throwableClass = throwable.getClass();
        for (Class<?> exception : exceptions) {
            if (!exception.isAssignableFrom(throwableClass)) continue;
            return true;
        }
        return false;
    }

    public boolean isValidReturnType(Class clazz) {
        if (this.method.getReturnType().isPrimitive()) {
            return Primitives.primitiveTypeOf(clazz) == this.method.getReturnType();
        }
        return this.method.getReturnType().isAssignableFrom(clazz);
    }

    public boolean isVoid() {
        return this.method.getReturnType() == Void.TYPE;
    }

    public String printMethodReturnType() {
        return this.method.getReturnType().getSimpleName();
    }

    public String getMethodName() {
        return this.method.getName();
    }

    public boolean returnsPrimitive() {
        return this.method.getReturnType().isPrimitive();
    }

    @Override
    public Location getLocation() {
        return this.location;
    }

    public int getArgumentsCount() {
        return this.arguments.length;
    }

    public Object[] getRawArguments() {
        return this.rawArguments;
    }

    @Override
    public Object callRealMethod() throws Throwable {
        if (this.isDeclaredOnInterface()) {
            new Reporter().cannotCallRealMethodOnInterface();
        }
        return this.realMethod.invoke(this.mock, this.rawArguments);
    }

    public boolean isDeclaredOnInterface() {
        return this.getMethod().getDeclaringClass().isInterface();
    }

    @Override
    public String toString(PrintSettings printSettings) {
        return this.toString(this.argumentsToMatchers(), printSettings);
    }

    void markVerified() {
        this.verified = true;
    }

    public StubInfo stubInfo() {
        return this.stubInfo;
    }

    public void markStubbed(StubInfo stubInfo) {
        this.stubInfo = stubInfo;
    }
}

