/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.com.cloudera.io.netty.handler.codec.http.websocketx;

import java.net.URI;
import java.util.List;
import org.apache.hadoop.shaded.com.cloudera.io.netty.channel.ChannelHandlerContext;
import org.apache.hadoop.shaded.com.cloudera.io.netty.channel.ChannelPipeline;
import org.apache.hadoop.shaded.com.cloudera.io.netty.handler.codec.http.HttpHeaders;
import org.apache.hadoop.shaded.com.cloudera.io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import org.apache.hadoop.shaded.com.cloudera.io.netty.handler.codec.http.websocketx.Utf8FrameValidator;
import org.apache.hadoop.shaded.com.cloudera.io.netty.handler.codec.http.websocketx.WebSocketClientHandshaker;
import org.apache.hadoop.shaded.com.cloudera.io.netty.handler.codec.http.websocketx.WebSocketClientHandshakerFactory;
import org.apache.hadoop.shaded.com.cloudera.io.netty.handler.codec.http.websocketx.WebSocketClientProtocolHandshakeHandler;
import org.apache.hadoop.shaded.com.cloudera.io.netty.handler.codec.http.websocketx.WebSocketFrame;
import org.apache.hadoop.shaded.com.cloudera.io.netty.handler.codec.http.websocketx.WebSocketProtocolHandler;
import org.apache.hadoop.shaded.com.cloudera.io.netty.handler.codec.http.websocketx.WebSocketVersion;

public class WebSocketClientProtocolHandler
extends WebSocketProtocolHandler {
    private final WebSocketClientHandshaker handshaker;
    private final boolean handleCloseFrames;

    public WebSocketClientHandshaker handshaker() {
        return this.handshaker;
    }

    public WebSocketClientProtocolHandler(URI webSocketURL, WebSocketVersion version, String subprotocol, boolean allowExtensions, HttpHeaders customHeaders, int maxFramePayloadLength, boolean handleCloseFrames, boolean performMasking, boolean allowMaskMismatch) {
        this(WebSocketClientHandshakerFactory.newHandshaker(webSocketURL, version, subprotocol, allowExtensions, customHeaders, maxFramePayloadLength, performMasking, allowMaskMismatch), handleCloseFrames);
    }

    public WebSocketClientProtocolHandler(URI webSocketURL, WebSocketVersion version, String subprotocol, boolean allowExtensions, HttpHeaders customHeaders, int maxFramePayloadLength, boolean handleCloseFrames) {
        this(webSocketURL, version, subprotocol, allowExtensions, customHeaders, maxFramePayloadLength, handleCloseFrames, true, false);
    }

    public WebSocketClientProtocolHandler(URI webSocketURL, WebSocketVersion version, String subprotocol, boolean allowExtensions, HttpHeaders customHeaders, int maxFramePayloadLength) {
        this(webSocketURL, version, subprotocol, allowExtensions, customHeaders, maxFramePayloadLength, true);
    }

    public WebSocketClientProtocolHandler(WebSocketClientHandshaker handshaker, boolean handleCloseFrames) {
        this.handshaker = handshaker;
        this.handleCloseFrames = handleCloseFrames;
    }

    public WebSocketClientProtocolHandler(WebSocketClientHandshaker handshaker) {
        this(handshaker, true);
    }

    @Override
    protected void decode(ChannelHandlerContext ctx, WebSocketFrame frame, List<Object> out) throws Exception {
        if (this.handleCloseFrames && frame instanceof CloseWebSocketFrame) {
            ctx.close();
            return;
        }
        super.decode(ctx, frame, out);
    }

    @Override
    public void handlerAdded(ChannelHandlerContext ctx) {
        ChannelPipeline cp = ctx.pipeline();
        if (cp.get(WebSocketClientProtocolHandshakeHandler.class) == null) {
            ctx.pipeline().addBefore(ctx.name(), WebSocketClientProtocolHandshakeHandler.class.getName(), new WebSocketClientProtocolHandshakeHandler(this.handshaker));
        }
        if (cp.get(Utf8FrameValidator.class) == null) {
            ctx.pipeline().addBefore(ctx.name(), Utf8FrameValidator.class.getName(), new Utf8FrameValidator());
        }
    }

    public static enum ClientHandshakeStateEvent {
        HANDSHAKE_ISSUED,
        HANDSHAKE_COMPLETE;

    }
}

