/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.com.cloudera.io.netty.channel.epoll;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.apache.hadoop.shaded.com.cloudera.io.netty.channel.Channel;
import org.apache.hadoop.shaded.com.cloudera.io.netty.channel.EventLoop;
import org.apache.hadoop.shaded.com.cloudera.io.netty.channel.epoll.AbstractEpollServerChannel;
import org.apache.hadoop.shaded.com.cloudera.io.netty.channel.epoll.EpollEventLoop;
import org.apache.hadoop.shaded.com.cloudera.io.netty.channel.epoll.EpollServerSocketChannelConfig;
import org.apache.hadoop.shaded.com.cloudera.io.netty.channel.epoll.EpollSocketChannel;
import org.apache.hadoop.shaded.com.cloudera.io.netty.channel.epoll.LinuxSocket;
import org.apache.hadoop.shaded.com.cloudera.io.netty.channel.epoll.Native;
import org.apache.hadoop.shaded.com.cloudera.io.netty.channel.epoll.TcpMd5Util;
import org.apache.hadoop.shaded.com.cloudera.io.netty.channel.socket.ServerSocketChannel;
import org.apache.hadoop.shaded.com.cloudera.io.netty.channel.unix.NativeInetAddress;

public final class EpollServerSocketChannel
extends AbstractEpollServerChannel
implements ServerSocketChannel {
    private final EpollServerSocketChannelConfig config;
    private volatile Collection<InetAddress> tcpMd5SigAddresses = Collections.emptyList();

    public EpollServerSocketChannel() {
        super(LinuxSocket.newSocketStream(), false);
        this.config = new EpollServerSocketChannelConfig(this);
    }

    public EpollServerSocketChannel(int fd) {
        this(new LinuxSocket(fd));
    }

    EpollServerSocketChannel(LinuxSocket fd) {
        super(fd);
        this.config = new EpollServerSocketChannelConfig(this);
    }

    EpollServerSocketChannel(LinuxSocket fd, boolean active) {
        super(fd, active);
        this.config = new EpollServerSocketChannelConfig(this);
    }

    @Override
    protected boolean isCompatible(EventLoop loop) {
        return loop instanceof EpollEventLoop;
    }

    @Override
    protected void doBind(SocketAddress localAddress) throws Exception {
        super.doBind(localAddress);
        if (Native.IS_SUPPORTING_TCP_FASTOPEN && this.config.getTcpFastopen() > 0) {
            this.socket.setTcpFastOpen(this.config.getTcpFastopen());
        }
        this.socket.listen(this.config.getBacklog());
        this.active = true;
    }

    @Override
    public InetSocketAddress remoteAddress() {
        return (InetSocketAddress)super.remoteAddress();
    }

    @Override
    public InetSocketAddress localAddress() {
        return (InetSocketAddress)super.localAddress();
    }

    @Override
    public EpollServerSocketChannelConfig config() {
        return this.config;
    }

    @Override
    protected Channel newChildChannel(int fd, byte[] address, int offset, int len) throws Exception {
        return new EpollSocketChannel((Channel)this, new LinuxSocket(fd), NativeInetAddress.address(address, offset, len));
    }

    Collection<InetAddress> tcpMd5SigAddresses() {
        return this.tcpMd5SigAddresses;
    }

    void setTcpMd5Sig(Map<InetAddress, byte[]> keys) throws IOException {
        this.tcpMd5SigAddresses = TcpMd5Util.newTcpMd5Sigs(this, this.tcpMd5SigAddresses, keys);
    }
}

