/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.federation.store.driver.impl;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.hadoop.hdfs.server.federation.store.StateStoreUtils;
import org.apache.hadoop.hdfs.server.federation.store.driver.impl.StateStoreFileBaseImpl;
import org.apache.hadoop.hdfs.server.federation.store.records.BaseRecord;
import org.apache.hadoop.shaded.com.google.common.io.Files;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StateStoreFileImpl
extends StateStoreFileBaseImpl {
    private static final Logger LOG = LoggerFactory.getLogger(StateStoreFileImpl.class);
    public static final String FEDERATION_STORE_FILE_DIRECTORY = "dfs.federation.router.store.driver.file.directory";
    private static final ReadWriteLock READ_WRITE_LOCK = new ReentrantReadWriteLock();
    private String rootDirectory;

    @Override
    protected boolean exists(String path) {
        File test2 = new File(path);
        return test2.exists();
    }

    @Override
    protected boolean mkdir(String path) {
        File dir = new File(path);
        return dir.mkdirs();
    }

    @Override
    protected String getRootDir() {
        if (this.rootDirectory == null) {
            String dir = this.getConf().get(FEDERATION_STORE_FILE_DIRECTORY);
            if (dir == null) {
                File tempDir = Files.createTempDir();
                dir = tempDir.getAbsolutePath();
            }
            this.rootDirectory = dir;
        }
        return this.rootDirectory;
    }

    @Override
    protected <T extends BaseRecord> void lockRecordWrite(Class<T> recordClass) {
        READ_WRITE_LOCK.writeLock().lock();
    }

    @Override
    protected <T extends BaseRecord> void unlockRecordWrite(Class<T> recordClass) {
        READ_WRITE_LOCK.writeLock().unlock();
    }

    @Override
    protected <T extends BaseRecord> void lockRecordRead(Class<T> recordClass) {
        READ_WRITE_LOCK.readLock().lock();
    }

    @Override
    protected <T extends BaseRecord> void unlockRecordRead(Class<T> recordClass) {
        READ_WRITE_LOCK.readLock().unlock();
    }

    @Override
    protected <T extends BaseRecord> BufferedReader getReader(Class<T> clazz, String sub) {
        String filename = StateStoreUtils.getRecordName(clazz);
        if (sub != null && sub.length() > 0) {
            filename = filename + "/" + sub;
        }
        filename = filename + "/" + this.getDataFileName();
        try {
            LOG.debug("Loading file: {}", (Object)filename);
            File file = new File(this.getRootDir(), filename);
            FileInputStream fis = new FileInputStream(file);
            InputStreamReader isr = new InputStreamReader((InputStream)fis, StandardCharsets.UTF_8);
            BufferedReader reader = new BufferedReader(isr);
            return reader;
        }
        catch (Exception ex) {
            LOG.error("Cannot open read stream for record {}", (Object)clazz.getSimpleName(), (Object)ex);
            return null;
        }
    }

    @Override
    protected <T extends BaseRecord> BufferedWriter getWriter(Class<T> clazz, String sub) {
        String filename = StateStoreUtils.getRecordName(clazz);
        if (sub != null && sub.length() > 0) {
            filename = filename + "/" + sub;
        }
        filename = filename + "/" + this.getDataFileName();
        try {
            File file = new File(this.getRootDir(), filename);
            FileOutputStream fos = new FileOutputStream(file, false);
            OutputStreamWriter osw = new OutputStreamWriter((OutputStream)fos, StandardCharsets.UTF_8);
            BufferedWriter writer = new BufferedWriter(osw);
            return writer;
        }
        catch (IOException ex) {
            LOG.error("Cannot open read stream for record {}", (Object)clazz.getSimpleName(), (Object)ex);
            return null;
        }
    }

    @Override
    public void close() throws Exception {
        this.setInitialized(false);
    }
}

