/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.federation.router;

import java.io.IOException;
import java.net.InetSocketAddress;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.protocol.proto.RouterProtocolProtos;
import org.apache.hadoop.hdfs.protocolPB.RouterAdminProtocolPB;
import org.apache.hadoop.hdfs.protocolPB.RouterAdminProtocolServerSideTranslatorPB;
import org.apache.hadoop.hdfs.server.federation.resolver.MountTableManager;
import org.apache.hadoop.hdfs.server.federation.router.Router;
import org.apache.hadoop.hdfs.server.federation.store.MountTableStore;
import org.apache.hadoop.hdfs.server.federation.store.protocol.AddMountTableEntryRequest;
import org.apache.hadoop.hdfs.server.federation.store.protocol.AddMountTableEntryResponse;
import org.apache.hadoop.hdfs.server.federation.store.protocol.GetMountTableEntriesRequest;
import org.apache.hadoop.hdfs.server.federation.store.protocol.GetMountTableEntriesResponse;
import org.apache.hadoop.hdfs.server.federation.store.protocol.RemoveMountTableEntryRequest;
import org.apache.hadoop.hdfs.server.federation.store.protocol.RemoveMountTableEntryResponse;
import org.apache.hadoop.hdfs.server.federation.store.protocol.UpdateMountTableEntryRequest;
import org.apache.hadoop.hdfs.server.federation.store.protocol.UpdateMountTableEntryResponse;
import org.apache.hadoop.ipc.ProtobufRpcEngine;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.service.AbstractService;
import org.apache.hadoop.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.shaded.com.google.protobuf.BlockingService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RouterAdminServer
extends AbstractService
implements MountTableManager {
    private static final Logger LOG = LoggerFactory.getLogger(RouterAdminServer.class);
    private Configuration conf;
    private final Router router;
    private MountTableStore mountTableStore;
    private final RPC.Server adminServer;
    private final InetSocketAddress adminAddress;

    public RouterAdminServer(Configuration conf, Router router) throws IOException {
        super(RouterAdminServer.class.getName());
        this.conf = conf;
        this.router = router;
        int handlerCount = this.conf.getInt("dfs.federation.router.admin.handler.count", 1);
        RPC.setProtocolEngine((Configuration)this.conf, RouterAdminProtocolPB.class, ProtobufRpcEngine.class);
        RouterAdminProtocolServerSideTranslatorPB routerAdminProtocolTranslator = new RouterAdminProtocolServerSideTranslatorPB(this);
        BlockingService clientNNPbService = RouterProtocolProtos.RouterAdminProtocolService.newReflectiveBlockingService(routerAdminProtocolTranslator);
        InetSocketAddress confRpcAddress = conf.getSocketAddr("dfs.federation.router.admin-bind-host", "dfs.federation.router.admin-address", "0.0.0.0:8111", 8111);
        String bindHost = conf.get("dfs.federation.router.admin-bind-host", confRpcAddress.getHostName());
        LOG.info("Admin server binding to {}:{}", (Object)bindHost, (Object)confRpcAddress.getPort());
        this.adminServer = new RPC.Builder(this.conf).setProtocol(RouterAdminProtocolPB.class).setInstance((Object)clientNNPbService).setBindAddress(bindHost).setPort(confRpcAddress.getPort()).setNumHandlers(handlerCount).setVerbose(false).build();
        InetSocketAddress listenAddress = this.adminServer.getListenerAddress();
        this.adminAddress = new InetSocketAddress(confRpcAddress.getHostName(), listenAddress.getPort());
        router.setAdminServerAddress(this.adminAddress);
    }

    @VisibleForTesting
    RPC.Server getAdminServer() {
        return this.adminServer;
    }

    private MountTableStore getMountTableStore() throws IOException {
        if (this.mountTableStore == null) {
            this.mountTableStore = this.router.getStateStore().getRegisteredRecordStore(MountTableStore.class);
            if (this.mountTableStore == null) {
                throw new IOException("Mount table state store is not available.");
            }
        }
        return this.mountTableStore;
    }

    public InetSocketAddress getRpcAddress() {
        return this.adminAddress;
    }

    protected void serviceInit(Configuration configuration) throws Exception {
        this.conf = configuration;
        super.serviceInit(this.conf);
    }

    protected void serviceStart() throws Exception {
        this.adminServer.start();
        super.serviceStart();
    }

    protected void serviceStop() throws Exception {
        if (this.adminServer != null) {
            this.adminServer.stop();
        }
        super.serviceStop();
    }

    @Override
    public AddMountTableEntryResponse addMountTableEntry(AddMountTableEntryRequest request) throws IOException {
        return this.getMountTableStore().addMountTableEntry(request);
    }

    @Override
    public UpdateMountTableEntryResponse updateMountTableEntry(UpdateMountTableEntryRequest request) throws IOException {
        return this.getMountTableStore().updateMountTableEntry(request);
    }

    @Override
    public RemoveMountTableEntryResponse removeMountTableEntry(RemoveMountTableEntryRequest request) throws IOException {
        return this.getMountTableStore().removeMountTableEntry(request);
    }

    @Override
    public GetMountTableEntriesResponse getMountTableEntries(GetMountTableEntriesRequest request) throws IOException {
        return this.getMountTableStore().getMountTableEntries(request);
    }
}

