/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.federation.router;

import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.service.AbstractService;
import org.apache.hadoop.service.Service;
import org.apache.hadoop.service.ServiceStateException;
import org.apache.hadoop.shaded.com.google.common.util.concurrent.ThreadFactoryBuilder;
import org.apache.hadoop.util.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PeriodicService
extends AbstractService {
    private static final Logger LOG = LoggerFactory.getLogger(PeriodicService.class);
    private static final long DEFAULT_INTERVAL_MS = TimeUnit.MINUTES.toMillis(1L);
    private long intervalMs;
    private final String serviceName;
    private final ScheduledExecutorService scheduler;
    private volatile boolean isRunning = false;
    private long runCount;
    private long errorCount;
    private long lastRun;

    public PeriodicService(String name) {
        this(name, DEFAULT_INTERVAL_MS);
    }

    public PeriodicService(String name, long interval) {
        super(name);
        this.serviceName = name;
        this.intervalMs = interval;
        ThreadFactory threadFactory = new ThreadFactoryBuilder().setNameFormat(this.getName() + "-%d").build();
        this.scheduler = Executors.newScheduledThreadPool(1, threadFactory);
    }

    protected void setIntervalMs(long interval) {
        if (this.getServiceState() == Service.STATE.STARTED) {
            throw new ServiceStateException("Periodic service already started");
        }
        this.intervalMs = interval;
    }

    protected long getIntervalMs() {
        return this.intervalMs;
    }

    protected long getErrorCount() {
        return this.errorCount;
    }

    protected long getRunCount() {
        return this.runCount;
    }

    protected long getLastUpdate() {
        return this.lastRun;
    }

    protected void serviceStart() throws Exception {
        super.serviceStart();
        LOG.info("Starting periodic service {}", (Object)this.serviceName);
        this.startPeriodic();
    }

    protected void serviceStop() throws Exception {
        this.stopPeriodic();
        LOG.info("Stopping periodic service {}", (Object)this.serviceName);
        super.serviceStop();
    }

    protected synchronized void stopPeriodic() {
        if (this.isRunning) {
            LOG.info("{} is shutting down", (Object)this.serviceName);
            this.isRunning = false;
            this.scheduler.shutdownNow();
        }
    }

    protected synchronized void startPeriodic() {
        this.stopPeriodic();
        Runnable updateRunnable = new Runnable(){

            @Override
            public void run() {
                LOG.debug("Running {} update task", (Object)PeriodicService.this.serviceName);
                try {
                    if (!PeriodicService.this.isRunning) {
                        return;
                    }
                    PeriodicService.this.periodicInvoke();
                    PeriodicService.this.runCount++;
                    PeriodicService.this.lastRun = Time.now();
                }
                catch (Exception ex) {
                    PeriodicService.this.errorCount++;
                    LOG.warn(PeriodicService.this.serviceName + " service threw an exception", (Throwable)ex);
                }
            }
        };
        this.isRunning = true;
        this.scheduler.scheduleWithFixedDelay(updateRunnable, 0L, this.intervalMs, TimeUnit.MILLISECONDS);
    }

    protected abstract void periodicInvoke();
}

