/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.federation.metrics;

import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.server.federation.metrics.StateStoreMBean;
import org.apache.hadoop.metrics2.MetricsInfo;
import org.apache.hadoop.metrics2.MetricsSystem;
import org.apache.hadoop.metrics2.annotation.Metric;
import org.apache.hadoop.metrics2.annotation.Metrics;
import org.apache.hadoop.metrics2.impl.MsInfo;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.apache.hadoop.metrics2.lib.MetricsRegistry;
import org.apache.hadoop.metrics2.lib.MutableGaugeInt;
import org.apache.hadoop.metrics2.lib.MutableRate;
import org.apache.hadoop.shaded.com.google.common.annotations.VisibleForTesting;

@Metrics(name="StateStoreActivity", about="Router metrics", context="router")
public final class StateStoreMetrics
implements StateStoreMBean {
    private final MetricsRegistry registry = new MetricsRegistry("router");
    @Metric(value={"GET transactions"})
    private MutableRate reads;
    @Metric(value={"PUT transactions"})
    private MutableRate writes;
    @Metric(value={"REMOVE transactions"})
    private MutableRate removes;
    @Metric(value={"Failed transactions"})
    private MutableRate failures;
    private Map<String, MutableGaugeInt> cacheSizes;

    private StateStoreMetrics(Configuration conf) {
        this.registry.tag((MetricsInfo)MsInfo.SessionId, "RouterSession");
        this.registry.tag((MetricsInfo)MsInfo.ProcessName, "Router");
        this.cacheSizes = new HashMap<String, MutableGaugeInt>();
    }

    public static StateStoreMetrics create(Configuration conf) {
        MetricsSystem ms = DefaultMetricsSystem.instance();
        return (StateStoreMetrics)ms.register((Object)new StateStoreMetrics(conf));
    }

    public void shutdown() {
        DefaultMetricsSystem.shutdown();
        this.reset();
    }

    public void addRead(long latency) {
        this.reads.add(latency);
    }

    @Override
    public long getReadOps() {
        return this.reads.lastStat().numSamples();
    }

    @Override
    public double getReadAvg() {
        return this.reads.lastStat().mean();
    }

    public void addWrite(long latency) {
        this.writes.add(latency);
    }

    @Override
    public long getWriteOps() {
        return this.writes.lastStat().numSamples();
    }

    @Override
    public double getWriteAvg() {
        return this.writes.lastStat().mean();
    }

    public void addFailure(long latency) {
        this.failures.add(latency);
    }

    @Override
    public long getFailureOps() {
        return this.failures.lastStat().numSamples();
    }

    @Override
    public double getFailureAvg() {
        return this.failures.lastStat().mean();
    }

    public void addRemove(long latency) {
        this.removes.add(latency);
    }

    @Override
    public long getRemoveOps() {
        return this.removes.lastStat().numSamples();
    }

    @Override
    public double getRemoveAvg() {
        return this.removes.lastStat().mean();
    }

    public void setCacheSize(String name, int size) {
        String counterName = "Cache" + name + "Size";
        MutableGaugeInt counter = this.cacheSizes.get(counterName);
        if (counter == null) {
            counter = this.registry.newGauge(counterName, name, size);
            this.cacheSizes.put(counterName, counter);
        }
        counter.set(size);
    }

    @VisibleForTesting
    public void reset() {
        this.reads.resetMinMax();
        this.writes.resetMinMax();
        this.removes.resetMinMax();
        this.failures.resetMinMax();
    }
}

