/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.federation;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.server.federation.RouterDFSCluster;
import org.apache.hadoop.hdfs.server.federation.resolver.ActiveNamenodeResolver;
import org.apache.hadoop.hdfs.server.federation.resolver.FederationNamenodeServiceState;
import org.apache.hadoop.hdfs.server.federation.resolver.FileSubclusterResolver;
import org.apache.hadoop.hdfs.server.federation.resolver.MembershipNamenodeResolver;
import org.apache.hadoop.hdfs.server.federation.resolver.MountTableResolver;
import org.apache.hadoop.hdfs.server.federation.store.FederationStateStoreTestUtils;
import org.apache.hadoop.hdfs.server.federation.store.StateStoreService;
import org.apache.hadoop.hdfs.server.federation.store.records.MembershipState;
import org.apache.hadoop.hdfs.server.federation.store.records.MountTable;

public class StateStoreDFSCluster
extends RouterDFSCluster {
    private static final Class<?> DEFAULT_FILE_RESOLVER = MountTableResolver.class;
    private static final Class<?> DEFAULT_NAMENODE_RESOLVER = MembershipNamenodeResolver.class;

    public StateStoreDFSCluster(boolean ha, int numNameservices, int numNamenodes, long heartbeatInterval, long cacheFlushInterval) throws IOException, InterruptedException {
        this(ha, numNameservices, numNamenodes, heartbeatInterval, cacheFlushInterval, DEFAULT_FILE_RESOLVER);
    }

    public StateStoreDFSCluster(boolean ha, int numNameservices, int numNamenodes, long heartbeatInterval, long cacheFlushInterval, Class<?> fileResolver) throws IOException, InterruptedException {
        super(ha, numNameservices, numNamenodes, heartbeatInterval, cacheFlushInterval);
        Configuration stateStoreConfig = FederationStateStoreTestUtils.getStateStoreConfiguration();
        stateStoreConfig.setClass("dfs.federation.router.namenode.resolver.client.class", DEFAULT_NAMENODE_RESOLVER, ActiveNamenodeResolver.class);
        stateStoreConfig.setClass("dfs.federation.router.file.resolver.client.class", fileResolver, FileSubclusterResolver.class);
        this.addRouterOverrides(stateStoreConfig);
    }

    public StateStoreDFSCluster(boolean ha, int numNameservices, Class<?> fileResolver) throws IOException, InterruptedException {
        this(ha, numNameservices, 2, DEFAULT_HEARTBEAT_INTERVAL_MS, DEFAULT_CACHE_INTERVAL_MS, fileResolver);
    }

    public StateStoreDFSCluster(boolean ha, int numNameservices) throws IOException, InterruptedException {
        this(ha, numNameservices, 2, DEFAULT_HEARTBEAT_INTERVAL_MS, DEFAULT_CACHE_INTERVAL_MS);
    }

    public StateStoreDFSCluster(boolean ha, int numNameservices, int numNamnodes) throws IOException, InterruptedException {
        this(ha, numNameservices, numNamnodes, DEFAULT_HEARTBEAT_INTERVAL_MS, DEFAULT_CACHE_INTERVAL_MS);
    }

    public void createTestRegistration(StateStoreService stateStore) throws IOException {
        ArrayList<MembershipState> entries = new ArrayList<MembershipState>();
        for (RouterDFSCluster.NamenodeContext nn : this.getNamenodes()) {
            MembershipState entry = FederationStateStoreTestUtils.createMockRegistrationForNamenode(nn.getNameserviceId(), nn.getNamenodeId(), FederationNamenodeServiceState.STANDBY);
            entries.add(entry);
        }
        FederationStateStoreTestUtils.synchronizeRecords(stateStore, entries, MembershipState.class);
    }

    public void createTestMountTable(StateStoreService stateStore) throws IOException {
        List<MountTable> mounts = this.generateMockMountTable();
        FederationStateStoreTestUtils.synchronizeRecords(stateStore, mounts, MountTable.class);
        stateStore.refreshCaches();
    }

    public List<MountTable> generateMockMountTable() throws IOException {
        ArrayList<MountTable> entries = new ArrayList<MountTable>();
        for (String ns : this.getNameservices()) {
            HashMap<String, String> destMap = new HashMap<String, String>();
            destMap.put(ns, this.getNamenodePathForNS(ns));
            String fedPath = this.getFederatedPathForNS(ns);
            MountTable entry = MountTable.newInstance(fedPath, destMap);
            entries.add(entry);
        }
        HashMap<String, String> destMap = new HashMap<String, String>();
        String ns0 = this.getNameservices().get(0);
        destMap.put(ns0, "/");
        MountTable entry = MountTable.newInstance("/", destMap);
        entries.add(entry);
        return entries;
    }
}

