/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.federation;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.server.federation.resolver.ActiveNamenodeResolver;
import org.apache.hadoop.hdfs.server.federation.resolver.FederationNamenodeContext;
import org.apache.hadoop.hdfs.server.federation.resolver.FederationNamenodeServiceState;
import org.apache.hadoop.hdfs.server.federation.resolver.FederationNamespaceInfo;
import org.apache.hadoop.hdfs.server.federation.resolver.FileSubclusterResolver;
import org.apache.hadoop.hdfs.server.federation.resolver.NamenodePriorityComparator;
import org.apache.hadoop.hdfs.server.federation.resolver.NamenodeStatusReport;
import org.apache.hadoop.hdfs.server.federation.resolver.PathLocation;
import org.apache.hadoop.hdfs.server.federation.resolver.RemoteLocation;
import org.apache.hadoop.hdfs.server.federation.router.Router;
import org.apache.hadoop.hdfs.server.federation.store.StateStoreService;
import org.apache.hadoop.util.Time;

public class MockResolver
implements ActiveNamenodeResolver,
FileSubclusterResolver {
    private Map<String, List<? extends FederationNamenodeContext>> resolver = new HashMap<String, List<? extends FederationNamenodeContext>>();
    private Map<String, List<RemoteLocation>> locations = new HashMap<String, List<RemoteLocation>>();
    private Set<FederationNamespaceInfo> namespaces = new HashSet<FederationNamespaceInfo>();
    private String defaultNamespace = null;

    public MockResolver() {
        this.cleanRegistrations();
    }

    public MockResolver(Configuration conf) {
        this();
    }

    public MockResolver(Configuration conf, StateStoreService store) {
        this();
    }

    public MockResolver(Configuration conf, Router router) {
        this();
    }

    public void addLocation(String mount, String nsId, String location) {
        RemoteLocation remoteLocation;
        List<RemoteLocation> locationsList = this.locations.get(mount);
        if (locationsList == null) {
            locationsList = new LinkedList<RemoteLocation>();
            this.locations.put(mount, locationsList);
        }
        if (!locationsList.contains(remoteLocation = new RemoteLocation(nsId, location))) {
            locationsList.add(remoteLocation);
        }
        if (this.defaultNamespace == null) {
            this.defaultNamespace = nsId;
        }
    }

    public synchronized void cleanRegistrations() {
        this.resolver = new HashMap<String, List<? extends FederationNamenodeContext>>();
        this.namespaces = new HashSet<FederationNamespaceInfo>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateActiveNamenode(String nsId, InetSocketAddress successfulAddress) {
        String address = successfulAddress.getHostName() + ":" + successfulAddress.getPort();
        String key = nsId;
        if (key != null) {
            List<? extends FederationNamenodeContext> namenodes = this.resolver.get(key);
            for (FederationNamenodeContext federationNamenodeContext : namenodes) {
                if (!federationNamenodeContext.getRpcAddress().equals(address)) continue;
                MockNamenodeContext nn = (MockNamenodeContext)federationNamenodeContext;
                nn.setState(FederationNamenodeServiceState.ACTIVE);
                break;
            }
            List<? extends FederationNamenodeContext> list = namenodes;
            synchronized (list) {
                Collections.sort(namenodes, new NamenodePriorityComparator());
            }
        }
    }

    @Override
    public List<? extends FederationNamenodeContext> getNamenodesForNameserviceId(String nameserviceId) {
        List<? extends FederationNamenodeContext> namenodes = this.resolver.get(nameserviceId);
        return Collections.unmodifiableList(new ArrayList<FederationNamenodeContext>(namenodes));
    }

    @Override
    public List<? extends FederationNamenodeContext> getNamenodesForBlockPoolId(String blockPoolId) {
        List<? extends FederationNamenodeContext> namenodes = this.resolver.get(blockPoolId);
        return Collections.unmodifiableList(new ArrayList<FederationNamenodeContext>(namenodes));
    }

    @Override
    public synchronized boolean registerNamenode(NamenodeStatusReport report) throws IOException {
        MockNamenodeContext context = new MockNamenodeContext(report.getRpcAddress(), report.getServiceAddress(), report.getLifelineAddress(), report.getWebAddress(), report.getNameserviceId(), report.getNamenodeId(), report.getState());
        String nsId = report.getNameserviceId();
        String bpId = report.getBlockPoolId();
        String cId = report.getClusterId();
        List<? extends FederationNamenodeContext> existingItems = this.resolver.get(nsId);
        if (existingItems == null) {
            existingItems = new ArrayList<FederationNamenodeContext>();
            this.resolver.put(bpId, existingItems);
            this.resolver.put(nsId, existingItems);
        }
        boolean added = false;
        for (int i = 0; i < existingItems.size() && !added; ++i) {
            MockNamenodeContext existing = (MockNamenodeContext)existingItems.get(i);
            if (!existing.getNamenodeKey().equals(context.getNamenodeKey())) continue;
            existingItems.set(i, context);
            added = true;
        }
        if (!added) {
            existingItems.add(context);
        }
        Collections.sort(existingItems, new NamenodePriorityComparator());
        FederationNamespaceInfo info = new FederationNamespaceInfo(bpId, cId, nsId);
        this.namespaces.add(info);
        return true;
    }

    @Override
    public Set<FederationNamespaceInfo> getNamespaces() throws IOException {
        return this.namespaces;
    }

    @Override
    public PathLocation getDestinationForPath(String path) throws IOException {
        LinkedList<RemoteLocation> remoteLocations = new LinkedList<RemoteLocation>();
        ArrayList<String> keys = new ArrayList<String>(this.locations.keySet());
        Collections.sort(keys, Collections.reverseOrder());
        for (String key : keys) {
            if (!path.startsWith(key)) continue;
            for (RemoteLocation location : this.locations.get(key)) {
                String finalPath = location.getDest() + path.substring(key.length());
                String nameservice = location.getNameserviceId();
                RemoteLocation remoteLocation = new RemoteLocation(nameservice, finalPath);
                remoteLocations.add(remoteLocation);
            }
        }
        if (remoteLocations.isEmpty()) {
            return null;
        }
        return new PathLocation(path, remoteLocations);
    }

    @Override
    public List<String> getMountPoints(String path) throws IOException {
        ArrayList<String> mounts = new ArrayList<String>();
        if (path.equals("/")) {
            for (String mount : this.locations.keySet()) {
                if (mount.length() <= 1) continue;
                mounts.add(mount.replace("/", ""));
            }
        }
        return mounts;
    }

    @Override
    public void setRouterId(String router) {
    }

    @Override
    public String getDefaultNamespace() {
        return this.defaultNamespace;
    }

    private static class MockNamenodeContext
    implements FederationNamenodeContext {
        private String namenodeId;
        private String nameserviceId;
        private String webAddress;
        private String rpcAddress;
        private String serviceAddress;
        private String lifelineAddress;
        private FederationNamenodeServiceState state;
        private long dateModified;

        MockNamenodeContext(String rpc, String service, String lifeline, String web, String ns, String nn, FederationNamenodeServiceState state) {
            this.rpcAddress = rpc;
            this.serviceAddress = service;
            this.lifelineAddress = lifeline;
            this.webAddress = web;
            this.namenodeId = nn;
            this.nameserviceId = ns;
            this.state = state;
            this.dateModified = Time.now();
        }

        public void setState(FederationNamenodeServiceState newState) {
            this.state = newState;
            this.dateModified = Time.now();
        }

        @Override
        public String getRpcAddress() {
            return this.rpcAddress;
        }

        @Override
        public String getServiceAddress() {
            return this.serviceAddress;
        }

        @Override
        public String getLifelineAddress() {
            return this.lifelineAddress;
        }

        @Override
        public String getWebAddress() {
            return this.webAddress;
        }

        @Override
        public String getNamenodeKey() {
            return this.nameserviceId + " " + this.namenodeId + " " + this.rpcAddress;
        }

        @Override
        public String getNameserviceId() {
            return this.nameserviceId;
        }

        @Override
        public String getNamenodeId() {
            return this.namenodeId;
        }

        @Override
        public FederationNamenodeServiceState getState() {
            return this.state;
        }

        @Override
        public long getDateModified() {
            return this.dateModified;
        }
    }
}

