/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode.fsdataset.impl;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Iterator;
import java.util.Scanner;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.CachingGetSpaceUsed;
import org.apache.hadoop.fs.GetSpaceUsed;
import org.apache.hadoop.hdfs.DFSUtilClient;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.protocol.BlockListAsLongs;
import org.apache.hadoop.hdfs.server.common.HdfsServerConstants;
import org.apache.hadoop.hdfs.server.datanode.DatanodeUtil;
import org.apache.hadoop.hdfs.server.datanode.FileIoProvider;
import org.apache.hadoop.hdfs.server.datanode.ReplicaBuilder;
import org.apache.hadoop.hdfs.server.datanode.ReplicaInfo;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.FsVolumeSpi;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.FsDatasetImpl;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.FsDatasetUtil;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.FsVolumeImpl;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.RamDiskReplicaTracker;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.ReplicaMap;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.util.AutoCloseableLock;
import org.apache.hadoop.util.DiskChecker;
import org.apache.hadoop.util.ShutdownHookManager;
import org.apache.hadoop.util.Timer;

class BlockPoolSlice {
    static final Log LOG = LogFactory.getLog(BlockPoolSlice.class);
    private final String bpid;
    private final FsVolumeImpl volume;
    private final File currentDir;
    private final File finalizedDir;
    private final File lazypersistDir;
    private final File rbwDir;
    private final File tmpDir;
    private final int ioFileBufferSize;
    @VisibleForTesting
    public static final String DU_CACHE_FILE = "dfsUsed";
    private volatile boolean dfsUsedSaved = false;
    private static final int SHUTDOWN_HOOK_PRIORITY = 30;
    private final boolean deleteDuplicateReplicas;
    private static final String REPLICA_CACHE_FILE = "replicas";
    private final long replicaCacheExpiry = 300000L;
    private AtomicLong numOfBlocks = new AtomicLong();
    private final long cachedDfsUsedCheckTime;
    private final Timer timer;
    private final int maxDataLength;
    private final FileIoProvider fileIoProvider;
    private final GetSpaceUsed dfsUsage;

    BlockPoolSlice(String bpid, FsVolumeImpl volume, File bpDir, Configuration conf, Timer timer) throws IOException {
        this.bpid = bpid;
        this.volume = volume;
        this.fileIoProvider = volume.getFileIoProvider();
        this.currentDir = new File(bpDir, "current");
        this.finalizedDir = new File(this.currentDir, "finalized");
        this.lazypersistDir = new File(this.currentDir, "lazypersist");
        if (!this.finalizedDir.exists() && !this.finalizedDir.mkdirs()) {
            throw new IOException("Failed to mkdirs " + this.finalizedDir);
        }
        this.ioFileBufferSize = DFSUtilClient.getIoFileBufferSize((Configuration)conf);
        this.deleteDuplicateReplicas = conf.getBoolean("dfs.datanode.duplicate.replica.deletion", true);
        this.cachedDfsUsedCheckTime = conf.getLong("dfs.datanode.cached-dfsused.check.interval.ms", 600000L);
        this.maxDataLength = conf.getInt("ipc.maximum.data.length", 0x4000000);
        this.timer = timer;
        this.tmpDir = new File(bpDir, "tmp");
        if (this.tmpDir.exists()) {
            this.fileIoProvider.fullyDelete(volume, this.tmpDir);
        }
        this.rbwDir = new File(this.currentDir, "rbw");
        this.fileIoProvider.mkdirs(volume, this.rbwDir);
        this.fileIoProvider.mkdirs(volume, this.tmpDir);
        this.dfsUsage = new GetSpaceUsed.Builder().setPath(bpDir).setConf(conf).setInitialUsed(this.loadDfsUsed()).build();
        ShutdownHookManager.get().addShutdownHook(new Runnable(){

            @Override
            public void run() {
                if (!BlockPoolSlice.this.dfsUsedSaved) {
                    BlockPoolSlice.this.saveDfsUsed();
                }
            }
        }, 30);
    }

    File getDirectory() {
        return this.currentDir.getParentFile();
    }

    File getFinalizedDir() {
        return this.finalizedDir;
    }

    File getLazypersistDir() {
        return this.lazypersistDir;
    }

    File getRbwDir() {
        return this.rbwDir;
    }

    File getTmpDir() {
        return this.tmpDir;
    }

    void decDfsUsed(long value) {
        if (this.dfsUsage instanceof CachingGetSpaceUsed) {
            ((CachingGetSpaceUsed)this.dfsUsage).incDfsUsed(-value);
        }
    }

    long getDfsUsed() throws IOException {
        return this.dfsUsage.getUsed();
    }

    void incDfsUsed(long value) {
        if (this.dfsUsage instanceof CachingGetSpaceUsed) {
            ((CachingGetSpaceUsed)this.dfsUsage).incDfsUsed(value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long loadDfsUsed() {
        Scanner sc;
        try {
            sc = new Scanner(new File(this.currentDir, DU_CACHE_FILE), "UTF-8");
        }
        catch (FileNotFoundException fnfe) {
            return -1L;
        }
        try {
            if (!sc.hasNextLong()) {
                long l = -1L;
                return l;
            }
            long cachedDfsUsed = sc.nextLong();
            if (!sc.hasNextLong()) {
                long l = -1L;
                return l;
            }
            long mtime = sc.nextLong();
            if (mtime > 0L && this.timer.now() - mtime < this.cachedDfsUsedCheckTime) {
                FsDatasetImpl.LOG.info("Cached dfsUsed found for " + this.currentDir + ": " + cachedDfsUsed);
                long l = cachedDfsUsed;
                return l;
            }
            long l = -1L;
            return l;
        }
        finally {
            sc.close();
        }
    }

    void saveDfsUsed() {
        File outFile = new File(this.currentDir, DU_CACHE_FILE);
        if (!this.fileIoProvider.deleteWithExistsCheck(this.volume, outFile)) {
            FsDatasetImpl.LOG.warn("Failed to delete old dfsUsed file in " + outFile.getParent());
        }
        try {
            long used = this.getDfsUsed();
            try (OutputStreamWriter out = new OutputStreamWriter((OutputStream)new FileOutputStream(outFile), "UTF-8");){
                out.write(Long.toString(used) + " " + Long.toString(this.timer.now()));
                ((Writer)out).flush();
            }
        }
        catch (IOException ioe) {
            FsDatasetImpl.LOG.warn("Failed to write dfsUsed to " + outFile, (Throwable)ioe);
        }
    }

    File createTmpFile(Block b) throws IOException {
        File f = new File(this.tmpDir, b.getBlockName());
        File tmpFile = DatanodeUtil.createFileWithExistsCheck(this.volume, b, f, this.fileIoProvider);
        this.incrNumBlocks();
        return tmpFile;
    }

    File createRbwFile(Block b) throws IOException {
        File f = new File(this.rbwDir, b.getBlockName());
        File rbwFile = DatanodeUtil.createFileWithExistsCheck(this.volume, b, f, this.fileIoProvider);
        this.incrNumBlocks();
        return rbwFile;
    }

    File addFinalizedBlock(Block b, ReplicaInfo replicaInfo) throws IOException {
        File blockDir = DatanodeUtil.idToBlockDir(this.finalizedDir, b.getBlockId());
        this.fileIoProvider.mkdirsWithExistsCheck(this.volume, blockDir);
        File blockFile = FsDatasetImpl.moveBlockFiles(b, replicaInfo, blockDir);
        File metaFile = FsDatasetUtil.getMetaFile(blockFile, b.getGenerationStamp());
        if (this.dfsUsage instanceof CachingGetSpaceUsed) {
            ((CachingGetSpaceUsed)this.dfsUsage).incDfsUsed(b.getNumBytes() + metaFile.length());
        }
        return blockFile;
    }

    ReplicaInfo activateSavedReplica(ReplicaInfo replicaInfo, RamDiskReplicaTracker.RamDiskReplica replicaState) throws IOException {
        File metaFile = replicaState.getSavedMetaFile();
        File blockFile = replicaState.getSavedBlockFile();
        long blockId = replicaInfo.getBlockId();
        File blockDir = DatanodeUtil.idToBlockDir(this.finalizedDir, blockId);
        File targetBlockFile = new File(blockDir, blockFile.getName());
        File targetMetaFile = new File(blockDir, metaFile.getName());
        this.fileIoProvider.moveFile(this.volume, blockFile, targetBlockFile);
        FsDatasetImpl.LOG.info("Moved " + blockFile + " to " + targetBlockFile);
        this.fileIoProvider.moveFile(this.volume, metaFile, targetMetaFile);
        FsDatasetImpl.LOG.info("Moved " + metaFile + " to " + targetMetaFile);
        ReplicaInfo newReplicaInfo = new ReplicaBuilder(HdfsServerConstants.ReplicaState.FINALIZED).setBlockId(blockId).setLength(replicaInfo.getBytesOnDisk()).setGenerationStamp(replicaInfo.getGenerationStamp()).setFsVolume(replicaState.getLazyPersistVolume()).setDirectoryToUse(targetBlockFile.getParentFile()).build();
        return newReplicaInfo;
    }

    void checkDirs() throws DiskChecker.DiskErrorException {
        DiskChecker.checkDir((File)this.finalizedDir);
        DiskChecker.checkDir((File)this.tmpDir);
        DiskChecker.checkDir((File)this.rbwDir);
    }

    void getVolumeMap(ReplicaMap volumeMap, RamDiskReplicaTracker lazyWriteReplicaMap) throws IOException {
        boolean success;
        if (this.lazypersistDir.exists()) {
            int numRecovered = this.moveLazyPersistReplicasToFinalized(this.lazypersistDir);
            FsDatasetImpl.LOG.info("Recovered " + numRecovered + " replicas from " + this.lazypersistDir);
        }
        if (!(success = this.readReplicasFromCache(volumeMap, lazyWriteReplicaMap))) {
            this.addToReplicasMap(volumeMap, this.finalizedDir, lazyWriteReplicaMap, true);
            this.addToReplicasMap(volumeMap, this.rbwDir, lazyWriteReplicaMap, false);
        }
    }

    File recoverTempUnlinkedBlock(File unlinkedTmp) throws IOException {
        File blockFile = FsDatasetUtil.getOrigFile(unlinkedTmp);
        if (blockFile.exists()) {
            if (!this.fileIoProvider.delete(this.volume, unlinkedTmp)) {
                throw new IOException("Unable to cleanup unlinked tmp file " + unlinkedTmp);
            }
            return null;
        }
        this.fileIoProvider.rename(this.volume, unlinkedTmp, blockFile);
        return blockFile;
    }

    private int moveLazyPersistReplicasToFinalized(File source) throws IOException {
        File[] files = this.fileIoProvider.listFiles(this.volume, source);
        int numRecovered = 0;
        for (File file : files) {
            if (file.isDirectory()) {
                numRecovered += this.moveLazyPersistReplicasToFinalized(file);
            }
            if (!Block.isMetaFilename((String)file.getName())) continue;
            File metaFile = file;
            File blockFile = Block.metaToBlockFile((File)metaFile);
            long blockId = Block.filename2id((String)blockFile.getName());
            File targetDir = DatanodeUtil.idToBlockDir(this.finalizedDir, blockId);
            if (!blockFile.exists()) continue;
            try {
                this.fileIoProvider.mkdirsWithExistsCheck(this.volume, targetDir);
            }
            catch (IOException ioe) {
                LOG.warn((Object)("Failed to mkdirs " + targetDir));
                continue;
            }
            File targetMetaFile = new File(targetDir, metaFile.getName());
            try {
                this.fileIoProvider.rename(this.volume, metaFile, targetMetaFile);
            }
            catch (IOException e) {
                LOG.warn((Object)("Failed to move meta file from " + metaFile + " to " + targetMetaFile), (Throwable)e);
                continue;
            }
            File targetBlockFile = new File(targetDir, blockFile.getName());
            try {
                this.fileIoProvider.rename(this.volume, blockFile, targetBlockFile);
            }
            catch (IOException e) {
                LOG.warn((Object)("Failed to move block file from " + blockFile + " to " + targetBlockFile), (Throwable)e);
                continue;
            }
            if (targetBlockFile.exists() && targetMetaFile.exists()) {
                ++numRecovered;
                continue;
            }
            LOG.warn((Object)("Failed to move " + blockFile + " to " + targetDir));
        }
        this.fileIoProvider.fullyDelete(this.volume, source);
        return numRecovered;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addReplicaToReplicasMap(Block block, ReplicaMap volumeMap, RamDiskReplicaTracker lazyWriteReplicaMap, boolean isFinalized) throws IOException {
        ReplicaInfo newReplica = null;
        long blockId = block.getBlockId();
        long genStamp = block.getGenerationStamp();
        if (isFinalized) {
            newReplica = new ReplicaBuilder(HdfsServerConstants.ReplicaState.FINALIZED).setBlockId(blockId).setLength(block.getNumBytes()).setGenerationStamp(genStamp).setFsVolume(this.volume).setDirectoryToUse(DatanodeUtil.idToBlockDir(this.finalizedDir, blockId)).build();
        } else {
            File file = new File(this.rbwDir, block.getBlockName());
            boolean loadRwr = true;
            File restartMeta = new File(file.getParent() + File.pathSeparator + "." + file.getName() + ".restart");
            try (Scanner sc = null;){
                sc = new Scanner(restartMeta, "UTF-8");
                if (sc.hasNextLong() && sc.nextLong() > this.timer.now()) {
                    newReplica = new ReplicaBuilder(HdfsServerConstants.ReplicaState.RBW).setBlockId(blockId).setLength(this.validateIntegrityAndSetLength(file, genStamp)).setGenerationStamp(genStamp).setFsVolume(this.volume).setDirectoryToUse(file.getParentFile()).setWriterThread(null).setBytesToReserve(0L).build();
                    loadRwr = false;
                }
                sc.close();
                if (!this.fileIoProvider.delete(this.volume, restartMeta)) {
                    FsDatasetImpl.LOG.warn("Failed to delete restart meta file: " + restartMeta.getPath());
                }
            }
            if (loadRwr) {
                ReplicaBuilder builder = new ReplicaBuilder(HdfsServerConstants.ReplicaState.RWR).setBlockId(blockId).setLength(this.validateIntegrityAndSetLength(file, genStamp)).setGenerationStamp(genStamp).setFsVolume(this.volume).setDirectoryToUse(file.getParentFile());
                newReplica = builder.build();
            }
        }
        ReplicaInfo oldReplica = volumeMap.get(this.bpid, newReplica.getBlockId());
        if (oldReplica == null) {
            volumeMap.add(this.bpid, newReplica);
        } else {
            newReplica = this.resolveDuplicateReplicas(newReplica, oldReplica, volumeMap);
        }
        if (newReplica.getVolume().isTransientStorage()) {
            lazyWriteReplicaMap.addReplica(this.bpid, blockId, (FsVolumeImpl)newReplica.getVolume(), 0L);
        } else {
            lazyWriteReplicaMap.discardReplica(this.bpid, blockId, false);
        }
        if (oldReplica == null) {
            this.incrNumBlocks();
        }
    }

    void addToReplicasMap(ReplicaMap volumeMap, File dir, RamDiskReplicaTracker lazyWriteReplicaMap, boolean isFinalized) throws IOException {
        File[] files;
        for (File file : files = this.fileIoProvider.listFiles(this.volume, dir)) {
            if (file.isDirectory()) {
                this.addToReplicasMap(volumeMap, file, lazyWriteReplicaMap, isFinalized);
            }
            if (isFinalized && FsDatasetUtil.isUnlinkTmpFile(file) && (file = this.recoverTempUnlinkedBlock(file)) == null || !Block.isBlockFilename((File)file)) continue;
            long genStamp = FsDatasetUtil.getGenerationStampFromFile(files, file);
            long blockId = Block.filename2id((String)file.getName());
            Block block = new Block(blockId, file.length(), genStamp);
            this.addReplicaToReplicasMap(block, volumeMap, lazyWriteReplicaMap, isFinalized);
        }
    }

    ReplicaInfo resolveDuplicateReplicas(ReplicaInfo replica1, ReplicaInfo replica2, ReplicaMap volumeMap) throws IOException {
        if (!this.deleteDuplicateReplicas) {
            return replica1;
        }
        ReplicaInfo replicaToDelete = BlockPoolSlice.selectReplicaToDelete(replica1, replica2);
        ReplicaInfo replicaToKeep = replicaToDelete != replica1 ? replica1 : replica2;
        volumeMap.add(this.bpid, replicaToKeep);
        if (replicaToDelete != null) {
            this.deleteReplica(replicaToDelete);
        }
        return replicaToKeep;
    }

    @VisibleForTesting
    static ReplicaInfo selectReplicaToDelete(ReplicaInfo replica1, ReplicaInfo replica2) {
        ReplicaInfo replicaToDelete;
        if (replica1.getBlockURI().equals(replica2.getBlockURI())) {
            return null;
        }
        ReplicaInfo replicaToKeep = replica1.getGenerationStamp() != replica2.getGenerationStamp() ? (replica1.getGenerationStamp() > replica2.getGenerationStamp() ? replica1 : replica2) : (replica1.getNumBytes() != replica2.getNumBytes() ? (replica1.getNumBytes() > replica2.getNumBytes() ? replica1 : replica2) : (replica1.getVolume().isTransientStorage() && !replica2.getVolume().isTransientStorage() ? replica2 : replica1));
        ReplicaInfo replicaInfo = replicaToDelete = replicaToKeep == replica1 ? replica2 : replica1;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("resolveDuplicateReplicas decide to keep " + replicaToKeep + ".  Will try to delete " + replicaToDelete));
        }
        return replicaToDelete;
    }

    private void deleteReplica(ReplicaInfo replicaToDelete) {
        if (!replicaToDelete.deleteBlockData()) {
            LOG.warn((Object)("Failed to delete block file for replica " + replicaToDelete));
        }
        if (!replicaToDelete.deleteMetadata()) {
            LOG.warn((Object)("Failed to delete meta file for replica " + replicaToDelete));
        }
    }

    /*
     * Exception decompiling
     */
    private long validateIntegrityAndSetLength(File blockFile, long genStamp) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 5 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public String toString() {
        return this.currentDir.getAbsolutePath();
    }

    void shutdown(BlockListAsLongs blocksListToPersist) {
        this.saveReplicas(blocksListToPersist);
        this.saveDfsUsed();
        this.dfsUsedSaved = true;
        if (this.dfsUsage instanceof CachingGetSpaceUsed) {
            IOUtils.cleanup((Log)LOG, (Closeable[])new Closeable[]{(CachingGetSpaceUsed)this.dfsUsage});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean readReplicasFromCache(ReplicaMap volumeMap, RamDiskReplicaTracker lazyWriteReplicaMap) {
        ReplicaMap tmpReplicaMap = new ReplicaMap(new AutoCloseableLock());
        File replicaFile = new File(this.currentDir, REPLICA_CACHE_FILE);
        if (!replicaFile.exists()) {
            LOG.info((Object)("Replica Cache file: " + replicaFile.getPath() + " doesn't exist "));
            return false;
        }
        long fileLastModifiedTime = replicaFile.lastModified();
        if (System.currentTimeMillis() > fileLastModifiedTime + 300000L) {
            LOG.info((Object)("Replica Cache file: " + replicaFile.getPath() + " has gone stale"));
            if (!replicaFile.delete()) {
                LOG.info((Object)("Replica Cache file: " + replicaFile.getPath() + " cannot be deleted"));
            }
            return false;
        }
        FileInputStream inputStream = null;
        try {
            inputStream = this.fileIoProvider.getFileInputStream(this.volume, replicaFile);
            BlockListAsLongs blocksList = BlockListAsLongs.readFrom(inputStream, this.maxDataLength);
            if (blocksList == null) {
                boolean bl = false;
                return bl;
            }
            for (BlockListAsLongs.BlockReportReplica replica : blocksList) {
                switch (replica.getState()) {
                    case FINALIZED: {
                        this.addReplicaToReplicasMap(replica, tmpReplicaMap, lazyWriteReplicaMap, true);
                        break;
                    }
                    case RUR: 
                    case RBW: 
                    case RWR: {
                        this.addReplicaToReplicasMap(replica, tmpReplicaMap, lazyWriteReplicaMap, false);
                        break;
                    }
                }
            }
            inputStream.close();
            Iterator<ReplicaInfo> iter = tmpReplicaMap.replicas(this.bpid).iterator();
            while (iter.hasNext()) {
                ReplicaInfo info = iter.next();
                iter.remove();
                volumeMap.add(this.bpid, info);
            }
            LOG.info((Object)("Successfully read replica from cache file : " + replicaFile.getPath()));
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            LOG.info((Object)("Exception occurred while reading the replicas cache file: " + replicaFile.getPath()), (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            if (!this.fileIoProvider.delete(this.volume, replicaFile)) {
                LOG.info((Object)("Failed to delete replica cache file: " + replicaFile.getPath()));
            }
            IOUtils.closeStream((Closeable)inputStream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveReplicas(BlockListAsLongs blocksListToPersist) {
        if (blocksListToPersist == null || blocksListToPersist.getNumberOfBlocks() == 0) {
            return;
        }
        File tmpFile = new File(this.currentDir, "replicas.tmp");
        File replicaCacheFile = new File(this.currentDir, REPLICA_CACHE_FILE);
        if (!this.fileIoProvider.deleteWithExistsCheck(this.volume, tmpFile) || !this.fileIoProvider.deleteWithExistsCheck(this.volume, replicaCacheFile)) {
            return;
        }
        FileOutputStream out = null;
        try {
            out = this.fileIoProvider.getFileOutputStream((FsVolumeSpi)this.volume, tmpFile);
            blocksListToPersist.writeTo(out);
            out.close();
            this.fileIoProvider.moveFile(this.volume, tmpFile, replicaCacheFile);
        }
        catch (Exception e) {
            try {
                LOG.warn((Object)"Failed to write replicas to cache ", (Throwable)e);
                this.fileIoProvider.deleteWithExistsCheck(this.volume, replicaCacheFile);
            }
            catch (Throwable throwable) {
                IOUtils.closeStream(out);
                this.fileIoProvider.deleteWithExistsCheck(this.volume, tmpFile);
                throw throwable;
            }
            IOUtils.closeStream((Closeable)out);
            this.fileIoProvider.deleteWithExistsCheck(this.volume, tmpFile);
        }
        IOUtils.closeStream((Closeable)out);
        this.fileIoProvider.deleteWithExistsCheck(this.volume, tmpFile);
    }

    void incrNumBlocks() {
        this.numOfBlocks.incrementAndGet();
    }

    void decrNumBlocks() {
        this.numOfBlocks.decrementAndGet();
    }

    public long getNumOfBlocks() {
        return this.numOfBlocks.get();
    }
}

