/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.blockmanagement;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.LongAdder;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockInfo;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockInfoStriped;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.hdfs.util.LightWeightLinkedSet;

class LowRedundancyBlocks
implements Iterable<BlockInfo> {
    static final int LEVEL = 5;
    static final int QUEUE_HIGHEST_PRIORITY = 0;
    static final int QUEUE_VERY_LOW_REDUNDANCY = 1;
    static final int QUEUE_LOW_REDUNDANCY = 2;
    static final int QUEUE_REPLICAS_BADLY_DISTRIBUTED = 3;
    static final int QUEUE_WITH_CORRUPT_BLOCKS = 4;
    private final List<LightWeightLinkedSet<BlockInfo>> priorityQueues = new ArrayList<LightWeightLinkedSet<BlockInfo>>(5);
    private final LongAdder lowRedundancyBlocks = new LongAdder();
    private final LongAdder corruptBlocks = new LongAdder();
    private final LongAdder corruptReplicationOneBlocks = new LongAdder();
    private final LongAdder lowRedundancyECBlockGroups = new LongAdder();
    private final LongAdder corruptECBlockGroups = new LongAdder();
    private final LongAdder highestPriorityLowRedundancyReplicatedBlocks = new LongAdder();
    private final LongAdder highestPriorityLowRedundancyECBlocks = new LongAdder();

    LowRedundancyBlocks() {
        for (int i = 0; i < 5; ++i) {
            this.priorityQueues.add(new LightWeightLinkedSet());
        }
    }

    synchronized void clear() {
        for (int i = 0; i < 5; ++i) {
            this.priorityQueues.get(i).clear();
        }
        this.lowRedundancyBlocks.reset();
        this.corruptBlocks.reset();
        this.corruptReplicationOneBlocks.reset();
        this.lowRedundancyECBlockGroups.reset();
        this.corruptECBlockGroups.reset();
    }

    synchronized int size() {
        int size = 0;
        for (int i = 0; i < 5; ++i) {
            size += this.priorityQueues.get(i).size();
        }
        return size;
    }

    synchronized int getLowRedundancyBlockCount() {
        int size = 0;
        for (int i = 0; i < 5; ++i) {
            if (i == 4) continue;
            size += this.priorityQueues.get(i).size();
        }
        return size;
    }

    synchronized int getCorruptBlockSize() {
        return this.priorityQueues.get(4).size();
    }

    long getCorruptReplicationOneBlockSize() {
        return this.getCorruptReplicationOneBlocks();
    }

    long getLowRedundancyBlocks() {
        return this.lowRedundancyBlocks.longValue() - this.getCorruptBlocks();
    }

    long getCorruptBlocks() {
        return this.corruptBlocks.longValue();
    }

    long getCorruptReplicationOneBlocks() {
        return this.corruptReplicationOneBlocks.longValue();
    }

    long getHighestPriorityReplicatedBlockCount() {
        return this.highestPriorityLowRedundancyReplicatedBlocks.longValue();
    }

    long getHighestPriorityECBlockCount() {
        return this.highestPriorityLowRedundancyECBlocks.longValue();
    }

    long getLowRedundancyECBlockGroups() {
        return this.lowRedundancyECBlockGroups.longValue() - this.getCorruptECBlockGroups();
    }

    long getCorruptECBlockGroups() {
        return this.corruptECBlockGroups.longValue();
    }

    synchronized boolean contains(BlockInfo block) {
        for (LightWeightLinkedSet<BlockInfo> set : this.priorityQueues) {
            if (!set.contains((Object)block)) continue;
            return true;
        }
        return false;
    }

    private int getPriority(BlockInfo block, int curReplicas, int readOnlyReplicas, int outOfServiceReplicas, int expectedReplicas) {
        assert (curReplicas >= 0) : "Negative replicas!";
        if (curReplicas >= expectedReplicas) {
            return 3;
        }
        if (block.isStriped()) {
            BlockInfoStriped sblk = (BlockInfoStriped)block;
            return this.getPriorityStriped(curReplicas, outOfServiceReplicas, sblk.getRealDataBlockNum(), sblk.getParityBlockNum());
        }
        return this.getPriorityContiguous(curReplicas, readOnlyReplicas, outOfServiceReplicas, expectedReplicas);
    }

    private int getPriorityContiguous(int curReplicas, int readOnlyReplicas, int outOfServiceReplicas, int expectedReplicas) {
        if (curReplicas == 0) {
            if (outOfServiceReplicas > 0) {
                return 0;
            }
            if (readOnlyReplicas > 0) {
                return 0;
            }
            return 4;
        }
        if (curReplicas == 1) {
            return 0;
        }
        if (curReplicas * 3 < expectedReplicas) {
            return 1;
        }
        return 2;
    }

    private int getPriorityStriped(int curReplicas, int outOfServiceReplicas, short dataBlkNum, short parityBlkNum) {
        if (curReplicas < dataBlkNum) {
            if (curReplicas + outOfServiceReplicas >= dataBlkNum) {
                return 0;
            }
            return 4;
        }
        if (curReplicas == dataBlkNum) {
            return 0;
        }
        if ((curReplicas - dataBlkNum) * 3 < parityBlkNum + 1) {
            return 1;
        }
        return 2;
    }

    synchronized boolean add(BlockInfo block, int curReplicas, int readOnlyReplicas, int outOfServiceReplicas, int expectedReplicas) {
        int priLevel = this.getPriority(block, curReplicas, readOnlyReplicas, outOfServiceReplicas, expectedReplicas);
        if (this.add(block, priLevel, expectedReplicas)) {
            NameNode.blockStateChangeLog.debug("BLOCK* NameSystem.LowRedundancyBlock.add: {} has only {} replicas and need {} replicas so is added to neededReconstructions at priority level {}", new Object[]{block, curReplicas, expectedReplicas, priLevel});
            return true;
        }
        return false;
    }

    private boolean add(BlockInfo blockInfo, int priLevel, int expectedReplicas) {
        if (this.priorityQueues.get(priLevel).add(blockInfo)) {
            this.incrementBlockStat(blockInfo, priLevel, expectedReplicas);
            return true;
        }
        return false;
    }

    private void incrementBlockStat(BlockInfo blockInfo, int priLevel, int expectedReplicas) {
        if (blockInfo.isStriped()) {
            this.lowRedundancyECBlockGroups.increment();
            if (priLevel == 4) {
                this.corruptECBlockGroups.increment();
            }
            if (priLevel == 0) {
                this.highestPriorityLowRedundancyECBlocks.increment();
            }
        } else {
            this.lowRedundancyBlocks.increment();
            if (priLevel == 4) {
                this.corruptBlocks.increment();
                if (expectedReplicas == 1) {
                    this.corruptReplicationOneBlocks.increment();
                }
            }
            if (priLevel == 0) {
                this.highestPriorityLowRedundancyReplicatedBlocks.increment();
            }
        }
    }

    synchronized boolean remove(BlockInfo block, int oldReplicas, int oldReadOnlyReplicas, int outOfServiceReplicas, int oldExpectedReplicas) {
        int priLevel = this.getPriority(block, oldReplicas, oldReadOnlyReplicas, outOfServiceReplicas, oldExpectedReplicas);
        boolean removedBlock = this.remove(block, priLevel, oldExpectedReplicas);
        if (priLevel == 4 && oldExpectedReplicas == 1 && removedBlock) assert (this.corruptReplicationOneBlocks.longValue() >= 0L) : "Number of corrupt blocks with replication factor 1 should be non-negative";
        return removedBlock;
    }

    boolean remove(BlockInfo block, int priLevel) {
        return this.remove(block, priLevel, block.getReplication());
    }

    boolean remove(BlockInfo block, int priLevel, int oldExpectedReplicas) {
        if (priLevel >= 0 && priLevel < 5 && this.priorityQueues.get(priLevel).remove((Object)block)) {
            NameNode.blockStateChangeLog.debug("BLOCK* NameSystem.LowRedundancyBlock.remove: Removing block {} from priority queue {}", (Object)block, (Object)priLevel);
            this.decrementBlockStat(block, priLevel, oldExpectedReplicas);
            return true;
        }
        for (int i = 0; i < 5; ++i) {
            if (i == priLevel || !this.priorityQueues.get(i).remove((Object)block)) continue;
            NameNode.blockStateChangeLog.debug("BLOCK* NameSystem.LowRedundancyBlock.remove: Removing block {} from priority queue {}", (Object)block, (Object)i);
            this.decrementBlockStat(block, i, oldExpectedReplicas);
            return true;
        }
        return false;
    }

    private void decrementBlockStat(BlockInfo blockInfo, int priLevel, int oldExpectedReplicas) {
        if (blockInfo.isStriped()) {
            this.lowRedundancyECBlockGroups.decrement();
            if (priLevel == 4) {
                this.corruptECBlockGroups.decrement();
            }
            if (priLevel == 0) {
                this.highestPriorityLowRedundancyECBlocks.decrement();
            }
        } else {
            this.lowRedundancyBlocks.decrement();
            if (priLevel == 4) {
                this.corruptBlocks.decrement();
                if (oldExpectedReplicas == 1) {
                    this.corruptReplicationOneBlocks.decrement();
                    assert (this.corruptReplicationOneBlocks.longValue() >= 0L) : "Number of corrupt blocks with replication factor 1 should be non-negative";
                }
            }
            if (priLevel == 0) {
                this.highestPriorityLowRedundancyReplicatedBlocks.decrement();
            }
        }
    }

    synchronized void update(BlockInfo block, int curReplicas, int readOnlyReplicas, int outOfServiceReplicas, int curExpectedReplicas, int curReplicasDelta, int expectedReplicasDelta) {
        int oldReplicas = curReplicas - curReplicasDelta;
        int oldExpectedReplicas = curExpectedReplicas - expectedReplicasDelta;
        int curPri = this.getPriority(block, curReplicas, readOnlyReplicas, outOfServiceReplicas, curExpectedReplicas);
        int oldPri = this.getPriority(block, oldReplicas, readOnlyReplicas, outOfServiceReplicas, oldExpectedReplicas);
        if (NameNode.stateChangeLog.isDebugEnabled()) {
            NameNode.stateChangeLog.debug("LowRedundancyBlocks.update " + (Object)((Object)block) + " curReplicas " + curReplicas + " curExpectedReplicas " + curExpectedReplicas + " oldReplicas " + oldReplicas + " oldExpectedReplicas  " + oldExpectedReplicas + " curPri  " + curPri + " oldPri  " + oldPri);
        }
        this.remove(block, oldPri, oldExpectedReplicas);
        if (this.add(block, curPri, curExpectedReplicas)) {
            NameNode.blockStateChangeLog.debug("BLOCK* NameSystem.LowRedundancyBlock.update: {} has only {} replicas and needs {} replicas so is added to neededReconstructions at priority level {}", new Object[]{block, curReplicas, curExpectedReplicas, curPri});
        }
    }

    synchronized List<List<BlockInfo>> chooseLowRedundancyBlocks(int blocksToProcess) {
        int priority;
        ArrayList<List<BlockInfo>> blocksToReconstruct = new ArrayList<List<BlockInfo>>(5);
        int count = 0;
        for (priority = 0; count < blocksToProcess && priority < 5; ++priority) {
            if (priority == 4) continue;
            Iterator<BlockInfo> i = this.priorityQueues.get(priority).getBookmark();
            LinkedList<BlockInfo> blocks = new LinkedList<BlockInfo>();
            blocksToReconstruct.add(blocks);
            while (count < blocksToProcess && i.hasNext()) {
                blocks.add(i.next());
                ++count;
            }
        }
        if (priority == 5) {
            for (LightWeightLinkedSet<BlockInfo> q : this.priorityQueues) {
                q.resetBookmark();
            }
        }
        return blocksToReconstruct;
    }

    synchronized Iterator<BlockInfo> iterator(int level) {
        return this.priorityQueues.get(level).iterator();
    }

    @Override
    public synchronized Iterator<BlockInfo> iterator() {
        final Iterator<LightWeightLinkedSet<BlockInfo>> q = this.priorityQueues.iterator();
        return new Iterator<BlockInfo>(){
            private Iterator<BlockInfo> b;
            {
                this.b = ((LightWeightLinkedSet)q.next()).iterator();
            }

            @Override
            public BlockInfo next() {
                this.hasNext();
                return this.b.next();
            }

            @Override
            public boolean hasNext() {
                while (!this.b.hasNext() && q.hasNext()) {
                    this.b = ((LightWeightLinkedSet)q.next()).iterator();
                }
                return this.b.hasNext();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }
}

