/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.qjournal.client;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.hdfs.qjournal.client.AsyncLogger;
import org.apache.hadoop.hdfs.qjournal.client.AsyncLoggerSet;
import org.apache.hadoop.hdfs.qjournal.client.IPCLoggerChannel;
import org.apache.hadoop.hdfs.qjournal.client.QuorumCall;
import org.apache.hadoop.hdfs.qjournal.client.QuorumOutputStream;
import org.apache.hadoop.hdfs.qjournal.client.SegmentRecoveryComparator;
import org.apache.hadoop.hdfs.qjournal.protocol.QJournalProtocolProtos;
import org.apache.hadoop.hdfs.server.common.Storage;
import org.apache.hadoop.hdfs.server.common.StorageInfo;
import org.apache.hadoop.hdfs.server.common.Util;
import org.apache.hadoop.hdfs.server.namenode.EditLogFileInputStream;
import org.apache.hadoop.hdfs.server.namenode.EditLogInputStream;
import org.apache.hadoop.hdfs.server.namenode.EditLogOutputStream;
import org.apache.hadoop.hdfs.server.namenode.JournalManager;
import org.apache.hadoop.hdfs.server.namenode.JournalSet;
import org.apache.hadoop.hdfs.server.protocol.NamespaceInfo;
import org.apache.hadoop.hdfs.server.protocol.RemoteEditLog;
import org.apache.hadoop.hdfs.server.protocol.RemoteEditLogManifest;
import org.apache.hadoop.hdfs.web.URLConnectionFactory;
import org.apache.hadoop.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.shaded.com.google.common.base.Joiner;
import org.apache.hadoop.shaded.com.google.common.base.Preconditions;
import org.apache.hadoop.shaded.com.google.common.collect.Lists;
import org.apache.hadoop.shaded.com.google.protobuf.MessageOrBuilder;
import org.apache.hadoop.shaded.com.google.protobuf.TextFormat;

@InterfaceAudience.Private
public class QuorumJournalManager
implements JournalManager {
    static final Log LOG = LogFactory.getLog(QuorumJournalManager.class);
    private final int startSegmentTimeoutMs;
    private final int prepareRecoveryTimeoutMs;
    private final int acceptRecoveryTimeoutMs;
    private final int finalizeSegmentTimeoutMs;
    private final int selectInputStreamsTimeoutMs;
    private final int getJournalStateTimeoutMs;
    private final int newEpochTimeoutMs;
    private final int writeTxnsTimeoutMs;
    private final int timeoutMs;
    private final Configuration conf;
    private final URI uri;
    private final NamespaceInfo nsInfo;
    private final String nameServiceId;
    private boolean isActiveWriter;
    private final AsyncLoggerSet loggers;
    private int outputBufferCapacity = 524288;
    private final URLConnectionFactory connectionFactory;

    @VisibleForTesting
    public QuorumJournalManager(Configuration conf, URI uri, NamespaceInfo nsInfo) throws IOException {
        this(conf, uri, nsInfo, null, IPCLoggerChannel.FACTORY);
    }

    public QuorumJournalManager(Configuration conf, URI uri, NamespaceInfo nsInfo, String nameServiceId) throws IOException {
        this(conf, uri, nsInfo, nameServiceId, IPCLoggerChannel.FACTORY);
    }

    @VisibleForTesting
    QuorumJournalManager(Configuration conf, URI uri, NamespaceInfo nsInfo, AsyncLogger.Factory loggerFactory) throws IOException {
        this(conf, uri, nsInfo, null, loggerFactory);
    }

    QuorumJournalManager(Configuration conf, URI uri, NamespaceInfo nsInfo, String nameServiceId, AsyncLogger.Factory loggerFactory) throws IOException {
        Preconditions.checkArgument((conf != null ? 1 : 0) != 0, (Object)"must be configured");
        this.conf = conf;
        this.uri = uri;
        this.nsInfo = nsInfo;
        this.nameServiceId = nameServiceId;
        this.loggers = new AsyncLoggerSet(this.createLoggers(loggerFactory));
        this.connectionFactory = URLConnectionFactory.newDefaultURLConnectionFactory((Configuration)conf);
        this.startSegmentTimeoutMs = conf.getInt("dfs.qjournal.start-segment.timeout.ms", 20000);
        this.prepareRecoveryTimeoutMs = conf.getInt("dfs.qjournal.prepare-recovery.timeout.ms", 120000);
        this.acceptRecoveryTimeoutMs = conf.getInt("dfs.qjournal.accept-recovery.timeout.ms", 120000);
        this.finalizeSegmentTimeoutMs = conf.getInt("dfs.qjournal.finalize-segment.timeout.ms", 120000);
        this.selectInputStreamsTimeoutMs = conf.getInt("dfs.qjournal.select-input-streams.timeout.ms", 20000);
        this.getJournalStateTimeoutMs = conf.getInt("dfs.qjournal.get-journal-state.timeout.ms", 120000);
        this.newEpochTimeoutMs = conf.getInt("dfs.qjournal.new-epoch.timeout.ms", 120000);
        this.writeTxnsTimeoutMs = conf.getInt("dfs.qjournal.write-txns.timeout.ms", 20000);
        this.timeoutMs = (int)conf.getTimeDuration("dfs.qjm.operations.timeout", 60000L, TimeUnit.MILLISECONDS);
    }

    protected List<AsyncLogger> createLoggers(AsyncLogger.Factory factory) throws IOException {
        return QuorumJournalManager.createLoggers(this.conf, this.uri, this.nsInfo, factory, this.nameServiceId);
    }

    static String parseJournalId(URI uri) {
        String path = uri.getPath();
        Preconditions.checkArgument((path != null && !path.isEmpty() ? 1 : 0) != 0, (String)"Bad URI '%s': must identify journal in path component", (Object[])new Object[]{uri});
        String journalId = path.substring(1);
        QuorumJournalManager.checkJournalId(journalId);
        return journalId;
    }

    public static void checkJournalId(String jid) {
        Preconditions.checkArgument((jid != null && !jid.isEmpty() && !jid.contains("/") && !jid.startsWith(".") ? 1 : 0) != 0, (Object)("bad journal id: " + jid));
    }

    Map<AsyncLogger, QJournalProtocolProtos.NewEpochResponseProto> createNewUniqueEpoch() throws IOException {
        Preconditions.checkState((!this.loggers.isEpochEstablished() ? 1 : 0) != 0, (Object)"epoch already created");
        Map<AsyncLogger, QJournalProtocolProtos.GetJournalStateResponseProto> lastPromises = this.loggers.waitForWriteQuorum(this.loggers.getJournalState(), this.getJournalStateTimeoutMs, "getJournalState()");
        long maxPromised = Long.MIN_VALUE;
        for (QJournalProtocolProtos.GetJournalStateResponseProto resp : lastPromises.values()) {
            maxPromised = Math.max(maxPromised, resp.getLastPromisedEpoch());
        }
        assert (maxPromised >= 0L);
        long myEpoch = maxPromised + 1L;
        Map<AsyncLogger, QJournalProtocolProtos.NewEpochResponseProto> resps = this.loggers.waitForWriteQuorum(this.loggers.newEpoch(this.nsInfo, myEpoch), this.newEpochTimeoutMs, "newEpoch(" + myEpoch + ")");
        this.loggers.setEpoch(myEpoch);
        return resps;
    }

    @Override
    public void format(NamespaceInfo nsInfo) throws IOException {
        QuorumCall<AsyncLogger, Void> call = this.loggers.format(nsInfo);
        try {
            call.waitFor(this.loggers.size(), this.loggers.size(), 0, this.timeoutMs, "format");
        }
        catch (InterruptedException e) {
            throw new IOException("Interrupted waiting for format() response");
        }
        catch (TimeoutException e) {
            throw new IOException("Timed out waiting for format() response");
        }
        if (call.countExceptions() > 0) {
            call.rethrowException("Could not format one or more JournalNodes");
        }
    }

    @Override
    public boolean hasSomeData() throws IOException {
        QuorumCall<AsyncLogger, Boolean> call = this.loggers.isFormatted();
        try {
            call.waitFor(this.loggers.size(), 0, 0, this.timeoutMs, "hasSomeData");
        }
        catch (InterruptedException e) {
            throw new IOException("Interrupted while determining if JNs have data");
        }
        catch (TimeoutException e) {
            throw new IOException("Timed out waiting for response from loggers");
        }
        if (call.countExceptions() > 0) {
            call.rethrowException("Unable to check if JNs are ready for formatting");
        }
        for (Boolean hasData : call.getResults().values()) {
            if (!hasData.booleanValue()) continue;
            return true;
        }
        return false;
    }

    private void recoverUnclosedSegment(long segmentTxId) throws IOException {
        Preconditions.checkArgument((segmentTxId > 0L ? 1 : 0) != 0);
        LOG.info((Object)("Beginning recovery of unclosed segment starting at txid " + segmentTxId));
        QuorumCall<AsyncLogger, QJournalProtocolProtos.PrepareRecoveryResponseProto> prepare = this.loggers.prepareRecovery(segmentTxId);
        Map<AsyncLogger, QJournalProtocolProtos.PrepareRecoveryResponseProto> prepareResponses = this.loggers.waitForWriteQuorum(prepare, this.prepareRecoveryTimeoutMs, "prepareRecovery(" + segmentTxId + ")");
        LOG.info((Object)("Recovery prepare phase complete. Responses:\n" + QuorumCall.mapToString(prepareResponses)));
        Map.Entry<AsyncLogger, QJournalProtocolProtos.PrepareRecoveryResponseProto> bestEntry = Collections.max(prepareResponses.entrySet(), SegmentRecoveryComparator.INSTANCE);
        AsyncLogger bestLogger = bestEntry.getKey();
        QJournalProtocolProtos.PrepareRecoveryResponseProto bestResponse = bestEntry.getValue();
        if (bestResponse.hasAcceptedInEpoch()) {
            LOG.info((Object)("Using already-accepted recovery for segment starting at txid " + segmentTxId + ": " + bestEntry));
        } else if (bestResponse.hasSegmentState()) {
            LOG.info((Object)("Using longest log: " + bestEntry));
        } else {
            for (QJournalProtocolProtos.PrepareRecoveryResponseProto resp : prepareResponses.values()) {
                assert (!resp.hasSegmentState()) : "One of the loggers had a response, but no best logger was found.";
            }
            LOG.info((Object)("None of the responders had a log to recover: " + QuorumCall.mapToString(prepareResponses)));
            return;
        }
        QJournalProtocolProtos.SegmentStateProto logToSync = bestResponse.getSegmentState();
        assert (segmentTxId == logToSync.getStartTxId());
        for (Map.Entry<AsyncLogger, QJournalProtocolProtos.PrepareRecoveryResponseProto> e : prepareResponses.entrySet()) {
            AsyncLogger logger = e.getKey();
            QJournalProtocolProtos.PrepareRecoveryResponseProto resp = e.getValue();
            if (resp.hasLastCommittedTxId() && resp.getLastCommittedTxId() > logToSync.getEndTxId()) {
                throw new AssertionError((Object)("Decided to synchronize log to " + logToSync + " but logger " + logger + " had seen txid " + resp.getLastCommittedTxId() + " committed"));
            }
        }
        URL syncFromUrl = bestLogger.buildURLToFetchLogs(segmentTxId);
        QuorumCall<AsyncLogger, Void> accept = this.loggers.acceptRecovery(logToSync, syncFromUrl);
        this.loggers.waitForWriteQuorum(accept, this.acceptRecoveryTimeoutMs, "acceptRecovery(" + TextFormat.shortDebugString((MessageOrBuilder)logToSync) + ")");
        QuorumCall<AsyncLogger, Void> finalize = this.loggers.finalizeLogSegment(logToSync.getStartTxId(), logToSync.getEndTxId());
        this.loggers.waitForWriteQuorum(finalize, this.finalizeSegmentTimeoutMs, String.format("finalizeLogSegment(%s-%s)", logToSync.getStartTxId(), logToSync.getEndTxId()));
    }

    static List<AsyncLogger> createLoggers(Configuration conf, URI uri, NamespaceInfo nsInfo, AsyncLogger.Factory factory, String nameServiceId) throws IOException {
        ArrayList ret = Lists.newArrayList();
        List<InetSocketAddress> addrs = Util.getAddressesList(uri);
        if (addrs.size() % 2 == 0) {
            LOG.warn((Object)("Quorum journal URI '" + uri + "' has an even number of Journal Nodes specified. This is not recommended!"));
        }
        String jid = QuorumJournalManager.parseJournalId(uri);
        for (InetSocketAddress addr : addrs) {
            ret.add(factory.createLogger(conf, nsInfo, jid, nameServiceId, addr));
        }
        return ret;
    }

    @Override
    public EditLogOutputStream startLogSegment(long txId, int layoutVersion) throws IOException {
        Preconditions.checkState((boolean)this.isActiveWriter, (Object)"must recover segments before starting a new one");
        QuorumCall<AsyncLogger, Void> q = this.loggers.startLogSegment(txId, layoutVersion);
        this.loggers.waitForWriteQuorum(q, this.startSegmentTimeoutMs, "startLogSegment(" + txId + ")");
        boolean updateCommittedTxId = this.conf.getBoolean("dfs.ha.tail-edits.in-progress", false);
        return new QuorumOutputStream(this.loggers, txId, this.outputBufferCapacity, this.writeTxnsTimeoutMs, updateCommittedTxId);
    }

    @Override
    public void finalizeLogSegment(long firstTxId, long lastTxId) throws IOException {
        QuorumCall<AsyncLogger, Void> q = this.loggers.finalizeLogSegment(firstTxId, lastTxId);
        this.loggers.waitForWriteQuorum(q, this.finalizeSegmentTimeoutMs, String.format("finalizeLogSegment(%s-%s)", firstTxId, lastTxId));
    }

    @Override
    public void setOutputBufferCapacity(int size) {
        this.outputBufferCapacity = size;
    }

    @Override
    public void purgeLogsOlderThan(long minTxIdToKeep) throws IOException {
        LOG.info((Object)("Purging remote journals older than txid " + minTxIdToKeep));
        this.loggers.purgeLogsOlderThan(minTxIdToKeep);
    }

    @Override
    public void recoverUnfinalizedSegments() throws IOException {
        Preconditions.checkState((!this.isActiveWriter ? 1 : 0) != 0, (Object)"already active writer");
        LOG.info((Object)"Starting recovery process for unclosed journal segments...");
        Map<AsyncLogger, QJournalProtocolProtos.NewEpochResponseProto> resps = this.createNewUniqueEpoch();
        LOG.info((Object)("Successfully started new epoch " + this.loggers.getEpoch()));
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("newEpoch(" + this.loggers.getEpoch() + ") responses:\n" + QuorumCall.mapToString(resps)));
        }
        long mostRecentSegmentTxId = Long.MIN_VALUE;
        for (QJournalProtocolProtos.NewEpochResponseProto r : resps.values()) {
            if (!r.hasLastSegmentTxId()) continue;
            mostRecentSegmentTxId = Math.max(mostRecentSegmentTxId, r.getLastSegmentTxId());
        }
        if (mostRecentSegmentTxId != Long.MIN_VALUE) {
            this.recoverUnclosedSegment(mostRecentSegmentTxId);
        }
        this.isActiveWriter = true;
    }

    @Override
    public void close() throws IOException {
        this.loggers.close();
    }

    public void selectInputStreams(Collection<EditLogInputStream> streams, long fromTxnId, boolean inProgressOk) throws IOException {
        this.selectInputStreams(streams, fromTxnId, inProgressOk, false);
    }

    @Override
    public void selectInputStreams(Collection<EditLogInputStream> streams, long fromTxnId, boolean inProgressOk, boolean onlyDurableTxns) throws IOException {
        QuorumCall<AsyncLogger, RemoteEditLogManifest> q = this.loggers.getEditLogManifest(fromTxnId, inProgressOk);
        Map<AsyncLogger, RemoteEditLogManifest> resps = this.loggers.waitForWriteQuorum(q, this.selectInputStreamsTimeoutMs, "selectInputStreams");
        LOG.debug((Object)("selectInputStream manifests:\n" + Joiner.on((String)"\n").withKeyValueSeparator(": ").join(resps)));
        PriorityQueue<EditLogInputStream> allStreams = new PriorityQueue<EditLogInputStream>(64, JournalSet.EDIT_LOG_INPUT_STREAM_COMPARATOR);
        for (Map.Entry<AsyncLogger, RemoteEditLogManifest> e : resps.entrySet()) {
            AsyncLogger logger = e.getKey();
            RemoteEditLogManifest manifest = e.getValue();
            long committedTxnId = manifest.getCommittedTxnId();
            for (RemoteEditLog remoteLog : manifest.getLogs()) {
                URL url = logger.buildURLToFetchLogs(remoteLog.getStartTxId());
                long endTxId = remoteLog.getEndTxId();
                if (onlyDurableTxns && inProgressOk && remoteLog.isInProgress() && (endTxId = Math.min(endTxId, committedTxnId)) < remoteLog.getStartTxId()) {
                    LOG.warn((Object)("Found endTxId (" + endTxId + ") that is less than the startTxId (" + remoteLog.getStartTxId() + ") - setting it to startTxId."));
                    endTxId = remoteLog.getStartTxId();
                }
                EditLogInputStream elis = EditLogFileInputStream.fromUrl(this.connectionFactory, url, remoteLog.getStartTxId(), endTxId, remoteLog.isInProgress());
                allStreams.add(elis);
            }
        }
        JournalSet.chainAndMakeRedundantStreams(streams, allStreams, fromTxnId);
    }

    @Override
    public String toString() {
        return "QJM to " + this.loggers;
    }

    @VisibleForTesting
    AsyncLoggerSet getLoggerSetForTests() {
        return this.loggers;
    }

    @Override
    public void doPreUpgrade() throws IOException {
        QuorumCall<AsyncLogger, Void> call = this.loggers.doPreUpgrade();
        try {
            call.waitFor(this.loggers.size(), this.loggers.size(), 0, this.timeoutMs, "doPreUpgrade");
            if (call.countExceptions() > 0) {
                call.rethrowException("Could not do pre-upgrade of one or more JournalNodes");
            }
        }
        catch (InterruptedException e) {
            throw new IOException("Interrupted waiting for doPreUpgrade() response");
        }
        catch (TimeoutException e) {
            throw new IOException("Timed out waiting for doPreUpgrade() response");
        }
    }

    @Override
    public void doUpgrade(Storage storage) throws IOException {
        QuorumCall<AsyncLogger, Void> call = this.loggers.doUpgrade(storage);
        try {
            call.waitFor(this.loggers.size(), this.loggers.size(), 0, this.timeoutMs, "doUpgrade");
            if (call.countExceptions() > 0) {
                call.rethrowException("Could not perform upgrade of one or more JournalNodes");
            }
        }
        catch (InterruptedException e) {
            throw new IOException("Interrupted waiting for doUpgrade() response");
        }
        catch (TimeoutException e) {
            throw new IOException("Timed out waiting for doUpgrade() response");
        }
    }

    @Override
    public void doFinalize() throws IOException {
        QuorumCall<AsyncLogger, Void> call = this.loggers.doFinalize();
        try {
            call.waitFor(this.loggers.size(), this.loggers.size(), 0, this.timeoutMs, "doFinalize");
            if (call.countExceptions() > 0) {
                call.rethrowException("Could not finalize one or more JournalNodes");
            }
        }
        catch (InterruptedException e) {
            throw new IOException("Interrupted waiting for doFinalize() response");
        }
        catch (TimeoutException e) {
            throw new IOException("Timed out waiting for doFinalize() response");
        }
    }

    @Override
    public boolean canRollBack(StorageInfo storage, StorageInfo prevStorage, int targetLayoutVersion) throws IOException {
        QuorumCall<AsyncLogger, Boolean> call = this.loggers.canRollBack(storage, prevStorage, targetLayoutVersion);
        try {
            call.waitFor(this.loggers.size(), this.loggers.size(), 0, this.timeoutMs, "lockSharedStorage");
            if (call.countExceptions() > 0) {
                call.rethrowException("Could not check if roll back possible for one or more JournalNodes");
            }
            try {
                DFSUtil.assertAllResultsEqual(call.getResults().values());
            }
            catch (AssertionError ae) {
                throw new IOException("Results differed for canRollBack", (Throwable)((Object)ae));
            }
            Iterator<Boolean> ae = call.getResults().values().iterator();
            if (ae.hasNext()) {
                Boolean result = ae.next();
                return result;
            }
        }
        catch (InterruptedException e) {
            throw new IOException("Interrupted waiting for lockSharedStorage() response");
        }
        catch (TimeoutException e) {
            throw new IOException("Timed out waiting for lockSharedStorage() response");
        }
        throw new AssertionError((Object)"Unreachable code.");
    }

    @Override
    public void doRollback() throws IOException {
        QuorumCall<AsyncLogger, Void> call = this.loggers.doRollback();
        try {
            call.waitFor(this.loggers.size(), this.loggers.size(), 0, this.timeoutMs, "doRollback");
            if (call.countExceptions() > 0) {
                call.rethrowException("Could not perform rollback of one or more JournalNodes");
            }
        }
        catch (InterruptedException e) {
            throw new IOException("Interrupted waiting for doFinalize() response");
        }
        catch (TimeoutException e) {
            throw new IOException("Timed out waiting for doFinalize() response");
        }
    }

    @Override
    public void discardSegments(long startTxId) throws IOException {
        QuorumCall<AsyncLogger, Void> call = this.loggers.discardSegments(startTxId);
        try {
            call.waitFor(this.loggers.size(), this.loggers.size(), 0, this.timeoutMs, "discardSegments");
            if (call.countExceptions() > 0) {
                call.rethrowException("Could not perform discardSegments of one or more JournalNodes");
            }
        }
        catch (InterruptedException e) {
            throw new IOException("Interrupted waiting for discardSegments() response");
        }
        catch (TimeoutException e) {
            throw new IOException("Timed out waiting for discardSegments() response");
        }
    }

    @Override
    public long getJournalCTime() throws IOException {
        QuorumCall<AsyncLogger, Long> call = this.loggers.getJournalCTime();
        try {
            call.waitFor(this.loggers.size(), this.loggers.size(), 0, this.timeoutMs, "getJournalCTime");
            if (call.countExceptions() > 0) {
                call.rethrowException("Could not journal CTime for one more JournalNodes");
            }
            try {
                DFSUtil.assertAllResultsEqual(call.getResults().values());
            }
            catch (AssertionError ae) {
                throw new IOException("Results differed for getJournalCTime", (Throwable)((Object)ae));
            }
            Iterator<Long> ae = call.getResults().values().iterator();
            if (ae.hasNext()) {
                Long result = ae.next();
                return result;
            }
        }
        catch (InterruptedException e) {
            throw new IOException("Interrupted waiting for getJournalCTime() response");
        }
        catch (TimeoutException e) {
            throw new IOException("Timed out waiting for getJournalCTime() response");
        }
        throw new AssertionError((Object)"Unreachable code.");
    }
}

