/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.qjournal;

import java.io.IOException;
import java.net.BindException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Random;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.MiniDFSNNTopology;
import org.apache.hadoop.hdfs.qjournal.MiniJournalCluster;
import org.apache.hadoop.hdfs.server.common.HdfsServerConstants;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.hdfs.server.namenode.ha.HATestUtil;

public class MiniQJMHACluster {
    private MiniDFSCluster cluster;
    private MiniJournalCluster journalCluster;
    private final Configuration conf;
    private static final Log LOG = LogFactory.getLog(MiniQJMHACluster.class);
    public static final String NAMESERVICE = "ns1";
    private static final Random RANDOM = new Random();

    public static MiniDFSNNTopology createDefaultTopology(int nns, int startingPort) {
        MiniDFSNNTopology.NSConf nameservice = new MiniDFSNNTopology.NSConf(NAMESERVICE);
        for (int i = 0; i < nns; ++i) {
            nameservice.addNN(new MiniDFSNNTopology.NNConf("nn" + i).setIpcPort(startingPort++).setHttpPort(startingPort++));
        }
        return new MiniDFSNNTopology().addNameservice(nameservice);
    }

    public static MiniDFSNNTopology createDefaultTopology(int basePort) {
        return MiniQJMHACluster.createDefaultTopology(2, basePort);
    }

    private MiniQJMHACluster(Builder builder) throws IOException {
        this.conf = builder.conf;
        int retryCount = 0;
        int basePort = 10000;
        while (true) {
            try {
                basePort = 10000 + RANDOM.nextInt(1000) * 4;
                LOG.info((Object)("Set MiniQJMHACluster basePort to " + basePort));
                this.journalCluster = new MiniJournalCluster.Builder(this.conf).format(true).build();
                this.journalCluster.waitActive();
                this.journalCluster.setNamenodeSharedEditsConf(NAMESERVICE);
                URI journalURI = this.journalCluster.getQuorumJournalURI(NAMESERVICE);
                MiniDFSNNTopology topology = MiniQJMHACluster.createDefaultTopology(builder.numNNs, basePort);
                this.initHAConf(journalURI, builder, basePort);
                this.cluster = builder.dfsBuilder.nnTopology(topology).manageNameDfsSharedDirs(false).build();
                this.cluster.waitActive();
                this.cluster.shutdownNameNodes();
                Configuration confNN0 = this.cluster.getConfiguration(0);
                NameNode.initializeSharedEdits(confNN0, true);
                for (MiniDFSCluster.NameNodeInfo nn : this.cluster.getNameNodeInfos()) {
                    nn.setStartOpt(builder.startOpt);
                }
                this.cluster.restartNameNodes();
            }
            catch (BindException e) {
                if (this.cluster != null) {
                    this.cluster.shutdown(true);
                    this.cluster = null;
                }
                LOG.info((Object)("MiniQJMHACluster port conflicts, retried " + ++retryCount + " times"));
                continue;
            }
            break;
        }
    }

    private Configuration initHAConf(URI journalURI, Builder builder, int basePort) {
        this.conf.set("dfs.namenode.shared.edits.dir", journalURI.toString());
        if (builder.forceRemoteEditsOnly) {
            this.conf.set("dfs.namenode.edits.dir", journalURI.toString());
            this.conf.set("dfs.namenode.edits.dir.required", journalURI.toString());
        }
        ArrayList<String> nns = new ArrayList<String>(builder.numNNs);
        int port = basePort;
        for (int i = 0; i < builder.numNNs; ++i) {
            nns.add("127.0.0.1:" + port);
            port += 2;
        }
        HATestUtil.setFailoverConfigurations(this.conf, NAMESERVICE, nns);
        return this.conf;
    }

    public MiniDFSCluster getDfsCluster() {
        return this.cluster;
    }

    public MiniJournalCluster getJournalCluster() {
        return this.journalCluster;
    }

    public void shutdown() throws IOException {
        this.cluster.shutdown();
        this.journalCluster.shutdown();
    }

    public static class Builder {
        private final Configuration conf;
        private HdfsServerConstants.StartupOption startOpt = null;
        private int numNNs = 2;
        private final MiniDFSCluster.Builder dfsBuilder;
        private boolean forceRemoteEditsOnly = false;

        public Builder(Configuration conf) {
            this.conf = conf;
            this.dfsBuilder = new MiniDFSCluster.Builder(conf).numDataNodes(0);
        }

        public MiniDFSCluster.Builder getDfsBuilder() {
            return this.dfsBuilder;
        }

        public MiniQJMHACluster build() throws IOException {
            return new MiniQJMHACluster(this);
        }

        public void startupOption(HdfsServerConstants.StartupOption startOpt) {
            this.startOpt = startOpt;
        }

        public Builder setNumNameNodes(int nns) {
            this.numNNs = nns;
            return this;
        }

        public Builder setForceRemoteEditsOnly(boolean val) {
            this.forceRemoteEditsOnly = val;
            return this;
        }
    }
}

