/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.HadoopIllegalArgumentException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DFSClient;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.hdfs.DFSUtilClient;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.NameNodeProxies;
import org.apache.hadoop.hdfs.NameNodeProxiesClient;
import org.apache.hadoop.hdfs.protocol.ClientProtocol;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.hdfs.server.namenode.ha.AbstractNNFailoverProxyProvider;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.hadoop.ipc.StandbyException;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.shaded.com.google.common.base.Joiner;
import org.apache.hadoop.shaded.com.google.common.base.Preconditions;
import org.apache.hadoop.shaded.com.google.common.collect.Lists;

@InterfaceAudience.Private
public class HAUtil {
    private static final String[] HA_SPECIAL_INDEPENDENT_KEYS = new String[]{"dfs.namenode.rpc-address", "dfs.namenode.rpc-bind-host", "dfs.namenode.lifeline.rpc-address", "dfs.namenode.lifeline.rpc-bind-host", "dfs.namenode.servicerpc-address", "dfs.namenode.servicerpc-bind-host", "dfs.namenode.http-address", "dfs.namenode.https-address", "dfs.namenode.http-bind-host", "dfs.namenode.https-bind-host"};

    private HAUtil() {
    }

    public static boolean isHAEnabled(Configuration conf, String nsId) {
        Map addresses = DFSUtilClient.getHaNnRpcAddresses((Configuration)conf);
        if (addresses == null) {
            return false;
        }
        Map nnMap = (Map)addresses.get(nsId);
        return nnMap != null && nnMap.size() > 1;
    }

    public static boolean usesSharedEditsDir(Configuration conf) {
        return null != conf.get("dfs.namenode.shared.edits.dir");
    }

    public static String getNameNodeId(Configuration conf, String nsId) {
        String namenodeId = conf.getTrimmed("dfs.ha.namenode.id");
        if (namenodeId != null) {
            return namenodeId;
        }
        String[] suffixes = DFSUtil.getSuffixIDs(conf, "dfs.namenode.rpc-address", nsId, null, DFSUtil.LOCAL_ADDRESS_MATCHER);
        if (suffixes == null) {
            String msg = "Configuration dfs.namenode.rpc-address must be suffixed with nameservice and namenode ID for HA configuration.";
            throw new HadoopIllegalArgumentException(msg);
        }
        return suffixes[1];
    }

    public static String getNameNodeIdFromAddress(Configuration conf, InetSocketAddress address, String ... keys) {
        String[] ids = DFSUtil.getSuffixIDs(conf, address, keys);
        if (ids != null && ids.length > 1) {
            return ids[1];
        }
        return null;
    }

    public static List<String> getNameNodeIdOfOtherNodes(Configuration conf, String nsId) {
        Preconditions.checkArgument((nsId != null ? 1 : 0) != 0, (Object)"Could not determine namespace id. Please ensure that this machine is one of the machines listed as a NN RPC address, or configure dfs.nameservice.id");
        Collection nnIds = DFSUtilClient.getNameNodeIds((Configuration)conf, (String)nsId);
        String myNNId = conf.get("dfs.ha.namenode.id");
        Preconditions.checkArgument((nnIds != null ? 1 : 0) != 0, (String)("Could not determine namenode ids in namespace '%s'. Please configure " + DFSUtil.addKeySuffixes("dfs.ha.namenodes", nsId)), (Object[])new Object[]{nsId});
        Preconditions.checkArgument((nnIds.size() >= 2 ? 1 : 0) != 0, (String)"Expected at least 2 NameNodes in namespace '%s'. Instead, got only %s (NN ids were '%s')", (Object[])new Object[]{nsId, nnIds.size(), Joiner.on((String)"','").join((Iterable)nnIds)});
        Preconditions.checkState((myNNId != null && !myNNId.isEmpty() ? 1 : 0) != 0, (String)"Could not determine own NN ID in namespace '%s'. Please ensure that this node is one of the machines listed as an NN RPC address, or configure dfs.ha.namenode.id", (Object[])new Object[]{nsId});
        ArrayList namenodes = Lists.newArrayList((Iterable)nnIds);
        namenodes.remove(myNNId);
        assert (namenodes.size() >= 1);
        return namenodes;
    }

    public static List<Configuration> getConfForOtherNodes(Configuration myConf) {
        String nsId = DFSUtil.getNamenodeNameServiceId(myConf);
        List<String> otherNn = HAUtil.getNameNodeIdOfOtherNodes(myConf, nsId);
        ArrayList<Configuration> confs = new ArrayList<Configuration>(otherNn.size());
        myConf = new Configuration(myConf);
        for (String idpKey : HA_SPECIAL_INDEPENDENT_KEYS) {
            myConf.unset(idpKey);
        }
        for (String nn : otherNn) {
            Configuration confForOtherNode = new Configuration(myConf);
            NameNode.initializeGenericKeys(confForOtherNode, nsId, nn);
            confs.add(confForOtherNode);
        }
        return confs;
    }

    public static boolean shouldAllowStandbyReads(Configuration conf) {
        return conf.getBoolean("dfs.ha.allow.stale.reads", false);
    }

    public static void setAllowStandbyReads(Configuration conf, boolean val) {
        conf.setBoolean("dfs.ha.allow.stale.reads", val);
    }

    public static boolean useLogicalUri(Configuration conf, URI nameNodeUri) throws IOException {
        AbstractNNFailoverProxyProvider provider = NameNodeProxiesClient.createFailoverProxyProvider((Configuration)conf, (URI)nameNodeUri, ClientProtocol.class, (boolean)false, null);
        if (provider == null) {
            return false;
        }
        return provider.useLogicalURI();
    }

    public static InetSocketAddress getAddressOfActive(FileSystem fs) throws IOException {
        if (!(fs instanceof DistributedFileSystem)) {
            throw new IllegalArgumentException("FileSystem " + fs + " is not a DFS.");
        }
        fs.exists(new Path("/"));
        DistributedFileSystem dfs = (DistributedFileSystem)fs;
        DFSClient dfsClient = dfs.getClient();
        return RPC.getServerAddress((Object)dfsClient.getNamenode());
    }

    public static List<ClientProtocol> getProxiesForAllNameNodesInNameservice(Configuration conf, String nsId) throws IOException {
        List<NameNodeProxiesClient.ProxyAndInfo<ClientProtocol>> proxies = HAUtil.getProxiesForAllNameNodesInNameservice(conf, nsId, ClientProtocol.class);
        ArrayList<ClientProtocol> namenodes = new ArrayList<ClientProtocol>(proxies.size());
        for (NameNodeProxiesClient.ProxyAndInfo<ClientProtocol> proxy : proxies) {
            namenodes.add((ClientProtocol)proxy.getProxy());
        }
        return namenodes;
    }

    public static <T> List<NameNodeProxiesClient.ProxyAndInfo<T>> getProxiesForAllNameNodesInNameservice(Configuration conf, String nsId, Class<T> xface) throws IOException {
        Map<String, InetSocketAddress> nnAddresses = DFSUtil.getRpcAddressesForNameserviceId(conf, nsId, null);
        ArrayList<NameNodeProxiesClient.ProxyAndInfo<T>> proxies = new ArrayList<NameNodeProxiesClient.ProxyAndInfo<T>>(nnAddresses.size());
        for (InetSocketAddress nnAddress : nnAddresses.values()) {
            NameNodeProxiesClient.ProxyAndInfo<T> proxyInfo = NameNodeProxies.createNonHAProxy(conf, nnAddress, xface, UserGroupInformation.getCurrentUser(), false);
            proxies.add(proxyInfo);
        }
        return proxies;
    }

    public static boolean isAtLeastOneActive(List<ClientProtocol> namenodes) throws IOException {
        for (ClientProtocol namenode : namenodes) {
            try {
                namenode.getFileInfo("/");
                return true;
            }
            catch (RemoteException re) {
                IOException cause = re.unwrapRemoteException();
                if (cause instanceof StandbyException) continue;
                throw re;
            }
        }
        return false;
    }
}

