/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.contract;

import java.io.IOException;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.contract.AbstractFSContractTestBase;
import org.apache.hadoop.fs.contract.ContractTestUtils;
import org.junit.Test;

public abstract class AbstractContractUnbufferTest
extends AbstractFSContractTestBase {
    private Path file;

    @Override
    public void setup() throws Exception {
        super.setup();
        this.skipIfUnsupported("supports-unbuffer");
        this.file = this.path("unbufferFile");
        ContractTestUtils.createFile(this.getFileSystem(), this.file, true, ContractTestUtils.dataset(1024, 0, 255));
    }

    @Test
    public void testUnbufferAfterRead() throws IOException {
        this.describe("unbuffer a file after a single read");
        try (FSDataInputStream stream = this.getFileSystem().open(this.file);){
            AbstractContractUnbufferTest.assertEquals((long)128L, (long)stream.read(new byte[128]));
            this.unbuffer(stream);
        }
    }

    @Test
    public void testUnbufferBeforeRead() throws IOException {
        this.describe("unbuffer a file before a read");
        try (FSDataInputStream stream = this.getFileSystem().open(this.file);){
            this.unbuffer(stream);
            AbstractContractUnbufferTest.assertEquals((long)128L, (long)stream.read(new byte[128]));
        }
    }

    @Test
    public void testUnbufferEmptyFile() throws IOException {
        Path emptyFile = this.path("emptyUnbufferFile");
        ContractTestUtils.createFile(this.getFileSystem(), emptyFile, true, ContractTestUtils.dataset(1024, 0, 255));
        this.describe("unbuffer an empty file");
        try (FSDataInputStream stream = this.getFileSystem().open(emptyFile);){
            this.unbuffer(stream);
        }
    }

    @Test
    public void testUnbufferOnClosedFile() throws IOException {
        this.describe("unbuffer a file before a read");
        try (FSDataInputStream stream = null;){
            stream = this.getFileSystem().open(this.file);
            AbstractContractUnbufferTest.assertEquals((long)128L, (long)stream.read(new byte[128]));
        }
        this.unbuffer(stream);
    }

    @Test
    public void testMultipleUnbuffers() throws IOException {
        this.describe("unbuffer a file multiple times");
        try (FSDataInputStream stream = this.getFileSystem().open(this.file);){
            this.unbuffer(stream);
            this.unbuffer(stream);
            AbstractContractUnbufferTest.assertEquals((long)128L, (long)stream.read(new byte[128]));
            this.unbuffer(stream);
            this.unbuffer(stream);
        }
    }

    @Test
    public void testUnbufferMultipleReads() throws IOException {
        this.describe("unbuffer a file multiple times");
        try (FSDataInputStream stream = this.getFileSystem().open(this.file);){
            this.unbuffer(stream);
            AbstractContractUnbufferTest.assertEquals((long)128L, (long)stream.read(new byte[128]));
            this.unbuffer(stream);
            AbstractContractUnbufferTest.assertEquals((long)128L, (long)stream.read(new byte[128]));
            AbstractContractUnbufferTest.assertEquals((long)128L, (long)stream.read(new byte[128]));
            this.unbuffer(stream);
            AbstractContractUnbufferTest.assertEquals((long)128L, (long)stream.read(new byte[128]));
            AbstractContractUnbufferTest.assertEquals((long)128L, (long)stream.read(new byte[128]));
            AbstractContractUnbufferTest.assertEquals((long)128L, (long)stream.read(new byte[128]));
            this.unbuffer(stream);
        }
    }

    private void unbuffer(FSDataInputStream stream) throws IOException {
        long pos = stream.getPos();
        stream.unbuffer();
        AbstractContractUnbufferTest.assertEquals((long)pos, (long)stream.getPos());
    }
}

