/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.web;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import org.apache.hadoop.hdfs.web.ByteRangeInputStream;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.internal.util.reflection.Whitebox;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;

public class TestByteRangeInputStream {
    private ByteRangeInputStream.URLOpener getMockURLOpener(URL url) throws IOException {
        ByteRangeInputStream.URLOpener opener = (ByteRangeInputStream.URLOpener)Mockito.mock(ByteRangeInputStream.URLOpener.class, (Answer)Mockito.CALLS_REAL_METHODS);
        opener.setURL(url);
        ((ByteRangeInputStream.URLOpener)Mockito.doReturn((Object)this.getMockConnection("65535")).when((Object)opener)).connect(Matchers.anyLong(), Matchers.anyBoolean());
        return opener;
    }

    private HttpURLConnection getMockConnection(String length) throws IOException {
        HttpURLConnection mockConnection = (HttpURLConnection)Mockito.mock(HttpURLConnection.class);
        ((HttpURLConnection)Mockito.doReturn((Object)new ByteArrayInputStream("asdf".getBytes())).when((Object)mockConnection)).getInputStream();
        ((HttpURLConnection)Mockito.doReturn((Object)length).when((Object)mockConnection)).getHeaderField("Content-Length");
        return mockConnection;
    }

    @Test
    public void testByteRange() throws IOException {
        ByteRangeInputStream.URLOpener oMock = this.getMockURLOpener(new URL("http://test"));
        ByteRangeInputStream.URLOpener rMock = this.getMockURLOpener(null);
        ByteRangeInputStreamImpl bris = new ByteRangeInputStreamImpl(oMock, rMock);
        bris.seek(0L);
        Assert.assertEquals((String)"getPos wrong", (long)0L, (long)bris.getPos());
        bris.read();
        Assert.assertEquals((String)"Initial call made incorrectly (offset check)", (long)0L, (long)bris.startPos);
        Assert.assertEquals((String)"getPos should return 1 after reading one byte", (long)1L, (long)bris.getPos());
        ((ByteRangeInputStream.URLOpener)Mockito.verify((Object)oMock, (VerificationMode)Mockito.times((int)1))).connect(0L, false);
        bris.read();
        Assert.assertEquals((String)"getPos should return 2 after reading two bytes", (long)2L, (long)bris.getPos());
        ((ByteRangeInputStream.URLOpener)Mockito.verify((Object)oMock, (VerificationMode)Mockito.times((int)1))).connect(0L, false);
        rMock.setURL(new URL("http://resolvedurl/"));
        bris.seek(100L);
        bris.read();
        Assert.assertEquals((String)"Seek to 100 bytes made incorrectly (offset Check)", (long)100L, (long)bris.startPos);
        Assert.assertEquals((String)"getPos should return 101 after reading one byte", (long)101L, (long)bris.getPos());
        ((ByteRangeInputStream.URLOpener)Mockito.verify((Object)rMock, (VerificationMode)Mockito.times((int)1))).connect(100L, true);
        bris.seek(101L);
        bris.read();
        ((ByteRangeInputStream.URLOpener)Mockito.verify((Object)rMock, (VerificationMode)Mockito.times((int)1))).connect(100L, true);
        ((ByteRangeInputStream.URLOpener)Mockito.verify((Object)rMock, (VerificationMode)Mockito.times((int)0))).connect(101L, true);
        bris.seek(2500L);
        bris.read();
        Assert.assertEquals((String)"Seek to 2500 bytes made incorrectly (offset Check)", (long)2500L, (long)bris.startPos);
        ((ByteRangeInputStream.URLOpener)Mockito.doReturn((Object)this.getMockConnection(null)).when((Object)rMock)).connect(Matchers.anyLong(), Matchers.anyBoolean());
        bris.seek(500L);
        try {
            bris.read();
            Assert.fail((String)"Exception should be thrown when content-length is not given");
        }
        catch (IOException e) {
            Assert.assertTrue((String)("Incorrect response message: " + e.getMessage()), (boolean)e.getMessage().startsWith("Content-Length is missing: "));
        }
        bris.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPropagatedClose() throws IOException {
        ByteRangeInputStream bris = (ByteRangeInputStream)Mockito.mock(ByteRangeInputStream.class, (Answer)Mockito.CALLS_REAL_METHODS);
        ByteRangeInputStream.InputStreamAndFileLength mockStream = new ByteRangeInputStream.InputStreamAndFileLength(Long.valueOf(1L), (InputStream)Mockito.mock(InputStream.class));
        ((ByteRangeInputStream)Mockito.doReturn((Object)mockStream).when((Object)bris)).openInputStream(Mockito.anyLong());
        Whitebox.setInternalState((Object)bris, (String)"status", (Object)ByteRangeInputStream.StreamStatus.SEEK);
        int brisOpens = 0;
        int brisCloses = 0;
        int isCloses = 0;
        bris.getInputStream();
        ((ByteRangeInputStream)Mockito.verify((Object)bris, (VerificationMode)Mockito.times((int)(++brisOpens)))).openInputStream(Mockito.anyLong());
        ((ByteRangeInputStream)Mockito.verify((Object)bris, (VerificationMode)Mockito.times((int)brisCloses))).close();
        ((InputStream)Mockito.verify((Object)mockStream.in, (VerificationMode)Mockito.times((int)isCloses))).close();
        bris.getInputStream();
        ((ByteRangeInputStream)Mockito.verify((Object)bris, (VerificationMode)Mockito.times((int)brisOpens))).openInputStream(Mockito.anyLong());
        ((ByteRangeInputStream)Mockito.verify((Object)bris, (VerificationMode)Mockito.times((int)brisCloses))).close();
        ((InputStream)Mockito.verify((Object)mockStream.in, (VerificationMode)Mockito.times((int)isCloses))).close();
        bris.seek(1L);
        bris.getInputStream();
        ((ByteRangeInputStream)Mockito.verify((Object)bris, (VerificationMode)Mockito.times((int)(++brisOpens)))).openInputStream(Mockito.anyLong());
        ((ByteRangeInputStream)Mockito.verify((Object)bris, (VerificationMode)Mockito.times((int)brisCloses))).close();
        ((InputStream)Mockito.verify((Object)mockStream.in, (VerificationMode)Mockito.times((int)(++isCloses)))).close();
        bris.getInputStream();
        ((ByteRangeInputStream)Mockito.verify((Object)bris, (VerificationMode)Mockito.times((int)brisOpens))).openInputStream(Mockito.anyLong());
        ((ByteRangeInputStream)Mockito.verify((Object)bris, (VerificationMode)Mockito.times((int)brisCloses))).close();
        ((InputStream)Mockito.verify((Object)mockStream.in, (VerificationMode)Mockito.times((int)isCloses))).close();
        bris.seek(1L);
        bris.getInputStream();
        ((ByteRangeInputStream)Mockito.verify((Object)bris, (VerificationMode)Mockito.times((int)brisOpens))).openInputStream(Mockito.anyLong());
        ((ByteRangeInputStream)Mockito.verify((Object)bris, (VerificationMode)Mockito.times((int)brisCloses))).close();
        ((InputStream)Mockito.verify((Object)mockStream.in, (VerificationMode)Mockito.times((int)isCloses))).close();
        bris.close();
        ((ByteRangeInputStream)Mockito.verify((Object)bris, (VerificationMode)Mockito.times((int)(++brisCloses)))).close();
        ((InputStream)Mockito.verify((Object)mockStream.in, (VerificationMode)Mockito.times((int)(++isCloses)))).close();
        bris.close();
        ((ByteRangeInputStream)Mockito.verify((Object)bris, (VerificationMode)Mockito.times((int)(++brisCloses)))).close();
        ((InputStream)Mockito.verify((Object)mockStream.in, (VerificationMode)Mockito.times((int)isCloses))).close();
        boolean errored = false;
        try {
            bris.getInputStream();
        }
        catch (IOException e) {
            errored = true;
            Assert.assertEquals((Object)"Stream closed", (Object)e.getMessage());
        }
        finally {
            Assert.assertTrue((String)"Read a closed steam", (boolean)errored);
        }
        ((ByteRangeInputStream)Mockito.verify((Object)bris, (VerificationMode)Mockito.times((int)brisOpens))).openInputStream(Mockito.anyLong());
        ((ByteRangeInputStream)Mockito.verify((Object)bris, (VerificationMode)Mockito.times((int)brisCloses))).close();
        ((InputStream)Mockito.verify((Object)mockStream.in, (VerificationMode)Mockito.times((int)isCloses))).close();
    }

    @Test
    public void testAvailable() throws IOException {
        ByteRangeInputStream bris = (ByteRangeInputStream)Mockito.mock(ByteRangeInputStream.class, (Answer)Mockito.CALLS_REAL_METHODS);
        ByteRangeInputStream.InputStreamAndFileLength mockStream = new ByteRangeInputStream.InputStreamAndFileLength(Long.valueOf(65535L), (InputStream)Mockito.mock(InputStream.class));
        ((ByteRangeInputStream)Mockito.doReturn((Object)mockStream).when((Object)bris)).openInputStream(Mockito.anyLong());
        Whitebox.setInternalState((Object)bris, (String)"status", (Object)ByteRangeInputStream.StreamStatus.SEEK);
        Assert.assertEquals((String)"Before read or seek, available should be same as filelength", (long)65535L, (long)bris.available());
        ((ByteRangeInputStream)Mockito.verify((Object)bris, (VerificationMode)Mockito.times((int)1))).openInputStream(Mockito.anyLong());
        bris.seek(10L);
        Assert.assertEquals((String)"Seek 10 bytes, available should return filelength - 10", (long)65525L, (long)bris.available());
        bris.seek(65535L);
        Assert.assertEquals((String)"Seek till end of file, available should return 0 bytes", (long)0L, (long)bris.available());
        bris.seek(0L);
        bris.read();
        Assert.assertEquals((String)"Read 1 byte, available must return  filelength - 1", (long)65534L, (long)bris.available());
        bris.read();
        Assert.assertEquals((String)"Read another 1 byte, available must return  filelength - 2", (long)65533L, (long)bris.available());
        bris.seek(100L);
        bris.read();
        Assert.assertEquals((String)"Seek to offset 100 and read 1 byte, available should return filelength - 101", (long)65434L, (long)bris.available());
        bris.close();
    }

    @Test
    public void testAvailableLengthNotKnown() throws IOException {
        ByteRangeInputStream bris = (ByteRangeInputStream)Mockito.mock(ByteRangeInputStream.class, (Answer)Mockito.CALLS_REAL_METHODS);
        ByteRangeInputStream.InputStreamAndFileLength mockStream = new ByteRangeInputStream.InputStreamAndFileLength(null, (InputStream)Mockito.mock(InputStream.class));
        ((ByteRangeInputStream)Mockito.doReturn((Object)mockStream).when((Object)bris)).openInputStream(Mockito.anyLong());
        Whitebox.setInternalState((Object)bris, (String)"status", (Object)ByteRangeInputStream.StreamStatus.SEEK);
        Assert.assertEquals((long)Integer.MAX_VALUE, (long)bris.available());
    }

    @Test
    public void testAvailableStreamClosed() throws IOException {
        ByteRangeInputStream bris = (ByteRangeInputStream)Mockito.mock(ByteRangeInputStream.class, (Answer)Mockito.CALLS_REAL_METHODS);
        ByteRangeInputStream.InputStreamAndFileLength mockStream = new ByteRangeInputStream.InputStreamAndFileLength(null, (InputStream)Mockito.mock(InputStream.class));
        ((ByteRangeInputStream)Mockito.doReturn((Object)mockStream).when((Object)bris)).openInputStream(Mockito.anyLong());
        Whitebox.setInternalState((Object)bris, (String)"status", (Object)ByteRangeInputStream.StreamStatus.SEEK);
        bris.close();
        try {
            bris.available();
            Assert.fail((String)"Exception should be thrown when stream is closed");
        }
        catch (IOException e) {
            Assert.assertTrue((String)"Exception when stream is closed", (boolean)e.getMessage().equals("Stream closed"));
        }
    }

    private class ByteRangeInputStreamImpl
    extends ByteRangeInputStream {
        public ByteRangeInputStreamImpl(ByteRangeInputStream.URLOpener o, ByteRangeInputStream.URLOpener r) throws IOException {
            super(o, r);
        }

        protected URL getResolvedUrl(HttpURLConnection connection) throws IOException {
            return new URL("http://resolvedurl/");
        }
    }
}

