/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Splitter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.metrics2.MetricsCollector;
import org.apache.hadoop.metrics2.MetricsInfo;
import org.apache.hadoop.metrics2.MetricsSource;
import org.apache.hadoop.metrics2.MetricsSystem;
import org.apache.hadoop.metrics2.annotation.Metric;
import org.apache.hadoop.metrics2.annotation.Metrics;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.apache.hadoop.metrics2.lib.Interns;
import org.apache.hadoop.metrics2.lib.MetricsRegistry;
import org.apache.hadoop.metrics2.lib.MutableCounterInt;
import org.apache.hadoop.metrics2.lib.MutableCounterLong;
import org.apache.hadoop.metrics2.lib.MutableGaugeInt;
import org.apache.hadoop.metrics2.lib.MutableGaugeLong;
import org.apache.hadoop.metrics2.lib.MutableRate;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppState;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.AppSchedulingInfo;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.NodeType;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.Queue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.QueueMetricsCustomResource;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.QueueMetricsForCustomResources;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.TimeBucketMetrics;
import org.apache.hadoop.yarn.util.resource.ResourceUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@Metrics(context="yarn")
public class QueueMetrics
implements MetricsSource {
    @Metric(value={"# of apps submitted"})
    MutableCounterInt appsSubmitted;
    @Metric(value={"# of running apps"})
    MutableGaugeInt appsRunning;
    @Metric(value={"# of pending apps"})
    MutableGaugeInt appsPending;
    @Metric(value={"# of apps completed"})
    MutableCounterInt appsCompleted;
    @Metric(value={"# of apps killed"})
    MutableCounterInt appsKilled;
    @Metric(value={"# of apps failed"})
    MutableCounterInt appsFailed;
    @Metric(value={"Aggregate # of allocated node-local containers"})
    MutableCounterLong aggregateNodeLocalContainersAllocated;
    @Metric(value={"Aggregate # of allocated rack-local containers"})
    MutableCounterLong aggregateRackLocalContainersAllocated;
    @Metric(value={"Aggregate # of allocated off-switch containers"})
    MutableCounterLong aggregateOffSwitchContainersAllocated;
    @Metric(value={"Aggregate # of preempted containers"})
    MutableCounterLong aggregateContainersPreempted;
    @Metric(value={"Aggregate # of preempted memory seconds"})
    MutableCounterLong aggregateMemoryMBSecondsPreempted;
    @Metric(value={"Aggregate # of preempted vcore seconds"})
    MutableCounterLong aggregateVcoreSecondsPreempted;
    @Metric(value={"# of active users"})
    MutableGaugeInt activeUsers;
    @Metric(value={"# of active applications"})
    MutableGaugeInt activeApplications;
    @Metric(value={"App Attempt First Container Allocation Delay"})
    MutableRate appAttemptFirstContainerAllocationDelay;
    @Metric(value={"Allocated memory in MB"})
    MutableGaugeLong allocatedMB;
    @Metric(value={"Allocated CPU in virtual cores"})
    MutableGaugeInt allocatedVCores;
    @Metric(value={"# of allocated containers"})
    MutableGaugeInt allocatedContainers;
    @Metric(value={"Aggregate # of allocated containers"})
    MutableCounterLong aggregateContainersAllocated;
    @Metric(value={"Aggregate # of released containers"})
    MutableCounterLong aggregateContainersReleased;
    @Metric(value={"Available memory in MB"})
    MutableGaugeLong availableMB;
    @Metric(value={"Available CPU in virtual cores"})
    MutableGaugeInt availableVCores;
    @Metric(value={"Pending memory allocation in MB"})
    MutableGaugeLong pendingMB;
    @Metric(value={"Pending CPU allocation in virtual cores"})
    MutableGaugeInt pendingVCores;
    @Metric(value={"# of pending containers"})
    MutableGaugeInt pendingContainers;
    @Metric(value={"# of reserved memory in MB"})
    MutableGaugeLong reservedMB;
    @Metric(value={"Reserved CPU in virtual cores"})
    MutableGaugeInt reservedVCores;
    @Metric(value={"# of reserved containers"})
    MutableGaugeInt reservedContainers;
    private final MutableGaugeInt[] runningTime;
    private TimeBucketMetrics<ApplicationId> runBuckets;
    static final Logger LOG = LoggerFactory.getLogger(QueueMetrics.class);
    static final MetricsInfo RECORD_INFO = Interns.info((String)"QueueMetrics", (String)"Metrics for the resource scheduler");
    protected static final MetricsInfo QUEUE_INFO = Interns.info((String)"Queue", (String)"Metrics by queue");
    protected static final MetricsInfo USER_INFO = Interns.info((String)"User", (String)"Metrics by user");
    static final Splitter Q_SPLITTER = Splitter.on((char)'.').omitEmptyStrings().trimResults();
    protected final MetricsRegistry registry = new MetricsRegistry(RECORD_INFO);
    protected final String queueName;
    protected final QueueMetrics parent;
    protected final MetricsSystem metricsSystem;
    protected final Map<String, QueueMetrics> users;
    protected final Configuration conf;
    private QueueMetricsForCustomResources queueMetricsForCustomResources;
    private static final Map<String, QueueMetrics> QUEUE_METRICS = new HashMap<String, QueueMetrics>();

    protected QueueMetrics(MetricsSystem ms, String queueName, Queue parent, boolean enableUserMetrics, Configuration conf) {
        this.queueName = queueName;
        this.parent = parent != null ? parent.getMetrics() : null;
        this.users = enableUserMetrics ? new HashMap() : null;
        this.metricsSystem = ms;
        this.conf = conf;
        this.runningTime = this.buildBuckets(conf);
        if (ResourceUtils.getNumberOfKnownResourceTypes() > 2) {
            this.queueMetricsForCustomResources = new QueueMetricsForCustomResources();
        }
    }

    protected QueueMetrics tag(MetricsInfo info, String value) {
        this.registry.tag(info, value);
        return this;
    }

    protected static StringBuilder sourceName(String queueName) {
        StringBuilder sb = new StringBuilder(RECORD_INFO.name());
        int i = 0;
        for (String node : Q_SPLITTER.split((CharSequence)queueName)) {
            sb.append(",q").append(i++).append('=').append(node);
        }
        return sb;
    }

    public static synchronized QueueMetrics forQueue(String queueName, Queue parent, boolean enableUserMetrics, Configuration conf) {
        return QueueMetrics.forQueue(DefaultMetricsSystem.instance(), queueName, parent, enableUserMetrics, conf);
    }

    @InterfaceAudience.Private
    public static synchronized void clearQueueMetrics() {
        QUEUE_METRICS.clear();
    }

    protected static Map<String, QueueMetrics> getQueueMetrics() {
        return QUEUE_METRICS;
    }

    public static synchronized QueueMetrics forQueue(MetricsSystem ms, String queueName, Queue parent, boolean enableUserMetrics, Configuration conf) {
        QueueMetrics metrics = QUEUE_METRICS.get(queueName);
        if (metrics == null) {
            metrics = new QueueMetrics(ms, queueName, parent, enableUserMetrics, conf).tag(QUEUE_INFO, queueName);
            if (ms != null) {
                metrics = (QueueMetrics)ms.register(QueueMetrics.sourceName(queueName).toString(), "Metrics for queue: " + queueName, (Object)metrics);
            }
            QUEUE_METRICS.put(queueName, metrics);
        }
        return metrics;
    }

    public synchronized QueueMetrics getUserMetrics(String userName) {
        if (this.users == null) {
            return null;
        }
        QueueMetrics metrics = this.users.get(userName);
        if (metrics == null) {
            metrics = new QueueMetrics(this.metricsSystem, this.queueName, null, false, this.conf);
            this.users.put(userName, metrics);
            this.metricsSystem.register(QueueMetrics.sourceName(this.queueName).append(",user=").append(userName).toString(), "Metrics for user '" + userName + "' in queue '" + this.queueName + "'", (Object)metrics.tag(QUEUE_INFO, this.queueName).tag(USER_INFO, userName));
        }
        return metrics;
    }

    private ArrayList<Integer> parseInts(String value) {
        ArrayList<Integer> result = new ArrayList<Integer>();
        for (String s : value.split(",")) {
            result.add(Integer.parseInt(s.trim()));
        }
        return result;
    }

    private MutableGaugeInt[] buildBuckets(Configuration conf) {
        ArrayList<Integer> buckets = this.parseInts(conf.get("yarn.resourcemanager.metrics.runtime.buckets", "60,300,1440"));
        MutableGaugeInt[] result = new MutableGaugeInt[buckets.size() + 1];
        result[0] = this.registry.newGauge("running_0", "", 0);
        long[] cuts = new long[buckets.size()];
        for (int i = 0; i < buckets.size(); ++i) {
            result[i + 1] = this.registry.newGauge("running_" + buckets.get(i), "", 0);
            cuts[i] = (long)buckets.get(i).intValue() * 1000L * 60L;
        }
        this.runBuckets = new TimeBucketMetrics(cuts);
        return result;
    }

    private void updateRunningTime() {
        int[] counts = this.runBuckets.getBucketCounts(System.currentTimeMillis());
        for (int i = 0; i < counts.length; ++i) {
            this.runningTime[i].set(counts[i]);
        }
    }

    public void getMetrics(MetricsCollector collector, boolean all) {
        this.updateRunningTime();
        this.registry.snapshot(collector.addRecord(this.registry.info()), all);
    }

    public void submitApp(String user) {
        this.appsSubmitted.incr();
        QueueMetrics userMetrics = this.getUserMetrics(user);
        if (userMetrics != null) {
            userMetrics.submitApp(user);
        }
        if (this.parent != null) {
            this.parent.submitApp(user);
        }
    }

    public void submitAppAttempt(String user) {
        this.appsPending.incr();
        QueueMetrics userMetrics = this.getUserMetrics(user);
        if (userMetrics != null) {
            userMetrics.submitAppAttempt(user);
        }
        if (this.parent != null) {
            this.parent.submitAppAttempt(user);
        }
    }

    public void runAppAttempt(ApplicationId appId, String user) {
        this.runBuckets.add(appId, System.currentTimeMillis());
        this.appsRunning.incr();
        this.appsPending.decr();
        QueueMetrics userMetrics = this.getUserMetrics(user);
        if (userMetrics != null) {
            userMetrics.runAppAttempt(appId, user);
        }
        if (this.parent != null) {
            this.parent.runAppAttempt(appId, user);
        }
    }

    public void finishAppAttempt(ApplicationId appId, boolean isPending, String user) {
        this.runBuckets.remove(appId);
        if (isPending) {
            this.appsPending.decr();
        } else {
            this.appsRunning.decr();
        }
        QueueMetrics userMetrics = this.getUserMetrics(user);
        if (userMetrics != null) {
            userMetrics.finishAppAttempt(appId, isPending, user);
        }
        if (this.parent != null) {
            this.parent.finishAppAttempt(appId, isPending, user);
        }
    }

    public void finishApp(String user, RMAppState rmAppFinalState) {
        switch (rmAppFinalState) {
            case KILLED: {
                this.appsKilled.incr();
                break;
            }
            case FAILED: {
                this.appsFailed.incr();
                break;
            }
            default: {
                this.appsCompleted.incr();
            }
        }
        QueueMetrics userMetrics = this.getUserMetrics(user);
        if (userMetrics != null) {
            userMetrics.finishApp(user, rmAppFinalState);
        }
        if (this.parent != null) {
            this.parent.finishApp(user, rmAppFinalState);
        }
    }

    public void moveAppFrom(AppSchedulingInfo app) {
        if (app.isPending()) {
            this.appsPending.decr();
        } else {
            this.appsRunning.decr();
        }
        QueueMetrics userMetrics = this.getUserMetrics(app.getUser());
        if (userMetrics != null) {
            userMetrics.moveAppFrom(app);
        }
        if (this.parent != null) {
            this.parent.moveAppFrom(app);
        }
    }

    public void moveAppTo(AppSchedulingInfo app) {
        if (app.isPending()) {
            this.appsPending.incr();
        } else {
            this.appsRunning.incr();
        }
        QueueMetrics userMetrics = this.getUserMetrics(app.getUser());
        if (userMetrics != null) {
            userMetrics.moveAppTo(app);
        }
        if (this.parent != null) {
            this.parent.moveAppTo(app);
        }
    }

    public void setAvailableResourcesToQueue(String partition, Resource limit) {
        if (partition == null || partition.equals("")) {
            this.availableMB.set(limit.getMemorySize());
            this.availableVCores.set(limit.getVirtualCores());
            if (this.queueMetricsForCustomResources != null) {
                this.queueMetricsForCustomResources.setAvailable(limit);
            }
        }
    }

    public void setAvailableResourcesToQueue(Resource limit) {
        this.setAvailableResourcesToQueue("", limit);
    }

    public void setAvailableResourcesToUser(String partition, String user, Resource limit) {
        QueueMetrics userMetrics;
        if ((partition == null || partition.equals("")) && (userMetrics = this.getUserMetrics(user)) != null) {
            userMetrics.setAvailableResourcesToQueue(partition, limit);
        }
    }

    public void incrPendingResources(String partition, String user, int containers, Resource res) {
        if (partition == null || partition.equals("")) {
            this._incrPendingResources(containers, res);
            QueueMetrics userMetrics = this.getUserMetrics(user);
            if (userMetrics != null) {
                userMetrics.incrPendingResources(partition, user, containers, res);
            }
            if (this.parent != null) {
                this.parent.incrPendingResources(partition, user, containers, res);
            }
        }
    }

    private void _incrPendingResources(int containers, Resource res) {
        this.pendingContainers.incr(containers);
        this.pendingMB.incr(res.getMemorySize() * (long)containers);
        this.pendingVCores.incr(res.getVirtualCores() * containers);
        if (this.queueMetricsForCustomResources != null) {
            this.queueMetricsForCustomResources.increasePending(res, containers);
        }
    }

    public void decrPendingResources(String partition, String user, int containers, Resource res) {
        if (partition == null || partition.equals("")) {
            this._decrPendingResources(containers, res);
            QueueMetrics userMetrics = this.getUserMetrics(user);
            if (userMetrics != null) {
                userMetrics.decrPendingResources(partition, user, containers, res);
            }
            if (this.parent != null) {
                this.parent.decrPendingResources(partition, user, containers, res);
            }
        }
    }

    private void _decrPendingResources(int containers, Resource res) {
        this.pendingContainers.decr(containers);
        this.pendingMB.decr(res.getMemorySize() * (long)containers);
        this.pendingVCores.decr(res.getVirtualCores() * containers);
        if (this.queueMetricsForCustomResources != null) {
            this.queueMetricsForCustomResources.decreasePending(res, containers);
        }
    }

    public void incrNodeTypeAggregations(String user, NodeType type) {
        if (type == NodeType.NODE_LOCAL) {
            this.aggregateNodeLocalContainersAllocated.incr();
        } else if (type == NodeType.RACK_LOCAL) {
            this.aggregateRackLocalContainersAllocated.incr();
        } else if (type == NodeType.OFF_SWITCH) {
            this.aggregateOffSwitchContainersAllocated.incr();
        } else {
            return;
        }
        QueueMetrics userMetrics = this.getUserMetrics(user);
        if (userMetrics != null) {
            userMetrics.incrNodeTypeAggregations(user, type);
        }
        if (this.parent != null) {
            this.parent.incrNodeTypeAggregations(user, type);
        }
    }

    public void allocateResources(String partition, String user, int containers, Resource res, boolean decrPending) {
        if (partition == null || partition.equals("")) {
            QueueMetrics userMetrics;
            this.allocatedContainers.incr(containers);
            this.aggregateContainersAllocated.incr((long)containers);
            this.allocatedMB.incr(res.getMemorySize() * (long)containers);
            this.allocatedVCores.incr(res.getVirtualCores() * containers);
            if (this.queueMetricsForCustomResources != null) {
                this.queueMetricsForCustomResources.increaseAllocated(res, containers);
            }
            if (decrPending) {
                this._decrPendingResources(containers, res);
            }
            if ((userMetrics = this.getUserMetrics(user)) != null) {
                userMetrics.allocateResources(partition, user, containers, res, decrPending);
            }
            if (this.parent != null) {
                this.parent.allocateResources(partition, user, containers, res, decrPending);
            }
        }
    }

    public void allocateResources(String partition, String user, Resource res) {
        if (partition == null || partition.equals("")) {
            QueueMetrics userMetrics;
            this.allocatedMB.incr(res.getMemorySize());
            this.allocatedVCores.incr(res.getVirtualCores());
            if (this.queueMetricsForCustomResources != null) {
                this.queueMetricsForCustomResources.increaseAllocated(res);
            }
            this.pendingMB.decr(res.getMemorySize());
            this.pendingVCores.decr(res.getVirtualCores());
            if (this.queueMetricsForCustomResources != null) {
                this.queueMetricsForCustomResources.decreasePending(res);
            }
            if ((userMetrics = this.getUserMetrics(user)) != null) {
                userMetrics.allocateResources(partition, user, res);
            }
            if (this.parent != null) {
                this.parent.allocateResources(partition, user, res);
            }
        }
    }

    public void releaseResources(String partition, String user, int containers, Resource res) {
        if (partition == null || partition.equals("")) {
            QueueMetrics userMetrics;
            this.allocatedContainers.decr(containers);
            this.aggregateContainersReleased.incr((long)containers);
            this.allocatedMB.decr(res.getMemorySize() * (long)containers);
            this.allocatedVCores.decr(res.getVirtualCores() * containers);
            if (this.queueMetricsForCustomResources != null) {
                this.queueMetricsForCustomResources.decreaseAllocated(res, containers);
            }
            if ((userMetrics = this.getUserMetrics(user)) != null) {
                userMetrics.releaseResources(partition, user, containers, res);
            }
            if (this.parent != null) {
                this.parent.releaseResources(partition, user, containers, res);
            }
        }
    }

    private void releaseResources(String user, Resource res) {
        QueueMetrics userMetrics;
        this.allocatedMB.decr(res.getMemorySize());
        this.allocatedVCores.decr(res.getVirtualCores());
        if (this.queueMetricsForCustomResources != null) {
            this.queueMetricsForCustomResources.decreaseAllocated(res);
        }
        if ((userMetrics = this.getUserMetrics(user)) != null) {
            userMetrics.releaseResources(user, res);
        }
        if (this.parent != null) {
            this.parent.releaseResources(user, res);
        }
    }

    public void preemptContainer() {
        this.aggregateContainersPreempted.incr();
        if (this.parent != null) {
            this.parent.preemptContainer();
        }
    }

    public void updatePreemptedMemoryMBSeconds(long mbSeconds) {
        this.aggregateMemoryMBSecondsPreempted.incr(mbSeconds);
        if (this.parent != null) {
            this.parent.updatePreemptedMemoryMBSeconds(mbSeconds);
        }
    }

    public void updatePreemptedVcoreSeconds(long vcoreSeconds) {
        this.aggregateVcoreSecondsPreempted.incr(vcoreSeconds);
        if (this.parent != null) {
            this.parent.updatePreemptedVcoreSeconds(vcoreSeconds);
        }
    }

    public void updatePreemptedSecondsForCustomResources(Resource res, long seconds) {
        if (this.queueMetricsForCustomResources != null) {
            this.queueMetricsForCustomResources.increaseAggregatedPreemptedSeconds(res, seconds);
        }
        if (this.parent != null) {
            this.parent.updatePreemptedSecondsForCustomResources(res, seconds);
        }
    }

    public void reserveResource(String partition, String user, Resource res) {
        if (partition == null || partition.equals("")) {
            this.reserveResource(user, res);
        }
    }

    public void reserveResource(String user, Resource res) {
        QueueMetrics userMetrics;
        this.reservedContainers.incr();
        this.reservedMB.incr(res.getMemorySize());
        this.reservedVCores.incr(res.getVirtualCores());
        if (this.queueMetricsForCustomResources != null) {
            this.queueMetricsForCustomResources.increaseReserved(res);
        }
        if ((userMetrics = this.getUserMetrics(user)) != null) {
            userMetrics.reserveResource(user, res);
        }
        if (this.parent != null) {
            this.parent.reserveResource(user, res);
        }
    }

    private void unreserveResource(String user, Resource res) {
        QueueMetrics userMetrics;
        this.reservedContainers.decr();
        this.reservedMB.decr(res.getMemorySize());
        this.reservedVCores.decr(res.getVirtualCores());
        if (this.queueMetricsForCustomResources != null) {
            this.queueMetricsForCustomResources.decreaseReserved(res);
        }
        if ((userMetrics = this.getUserMetrics(user)) != null) {
            userMetrics.unreserveResource(user, res);
        }
        if (this.parent != null) {
            this.parent.unreserveResource(user, res);
        }
    }

    public void unreserveResource(String partition, String user, Resource res) {
        if (partition == null || partition.equals("")) {
            this.unreserveResource(user, res);
        }
    }

    public void incrActiveUsers() {
        this.activeUsers.incr();
    }

    public void decrActiveUsers() {
        this.activeUsers.decr();
    }

    public void activateApp(String user) {
        this.activeApplications.incr();
        QueueMetrics userMetrics = this.getUserMetrics(user);
        if (userMetrics != null) {
            userMetrics.activateApp(user);
        }
        if (this.parent != null) {
            this.parent.activateApp(user);
        }
    }

    public void deactivateApp(String user) {
        this.activeApplications.decr();
        QueueMetrics userMetrics = this.getUserMetrics(user);
        if (userMetrics != null) {
            userMetrics.deactivateApp(user);
        }
        if (this.parent != null) {
            this.parent.deactivateApp(user);
        }
    }

    public void addAppAttemptFirstContainerAllocationDelay(long latency) {
        this.appAttemptFirstContainerAllocationDelay.add(latency);
    }

    public int getAppsSubmitted() {
        return this.appsSubmitted.value();
    }

    public int getAppsRunning() {
        return this.appsRunning.value();
    }

    public int getAppsPending() {
        return this.appsPending.value();
    }

    public int getAppsCompleted() {
        return this.appsCompleted.value();
    }

    public int getAppsKilled() {
        return this.appsKilled.value();
    }

    public int getAppsFailed() {
        return this.appsFailed.value();
    }

    public Resource getAllocatedResources() {
        if (this.queueMetricsForCustomResources != null) {
            return Resource.newInstance((long)this.allocatedMB.value(), (int)this.allocatedVCores.value(), this.queueMetricsForCustomResources.getAllocatedValues());
        }
        return Resource.newInstance((long)this.allocatedMB.value(), (int)this.allocatedVCores.value());
    }

    public Resource getAvailableResources() {
        if (this.queueMetricsForCustomResources != null) {
            return Resource.newInstance((long)this.availableMB.value(), (int)this.availableVCores.value(), this.queueMetricsForCustomResources.getAvailableValues());
        }
        return Resource.newInstance((long)this.availableMB.value(), (int)this.availableVCores.value());
    }

    public Resource getPendingResources() {
        if (this.queueMetricsForCustomResources != null) {
            return Resource.newInstance((long)this.pendingMB.value(), (int)this.pendingVCores.value(), this.queueMetricsForCustomResources.getPendingValues());
        }
        return Resource.newInstance((long)this.pendingMB.value(), (int)this.pendingVCores.value());
    }

    public Resource getReservedResources() {
        if (this.queueMetricsForCustomResources != null) {
            return Resource.newInstance((long)this.reservedMB.value(), (int)this.reservedVCores.value(), this.queueMetricsForCustomResources.getReservedValues());
        }
        return Resource.newInstance((long)this.reservedMB.value(), (int)this.reservedVCores.value());
    }

    @VisibleForTesting
    public QueueMetricsCustomResource getAggregatedPreemptedSecondsResources() {
        return this.queueMetricsForCustomResources.getAggregatePreemptedSeconds();
    }

    @VisibleForTesting
    public MutableCounterLong getAggregateMemoryMBSecondsPreempted() {
        return this.aggregateMemoryMBSecondsPreempted;
    }

    @VisibleForTesting
    public MutableCounterLong getAggregateVcoreSecondsPreempted() {
        return this.aggregateVcoreSecondsPreempted;
    }

    public long getAllocatedMB() {
        return this.allocatedMB.value();
    }

    public int getAllocatedVirtualCores() {
        return this.allocatedVCores.value();
    }

    public int getAllocatedContainers() {
        return this.allocatedContainers.value();
    }

    public long getAvailableMB() {
        return this.availableMB.value();
    }

    public int getAvailableVirtualCores() {
        return this.availableVCores.value();
    }

    public long getPendingMB() {
        return this.pendingMB.value();
    }

    public int getPendingVirtualCores() {
        return this.pendingVCores.value();
    }

    public int getPendingContainers() {
        return this.pendingContainers.value();
    }

    public long getReservedMB() {
        return this.reservedMB.value();
    }

    public int getReservedVirtualCores() {
        return this.reservedVCores.value();
    }

    public int getReservedContainers() {
        return this.reservedContainers.value();
    }

    public int getActiveUsers() {
        return this.activeUsers.value();
    }

    public int getActiveApps() {
        return this.activeApplications.value();
    }

    public MetricsSystem getMetricsSystem() {
        return this.metricsSystem;
    }

    public long getAggregateAllocatedContainers() {
        return this.aggregateContainersAllocated.value();
    }

    public long getAggregateNodeLocalContainersAllocated() {
        return this.aggregateNodeLocalContainersAllocated.value();
    }

    public long getAggregateRackLocalContainersAllocated() {
        return this.aggregateRackLocalContainersAllocated.value();
    }

    public long getAggregateOffSwitchContainersAllocated() {
        return this.aggregateOffSwitchContainersAllocated.value();
    }

    public long getAggegatedReleasedContainers() {
        return this.aggregateContainersReleased.value();
    }

    public long getAggregatePreemptedContainers() {
        return this.aggregateContainersPreempted.value();
    }

    public QueueMetricsForCustomResources getQueueMetricsForCustomResources() {
        return this.queueMetricsForCustomResources;
    }
}

