/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.monitor.capacity;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.PriorityQueue;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.server.resourcemanager.monitor.capacity.CapacitySchedulerPreemptionContext;
import org.apache.hadoop.yarn.server.resourcemanager.monitor.capacity.TempQueuePerPartition;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.policy.PriorityUtilizationQueueOrderingPolicy;
import org.apache.hadoop.yarn.util.resource.ResourceCalculator;
import org.apache.hadoop.yarn.util.resource.Resources;

public class AbstractPreemptableResourceCalculator {
    protected final CapacitySchedulerPreemptionContext context;
    protected final ResourceCalculator rc;
    private boolean isReservedPreemptionCandidatesSelector;

    public AbstractPreemptableResourceCalculator(CapacitySchedulerPreemptionContext preemptionContext, boolean isReservedPreemptionCandidatesSelector) {
        this.context = preemptionContext;
        this.rc = preemptionContext.getResourceCalculator();
        this.isReservedPreemptionCandidatesSelector = isReservedPreemptionCandidatesSelector;
    }

    protected void computeFixpointAllocation(Resource totGuarant, Collection<TempQueuePerPartition> qAlloc, Resource unassigned, boolean ignoreGuarantee) {
        TQComparator tqComparator = new TQComparator(this.rc, totGuarant);
        PriorityQueue<TempQueuePerPartition> orderedByNeed = new PriorityQueue<TempQueuePerPartition>(10, tqComparator);
        for (TempQueuePerPartition q : qAlloc) {
            Resource used = q.getUsed();
            q.idealAssigned = Resources.greaterThan((ResourceCalculator)this.rc, (Resource)totGuarant, (Resource)used, (Resource)q.getGuaranteed()) ? Resources.add((Resource)q.getGuaranteed(), (Resource)q.untouchableExtra) : Resources.clone((Resource)used);
            Resources.subtractFrom((Resource)unassigned, (Resource)q.idealAssigned);
            Resource curPlusPend = Resources.add((Resource)q.getUsed(), (Resource)q.pending);
            if (!Resources.lessThan((ResourceCalculator)this.rc, (Resource)totGuarant, (Resource)q.idealAssigned, (Resource)curPlusPend)) continue;
            orderedByNeed.add(q);
        }
        while (!orderedByNeed.isEmpty() && Resources.greaterThan((ResourceCalculator)this.rc, (Resource)totGuarant, (Resource)unassigned, (Resource)Resources.none())) {
            Resource wQassigned = Resource.newInstance((int)0, (int)0);
            this.resetCapacity(unassigned, orderedByNeed, ignoreGuarantee);
            Collection<TempQueuePerPartition> underserved = this.getMostUnderservedQueues(orderedByNeed, tqComparator);
            for (TempQueuePerPartition sub : underserved) {
                Resource wQidle;
                Resource wQavail = Resources.multiplyAndNormalizeUp((ResourceCalculator)this.rc, (Resource)unassigned, (double)sub.normalizedGuarantee, (Resource)Resource.newInstance((int)1, (int)1));
                Resource wQdone = Resources.subtract((Resource)wQavail, (Resource)(wQidle = sub.offer(wQavail, this.rc, totGuarant, this.isReservedPreemptionCandidatesSelector)));
                if (Resources.greaterThan((ResourceCalculator)this.rc, (Resource)totGuarant, (Resource)wQdone, (Resource)Resources.none())) {
                    orderedByNeed.add(sub);
                }
                Resources.addTo((Resource)wQassigned, (Resource)wQdone);
            }
            Resources.subtractFrom((Resource)unassigned, (Resource)wQassigned);
        }
        while (!orderedByNeed.isEmpty()) {
            TempQueuePerPartition q1 = (TempQueuePerPartition)orderedByNeed.remove();
            this.context.addPartitionToUnderServedQueues(q1.queueName, q1.partition);
        }
    }

    private void resetCapacity(Resource clusterResource, Collection<TempQueuePerPartition> queues, boolean ignoreGuar) {
        Resource activeCap = Resource.newInstance((int)0, (int)0);
        if (ignoreGuar) {
            for (TempQueuePerPartition q : queues) {
                q.normalizedGuarantee = 1.0f / (float)queues.size();
            }
        } else {
            for (TempQueuePerPartition q : queues) {
                Resources.addTo((Resource)activeCap, (Resource)q.getGuaranteed());
            }
            for (TempQueuePerPartition q : queues) {
                q.normalizedGuarantee = Resources.divide((ResourceCalculator)this.rc, (Resource)clusterResource, (Resource)q.getGuaranteed(), (Resource)activeCap);
            }
        }
    }

    private Collection<TempQueuePerPartition> getMostUnderservedQueues(PriorityQueue<TempQueuePerPartition> orderedByNeed, TQComparator tqComparator) {
        ArrayList<TempQueuePerPartition> underserved = new ArrayList<TempQueuePerPartition>();
        while (!orderedByNeed.isEmpty()) {
            TempQueuePerPartition q1 = (TempQueuePerPartition)orderedByNeed.remove();
            underserved.add(q1);
            this.context.addPartitionToUnderServedQueues(q1.queueName, q1.partition);
            TempQueuePerPartition q2 = orderedByNeed.peek();
            if (q2 != null && tqComparator.compare(q1, q2) >= 0) continue;
            if (null != q2) {
                this.context.addPartitionToUnderServedQueues(q2.queueName, q2.partition);
            }
            return underserved;
        }
        return underserved;
    }

    static class TQComparator
    implements Comparator<TempQueuePerPartition> {
        private ResourceCalculator rc;
        private Resource clusterRes;

        TQComparator(ResourceCalculator rc, Resource clusterRes) {
            this.rc = rc;
            this.clusterRes = clusterRes;
        }

        @Override
        public int compare(TempQueuePerPartition tq1, TempQueuePerPartition tq2) {
            double assigned1 = this.getIdealPctOfGuaranteed(tq1);
            double assigned2 = this.getIdealPctOfGuaranteed(tq2);
            return PriorityUtilizationQueueOrderingPolicy.compare(assigned1, assigned2, tq1.relativePriority, tq2.relativePriority);
        }

        private double getIdealPctOfGuaranteed(TempQueuePerPartition q) {
            double pctOver = 2.147483647E9;
            if (q != null && Resources.greaterThan((ResourceCalculator)this.rc, (Resource)this.clusterRes, (Resource)q.getGuaranteed(), (Resource)Resources.none())) {
                pctOver = Resources.divide((ResourceCalculator)this.rc, (Resource)this.clusterRes, (Resource)q.idealAssigned, (Resource)q.getGuaranteed());
            }
            return pctOver;
        }
    }
}

