/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.slive;

import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.slive.ArgumentParser;
import org.apache.hadoop.fs.slive.ConfigExtractor;
import org.apache.hadoop.fs.slive.ConfigMerger;
import org.apache.hadoop.fs.slive.ConfigOption;
import org.apache.hadoop.fs.slive.DummyInputFormat;
import org.apache.hadoop.fs.slive.Helper;
import org.apache.hadoop.fs.slive.OperationOutput;
import org.apache.hadoop.fs.slive.ReportWriter;
import org.apache.hadoop.fs.slive.SliveMapper;
import org.apache.hadoop.fs.slive.SlivePartitioner;
import org.apache.hadoop.fs.slive.SliveReducer;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.TextOutputFormat;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;

public class SliveTest
implements Tool {
    private static final Log LOG = LogFactory.getLog(SliveTest.class);
    private Configuration base;

    public SliveTest(Configuration base) {
        this.base = base;
    }

    public int run(String[] args) {
        boolean cleanUp;
        ArgumentParser.ParsedOutput parsedOpts = null;
        try {
            ArgumentParser argHolder = new ArgumentParser(args);
            parsedOpts = argHolder.parse();
            if (parsedOpts.shouldOutputHelp()) {
                parsedOpts.outputHelp();
                return 1;
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Unable to parse arguments due to error: ", (Throwable)e);
            return 1;
        }
        LOG.info((Object)("Running with option list " + Helper.stringifyArray(args, " ")));
        ConfigExtractor config = null;
        try {
            ConfigMerger cfgMerger = new ConfigMerger();
            Configuration cfg = cfgMerger.getMerged(parsedOpts, new Configuration(this.base));
            if (cfg != null) {
                config = new ConfigExtractor(cfg);
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Unable to merge config due to error: ", (Throwable)e);
            return 1;
        }
        if (config == null) {
            LOG.error((Object)"Unable to merge config & options!");
            return 1;
        }
        try {
            LOG.info((Object)"Options are:");
            ConfigExtractor.dumpOptions(config);
        }
        catch (Exception e) {
            LOG.error((Object)"Unable to dump options due to error: ", (Throwable)e);
            return 1;
        }
        boolean jobOk = false;
        try {
            LOG.info((Object)"Running job:");
            this.runJob(config);
            jobOk = true;
        }
        catch (Exception e) {
            LOG.error((Object)"Unable to run job due to error: ", (Throwable)e);
        }
        if (jobOk) {
            try {
                LOG.info((Object)"Reporting on job:");
                this.writeReport(config);
            }
            catch (Exception e) {
                LOG.error((Object)"Unable to report on job due to error: ", (Throwable)e);
            }
        }
        if (cleanUp = this.getBool(parsedOpts.getValue(ConfigOption.CLEANUP.getOpt()))) {
            try {
                LOG.info((Object)"Cleaning up job:");
                this.cleanup(config);
            }
            catch (Exception e) {
                LOG.error((Object)"Unable to cleanup job due to error: ", (Throwable)e);
            }
        }
        if (jobOk) {
            return 0;
        }
        return 1;
    }

    private boolean getBool(String val) {
        if (val == null) {
            return false;
        }
        String cleanupOpt = StringUtils.toLowerCase((String)val).trim();
        return cleanupOpt.equals("true") || cleanupOpt.equals("1");
    }

    private JobConf getJob(ConfigExtractor config) throws IOException {
        JobConf job = new JobConf(config.getConfig(), SliveTest.class);
        job.setInputFormat(DummyInputFormat.class);
        FileOutputFormat.setOutputPath((JobConf)job, (Path)config.getOutputPath());
        job.setMapperClass(SliveMapper.class);
        job.setPartitionerClass(SlivePartitioner.class);
        job.setReducerClass(SliveReducer.class);
        job.setOutputKeyClass(Text.class);
        job.setOutputValueClass(Text.class);
        job.setOutputFormat(TextOutputFormat.class);
        TextOutputFormat.setCompressOutput((JobConf)job, (boolean)false);
        job.setNumReduceTasks(config.getReducerAmount().intValue());
        job.setNumMapTasks(config.getMapAmount().intValue());
        return job;
    }

    private void runJob(ConfigExtractor config) throws IOException {
        JobClient.runJob((JobConf)this.getJob(config));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeReport(ConfigExtractor cfg) throws Exception {
        Path dn = cfg.getOutputPath();
        LOG.info((Object)("Writing report using contents of " + dn));
        FileSystem fs = dn.getFileSystem(cfg.getConfig());
        FileStatus[] reduceFiles = fs.listStatus(dn);
        BufferedReader fileReader = null;
        PrintWriter reportWriter = null;
        try {
            ArrayList<OperationOutput> noOperations = new ArrayList<OperationOutput>();
            TreeMap<String, ArrayList<OperationOutput>> splitTypes = new TreeMap<String, ArrayList<OperationOutput>>();
            for (FileStatus fn : reduceFiles) {
                String line;
                if (!fn.getPath().getName().startsWith("part")) continue;
                fileReader = new BufferedReader(new InputStreamReader(new DataInputStream((InputStream)fs.open(fn.getPath()))));
                while ((line = fileReader.readLine()) != null) {
                    String[] pieces = line.split("\t", 2);
                    if (pieces.length == 2) {
                        OperationOutput data = new OperationOutput(pieces[0], (Object)pieces[1]);
                        String op = data.getOperationType();
                        if (op != null) {
                            ArrayList<OperationOutput> opList = (ArrayList<OperationOutput>)splitTypes.get(op);
                            if (opList == null) {
                                opList = new ArrayList<OperationOutput>();
                            }
                            opList.add(data);
                            splitTypes.put(op, opList);
                            continue;
                        }
                        noOperations.add(data);
                        continue;
                    }
                    throw new IOException("Unparseable line " + line);
                }
                fileReader.close();
                fileReader = null;
            }
            File resFile = null;
            if (cfg.getResultFile() != null) {
                resFile = new File(cfg.getResultFile());
            }
            if (resFile != null) {
                LOG.info((Object)("Report results being placed to logging output and to file " + resFile.getCanonicalPath()));
                reportWriter = new PrintWriter(new FileOutputStream(resFile));
            } else {
                LOG.info((Object)"Report results being placed to logging output");
            }
            ReportWriter reporter = new ReportWriter();
            if (!noOperations.isEmpty()) {
                reporter.basicReport(noOperations, reportWriter);
            }
            for (String opType : splitTypes.keySet()) {
                reporter.opReport(opType, (List)splitTypes.get(opType), reportWriter);
            }
        }
        finally {
            if (fileReader != null) {
                fileReader.close();
            }
            if (reportWriter != null) {
                reportWriter.close();
            }
        }
    }

    private void cleanup(ConfigExtractor cfg) throws IOException {
        Path base = cfg.getBaseDirectory();
        if (base != null) {
            LOG.info((Object)("Attempting to recursively delete " + base));
            FileSystem fs = base.getFileSystem(cfg.getConfig());
            fs.delete(base, true);
        }
    }

    public static void main(String[] args) throws Exception {
        Configuration startCfg = new Configuration(true);
        SliveTest runner = new SliveTest(startCfg);
        int ec = ToolRunner.run((Tool)runner, (String[])args);
        System.exit(ec);
    }

    public Configuration getConf() {
        return this.base;
    }

    public void setConf(Configuration conf) {
        this.base = conf;
    }

    static {
        Configuration.addDefaultResource((String)"hdfs-default.xml");
        Configuration.addDefaultResource((String)"hdfs-site.xml");
    }
}

