/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.type.context;

import java.io.Serializable;
import java.text.Format;
import java.text.ParseException;
import java.util.Objects;
import org.ojalgo.type.context.GenericContext;
import org.ojalgo.type.context.TypeContext;

abstract class FormatContext<T>
implements TypeContext<T>,
Serializable {
    public static final boolean NBSP = true;
    private boolean myConfigured = false;
    private final Format myFormat;

    FormatContext(Format format) {
        Objects.requireNonNull(format);
        this.myFormat = (Format)format.clone();
    }

    @Override
    public final String format(Object object) {
        if (object != null) {
            try {
                if (!this.myConfigured) {
                    this.configureFormat(this.myFormat, object);
                    this.myConfigured = true;
                }
                return this.myFormat.format(object).replace(' ', '\u00a0');
            }
            catch (IllegalArgumentException exception) {
                return this.handleFormatException(this.myFormat, object);
            }
        }
        return null;
    }

    public final Format getFormat() {
        return (Format)this.myFormat.clone();
    }

    public final <G> TypeContext<G> newFormat(Format format) {
        return new GenericContext(this, format);
    }

    @Override
    public final T parse(String string) {
        if (string != null) {
            try {
                return (T)this.myFormat.parseObject(string.replace('\u00a0', ' '));
            }
            catch (ParseException anException) {
                return this.handleParseException(this.myFormat, string);
            }
        }
        return null;
    }

    protected abstract void configureFormat(Format var1, Object var2);

    protected abstract String handleFormatException(Format var1, Object var2);

    protected abstract T handleParseException(Format var1, String var2);
}

