/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.random;

import java.util.Random;
import org.ojalgo.access.Access2D;
import org.ojalgo.array.Array1D;
import org.ojalgo.matrix.decomposition.Cholesky;
import org.ojalgo.matrix.store.MatrixStore;
import org.ojalgo.matrix.store.PrimitiveDenseStore;
import org.ojalgo.random.RandomNumber;
import org.ojalgo.type.Alternator;

public class Random1D {
    public final int length;
    private final Alternator<Random> myAlternator = RandomNumber.makeRandomAlternator();
    private final MatrixStore<Double> myCholeskiedCorrelations;

    public Random1D(Access2D<?> correlations) {
        Cholesky tmpCholesky = (Cholesky)Cholesky.PRIMITIVE.make();
        tmpCholesky.decompose(MatrixStore.PRIMITIVE.makeWrapper(correlations));
        this.myCholeskiedCorrelations = tmpCholesky.getL();
        tmpCholesky.reset();
        this.length = (int)this.myCholeskiedCorrelations.countRows();
    }

    public Random1D(int size) {
        this.myCholeskiedCorrelations = null;
        this.length = size;
    }

    private Random1D() {
        this(null);
    }

    public Array1D<Double> nextDouble() {
        PrimitiveDenseStore tmpUncorrelated = (PrimitiveDenseStore)PrimitiveDenseStore.FACTORY.makeZero(this.length, 1L);
        for (int i = 0; i < this.length; ++i) {
            tmpUncorrelated.set((long)i, 0L, this.random().nextDouble());
        }
        if (this.myCholeskiedCorrelations != null) {
            return ((PrimitiveDenseStore)this.myCholeskiedCorrelations.multiply((Double)((Object)tmpUncorrelated))).asList();
        }
        return tmpUncorrelated.asList();
    }

    public Array1D<Double> nextGaussian() {
        PrimitiveDenseStore tmpUncorrelated = (PrimitiveDenseStore)PrimitiveDenseStore.FACTORY.makeZero(this.length, 1L);
        for (int i = 0; i < this.length; ++i) {
            tmpUncorrelated.set((long)i, 0L, this.random().nextGaussian());
        }
        if (this.myCholeskiedCorrelations != null) {
            return ((PrimitiveDenseStore)this.myCholeskiedCorrelations.multiply((Double)((Object)tmpUncorrelated))).asList();
        }
        return tmpUncorrelated.asList();
    }

    public int size() {
        return this.length;
    }

    protected Random random() {
        return this.myAlternator.get();
    }
}

