/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.tools;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.tools.CopyListing;
import org.apache.hadoop.tools.DistCpContext;
import org.apache.hadoop.tools.GlobbedCopyListing;

public class FileBasedCopyListing
extends CopyListing {
    private final CopyListing globbedListing;

    public FileBasedCopyListing(Configuration configuration, Credentials credentials) {
        super(configuration, credentials);
        this.globbedListing = new GlobbedCopyListing(this.getConf(), credentials);
    }

    @Override
    protected void validatePaths(DistCpContext context) throws IOException, CopyListing.InvalidInputException {
    }

    @Override
    public void doBuildListing(Path pathToListFile, DistCpContext context) throws IOException {
        context.setSourcePaths(this.fetchFileList(context.getSourceFileListing()));
        this.globbedListing.buildListing(pathToListFile, context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Path> fetchFileList(Path sourceListing) throws IOException {
        ArrayList<Path> result = new ArrayList<Path>();
        FileSystem fs = sourceListing.getFileSystem(this.getConf());
        BufferedReader input = null;
        try {
            input = new BufferedReader(new InputStreamReader((InputStream)fs.open(sourceListing), Charset.forName("UTF-8")));
            String line = input.readLine();
            while (line != null) {
                result.add(new Path(line));
                line = input.readLine();
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeStream(input);
            throw throwable;
        }
        IOUtils.closeStream((Closeable)input);
        return result;
    }

    @Override
    protected long getBytesToCopy() {
        return this.globbedListing.getBytesToCopy();
    }

    @Override
    protected long getNumberOfPaths() {
        return this.globbedListing.getNumberOfPaths();
    }
}

