/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.http.server;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Properties;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.http.server.HttpFSServerWebApp;
import org.apache.hadoop.hdfs.web.WebHdfsConstants;
import org.apache.hadoop.security.token.delegation.web.DelegationTokenAuthenticationFilter;

@InterfaceAudience.Private
public class HttpFSAuthenticationFilter
extends DelegationTokenAuthenticationFilter {
    static final String CONF_PREFIX = "httpfs.authentication.";
    private static final String SIGNATURE_SECRET_FILE = "signature.secret.file";

    protected Properties getConfiguration(String configPrefix, FilterConfig filterConfig) throws ServletException {
        Properties props = new Properties();
        Configuration conf = HttpFSServerWebApp.get().getConfig();
        props.setProperty("cookie.path", "/");
        for (Map.Entry entry : conf) {
            String name = (String)entry.getKey();
            if (!name.startsWith(CONF_PREFIX)) continue;
            String value = conf.get(name);
            name = name.substring(CONF_PREFIX.length());
            props.setProperty(name, value);
        }
        String signatureSecretFile = props.getProperty(SIGNATURE_SECRET_FILE, null);
        if (signatureSecretFile == null) {
            throw new RuntimeException("Undefined property: signature.secret.file");
        }
        try {
            StringBuilder secret = new StringBuilder();
            InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(signatureSecretFile), StandardCharsets.UTF_8);
            int c = ((Reader)reader).read();
            while (c > -1) {
                secret.append((char)c);
                c = ((Reader)reader).read();
            }
            ((Reader)reader).close();
            props.setProperty("signature.secret", secret.toString());
        }
        catch (IOException ex) {
            throw new RuntimeException("Could not read HttpFS signature secret file: " + signatureSecretFile);
        }
        this.setAuthHandlerClass(props);
        String dtkind = WebHdfsConstants.WEBHDFS_TOKEN_KIND.toString();
        if (conf.getBoolean("httpfs.ssl.enabled", false)) {
            dtkind = WebHdfsConstants.SWEBHDFS_TOKEN_KIND.toString();
        }
        props.setProperty("delegation-token.token-kind", dtkind);
        return props;
    }

    protected Configuration getProxyuserConfiguration(FilterConfig filterConfig) {
        Map proxyuserConf = HttpFSServerWebApp.get().getConfig().getValByRegex("httpfs\\.proxyuser\\.");
        Configuration conf = new Configuration(false);
        for (Map.Entry entry : proxyuserConf.entrySet()) {
            conf.set(((String)entry.getKey()).substring("httpfs.".length()), (String)entry.getValue());
        }
        return conf;
    }
}

