/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security;

import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import org.apache.hadoop.security.LdapGroupsMapping;
import org.junit.Before;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.Spy;

public class TestLdapGroupsMappingBase {
    @Mock
    private DirContext context;
    @Mock
    private NamingEnumeration<SearchResult> userNames;
    @Mock
    private NamingEnumeration<SearchResult> groupNames;
    @Mock
    private NamingEnumeration<SearchResult> parentGroupNames;
    @Mock
    private SearchResult userSearchResult;
    @Mock
    private Attributes attributes;
    @Spy
    private LdapGroupsMapping groupsMapping = new LdapGroupsMapping();
    private String[] testGroups = new String[]{"group1", "group2"};
    private String[] testParentGroups = new String[]{"group1", "group2", "group1_1"};

    @Before
    public void setupMocksBase() throws NamingException {
        MockitoAnnotations.initMocks((Object)this);
        DirContext ctx = this.getContext();
        ((LdapGroupsMapping)Mockito.doReturn((Object)ctx).when((Object)this.groupsMapping)).getDirContext();
        Mockito.when(ctx.search(Mockito.anyString(), Mockito.anyString(), (Object[])Mockito.any(Object[].class), (SearchControls)Mockito.any(SearchControls.class))).thenReturn(this.userNames);
        Mockito.when((Object)this.userNames.hasMoreElements()).thenReturn((Object)true);
        SearchResult groupSearchResult = (SearchResult)Mockito.mock(SearchResult.class);
        Mockito.when((Object)this.groupNames.hasMoreElements()).thenReturn((Object)true, (Object[])new Boolean[]{true, false});
        Mockito.when(this.groupNames.nextElement()).thenReturn((Object)groupSearchResult);
        BasicAttribute group1Attr = new BasicAttribute("cn");
        group1Attr.add(this.testGroups[0]);
        BasicAttributes group1Attrs = new BasicAttributes();
        group1Attrs.put(group1Attr);
        BasicAttribute group2Attr = new BasicAttribute("cn");
        group2Attr.add(this.testGroups[1]);
        BasicAttributes group2Attrs = new BasicAttributes();
        group2Attrs.put(group2Attr);
        Mockito.when((Object)groupSearchResult.getAttributes()).thenReturn((Object)group1Attrs, (Object[])new Attributes[]{group2Attrs});
        Mockito.when(this.getUserNames().nextElement()).thenReturn((Object)this.getUserSearchResult());
        Mockito.when((Object)this.getUserSearchResult().getAttributes()).thenReturn((Object)this.getAttributes());
        SearchResult parentGroupResult = (SearchResult)Mockito.mock(SearchResult.class);
        Mockito.when((Object)this.parentGroupNames.hasMoreElements()).thenReturn((Object)true, (Object[])new Boolean[]{false});
        Mockito.when(this.parentGroupNames.nextElement()).thenReturn((Object)parentGroupResult);
        BasicAttribute parentGroup1Attr = new BasicAttribute("cn");
        parentGroup1Attr.add(this.testParentGroups[2]);
        BasicAttributes parentGroup1Attrs = new BasicAttributes();
        parentGroup1Attrs.put(parentGroup1Attr);
        Mockito.when((Object)parentGroupResult.getAttributes()).thenReturn((Object)parentGroup1Attrs);
        Mockito.when((Object)parentGroupResult.getNameInNamespace()).thenReturn((Object)"CN=some_group,DC=test,DC=com");
    }

    protected DirContext getContext() {
        return this.context;
    }

    protected NamingEnumeration<SearchResult> getUserNames() {
        return this.userNames;
    }

    protected NamingEnumeration<SearchResult> getGroupNames() {
        return this.groupNames;
    }

    protected SearchResult getUserSearchResult() {
        return this.userSearchResult;
    }

    protected Attributes getAttributes() {
        return this.attributes;
    }

    protected LdapGroupsMapping getGroupsMapping() {
        return this.groupsMapping;
    }

    protected String[] getTestGroups() {
        return this.testGroups;
    }

    protected NamingEnumeration getParentGroupNames() {
        return this.parentGroupNames;
    }

    protected String[] getTestParentGroups() {
        return this.testParentGroups;
    }
}

