/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.io;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.SecureIOUtils;
import org.apache.hadoop.io.nativeio.NativeIO;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestSecureIOUtils {
    private static String realOwner;
    private static String realGroup;
    private static File testFilePathIs;
    private static File testFilePathRaf;
    private static File testFilePathFadis;
    private static FileSystem fs;

    @BeforeClass
    public static void makeTestFile() throws Exception {
        Configuration conf = new Configuration();
        fs = FileSystem.getLocal((Configuration)conf).getRaw();
        testFilePathIs = new File(new Path("target", TestSecureIOUtils.class.getSimpleName() + "1").toUri().getRawPath());
        testFilePathRaf = new File(new Path("target", TestSecureIOUtils.class.getSimpleName() + "2").toUri().getRawPath());
        testFilePathFadis = new File(new Path("target", TestSecureIOUtils.class.getSimpleName() + "3").toUri().getRawPath());
        for (File f : new File[]{testFilePathIs, testFilePathRaf, testFilePathFadis}) {
            FileOutputStream fos = new FileOutputStream(f);
            fos.write("hello".getBytes("UTF-8"));
            fos.close();
        }
        FileStatus stat = fs.getFileStatus(new Path(testFilePathIs.toString()));
        realOwner = stat.getOwner();
        realGroup = stat.getGroup();
    }

    @Test(timeout=10000L)
    public void testReadUnrestricted() throws IOException {
        SecureIOUtils.openForRead((File)testFilePathIs, null, null).close();
        SecureIOUtils.openFSDataInputStream((File)testFilePathFadis, null, null).close();
        SecureIOUtils.openForRandomRead((File)testFilePathRaf, (String)"r", null, null).close();
    }

    @Test(timeout=10000L)
    public void testReadCorrectlyRestrictedWithSecurity() throws IOException {
        SecureIOUtils.openForRead((File)testFilePathIs, (String)realOwner, (String)realGroup).close();
        SecureIOUtils.openFSDataInputStream((File)testFilePathFadis, (String)realOwner, (String)realGroup).close();
        SecureIOUtils.openForRandomRead((File)testFilePathRaf, (String)"r", (String)realOwner, (String)realGroup).close();
    }

    @Test(timeout=10000L)
    public void testReadIncorrectlyRestrictedWithSecurity() throws IOException {
        Assume.assumeTrue((boolean)NativeIO.isAvailable());
        System.out.println("Running test with native libs...");
        String invalidUser = "InvalidUser";
        try {
            SecureIOUtils.forceSecureOpenForRead((File)testFilePathIs, (String)invalidUser, (String)realGroup).close();
            Assert.fail((String)"Didn't throw expection for wrong user ownership!");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            SecureIOUtils.forceSecureOpenFSDataInputStream((File)testFilePathFadis, (String)invalidUser, (String)realGroup).close();
            Assert.fail((String)"Didn't throw expection for wrong user ownership!");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            SecureIOUtils.forceSecureOpenForRandomRead((File)testFilePathRaf, (String)"r", (String)invalidUser, (String)realGroup).close();
            Assert.fail((String)"Didn't throw expection for wrong user ownership!");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Test(timeout=10000L)
    public void testCreateForWrite() throws IOException {
        try {
            SecureIOUtils.createForWrite((File)testFilePathIs, (int)511);
            Assert.fail((String)("Was able to create file at " + testFilePathIs));
        }
        catch (SecureIOUtils.AlreadyExistsException alreadyExistsException) {
            // empty catch block
        }
    }

    @AfterClass
    public static void removeTestFile() throws Exception {
        for (File f : new File[]{testFilePathIs, testFilePathRaf, testFilePathFadis}) {
            f.delete();
        }
    }
}

