/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FsShell;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestFsShellList {
    private static Configuration conf;
    private static FsShell shell;
    private static LocalFileSystem lfs;
    private static Path testRootDir;

    @BeforeClass
    public static void setup() throws Exception {
        conf = new Configuration();
        shell = new FsShell(conf);
        lfs = FileSystem.getLocal((Configuration)conf);
        lfs.setVerifyChecksum(true);
        lfs.setWriteChecksum(true);
        String root = System.getProperty("test.build.data", "test/build/data");
        testRootDir = lfs.makeQualified(new Path(root, "testFsShellList"));
        Assert.assertThat((Object)lfs.mkdirs(testRootDir), (Matcher)Is.is((Object)true));
    }

    @AfterClass
    public static void teardown() throws Exception {
        lfs.delete(testRootDir, true);
    }

    private void createFile(Path filePath) throws Exception {
        FSDataOutputStream out = lfs.create(filePath);
        out.writeChars("I am " + filePath);
        out.close();
        Assert.assertThat((Object)lfs.exists(lfs.getChecksumFile(filePath)), (Matcher)Is.is((Object)true));
    }

    @Test
    public void testList() throws Exception {
        this.createFile(new Path(testRootDir, "abc"));
        String[] lsArgv = new String[]{"-ls", testRootDir.toString()};
        Assert.assertThat((Object)shell.run(lsArgv), (Matcher)Is.is((Object)0));
        this.createFile(new Path(testRootDir, "abc\bd\tef"));
        this.createFile(new Path(testRootDir, "ghi"));
        this.createFile(new Path(testRootDir, "qq\r123"));
        lsArgv = new String[]{"-ls", testRootDir.toString()};
        Assert.assertThat((Object)shell.run(lsArgv), (Matcher)Is.is((Object)0));
        lsArgv = new String[]{"-ls", "-q", testRootDir.toString()};
        Assert.assertThat((Object)shell.run(lsArgv), (Matcher)Is.is((Object)0));
    }
}

