/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.crypto.key.kms.server;

import com.codahale.metrics.JmxReporter;
import com.codahale.metrics.Meter;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.net.URI;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.crypto.key.CachingKeyProvider;
import org.apache.hadoop.crypto.key.KeyProvider;
import org.apache.hadoop.crypto.key.KeyProviderCryptoExtension;
import org.apache.hadoop.crypto.key.KeyProviderFactory;
import org.apache.hadoop.crypto.key.kms.server.EagerKeyGeneratorKeyProviderCryptoExtension;
import org.apache.hadoop.crypto.key.kms.server.KMSACLs;
import org.apache.hadoop.crypto.key.kms.server.KMSAudit;
import org.apache.hadoop.crypto.key.kms.server.KMSConfiguration;
import org.apache.hadoop.crypto.key.kms.server.KeyAuthorizationKeyProvider;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.util.VersionInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class KMSWebApp
implements ServletContextListener {
    private static final Logger LOG = LoggerFactory.getLogger(KMSWebApp.class);
    private static final String METRICS_PREFIX = "hadoop.kms.";
    private static final String ADMIN_CALLS_METER = "hadoop.kms.admin.calls.meter";
    private static final String KEY_CALLS_METER = "hadoop.kms.key.calls.meter";
    private static final String INVALID_CALLS_METER = "hadoop.kms.invalid.calls.meter";
    private static final String UNAUTHORIZED_CALLS_METER = "hadoop.kms.unauthorized.calls.meter";
    private static final String UNAUTHENTICATED_CALLS_METER = "hadoop.kms.unauthenticated.calls.meter";
    private static final String GENERATE_EEK_METER = "hadoop.kms.generate_eek.calls.meter";
    private static final String DECRYPT_EEK_METER = "hadoop.kms.decrypt_eek.calls.meter";
    private static final String REENCRYPT_EEK_METER = "hadoop.kms.reencrypt_eek.calls.meter";
    private static final String REENCRYPT_EEK_BATCH_METER = "hadoop.kms.reencrypt_eek_batch.calls.meter";
    private static MetricRegistry metricRegistry;
    private JmxReporter jmxReporter;
    private static Configuration kmsConf;
    private static KMSACLs kmsAcls;
    private static Meter adminCallsMeter;
    private static Meter keyCallsMeter;
    private static Meter unauthorizedCallsMeter;
    private static Meter unauthenticatedCallsMeter;
    private static Meter decryptEEKCallsMeter;
    private static Meter reencryptEEKCallsMeter;
    private static Meter reencryptEEKBatchCallsMeter;
    private static Meter generateEEKCallsMeter;
    private static Meter invalidCallsMeter;
    private static KMSAudit kmsAudit;
    private static KeyProviderCryptoExtension keyProviderCryptoExtension;

    public void contextInitialized(ServletContextEvent sce) {
        try {
            kmsConf = KMSConfiguration.getKMSConf();
            UserGroupInformation.setConfiguration((Configuration)kmsConf);
            LOG.info("-------------------------------------------------------------");
            LOG.info("  Java runtime version : {}", (Object)System.getProperty("java.runtime.version"));
            LOG.info("  User: {}", (Object)System.getProperty("user.name"));
            LOG.info("  KMS Hadoop Version: " + VersionInfo.getVersion());
            LOG.info("-------------------------------------------------------------");
            kmsAcls = new KMSACLs();
            kmsAcls.startReloader();
            metricRegistry = new MetricRegistry();
            this.jmxReporter = JmxReporter.forRegistry((MetricRegistry)metricRegistry).build();
            this.jmxReporter.start();
            generateEEKCallsMeter = (Meter)metricRegistry.register(GENERATE_EEK_METER, (Metric)new Meter());
            decryptEEKCallsMeter = (Meter)metricRegistry.register(DECRYPT_EEK_METER, (Metric)new Meter());
            reencryptEEKCallsMeter = (Meter)metricRegistry.register(REENCRYPT_EEK_METER, (Metric)new Meter());
            reencryptEEKBatchCallsMeter = (Meter)metricRegistry.register(REENCRYPT_EEK_BATCH_METER, (Metric)new Meter());
            adminCallsMeter = (Meter)metricRegistry.register(ADMIN_CALLS_METER, (Metric)new Meter());
            keyCallsMeter = (Meter)metricRegistry.register(KEY_CALLS_METER, (Metric)new Meter());
            invalidCallsMeter = (Meter)metricRegistry.register(INVALID_CALLS_METER, (Metric)new Meter());
            unauthorizedCallsMeter = (Meter)metricRegistry.register(UNAUTHORIZED_CALLS_METER, (Metric)new Meter());
            unauthenticatedCallsMeter = (Meter)metricRegistry.register(UNAUTHENTICATED_CALLS_METER, (Metric)new Meter());
            kmsAudit = new KMSAudit(kmsConf);
            String providerString = kmsConf.get("hadoop.kms.key.provider.uri");
            if (providerString == null) {
                throw new IllegalStateException("No KeyProvider has been defined");
            }
            KeyProvider keyProvider = KeyProviderFactory.get((URI)new URI(providerString), (Configuration)kmsConf);
            Preconditions.checkNotNull((Object)keyProvider, (Object)String.format("No KeyProvider has been initialized, please check whether %s '%s' is configured correctly in kms-site.xml.", "hadoop.kms.key.provider.uri", providerString));
            if (kmsConf.getBoolean("hadoop.kms.cache.enable", true)) {
                long keyTimeOutMillis = kmsConf.getLong("hadoop.kms.cache.timeout.ms", 600000L);
                long currKeyTimeOutMillis = kmsConf.getLong("hadoop.kms.current.key.cache.timeout.ms", 30000L);
                keyProvider = new CachingKeyProvider(keyProvider, keyTimeOutMillis, currKeyTimeOutMillis);
            }
            LOG.info("Initialized KeyProvider " + keyProvider);
            keyProviderCryptoExtension = KeyProviderCryptoExtension.createKeyProviderCryptoExtension((KeyProvider)keyProvider);
            keyProviderCryptoExtension = new EagerKeyGeneratorKeyProviderCryptoExtension(kmsConf, keyProviderCryptoExtension);
            if (kmsConf.getBoolean("hadoop.kms.key.authorization.enable", true)) {
                keyProviderCryptoExtension = new KeyAuthorizationKeyProvider(keyProviderCryptoExtension, kmsAcls);
            }
            LOG.info("Initialized KeyProviderCryptoExtension " + keyProviderCryptoExtension);
            int defaultBitlength = kmsConf.getInt("hadoop.security.key.default.bitlength", 128);
            LOG.info("Default key bitlength is {}", (Object)defaultBitlength);
            LOG.info("KMS Started");
        }
        catch (Throwable ex) {
            System.out.println();
            System.out.println("ERROR: Hadoop KMS could not be started");
            System.out.println();
            System.out.println("REASON: " + ex.toString());
            System.out.println();
            System.out.println("Stacktrace:");
            System.out.println("---------------------------------------------------");
            ex.printStackTrace(System.out);
            System.out.println("---------------------------------------------------");
            System.out.println();
            System.exit(1);
        }
    }

    public void contextDestroyed(ServletContextEvent sce) {
        try {
            keyProviderCryptoExtension.close();
        }
        catch (IOException ioe) {
            LOG.error("Error closing KeyProviderCryptoExtension", (Throwable)ioe);
        }
        kmsAudit.shutdown();
        kmsAcls.stopReloader();
        this.jmxReporter.stop();
        this.jmxReporter.close();
        metricRegistry = null;
        LOG.info("KMS Stopped");
    }

    public static Configuration getConfiguration() {
        return new Configuration(kmsConf);
    }

    public static KMSACLs getACLs() {
        return kmsAcls;
    }

    public static Meter getAdminCallsMeter() {
        return adminCallsMeter;
    }

    public static Meter getKeyCallsMeter() {
        return keyCallsMeter;
    }

    public static Meter getInvalidCallsMeter() {
        return invalidCallsMeter;
    }

    public static Meter getGenerateEEKCallsMeter() {
        return generateEEKCallsMeter;
    }

    public static Meter getDecryptEEKCallsMeter() {
        return decryptEEKCallsMeter;
    }

    public static Meter getReencryptEEKCallsMeter() {
        return reencryptEEKCallsMeter;
    }

    public static Meter getReencryptEEKBatchCallsMeter() {
        return reencryptEEKBatchCallsMeter;
    }

    public static Meter getUnauthorizedCallsMeter() {
        return unauthorizedCallsMeter;
    }

    public static Meter getUnauthenticatedCallsMeter() {
        return unauthenticatedCallsMeter;
    }

    public static KeyProviderCryptoExtension getKeyProvider() {
        return keyProviderCryptoExtension;
    }

    public static KMSAudit getKMSAudit() {
        return kmsAudit;
    }
}

