/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.router.webapp;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.IOException;
import java.security.Principal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.NotImplementedException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.authorize.AuthorizationException;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.hadoop.util.concurrent.HadoopExecutors;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ApplicationSubmissionContext;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.exceptions.YarnRuntimeException;
import org.apache.hadoop.yarn.server.federation.policies.FederationPolicyUtils;
import org.apache.hadoop.yarn.server.federation.policies.RouterPolicyFacade;
import org.apache.hadoop.yarn.server.federation.policies.exceptions.FederationPolicyInitializationException;
import org.apache.hadoop.yarn.server.federation.resolver.SubClusterResolver;
import org.apache.hadoop.yarn.server.federation.store.records.ApplicationHomeSubCluster;
import org.apache.hadoop.yarn.server.federation.store.records.SubClusterId;
import org.apache.hadoop.yarn.server.federation.store.records.SubClusterInfo;
import org.apache.hadoop.yarn.server.federation.utils.FederationStateStoreFacade;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.RMWebAppUtil;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.ActivitiesInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.AppActivitiesInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.AppAttemptsInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.AppInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.AppPriority;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.AppQueue;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.AppState;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.AppTimeoutInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.AppTimeoutsInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.ApplicationStatisticsInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.ApplicationSubmissionContextInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.AppsInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.ClusterInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.ClusterMetricsInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.DelegationToken;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.LabelsToNodesInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.NodeInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.NodeLabelsInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.NodeToLabelsEntryList;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.NodeToLabelsInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.NodesInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.ReservationDeleteRequestInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.ReservationSubmissionRequestInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.ReservationUpdateRequestInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.SchedulerTypeInfo;
import org.apache.hadoop.yarn.server.router.RouterMetrics;
import org.apache.hadoop.yarn.server.router.RouterServerUtil;
import org.apache.hadoop.yarn.server.router.webapp.AbstractRESTRequestInterceptor;
import org.apache.hadoop.yarn.server.router.webapp.DefaultRequestInterceptorREST;
import org.apache.hadoop.yarn.server.router.webapp.RESTRequestInterceptor;
import org.apache.hadoop.yarn.server.router.webapp.RouterWebServiceUtil;
import org.apache.hadoop.yarn.server.webapp.dao.AppAttemptInfo;
import org.apache.hadoop.yarn.server.webapp.dao.ContainerInfo;
import org.apache.hadoop.yarn.server.webapp.dao.ContainersInfo;
import org.apache.hadoop.yarn.util.Clock;
import org.apache.hadoop.yarn.util.MonotonicClock;
import org.apache.hadoop.yarn.webapp.NotFoundException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FederationInterceptorREST
extends AbstractRESTRequestInterceptor {
    private static final Logger LOG = LoggerFactory.getLogger(FederationInterceptorREST.class);
    private int numSubmitRetries;
    private FederationStateStoreFacade federationFacade;
    private Random rand;
    private RouterPolicyFacade policyFacade;
    private RouterMetrics routerMetrics;
    private final Clock clock = new MonotonicClock();
    private boolean returnPartialReport;
    private Map<SubClusterId, DefaultRequestInterceptorREST> interceptors;
    private ExecutorService threadpool;

    @Override
    public void init(String user) {
        this.federationFacade = FederationStateStoreFacade.getInstance();
        this.rand = new Random();
        Configuration conf = this.getConf();
        try {
            SubClusterResolver subClusterResolver = this.federationFacade.getSubClusterResolver();
            this.policyFacade = new RouterPolicyFacade(conf, this.federationFacade, subClusterResolver, null);
        }
        catch (FederationPolicyInitializationException e) {
            throw new YarnRuntimeException((Throwable)e);
        }
        this.numSubmitRetries = conf.getInt("yarn.router.submit.retry", 3);
        this.interceptors = new HashMap<SubClusterId, DefaultRequestInterceptorREST>();
        this.routerMetrics = RouterMetrics.getMetrics();
        this.threadpool = HadoopExecutors.newCachedThreadPool((ThreadFactory)new ThreadFactoryBuilder().setNameFormat("FederationInterceptorREST #%d").build());
        this.returnPartialReport = conf.getBoolean("yarn.router.webapp.partial-result.enabled", false);
    }

    private SubClusterId getRandomActiveSubCluster(Map<SubClusterId, SubClusterInfo> activeSubclusters, List<SubClusterId> blackListSubClusters) throws YarnException {
        if (activeSubclusters == null || activeSubclusters.size() < 1) {
            RouterServerUtil.logAndThrowException("No active SubCluster available to submit the request.", null);
        }
        ArrayList<SubClusterId> list = new ArrayList<SubClusterId>(activeSubclusters.keySet());
        FederationPolicyUtils.validateSubClusterAvailability(list, blackListSubClusters);
        if (blackListSubClusters != null) {
            for (SubClusterId scId : blackListSubClusters) {
                list.remove(scId);
            }
        }
        return (SubClusterId)list.get(this.rand.nextInt(list.size()));
    }

    @VisibleForTesting
    protected DefaultRequestInterceptorREST getInterceptorForSubCluster(SubClusterId subClusterId) {
        if (this.interceptors.containsKey(subClusterId)) {
            return this.interceptors.get(subClusterId);
        }
        LOG.error("The interceptor for SubCluster {} does not exist in the cache.", (Object)subClusterId);
        return null;
    }

    private DefaultRequestInterceptorREST createInterceptorForSubCluster(SubClusterId subClusterId, String webAppAddress) {
        Configuration conf = this.getConf();
        String interceptorClassName = conf.get("yarn.router.webapp.default-interceptor-class", "org.apache.hadoop.yarn.server.router.webapp.DefaultRequestInterceptorREST");
        DefaultRequestInterceptorREST interceptorInstance = null;
        try {
            Class interceptorClass = conf.getClassByName(interceptorClassName);
            if (!DefaultRequestInterceptorREST.class.isAssignableFrom(interceptorClass)) {
                throw new YarnRuntimeException("Class: " + interceptorClassName + " not instance of " + DefaultRequestInterceptorREST.class.getCanonicalName());
            }
            interceptorInstance = (DefaultRequestInterceptorREST)ReflectionUtils.newInstance((Class)interceptorClass, (Configuration)conf);
        }
        catch (ClassNotFoundException e) {
            throw new YarnRuntimeException("Could not instantiate ApplicationMasterRequestInterceptor: " + interceptorClassName, (Throwable)e);
        }
        interceptorInstance.setWebAppAddress("http://" + webAppAddress);
        interceptorInstance.setSubClusterId(subClusterId);
        this.interceptors.put(subClusterId, interceptorInstance);
        return interceptorInstance;
    }

    @VisibleForTesting
    protected DefaultRequestInterceptorREST getOrCreateInterceptorForSubCluster(SubClusterId subClusterId, String webAppAddress) {
        DefaultRequestInterceptorREST interceptor = this.getInterceptorForSubCluster(subClusterId);
        if (interceptor == null) {
            interceptor = this.createInterceptorForSubCluster(subClusterId, webAppAddress);
        }
        return interceptor;
    }

    public Response createNewApplication(HttpServletRequest hsr) throws AuthorizationException, IOException, InterruptedException {
        Map subClustersActive;
        long startTime = this.clock.getTime();
        try {
            subClustersActive = this.federationFacade.getSubClusters(true);
        }
        catch (YarnException e) {
            this.routerMetrics.incrAppsFailedCreated();
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)e.getLocalizedMessage()).build();
        }
        ArrayList<SubClusterId> blacklist = new ArrayList<SubClusterId>();
        for (int i = 0; i < this.numSubmitRetries; ++i) {
            SubClusterId subClusterId;
            try {
                subClusterId = this.getRandomActiveSubCluster(subClustersActive, blacklist);
            }
            catch (YarnException e) {
                this.routerMetrics.incrAppsFailedCreated();
                return Response.status((Response.Status)Response.Status.SERVICE_UNAVAILABLE).entity((Object)e.getLocalizedMessage()).build();
            }
            LOG.debug("getNewApplication try #{} on SubCluster {}", (Object)i, (Object)subClusterId);
            DefaultRequestInterceptorREST interceptor = this.getOrCreateInterceptorForSubCluster(subClusterId, ((SubClusterInfo)subClustersActive.get(subClusterId)).getRMWebServiceAddress());
            Response response = null;
            try {
                response = interceptor.createNewApplication(hsr);
            }
            catch (Exception e) {
                LOG.warn("Unable to create a new ApplicationId in SubCluster {}", (Object)subClusterId.getId(), (Object)e);
            }
            if (response != null && response.getStatus() == 200) {
                long stopTime = this.clock.getTime();
                this.routerMetrics.succeededAppsCreated(stopTime - startTime);
                return response;
            }
            blacklist.add(subClusterId);
        }
        String errMsg = "Fail to create a new application.";
        LOG.error(errMsg);
        this.routerMetrics.incrAppsFailedCreated();
        return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)errMsg).build();
    }

    public Response submitApplication(ApplicationSubmissionContextInfo newApp, HttpServletRequest hsr) throws AuthorizationException, IOException, InterruptedException {
        long startTime = this.clock.getTime();
        if (newApp == null || newApp.getApplicationId() == null) {
            this.routerMetrics.incrAppsFailedSubmitted();
            String errMsg = "Missing ApplicationSubmissionContextInfo or applicationSubmissionContex information.";
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)errMsg).build();
        }
        ApplicationId applicationId = null;
        try {
            applicationId = ApplicationId.fromString((String)newApp.getApplicationId());
        }
        catch (IllegalArgumentException e) {
            this.routerMetrics.incrAppsFailedSubmitted();
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)e.getLocalizedMessage()).build();
        }
        ArrayList<SubClusterId> blacklist = new ArrayList<SubClusterId>();
        for (int i = 0; i < this.numSubmitRetries; ++i) {
            SubClusterInfo subClusterInfo;
            String errMsg;
            ApplicationSubmissionContext context = RMWebAppUtil.createAppSubmissionContext((ApplicationSubmissionContextInfo)newApp, (Configuration)this.getConf());
            SubClusterId subClusterId = null;
            try {
                subClusterId = this.policyFacade.getHomeSubcluster(context, blacklist);
            }
            catch (YarnException e) {
                this.routerMetrics.incrAppsFailedSubmitted();
                return Response.status((Response.Status)Response.Status.SERVICE_UNAVAILABLE).entity((Object)e.getLocalizedMessage()).build();
            }
            LOG.info("submitApplication appId {} try #{} on SubCluster {}", new Object[]{applicationId, i, subClusterId});
            ApplicationHomeSubCluster appHomeSubCluster = ApplicationHomeSubCluster.newInstance((ApplicationId)applicationId, (SubClusterId)subClusterId);
            if (i == 0) {
                try {
                    subClusterId = this.federationFacade.addApplicationHomeSubCluster(appHomeSubCluster);
                }
                catch (YarnException e) {
                    this.routerMetrics.incrAppsFailedSubmitted();
                    errMsg = "Unable to insert the ApplicationId " + applicationId + " into the FederationStateStore";
                    return Response.status((Response.Status)Response.Status.SERVICE_UNAVAILABLE).entity((Object)(errMsg + " " + e.getLocalizedMessage())).build();
                }
            }
            try {
                this.federationFacade.updateApplicationHomeSubCluster(appHomeSubCluster);
            }
            catch (YarnException e) {
                SubClusterId subClusterIdInStateStore;
                errMsg = "Unable to update the ApplicationId " + applicationId + " into the FederationStateStore";
                try {
                    subClusterIdInStateStore = this.federationFacade.getApplicationHomeSubCluster(applicationId);
                }
                catch (YarnException e1) {
                    this.routerMetrics.incrAppsFailedSubmitted();
                    return Response.status((Response.Status)Response.Status.SERVICE_UNAVAILABLE).entity((Object)e1.getLocalizedMessage()).build();
                }
                if (subClusterId == subClusterIdInStateStore) {
                    LOG.info("Application {} already submitted on SubCluster {}", (Object)applicationId, (Object)subClusterId);
                }
                this.routerMetrics.incrAppsFailedSubmitted();
                return Response.status((Response.Status)Response.Status.SERVICE_UNAVAILABLE).entity((Object)errMsg).build();
            }
            try {
                subClusterInfo = this.federationFacade.getSubCluster(subClusterId);
            }
            catch (YarnException e) {
                this.routerMetrics.incrAppsFailedSubmitted();
                return Response.status((Response.Status)Response.Status.SERVICE_UNAVAILABLE).entity((Object)e.getLocalizedMessage()).build();
            }
            Response response = null;
            try {
                response = this.getOrCreateInterceptorForSubCluster(subClusterId, subClusterInfo.getRMWebServiceAddress()).submitApplication(newApp, hsr);
            }
            catch (Exception e) {
                LOG.warn("Unable to submit the application {} to SubCluster {}", new Object[]{applicationId, subClusterId.getId(), e});
            }
            if (response != null && response.getStatus() == 202) {
                LOG.info("Application {} with appId {} submitted on {}", new Object[]{context.getApplicationName(), applicationId, subClusterId});
                long stopTime = this.clock.getTime();
                this.routerMetrics.succeededAppsSubmitted(stopTime - startTime);
                return response;
            }
            blacklist.add(subClusterId);
        }
        this.routerMetrics.incrAppsFailedSubmitted();
        String errMsg = "Application " + newApp.getApplicationName() + " with appId " + applicationId + " failed to be submitted.";
        LOG.error(errMsg);
        return Response.status((Response.Status)Response.Status.SERVICE_UNAVAILABLE).entity((Object)errMsg).build();
    }

    public AppInfo getApp(HttpServletRequest hsr, String appId, Set<String> unselectedFields) {
        long startTime = this.clock.getTime();
        ApplicationId applicationId = null;
        try {
            applicationId = ApplicationId.fromString((String)appId);
        }
        catch (IllegalArgumentException e) {
            this.routerMetrics.incrAppsFailedRetrieved();
            return null;
        }
        SubClusterInfo subClusterInfo = null;
        SubClusterId subClusterId = null;
        try {
            subClusterId = this.federationFacade.getApplicationHomeSubCluster(applicationId);
            if (subClusterId == null) {
                this.routerMetrics.incrAppsFailedRetrieved();
                return null;
            }
            subClusterInfo = this.federationFacade.getSubCluster(subClusterId);
        }
        catch (YarnException e) {
            this.routerMetrics.incrAppsFailedRetrieved();
            return null;
        }
        DefaultRequestInterceptorREST interceptor = this.getOrCreateInterceptorForSubCluster(subClusterId, subClusterInfo.getRMWebServiceAddress());
        AppInfo response = interceptor.getApp(hsr, appId, unselectedFields);
        long stopTime = this.clock.getTime();
        this.routerMetrics.succeededAppsRetrieved(stopTime - startTime);
        return response;
    }

    public Response updateAppState(AppState targetState, HttpServletRequest hsr, String appId) throws AuthorizationException, YarnException, InterruptedException, IOException {
        long startTime = this.clock.getTime();
        ApplicationId applicationId = null;
        try {
            applicationId = ApplicationId.fromString((String)appId);
        }
        catch (IllegalArgumentException e) {
            this.routerMetrics.incrAppsFailedKilled();
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)e.getLocalizedMessage()).build();
        }
        SubClusterInfo subClusterInfo = null;
        SubClusterId subClusterId = null;
        try {
            subClusterId = this.federationFacade.getApplicationHomeSubCluster(applicationId);
            subClusterInfo = this.federationFacade.getSubCluster(subClusterId);
        }
        catch (YarnException e) {
            this.routerMetrics.incrAppsFailedKilled();
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)e.getLocalizedMessage()).build();
        }
        Response response = this.getOrCreateInterceptorForSubCluster(subClusterId, subClusterInfo.getRMWebServiceAddress()).updateAppState(targetState, hsr, appId);
        long stopTime = this.clock.getTime();
        this.routerMetrics.succeededAppsRetrieved(stopTime - startTime);
        return response;
    }

    public AppsInfo getApps(HttpServletRequest hsr, String stateQuery, Set<String> statesQuery, String finalStatusQuery, String userQuery, String queueQuery, String count, String startedBegin, String startedEnd, String finishBegin, String finishEnd, Set<String> applicationTypes, Set<String> applicationTags, Set<String> unselectedFields) {
        AppsInfo apps = new AppsInfo();
        long startTime = this.clock.getTime();
        Map subClustersActive = null;
        try {
            subClustersActive = this.federationFacade.getSubClusters(true);
        }
        catch (YarnException e) {
            this.routerMetrics.incrMultipleAppsFailedRetrieved();
            return null;
        }
        ExecutorCompletionService<AppsInfo> compSvc = new ExecutorCompletionService<AppsInfo>(this.threadpool);
        HttpServletRequestWrapper hsrCopy = this.clone(hsr);
        for (final SubClusterInfo info : subClustersActive.values()) {
            compSvc.submit(new Callable<AppsInfo>((HttpServletRequest)hsrCopy, stateQuery, statesQuery, finalStatusQuery, userQuery, queueQuery, count, startedBegin, startedEnd, finishBegin, finishEnd, applicationTypes, applicationTags, unselectedFields){
                final /* synthetic */ HttpServletRequest val$hsrCopy;
                final /* synthetic */ String val$stateQuery;
                final /* synthetic */ Set val$statesQuery;
                final /* synthetic */ String val$finalStatusQuery;
                final /* synthetic */ String val$userQuery;
                final /* synthetic */ String val$queueQuery;
                final /* synthetic */ String val$count;
                final /* synthetic */ String val$startedBegin;
                final /* synthetic */ String val$startedEnd;
                final /* synthetic */ String val$finishBegin;
                final /* synthetic */ String val$finishEnd;
                final /* synthetic */ Set val$applicationTypes;
                final /* synthetic */ Set val$applicationTags;
                final /* synthetic */ Set val$unselectedFields;
                {
                    this.val$hsrCopy = httpServletRequest;
                    this.val$stateQuery = string;
                    this.val$statesQuery = set;
                    this.val$finalStatusQuery = string2;
                    this.val$userQuery = string3;
                    this.val$queueQuery = string4;
                    this.val$count = string5;
                    this.val$startedBegin = string6;
                    this.val$startedEnd = string7;
                    this.val$finishBegin = string8;
                    this.val$finishEnd = string9;
                    this.val$applicationTypes = set2;
                    this.val$applicationTags = set3;
                    this.val$unselectedFields = set4;
                }

                @Override
                public AppsInfo call() {
                    DefaultRequestInterceptorREST interceptor = FederationInterceptorREST.this.getOrCreateInterceptorForSubCluster(info.getSubClusterId(), info.getRMWebServiceAddress());
                    AppsInfo rmApps = interceptor.getApps(this.val$hsrCopy, this.val$stateQuery, this.val$statesQuery, this.val$finalStatusQuery, this.val$userQuery, this.val$queueQuery, this.val$count, this.val$startedBegin, this.val$startedEnd, this.val$finishBegin, this.val$finishEnd, this.val$applicationTypes, this.val$applicationTags, this.val$unselectedFields);
                    if (rmApps == null) {
                        FederationInterceptorREST.this.routerMetrics.incrMultipleAppsFailedRetrieved();
                        LOG.error("Subcluster {} failed to return appReport.", (Object)info.getSubClusterId());
                        return null;
                    }
                    return rmApps;
                }
            });
        }
        for (int i = 0; i < subClustersActive.size(); ++i) {
            try {
                Future future = compSvc.take();
                AppsInfo appsResponse = (AppsInfo)future.get();
                long stopTime = this.clock.getTime();
                this.routerMetrics.succeededMultipleAppsRetrieved(stopTime - startTime);
                if (appsResponse == null) continue;
                apps.addAll(appsResponse.getApps());
                continue;
            }
            catch (Throwable e) {
                this.routerMetrics.incrMultipleAppsFailedRetrieved();
                LOG.warn("Failed to get application report", e);
            }
        }
        if (apps.getApps().isEmpty()) {
            return null;
        }
        return RouterWebServiceUtil.mergeAppsInfo(apps.getApps(), this.returnPartialReport);
    }

    private HttpServletRequestWrapper clone(HttpServletRequest hsr) {
        if (hsr == null) {
            return null;
        }
        final Map parameterMap = hsr.getParameterMap();
        final String pathInfo = hsr.getPathInfo();
        final String user = hsr.getRemoteUser();
        final Principal principal = hsr.getUserPrincipal();
        final String mediaType = RouterWebServiceUtil.getMediaTypeFromHttpServletRequest(hsr, AppsInfo.class);
        return new HttpServletRequestWrapper(hsr){

            public Map<String, String[]> getParameterMap() {
                return parameterMap;
            }

            public String getPathInfo() {
                return pathInfo;
            }

            public String getRemoteUser() {
                return user;
            }

            public Principal getUserPrincipal() {
                return principal;
            }

            public String getHeader(String value) {
                if (value.equals("Accept")) {
                    return mediaType;
                }
                return null;
            }
        };
    }

    public NodeInfo getNode(final String nodeId) {
        Map subClustersActive = null;
        try {
            subClustersActive = this.federationFacade.getSubClusters(true);
        }
        catch (YarnException e) {
            throw new NotFoundException(e.getMessage());
        }
        if (subClustersActive.isEmpty()) {
            throw new NotFoundException("No active SubCluster available to submit the request.");
        }
        ExecutorCompletionService<NodeInfo> compSvc = new ExecutorCompletionService<NodeInfo>(this.threadpool);
        for (final SubClusterInfo info : subClustersActive.values()) {
            compSvc.submit(new Callable<NodeInfo>(){

                @Override
                public NodeInfo call() {
                    DefaultRequestInterceptorREST interceptor = FederationInterceptorREST.this.getOrCreateInterceptorForSubCluster(info.getSubClusterId(), info.getRMWebServiceAddress());
                    try {
                        NodeInfo nodeInfo = interceptor.getNode(nodeId);
                        return nodeInfo;
                    }
                    catch (Exception e) {
                        LOG.error("Subcluster {} failed to return nodeInfo.", (Object)info.getSubClusterId());
                        return null;
                    }
                }
            });
        }
        NodeInfo nodeInfo = null;
        for (int i = 0; i < subClustersActive.size(); ++i) {
            try {
                Future future = compSvc.take();
                NodeInfo nodeResponse = (NodeInfo)future.get();
                if (nodeResponse == null || nodeInfo != null && nodeInfo.getLastHealthUpdate() >= nodeResponse.getLastHealthUpdate()) continue;
                nodeInfo = nodeResponse;
                continue;
            }
            catch (Throwable e) {
                LOG.warn("Failed to get node report ", e);
            }
        }
        if (nodeInfo == null) {
            throw new NotFoundException("nodeId, " + nodeId + ", is not found");
        }
        return nodeInfo;
    }

    public NodesInfo getNodes(final String states) {
        NodesInfo nodes = new NodesInfo();
        Map subClustersActive = null;
        try {
            subClustersActive = this.federationFacade.getSubClusters(true);
        }
        catch (YarnException e) {
            LOG.error("Cannot get nodes: {}", (Object)e.getMessage());
            return new NodesInfo();
        }
        ExecutorCompletionService<NodesInfo> compSvc = new ExecutorCompletionService<NodesInfo>(this.threadpool);
        for (final SubClusterInfo info : subClustersActive.values()) {
            compSvc.submit(new Callable<NodesInfo>(){

                @Override
                public NodesInfo call() {
                    DefaultRequestInterceptorREST interceptor = FederationInterceptorREST.this.getOrCreateInterceptorForSubCluster(info.getSubClusterId(), info.getRMWebServiceAddress());
                    try {
                        NodesInfo nodesInfo = interceptor.getNodes(states);
                        return nodesInfo;
                    }
                    catch (Exception e) {
                        LOG.error("Subcluster {} failed to return nodesInfo.", (Object)info.getSubClusterId());
                        return null;
                    }
                }
            });
        }
        for (int i = 0; i < subClustersActive.size(); ++i) {
            try {
                Future future = compSvc.take();
                NodesInfo nodesResponse = (NodesInfo)future.get();
                if (nodesResponse == null) continue;
                nodes.addAll(nodesResponse.getNodes());
                continue;
            }
            catch (Throwable e) {
                LOG.warn("Failed to get nodes report ", e);
            }
        }
        return RouterWebServiceUtil.deleteDuplicateNodesInfo(nodes.getNodes());
    }

    public ClusterMetricsInfo getClusterMetricsInfo() {
        ClusterMetricsInfo metrics = new ClusterMetricsInfo();
        Map subClustersActive = null;
        try {
            subClustersActive = this.federationFacade.getSubClusters(true);
        }
        catch (YarnException e) {
            LOG.error(e.getLocalizedMessage());
            return metrics;
        }
        ExecutorCompletionService<ClusterMetricsInfo> compSvc = new ExecutorCompletionService<ClusterMetricsInfo>(this.threadpool);
        for (final SubClusterInfo info : subClustersActive.values()) {
            compSvc.submit(new Callable<ClusterMetricsInfo>(){

                @Override
                public ClusterMetricsInfo call() {
                    DefaultRequestInterceptorREST interceptor = FederationInterceptorREST.this.getOrCreateInterceptorForSubCluster(info.getSubClusterId(), info.getRMWebServiceAddress());
                    try {
                        ClusterMetricsInfo metrics = interceptor.getClusterMetricsInfo();
                        return metrics;
                    }
                    catch (Exception e) {
                        LOG.error("Subcluster {} failed to return Cluster Metrics.", (Object)info.getSubClusterId());
                        return null;
                    }
                }
            });
        }
        for (int i = 0; i < subClustersActive.size(); ++i) {
            try {
                Future future = compSvc.take();
                ClusterMetricsInfo metricsResponse = (ClusterMetricsInfo)future.get();
                if (metricsResponse == null) continue;
                RouterWebServiceUtil.mergeMetrics(metrics, metricsResponse);
                continue;
            }
            catch (Throwable e) {
                LOG.warn("Failed to get nodes report ", e);
            }
        }
        return metrics;
    }

    public ClusterInfo get() {
        return this.getClusterInfo();
    }

    public ClusterInfo getClusterInfo() {
        throw new NotImplementedException();
    }

    public SchedulerTypeInfo getSchedulerInfo() {
        throw new NotImplementedException();
    }

    public String dumpSchedulerLogs(String time, HttpServletRequest hsr) throws IOException {
        throw new NotImplementedException();
    }

    public ActivitiesInfo getActivities(HttpServletRequest hsr, String nodeId) {
        throw new NotImplementedException();
    }

    public AppActivitiesInfo getAppActivities(HttpServletRequest hsr, String appId, String time) {
        throw new NotImplementedException();
    }

    public ApplicationStatisticsInfo getAppStatistics(HttpServletRequest hsr, Set<String> stateQueries, Set<String> typeQueries) {
        throw new NotImplementedException();
    }

    public AppState getAppState(HttpServletRequest hsr, String appId) throws AuthorizationException {
        throw new NotImplementedException();
    }

    public NodeToLabelsInfo getNodeToLabels(HttpServletRequest hsr) throws IOException {
        throw new NotImplementedException();
    }

    public LabelsToNodesInfo getLabelsToNodes(Set<String> labels) throws IOException {
        throw new NotImplementedException();
    }

    public Response replaceLabelsOnNodes(NodeToLabelsEntryList newNodeToLabels, HttpServletRequest hsr) throws IOException {
        throw new NotImplementedException();
    }

    public Response replaceLabelsOnNode(Set<String> newNodeLabelsName, HttpServletRequest hsr, String nodeId) throws Exception {
        throw new NotImplementedException();
    }

    public NodeLabelsInfo getClusterNodeLabels(HttpServletRequest hsr) throws IOException {
        throw new NotImplementedException();
    }

    public Response addToClusterNodeLabels(NodeLabelsInfo newNodeLabels, HttpServletRequest hsr) throws Exception {
        throw new NotImplementedException();
    }

    public Response removeFromCluserNodeLabels(Set<String> oldNodeLabels, HttpServletRequest hsr) throws Exception {
        throw new NotImplementedException();
    }

    public NodeLabelsInfo getLabelsOnNode(HttpServletRequest hsr, String nodeId) throws IOException {
        throw new NotImplementedException();
    }

    public AppPriority getAppPriority(HttpServletRequest hsr, String appId) throws AuthorizationException {
        throw new NotImplementedException();
    }

    public Response updateApplicationPriority(AppPriority targetPriority, HttpServletRequest hsr, String appId) throws AuthorizationException, YarnException, InterruptedException, IOException {
        throw new NotImplementedException();
    }

    public AppQueue getAppQueue(HttpServletRequest hsr, String appId) throws AuthorizationException {
        throw new NotImplementedException();
    }

    public Response updateAppQueue(AppQueue targetQueue, HttpServletRequest hsr, String appId) throws AuthorizationException, YarnException, InterruptedException, IOException {
        throw new NotImplementedException();
    }

    public Response postDelegationToken(DelegationToken tokenData, HttpServletRequest hsr) throws AuthorizationException, IOException, InterruptedException, Exception {
        throw new NotImplementedException();
    }

    public Response postDelegationTokenExpiration(HttpServletRequest hsr) throws AuthorizationException, IOException, InterruptedException, Exception {
        throw new NotImplementedException();
    }

    public Response cancelDelegationToken(HttpServletRequest hsr) throws AuthorizationException, IOException, InterruptedException, Exception {
        throw new NotImplementedException();
    }

    public Response createNewReservation(HttpServletRequest hsr) throws AuthorizationException, IOException, InterruptedException {
        throw new NotImplementedException();
    }

    public Response submitReservation(ReservationSubmissionRequestInfo resContext, HttpServletRequest hsr) throws AuthorizationException, IOException, InterruptedException {
        throw new NotImplementedException();
    }

    public Response updateReservation(ReservationUpdateRequestInfo resContext, HttpServletRequest hsr) throws AuthorizationException, IOException, InterruptedException {
        throw new NotImplementedException();
    }

    public Response deleteReservation(ReservationDeleteRequestInfo resContext, HttpServletRequest hsr) throws AuthorizationException, IOException, InterruptedException {
        throw new NotImplementedException();
    }

    public Response listReservation(String queue, String reservationId, long startTime, long endTime, boolean includeResourceAllocations, HttpServletRequest hsr) throws Exception {
        throw new NotImplementedException();
    }

    public AppTimeoutInfo getAppTimeout(HttpServletRequest hsr, String appId, String type) throws AuthorizationException {
        throw new NotImplementedException();
    }

    public AppTimeoutsInfo getAppTimeouts(HttpServletRequest hsr, String appId) throws AuthorizationException {
        throw new NotImplementedException();
    }

    public Response updateApplicationTimeout(AppTimeoutInfo appTimeout, HttpServletRequest hsr, String appId) throws AuthorizationException, YarnException, InterruptedException, IOException {
        throw new NotImplementedException();
    }

    public AppAttemptsInfo getAppAttempts(HttpServletRequest hsr, String appId) {
        throw new NotImplementedException();
    }

    @Override
    public AppAttemptInfo getAppAttempt(HttpServletRequest req, HttpServletResponse res, String appId, String appAttemptId) {
        throw new NotImplementedException();
    }

    @Override
    public ContainersInfo getContainers(HttpServletRequest req, HttpServletResponse res, String appId, String appAttemptId) {
        throw new NotImplementedException();
    }

    @Override
    public ContainerInfo getContainer(HttpServletRequest req, HttpServletResponse res, String appId, String appAttemptId, String containerId) {
        throw new NotImplementedException();
    }

    @Override
    public void setNextInterceptor(RESTRequestInterceptor next) {
        throw new YarnRuntimeException("setNextInterceptor is being called on FederationInterceptorREST, which should be the last one in the chain. Check if the interceptor pipeline configuration is correct");
    }

    @Override
    public void shutdown() {
        if (this.threadpool != null) {
            this.threadpool.shutdown();
        }
    }
}

