/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.router.webapp;

import java.io.IOException;
import java.util.HashMap;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.core.Response;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.authorize.AuthorizationException;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.exceptions.YarnRuntimeException;
import org.apache.hadoop.yarn.server.federation.store.records.SubClusterId;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.ActivitiesInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.AppActivitiesInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.AppAttemptsInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.AppInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.AppPriority;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.AppQueue;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.AppState;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.AppTimeoutInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.AppTimeoutsInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.ApplicationStatisticsInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.ApplicationSubmissionContextInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.AppsInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.ClusterInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.ClusterMetricsInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.DelegationToken;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.LabelsToNodesInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.NodeInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.NodeLabelsInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.NodeToLabelsEntryList;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.NodeToLabelsInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.NodesInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.ReservationDeleteRequestInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.ReservationSubmissionRequestInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.ReservationUpdateRequestInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.SchedulerTypeInfo;
import org.apache.hadoop.yarn.server.router.webapp.AbstractRESTRequestInterceptor;
import org.apache.hadoop.yarn.server.router.webapp.HTTPMethods;
import org.apache.hadoop.yarn.server.router.webapp.RESTRequestInterceptor;
import org.apache.hadoop.yarn.server.router.webapp.RouterWebServiceUtil;
import org.apache.hadoop.yarn.server.webapp.dao.AppAttemptInfo;
import org.apache.hadoop.yarn.server.webapp.dao.ContainerInfo;
import org.apache.hadoop.yarn.server.webapp.dao.ContainersInfo;
import org.apache.hadoop.yarn.webapp.util.WebAppUtils;

public class DefaultRequestInterceptorREST
extends AbstractRESTRequestInterceptor {
    private String webAppAddress;
    private SubClusterId subClusterId = null;

    public void setWebAppAddress(String webAppAddress) {
        this.webAppAddress = webAppAddress;
    }

    protected void setSubClusterId(SubClusterId scId) {
        this.subClusterId = scId;
    }

    protected SubClusterId getSubClusterId() {
        return this.subClusterId;
    }

    @Override
    public void init(String user) {
        this.webAppAddress = WebAppUtils.getRMWebAppURLWithScheme((Configuration)this.getConf());
    }

    public ClusterInfo get() {
        return this.getClusterInfo();
    }

    public ClusterInfo getClusterInfo() {
        return RouterWebServiceUtil.genericForward(this.webAppAddress, null, ClusterInfo.class, HTTPMethods.GET, "/ws/v1/cluster/info", null, null);
    }

    public ClusterMetricsInfo getClusterMetricsInfo() {
        return RouterWebServiceUtil.genericForward(this.webAppAddress, null, ClusterMetricsInfo.class, HTTPMethods.GET, "/ws/v1/cluster/metrics", null, null);
    }

    public SchedulerTypeInfo getSchedulerInfo() {
        return RouterWebServiceUtil.genericForward(this.webAppAddress, null, SchedulerTypeInfo.class, HTTPMethods.GET, "/ws/v1/cluster/scheduler", null, null);
    }

    public String dumpSchedulerLogs(String time, HttpServletRequest hsr) throws IOException {
        return RouterWebServiceUtil.genericForward(this.webAppAddress, null, String.class, HTTPMethods.GET, "/ws/v1/cluster/scheduler/logs", null, null);
    }

    public NodesInfo getNodes(String states) {
        HashMap<String, String[]> additionalParam = new HashMap<String, String[]>();
        if (states != null && !states.isEmpty()) {
            additionalParam.put("states", new String[]{states});
        }
        return RouterWebServiceUtil.genericForward(this.webAppAddress, null, NodesInfo.class, HTTPMethods.GET, "/ws/v1/cluster/nodes", null, additionalParam);
    }

    public NodeInfo getNode(String nodeId) {
        return RouterWebServiceUtil.genericForward(this.webAppAddress, null, NodeInfo.class, HTTPMethods.GET, "/ws/v1/cluster/nodes/" + nodeId, null, null);
    }

    public AppsInfo getApps(HttpServletRequest hsr, String stateQuery, Set<String> statesQuery, String finalStatusQuery, String userQuery, String queueQuery, String count, String startedBegin, String startedEnd, String finishBegin, String finishEnd, Set<String> applicationTypes, Set<String> applicationTags, Set<String> unselectedFields) {
        return RouterWebServiceUtil.genericForward(this.webAppAddress, hsr, AppsInfo.class, HTTPMethods.GET, "/ws/v1/cluster/apps", null, null);
    }

    public ActivitiesInfo getActivities(HttpServletRequest hsr, String nodeId) {
        return RouterWebServiceUtil.genericForward(this.webAppAddress, hsr, ActivitiesInfo.class, HTTPMethods.GET, "/ws/v1/cluster/scheduler/activities", null, null);
    }

    public AppActivitiesInfo getAppActivities(HttpServletRequest hsr, String appId, String time) {
        return RouterWebServiceUtil.genericForward(this.webAppAddress, hsr, AppActivitiesInfo.class, HTTPMethods.GET, "/ws/v1/cluster/scheduler/app-activities", null, null);
    }

    public ApplicationStatisticsInfo getAppStatistics(HttpServletRequest hsr, Set<String> stateQueries, Set<String> typeQueries) {
        return RouterWebServiceUtil.genericForward(this.webAppAddress, hsr, ApplicationStatisticsInfo.class, HTTPMethods.GET, "/ws/v1/cluster/appstatistics", null, null);
    }

    public AppInfo getApp(HttpServletRequest hsr, String appId, Set<String> unselectedFields) {
        return RouterWebServiceUtil.genericForward(this.webAppAddress, hsr, AppInfo.class, HTTPMethods.GET, "/ws/v1/cluster/apps/" + appId, null, null);
    }

    public AppState getAppState(HttpServletRequest hsr, String appId) throws AuthorizationException {
        return RouterWebServiceUtil.genericForward(this.webAppAddress, hsr, AppState.class, HTTPMethods.GET, "/ws/v1/cluster/apps/" + appId + "/" + "state", null, null);
    }

    public Response updateAppState(AppState targetState, HttpServletRequest hsr, String appId) throws AuthorizationException, YarnException, InterruptedException, IOException {
        return RouterWebServiceUtil.genericForward(this.webAppAddress, hsr, Response.class, HTTPMethods.PUT, "/ws/v1/cluster/apps/" + appId + "/" + "state", targetState, null);
    }

    public NodeToLabelsInfo getNodeToLabels(HttpServletRequest hsr) throws IOException {
        return RouterWebServiceUtil.genericForward(this.webAppAddress, hsr, NodeToLabelsInfo.class, HTTPMethods.GET, "/ws/v1/cluster/get-node-to-labels", null, null);
    }

    public LabelsToNodesInfo getLabelsToNodes(Set<String> labels) throws IOException {
        HashMap<String, String[]> additionalParam = new HashMap<String, String[]>();
        if (labels != null && !labels.isEmpty()) {
            additionalParam.put("labels", labels.toArray(new String[labels.size()]));
        }
        return RouterWebServiceUtil.genericForward(this.webAppAddress, null, LabelsToNodesInfo.class, HTTPMethods.GET, "/ws/v1/cluster/label-mappings", null, additionalParam);
    }

    public Response replaceLabelsOnNodes(NodeToLabelsEntryList newNodeToLabels, HttpServletRequest hsr) throws IOException {
        return RouterWebServiceUtil.genericForward(this.webAppAddress, hsr, Response.class, HTTPMethods.POST, "/ws/v1/cluster/replace-node-to-labels", newNodeToLabels, null);
    }

    public Response replaceLabelsOnNode(Set<String> newNodeLabelsName, HttpServletRequest hsr, String nodeId) throws Exception {
        return RouterWebServiceUtil.genericForward(this.webAppAddress, hsr, Response.class, HTTPMethods.POST, "/ws/v1/cluster/nodes/" + nodeId + "/replace-labels", null, null);
    }

    public NodeLabelsInfo getClusterNodeLabels(HttpServletRequest hsr) throws IOException {
        return RouterWebServiceUtil.genericForward(this.webAppAddress, hsr, NodeLabelsInfo.class, HTTPMethods.GET, "/ws/v1/cluster/get-node-labels", null, null);
    }

    public Response addToClusterNodeLabels(NodeLabelsInfo newNodeLabels, HttpServletRequest hsr) throws Exception {
        return RouterWebServiceUtil.genericForward(this.webAppAddress, hsr, Response.class, HTTPMethods.POST, "/ws/v1/cluster/add-node-labels", newNodeLabels, null);
    }

    public Response removeFromCluserNodeLabels(Set<String> oldNodeLabels, HttpServletRequest hsr) throws Exception {
        return RouterWebServiceUtil.genericForward(this.webAppAddress, hsr, Response.class, HTTPMethods.POST, "/ws/v1/cluster/remove-node-labels", null, null);
    }

    public NodeLabelsInfo getLabelsOnNode(HttpServletRequest hsr, String nodeId) throws IOException {
        return RouterWebServiceUtil.genericForward(this.webAppAddress, hsr, NodeLabelsInfo.class, HTTPMethods.GET, "/ws/v1/cluster/nodes/" + nodeId + "/get-labels", null, null);
    }

    public AppPriority getAppPriority(HttpServletRequest hsr, String appId) throws AuthorizationException {
        return RouterWebServiceUtil.genericForward(this.webAppAddress, hsr, AppPriority.class, HTTPMethods.GET, "/ws/v1/cluster/apps/" + appId + "/" + "priority", null, null);
    }

    public Response updateApplicationPriority(AppPriority targetPriority, HttpServletRequest hsr, String appId) throws AuthorizationException, YarnException, InterruptedException, IOException {
        return RouterWebServiceUtil.genericForward(this.webAppAddress, hsr, Response.class, HTTPMethods.PUT, "/ws/v1/cluster/apps/" + appId + "/" + "priority", targetPriority, null);
    }

    public AppQueue getAppQueue(HttpServletRequest hsr, String appId) throws AuthorizationException {
        return RouterWebServiceUtil.genericForward(this.webAppAddress, hsr, AppQueue.class, HTTPMethods.GET, "/ws/v1/cluster/apps/" + appId + "/" + "queue", null, null);
    }

    public Response updateAppQueue(AppQueue targetQueue, HttpServletRequest hsr, String appId) throws AuthorizationException, YarnException, InterruptedException, IOException {
        return RouterWebServiceUtil.genericForward(this.webAppAddress, hsr, Response.class, HTTPMethods.PUT, "/ws/v1/cluster/apps/" + appId + "/" + "queue", targetQueue, null);
    }

    public Response createNewApplication(HttpServletRequest hsr) throws AuthorizationException, IOException, InterruptedException {
        return RouterWebServiceUtil.genericForward(this.webAppAddress, hsr, Response.class, HTTPMethods.POST, "/ws/v1/cluster/apps/new-application", null, null);
    }

    public Response submitApplication(ApplicationSubmissionContextInfo newApp, HttpServletRequest hsr) throws AuthorizationException, IOException, InterruptedException {
        return RouterWebServiceUtil.genericForward(this.webAppAddress, hsr, Response.class, HTTPMethods.POST, "/ws/v1/cluster/apps", newApp, null);
    }

    public Response postDelegationToken(DelegationToken tokenData, HttpServletRequest hsr) throws AuthorizationException, IOException, InterruptedException, Exception {
        return RouterWebServiceUtil.genericForward(this.webAppAddress, hsr, Response.class, HTTPMethods.POST, "/ws/v1/cluster/delegation-token", tokenData, null);
    }

    public Response postDelegationTokenExpiration(HttpServletRequest hsr) throws AuthorizationException, IOException, InterruptedException, Exception {
        return RouterWebServiceUtil.genericForward(this.webAppAddress, hsr, Response.class, HTTPMethods.POST, "/ws/v1/cluster/delegation-token/expiration", null, null);
    }

    public Response cancelDelegationToken(HttpServletRequest hsr) throws AuthorizationException, IOException, InterruptedException, Exception {
        return RouterWebServiceUtil.genericForward(this.webAppAddress, hsr, Response.class, HTTPMethods.DELETE, "/ws/v1/cluster/delegation-token", null, null);
    }

    public Response createNewReservation(HttpServletRequest hsr) throws AuthorizationException, IOException, InterruptedException {
        return RouterWebServiceUtil.genericForward(this.webAppAddress, hsr, Response.class, HTTPMethods.POST, "/ws/v1/cluster/reservation/new-reservation", null, null);
    }

    public Response submitReservation(ReservationSubmissionRequestInfo resContext, HttpServletRequest hsr) throws AuthorizationException, IOException, InterruptedException {
        return RouterWebServiceUtil.genericForward(this.webAppAddress, hsr, Response.class, HTTPMethods.POST, "/ws/v1/cluster/reservation/submit", resContext, null);
    }

    public Response updateReservation(ReservationUpdateRequestInfo resContext, HttpServletRequest hsr) throws AuthorizationException, IOException, InterruptedException {
        return RouterWebServiceUtil.genericForward(this.webAppAddress, hsr, Response.class, HTTPMethods.POST, "/ws/v1/cluster/reservation/update", resContext, null);
    }

    public Response deleteReservation(ReservationDeleteRequestInfo resContext, HttpServletRequest hsr) throws AuthorizationException, IOException, InterruptedException {
        return RouterWebServiceUtil.genericForward(this.webAppAddress, hsr, Response.class, HTTPMethods.POST, "/ws/v1/cluster/reservation/delete", resContext, null);
    }

    public Response listReservation(String queue, String reservationId, long startTime, long endTime, boolean includeResourceAllocations, HttpServletRequest hsr) throws Exception {
        return RouterWebServiceUtil.genericForward(this.webAppAddress, hsr, Response.class, HTTPMethods.GET, "/ws/v1/cluster/reservation/list", null, null);
    }

    public AppTimeoutInfo getAppTimeout(HttpServletRequest hsr, String appId, String type) throws AuthorizationException {
        return RouterWebServiceUtil.genericForward(this.webAppAddress, hsr, AppTimeoutInfo.class, HTTPMethods.GET, "/ws/v1/cluster/apps/" + appId + "/" + "timeouts" + "/" + type, null, null);
    }

    public AppTimeoutsInfo getAppTimeouts(HttpServletRequest hsr, String appId) throws AuthorizationException {
        return RouterWebServiceUtil.genericForward(this.webAppAddress, hsr, AppTimeoutsInfo.class, HTTPMethods.GET, "/ws/v1/cluster/apps/" + appId + "/" + "timeouts", null, null);
    }

    public Response updateApplicationTimeout(AppTimeoutInfo appTimeout, HttpServletRequest hsr, String appId) throws AuthorizationException, YarnException, InterruptedException, IOException {
        return RouterWebServiceUtil.genericForward(this.webAppAddress, hsr, Response.class, HTTPMethods.PUT, "/ws/v1/cluster/apps/" + appId + "/" + "timeout", appTimeout, null);
    }

    public AppAttemptsInfo getAppAttempts(HttpServletRequest hsr, String appId) {
        return RouterWebServiceUtil.genericForward(this.webAppAddress, hsr, AppAttemptsInfo.class, HTTPMethods.GET, "/ws/v1/cluster/apps/" + appId + "/" + "appattempts", null, null);
    }

    @Override
    public AppAttemptInfo getAppAttempt(HttpServletRequest req, HttpServletResponse res, String appId, String appAttemptId) {
        return RouterWebServiceUtil.genericForward(this.webAppAddress, req, AppAttemptInfo.class, HTTPMethods.GET, "/ws/v1/cluster/apps/" + appId + "/" + "appattempts" + "/" + appAttemptId, null, null);
    }

    @Override
    public ContainersInfo getContainers(HttpServletRequest req, HttpServletResponse res, String appId, String appAttemptId) {
        return RouterWebServiceUtil.genericForward(this.webAppAddress, req, ContainersInfo.class, HTTPMethods.GET, "/ws/v1/cluster/apps/" + appId + "/" + "appattempts" + "/" + appAttemptId + "/" + "containers", null, null);
    }

    @Override
    public ContainerInfo getContainer(HttpServletRequest req, HttpServletResponse res, String appId, String appAttemptId, String containerId) {
        return RouterWebServiceUtil.genericForward(this.webAppAddress, req, ContainerInfo.class, HTTPMethods.GET, "/ws/v1/cluster/apps/" + appId + "/" + "appattempts" + "/" + appAttemptId + "/" + "containers" + "/" + containerId, null, null);
    }

    @Override
    public void setNextInterceptor(RESTRequestInterceptor next) {
        throw new YarnRuntimeException("setNextInterceptor is being called on DefaultRequestInterceptorREST, which should be the last one in the chain. Check if the interceptor pipeline configuration is correct");
    }
}

