/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.usergroupsync;

import org.apache.ranger.unixusersync.config.UserGroupSyncConfig;
import org.apache.ranger.usergroupsync.UserGroupSink;
import org.apache.ranger.usergroupsync.UserGroupSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserGroupSync
implements Runnable {
    private static final Logger LOG = LoggerFactory.getLogger(UserGroupSync.class);
    private UserGroupSink ugSink;
    private UserGroupSource ugSource;

    public static void main(String[] args) {
        UserGroupSync userGroupSync = new UserGroupSync();
        userGroupSync.run();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            try {
                long sleepTimeBetweenCycleInMillis = UserGroupSyncConfig.getInstance().getSleepTimeInMillisBetweenCycle();
                boolean initPending = true;
                while (initPending) {
                    try {
                        this.ugSink = UserGroupSyncConfig.getInstance().getUserGroupSink();
                        LOG.info("initializing sink: " + this.ugSink.getClass().getName());
                        this.ugSink.init();
                        this.ugSource = UserGroupSyncConfig.getInstance().getUserGroupSource();
                        LOG.info("initializing source: " + this.ugSource.getClass().getName());
                        this.ugSource.init();
                        LOG.info("Begin: initial load of user/group from source==>sink");
                        this.syncUserGroup();
                        LOG.info("End: initial load of user/group from source==>sink");
                        initPending = false;
                        LOG.info("Done initializing user/group source and sink");
                    }
                    catch (Throwable t) {
                        LOG.error("Failed to initialize UserGroup source/sink. Will retry after " + sleepTimeBetweenCycleInMillis + " milliseconds. Error details: ", t);
                        try {
                            LOG.debug("Sleeping for [" + sleepTimeBetweenCycleInMillis + "] milliSeconds");
                            Thread.sleep(sleepTimeBetweenCycleInMillis);
                        }
                        catch (Exception e) {
                            LOG.error("Failed to wait for [" + sleepTimeBetweenCycleInMillis + "] milliseconds before attempting to initialize UserGroup source/sink", (Throwable)e);
                        }
                    }
                }
                while (true) {
                    try {
                        LOG.debug("Sleeping for [" + sleepTimeBetweenCycleInMillis + "] milliSeconds");
                        Thread.sleep(sleepTimeBetweenCycleInMillis);
                    }
                    catch (InterruptedException e) {
                        LOG.error("Failed to wait for [" + sleepTimeBetweenCycleInMillis + "] milliseconds before attempting to synchronize UserGroup information", (Throwable)e);
                    }
                    try {
                        LOG.info("Begin: update user/group from source==>sink");
                        this.syncUserGroup();
                        LOG.info("End: update user/group from source==>sink");
                    }
                    catch (Throwable t) {
                        LOG.error("Failed to synchronize UserGroup information. Error details: ", t);
                    }
                }
            }
            catch (Throwable t) {
                LOG.error("UserGroupSync thread got an error", t);
                LOG.info("Shutting down the UserGroupSync thread");
            }
        }
        catch (Throwable throwable) {
            LOG.info("Shutting down the UserGroupSync thread");
            throw throwable;
        }
    }

    private void syncUserGroup() throws Throwable {
        UserGroupSyncConfig config = UserGroupSyncConfig.getInstance();
        if (config.isUserSyncEnabled()) {
            this.ugSource.updateSink(this.ugSink);
        }
    }
}

