/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.unixusersync.poc;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.ranger.unixusersync.poc.InvalidGroupException;

public class ListRangerUserGroup {
    private final int gid;
    private final String name;
    private final String passwd;
    private final List<String> userList;

    public static ListRangerUserGroup parseGroup(String groupLine) throws InvalidGroupException {
        if (groupLine == null) {
            throw new IllegalArgumentException("groupLine cannot be null");
        }
        String line = groupLine.trim();
        if (line.startsWith("#") || line.isEmpty()) {
            return null;
        }
        String[] parts = line.split(":");
        if (parts.length < 3) {
            throw new InvalidGroupException(groupLine + "must be in the format of name:passwd:gid[:userlist]", line);
        }
        try {
            String name = parts[0];
            String passwd = parts[1];
            int gid = Integer.parseInt(parts[2]);
            List<String> userList = parts.length == 4 ? Arrays.asList(parts[3].split(",")) : Collections.emptyList();
            ListRangerUserGroup group = new ListRangerUserGroup(name, passwd, gid, userList);
            return group;
        }
        catch (NumberFormatException ex) {
            throw new InvalidGroupException(groupLine + " gid must be a number", line);
        }
    }

    public ListRangerUserGroup(String nm, String pw, int id, List<String> users) {
        this.name = nm;
        this.passwd = pw;
        this.gid = id;
        this.userList = Collections.unmodifiableList(new ArrayList<String>(users));
    }

    public int getGid() {
        return this.gid;
    }

    public String getName() {
        return this.name;
    }

    public String getPasswd() {
        return this.passwd;
    }

    public List<String> getUserList() {
        return this.userList;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.name);
        sb.append(":");
        sb.append(this.passwd);
        sb.append(":");
        sb.append(this.gid);
        sb.append(":");
        for (String user : this.userList) {
            sb.append(user);
            sb.append(",");
        }
        sb.setLength(sb.length() - 1);
        return sb.toString();
    }
}

